/*
 * Decompiled with CFR 0.152.
 */
package org.openhab.core.automation.internal.module.handler;

import java.util.Arrays;
import java.util.Collection;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.jdt.annotation.Nullable;
import org.openhab.core.automation.Condition;
import org.openhab.core.automation.Module;
import org.openhab.core.automation.Trigger;
import org.openhab.core.automation.handler.BaseModuleHandlerFactory;
import org.openhab.core.automation.handler.ModuleHandler;
import org.openhab.core.automation.handler.ModuleHandlerFactory;
import org.openhab.core.automation.internal.module.handler.DateTimeTriggerHandler;
import org.openhab.core.automation.internal.module.handler.DayOfWeekConditionHandler;
import org.openhab.core.automation.internal.module.handler.GenericCronTriggerHandler;
import org.openhab.core.automation.internal.module.handler.IntervalConditionHandler;
import org.openhab.core.automation.internal.module.handler.TimeOfDayConditionHandler;
import org.openhab.core.automation.internal.module.handler.TimeOfDayTriggerHandler;
import org.openhab.core.items.ItemRegistry;
import org.openhab.core.scheduler.CronScheduler;
import org.osgi.framework.BundleContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@NonNullByDefault
@Component(immediate=true, service={ModuleHandlerFactory.class})
public class TimerModuleHandlerFactory
extends BaseModuleHandlerFactory {
    private final Logger logger = LoggerFactory.getLogger(TimerModuleHandlerFactory.class);
    public static final String THREADPOOLNAME = "ruletimer";
    private static final Collection<String> TYPES = Arrays.asList("timer.GenericCronTrigger", "timer.TimeOfDayTrigger", "core.TimeOfDayCondition", "timer.DayOfWeekCondition", "timer.DateTimeTrigger", "timer.IntervalCondition");
    private final CronScheduler scheduler;
    private final ItemRegistry itemRegistry;
    private final BundleContext bundleContext;

    @Activate
    public TimerModuleHandlerFactory(@Reference CronScheduler scheduler, @Reference ItemRegistry itemRegistry, BundleContext bundleContext) {
        this.scheduler = scheduler;
        this.itemRegistry = itemRegistry;
        this.bundleContext = bundleContext;
    }

    @Override
    @Deactivate
    public void deactivate() {
        super.deactivate();
    }

    @Override
    public Collection<String> getTypes() {
        return TYPES;
    }

    @Override
    protected @Nullable ModuleHandler internalCreate(Module module, String ruleUID) {
        String moduleTypeUID;
        block28: {
            block26: {
                this.logger.trace("create {} -> {}", (Object)module.getId(), (Object)module.getTypeUID());
                moduleTypeUID = module.getTypeUID();
                if (!(module instanceof Trigger)) break block26;
                Trigger trigger = (Trigger)module;
                switch (moduleTypeUID) {
                    case "timer.GenericCronTrigger": {
                        return new GenericCronTriggerHandler(trigger, this.scheduler);
                    }
                    case "timer.TimeOfDayTrigger": {
                        return new TimeOfDayTriggerHandler(trigger, this.scheduler);
                    }
                    case "timer.DateTimeTrigger": {
                        return new DateTimeTriggerHandler(trigger, this.scheduler, this.itemRegistry, this.bundleContext);
                    }
                }
                break block28;
            }
            if (!(module instanceof Condition)) break block28;
            Condition condition = (Condition)module;
            switch (moduleTypeUID) {
                case "core.TimeOfDayCondition": {
                    return new TimeOfDayConditionHandler(condition);
                }
                case "timer.DayOfWeekCondition": {
                    return new DayOfWeekConditionHandler(condition);
                }
                case "timer.IntervalCondition": {
                    return new IntervalConditionHandler(condition);
                }
            }
        }
        this.logger.error("The module handler type '{}' is not supported.", (Object)moduleTypeUID);
        return null;
    }
}

