/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jupyter.tables;

import com.intellij.jupyter.core.core.impl.file.BackedNotebookVirtualFile;
import com.intellij.jupyter.core.jupyter.actions.utils.JupyterDebugger;
import com.intellij.jupyter.core.jupyter.connections.JupyterConnectionParameters;
import com.intellij.jupyter.core.jupyter.connections.execution.JupyterCellExecutionListener;
import com.intellij.jupyter.core.jupyter.connections.execution.core.JupyterNotebookSession;
import com.intellij.jupyter.core.jupyter.connections.execution.notebook.JupyterRuntimeService;
import com.intellij.jupyter.core.jupyter.connections.server.JupyterServer;
import com.intellij.jupyter.core.jupyter.connections.server.JupyterServerEx;
import com.intellij.jupyter.core.jupyter.connections.server.JupyterServers;
import com.intellij.jupyter.core.jupyter.connections.session.JupyterSessionData;
import com.intellij.jupyter.core.jupyter.connections.session.JupyterSessionListener;
import com.intellij.jupyter.core.jupyter.connections.session.JupyterSessionManager;
import com.intellij.jupyter.core.jupyter.editor.outputs.webOutputs.appBasedApi.scriptLoader.utils.JupyterCoroutineKt;
import com.intellij.jupyter.core.jupyter.helper.JupyterEditorExtensionsKt;
import com.intellij.jupyter.core.jupyter.nbformat.JupyterListenersKt;
import com.intellij.jupyter.core.jupyter.nbformat.JupyterNotebook;
import com.intellij.jupyter.core.jupyter.tables.CommandOutputType;
import com.intellij.jupyter.core.jupyter.variables.common.JupyterVarsCommandExecutor;
import com.intellij.notebooks.visualization.NotebookIntervalPointer;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.impl.EditorImpl;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.IntellijInternalApi;
import com.intellij.scientific.tables.api.DSSessionListener;
import com.intellij.scientific.tables.api.DSTableCommandExecutor;
import com.intellij.scientific.tables.api.DescribeTableCommand;
import com.intellij.scientific.tables.api.ImageLoadCommand;
import com.intellij.scientific.tables.api.ImageStartLoadCommand;
import com.intellij.scientific.tables.api.InfoTableCommand;
import com.intellij.scientific.tables.api.SliceTableCommand;
import com.intellij.scientific.tables.api.TableCommand;
import com.intellij.scientific.tables.api.TableCommandCodeProvider;
import com.intellij.scientific.tables.api.VisualizationDataTableCommand;
import com.intellij.util.concurrency.ThreadingAssertions;
import com.intellij.util.messages.MessageBus;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.coroutines.CoroutineScope;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0006\u0018\u0000 )2\u00020\u0001:\u0001)B)\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0004\b\n\u0010\u000bJ\u0018\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001eH\u0017J\u0010\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001f\u001a\u00020\u001aH\u0017J\u0018\u0010\u0019\u001a\u00020\u001a2\u0006\u0010 \u001a\u00020\u001a2\u0006\u0010!\u001a\u00020\"H\u0007J\b\u0010#\u001a\u00020$H\u0016J\u0010\u0010%\u001a\u00020$2\u0006\u0010&\u001a\u00020\u0014H\u0016J\u0010\u0010'\u001a\u00020$2\u0006\u0010&\u001a\u00020\u0014H\u0016J\b\u0010(\u001a\u00020$H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0014\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00140\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u0010\u0015\u001a\u0006\u0012\u0002\b\u00030\u00168VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0017\u0010\u0018\u00a8\u0006*"}, d2={"Lcom/intellij/jupyter/tables/JupyterTableCommandExecutor;", "Lcom/intellij/scientific/tables/api/DSTableCommandExecutor;", "project", "Lcom/intellij/openapi/project/Project;", "notebookVirtualFile", "Lcom/intellij/jupyter/core/core/impl/file/BackedNotebookVirtualFile;", "cellPointer", "Lcom/intellij/notebooks/visualization/NotebookIntervalPointer;", "editor", "Lcom/intellij/openapi/editor/Editor;", "<init>", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/jupyter/core/core/impl/file/BackedNotebookVirtualFile;Lcom/intellij/notebooks/visualization/NotebookIntervalPointer;Lcom/intellij/openapi/editor/Editor;)V", "getProject", "()Lcom/intellij/openapi/project/Project;", "getCellPointer", "()Lcom/intellij/notebooks/visualization/NotebookIntervalPointer;", "getEditor", "()Lcom/intellij/openapi/editor/Editor;", "sessionListeners", "", "Lcom/intellij/scientific/tables/api/DSSessionListener;", "dataAccessorClass", "Ljava/lang/Class;", "getDataAccessorClass", "()Ljava/lang/Class;", "executeCommand", "", "tableCommand", "Lcom/intellij/scientific/tables/api/TableCommand;", "tableCommandCodeProvider", "Lcom/intellij/scientific/tables/api/TableCommandCodeProvider;", "commandCode", "commandText", "outputType", "Lcom/intellij/jupyter/core/jupyter/tables/CommandOutputType;", "notifyAsyncOutputLoaded", "", "addSessionListener", "listener", "removeSessionListener", "restoreOutputWithoutStaticTableData", "Companion", "intellij.jupyter.tables"})
public final class JupyterTableCommandExecutor
implements DSTableCommandExecutor {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Project project;
    @NotNull
    private final BackedNotebookVirtualFile notebookVirtualFile;
    @Nullable
    private final NotebookIntervalPointer cellPointer;
    @NotNull
    private final Editor editor;
    @NotNull
    private final List<DSSessionListener> sessionListeners;

    public JupyterTableCommandExecutor(@NotNull Project project, @NotNull BackedNotebookVirtualFile notebookVirtualFile, @Nullable NotebookIntervalPointer cellPointer, @NotNull Editor editor) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)notebookVirtualFile, (String)"notebookVirtualFile");
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        this.project = project;
        this.notebookVirtualFile = notebookVirtualFile;
        this.cellPointer = cellPointer;
        this.editor = editor;
        this.sessionListeners = new ArrayList();
        MessageBus messageBus = this.project.getMessageBus();
        Editor editor2 = this.editor;
        Intrinsics.checkNotNull((Object)editor2, (String)"null cannot be cast to non-null type com.intellij.openapi.editor.impl.EditorImpl");
        Disposable disposable = ((EditorImpl)editor2).getDisposable();
        Intrinsics.checkNotNullExpressionValue((Object)disposable, (String)"getDisposable(...)");
        messageBus.connect(disposable).subscribe(JupyterSessionListener.Companion.getTOPIC(), (Object)new JupyterSessionListener(){

            public void sessionUpdated(JupyterConnectionParameters connectionParameters, JupyterSessionData session, JupyterSessionListener.EventType eventType) {
                Intrinsics.checkNotNullParameter((Object)connectionParameters, (String)"connectionParameters");
                Intrinsics.checkNotNullParameter((Object)session, (String)"session");
                Intrinsics.checkNotNullParameter((Object)eventType, (String)"eventType");
                switch (WhenMappings.$EnumSwitchMapping$0[eventType.ordinal()]) {
                    case 1: {
                        break;
                    }
                    case 2: {
                        this.sessionStopped(connectionParameters, session);
                        break;
                    }
                    default: {
                        throw new NoWhenBranchMatchedException();
                    }
                }
            }

            public final void sessionStopped(JupyterConnectionParameters connParameters, JupyterSessionData session) {
                Intrinsics.checkNotNullParameter((Object)connParameters, (String)"connParameters");
                Intrinsics.checkNotNullParameter((Object)session, (String)"session");
                JupyterServer jupyterServer = JupyterServers.Companion.getInstance().getCachedServer(connParameters);
                if (jupyterServer == null) {
                    return;
                }
                JupyterServer server = jupyterServer;
                if (!Intrinsics.areEqual((Object)server.getConnectionParameters(), (Object)connParameters)) {
                    return;
                }
                JupyterServerEx jupyterServerEx = server instanceof JupyterServerEx ? (JupyterServerEx)server : null;
                if (jupyterServerEx == null || (jupyterServerEx = jupyterServerEx.getSessionManager()) == null) {
                    return;
                }
                JupyterServerEx sessionManager = jupyterServerEx;
                JupyterCoroutineKt.launchBackground((Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>((JupyterSessionManager)sessionManager, session, this, null){
                    int label;
                    final /* synthetic */ JupyterSessionManager $sessionManager;
                    final /* synthetic */ JupyterSessionData $session;
                    final /* synthetic */ JupyterTableCommandExecutor this$0;
                    {
                        this.$sessionManager = $sessionManager;
                        this.$session = $session;
                        this.this$0 = $receiver;
                        super(2, $completion);
                    }

                    /*
                     * Unable to fully structure code
                     */
                    public final Object invokeSuspend(Object $result) {
                        var5_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                        switch (this.label) {
                            case 0: {
                                ResultKt.throwOnFailure((Object)$result);
                                this.label = 1;
                                v0 = this.$sessionManager.isSessionForFile(this.$session, JupyterTableCommandExecutor.access$getNotebookVirtualFile$p(this.this$0).getFile(), (Continuation)this);
                                if (v0 == var5_2) {
                                    return var5_2;
                                }
                                ** GOTO lbl13
                            }
                            case 1: {
                                ResultKt.throwOnFailure((Object)$result);
                                v0 = $result;
lbl13:
                                // 2 sources

                                if (!(isAttached = ((Boolean)v0).booleanValue())) {
                                    return Unit.INSTANCE;
                                }
                                for (DSSessionListener listener : JupyterTableCommandExecutor.access$getSessionListeners$p(this.this$0)) {
                                    listener.sessionStopped();
                                }
                                return Unit.INSTANCE;
                            }
                        }
                        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                    }

                    public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                        return (Continuation)new /* invalid duplicate definition of identical inner class */;
                    }

                    public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                        return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                    }
                }));
            }

            @Metadata(mv={2, 2, 0}, k=3, xi=48)
            public static final class WhenMappings {
                public static final /* synthetic */ int[] $EnumSwitchMapping$0;

                static {
                    int[] nArray = new int[JupyterSessionListener.EventType.values().length];
                    try {
                        nArray[JupyterSessionListener.EventType.STARTED.ordinal()] = 1;
                    }
                    catch (NoSuchFieldError noSuchFieldError) {
                        // empty catch block
                    }
                    try {
                        nArray[JupyterSessionListener.EventType.STOPPED.ordinal()] = 2;
                    }
                    catch (NoSuchFieldError noSuchFieldError) {
                        // empty catch block
                    }
                    $EnumSwitchMapping$0 = nArray;
                }
            }
        });
    }

    @NotNull
    public final Project getProject() {
        return this.project;
    }

    @Nullable
    public final NotebookIntervalPointer getCellPointer() {
        return this.cellPointer;
    }

    @NotNull
    public final Editor getEditor() {
        return this.editor;
    }

    @NotNull
    public Class<?> getDataAccessorClass() {
        return JupyterTableCommandExecutor.class;
    }

    @IntellijInternalApi
    @NotNull
    public String executeCommand(@NotNull TableCommand tableCommand, @NotNull TableCommandCodeProvider tableCommandCodeProvider) {
        CommandOutputType commandOutputType;
        Intrinsics.checkNotNullParameter((Object)tableCommand, (String)"tableCommand");
        Intrinsics.checkNotNullParameter((Object)tableCommandCodeProvider, (String)"tableCommandCodeProvider");
        String commandText = tableCommandCodeProvider.getCommandCode(tableCommand);
        TableCommand tableCommand2 = tableCommand;
        if (tableCommand2 instanceof SliceTableCommand) {
            commandOutputType = CommandOutputType.DISPLAY;
        } else if (tableCommand2 instanceof DescribeTableCommand || tableCommand2 instanceof InfoTableCommand || tableCommand2 instanceof VisualizationDataTableCommand || tableCommand2 instanceof ImageLoadCommand || tableCommand2 instanceof ImageStartLoadCommand) {
            commandOutputType = CommandOutputType.STREAM;
        } else {
            throw new NoWhenBranchMatchedException();
        }
        CommandOutputType outputType = commandOutputType;
        return this.executeCommand(commandText, outputType);
    }

    @IntellijInternalApi
    @NotNull
    public String executeCommand(@NotNull String commandCode) {
        Intrinsics.checkNotNullParameter((Object)commandCode, (String)"commandCode");
        return this.executeCommand(commandCode, CommandOutputType.STREAM);
    }

    @IntellijInternalApi
    @NotNull
    public final String executeCommand(@NotNull String commandText, @NotNull CommandOutputType outputType) {
        Intrinsics.checkNotNullParameter((Object)commandText, (String)"commandText");
        Intrinsics.checkNotNullParameter((Object)outputType, (String)"outputType");
        return JupyterVarsCommandExecutor.Companion.getInstance(this.project).executeCommands(commandText, this.notebookVirtualFile, outputType);
    }

    public void notifyAsyncOutputLoaded() {
        boolean executionHandled;
        ThreadingAssertions.assertEventDispatchThread();
        JupyterNotebookSession jupyterNotebookSession = JupyterRuntimeService.Companion.getInstance(this.project).getNotebookSession(this.notebookVirtualFile);
        if (jupyterNotebookSession == null) {
            return;
        }
        JupyterNotebookSession session = jupyterNotebookSession;
        if (this.cellPointer != null) {
            session.getMessageTracker().asyncOutputLoaded(this.cellPointer);
        }
        if ((executionHandled = session.getMessageTracker().handleExecutionFinished-Q4AT_I0(null)) && !JupyterDebugger.INSTANCE.isUnderDebugger(this.project, this.notebookVirtualFile)) {
            ((JupyterCellExecutionListener)this.project.getMessageBus().syncPublisher(JupyterCellExecutionListener.Companion.getTOPIC())).executionFinished(this.notebookVirtualFile);
        }
    }

    public void addSessionListener(@NotNull DSSessionListener listener) {
        Intrinsics.checkNotNullParameter((Object)listener, (String)"listener");
        this.sessionListeners.add(listener);
    }

    public void removeSessionListener(@NotNull DSSessionListener listener) {
        Intrinsics.checkNotNullParameter((Object)listener, (String)"listener");
        this.sessionListeners.remove(listener);
    }

    public void restoreOutputWithoutStaticTableData() {
        if (this.cellPointer != null) {
            JupyterListenersKt.outputUpdated((JupyterNotebook)JupyterEditorExtensionsKt.getNotebookFile((Editor)this.editor).getNotebook(), (NotebookIntervalPointer)this.cellPointer);
        }
    }

    public static final /* synthetic */ BackedNotebookVirtualFile access$getNotebookVirtualFile$p(JupyterTableCommandExecutor $this) {
        return $this.notebookVirtualFile;
    }

    public static final /* synthetic */ List access$getSessionListeners$p(JupyterTableCommandExecutor $this) {
        return $this.sessionListeners;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007\u00a8\u0006\b"}, d2={"Lcom/intellij/jupyter/tables/JupyterTableCommandExecutor$Companion;", "", "<init>", "()V", "getContentName", "", "executionCount", "", "intellij.jupyter.tables"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final String getContentName(int executionCount) {
            return "Out[" + executionCount + "]";
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

