/*
 * Decompiled with CFR 0.152.
 */
package org.olap4j.query;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import org.olap4j.Axis;
import org.olap4j.CellSet;
import org.olap4j.OlapConnection;
import org.olap4j.OlapException;
import org.olap4j.OlapStatement;
import org.olap4j.mdx.SelectNode;
import org.olap4j.metadata.Catalog;
import org.olap4j.metadata.Cube;
import org.olap4j.metadata.Dimension;
import org.olap4j.metadata.Member;
import org.olap4j.query.Olap4jNodeConverter;
import org.olap4j.query.QueryAxis;
import org.olap4j.query.QueryDimension;
import org.olap4j.query.QueryNode;
import org.olap4j.query.QueryNodeImpl;
import org.olap4j.query.SelectionFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Query
extends QueryNodeImpl {
    protected final String name;
    protected Map<Axis, QueryAxis> axes = new HashMap<Axis, QueryAxis>();
    protected QueryAxis across;
    protected QueryAxis down;
    protected QueryAxis filter;
    protected QueryAxis unused;
    protected final Cube cube;
    protected Map<String, QueryDimension> dimensionMap = new HashMap<String, QueryDimension>();
    protected boolean selectDefaultMembers = true;
    private final OlapConnection connection;
    private final SelectionFactory selectionFactory = new SelectionFactory();

    public Query(String name, Cube cube) throws SQLException {
        this.name = name;
        this.cube = cube;
        Catalog catalog = cube.getSchema().getCatalog();
        this.connection = catalog.getMetaData().getConnection().unwrap(OlapConnection.class);
        this.connection.setCatalog(catalog.getName());
        this.unused = new QueryAxis(this, null);
        for (Dimension dimension : cube.getDimensions()) {
            QueryDimension queryDimension = new QueryDimension(this, dimension);
            this.unused.getDimensions().add(queryDimension);
            this.dimensionMap.put(queryDimension.getName(), queryDimension);
        }
        this.across = new QueryAxis(this, Axis.COLUMNS);
        this.down = new QueryAxis(this, Axis.ROWS);
        this.filter = new QueryAxis(this, Axis.FILTER);
        this.axes.put(null, this.unused);
        this.axes.put(Axis.COLUMNS, this.across);
        this.axes.put(Axis.ROWS, this.down);
        this.axes.put(Axis.FILTER, this.filter);
    }

    public SelectNode getSelect() {
        return Olap4jNodeConverter.toOlap4j(this);
    }

    public Cube getCube() {
        return this.cube;
    }

    public QueryDimension getDimension(String name) {
        return this.dimensionMap.get(name);
    }

    public void swapAxes() {
        if (this.axes.size() != 4) {
            throw new IllegalArgumentException();
        }
        ArrayList<QueryDimension> tmpAcross = new ArrayList<QueryDimension>();
        tmpAcross.addAll(this.across.getDimensions());
        ArrayList<QueryDimension> tmpDown = new ArrayList<QueryDimension>();
        tmpDown.addAll(this.down.getDimensions());
        this.across.getDimensions().clear();
        HashMap<Integer, QueryNode> acrossChildList = new HashMap<Integer, QueryNode>();
        for (int cpt = 0; cpt < tmpAcross.size(); ++cpt) {
            acrossChildList.put(cpt, (QueryNode)tmpAcross.get(cpt));
        }
        this.across.notifyRemove(acrossChildList);
        this.down.getDimensions().clear();
        HashMap<Integer, QueryNode> downChildList = new HashMap<Integer, QueryNode>();
        for (int cpt = 0; cpt < tmpDown.size(); ++cpt) {
            downChildList.put(cpt, (QueryNode)tmpDown.get(cpt));
        }
        this.down.notifyRemove(downChildList);
        this.across.getDimensions().addAll(tmpDown);
        this.across.notifyAdd(downChildList);
        this.down.getDimensions().addAll(tmpAcross);
        this.down.notifyAdd(acrossChildList);
    }

    public QueryAxis getAxis(Axis axis) {
        return this.axes.get(axis);
    }

    public Map<Axis, QueryAxis> getAxes() {
        return this.axes;
    }

    public QueryAxis getUnusedAxis() {
        return this.unused;
    }

    public void tearDown(boolean closeConnection) {
        for (Map.Entry<Axis, QueryAxis> entry : this.axes.entrySet()) {
            entry.getValue().tearDown();
        }
        this.axes.clear();
        this.clearListeners();
        if (closeConnection) {
            try {
                this.connection.close();
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
        }
    }

    @Override
    public void tearDown() {
        this.tearDown(true);
    }

    public void validate() throws OlapException {
        try {
            if (this.selectDefaultMembers) {
                Member defaultMember;
                for (QueryDimension dimension : this.getAxis(Axis.ROWS).getDimensions()) {
                    if (dimension.getInclusions().size() != 0) continue;
                    defaultMember = dimension.getDimension().getDefaultHierarchy().getDefaultMember();
                    dimension.include(defaultMember);
                }
                for (QueryDimension dimension : this.getAxis(Axis.COLUMNS).getDimensions()) {
                    if (dimension.getInclusions().size() != 0) continue;
                    defaultMember = dimension.getDimension().getDefaultHierarchy().getDefaultMember();
                    dimension.include(defaultMember);
                }
                for (QueryDimension dimension : this.getAxis(Axis.FILTER).getDimensions()) {
                    if (dimension.getInclusions().size() != 0) continue;
                    defaultMember = dimension.getDimension().getDefaultHierarchy().getDefaultMember();
                    dimension.include(defaultMember);
                }
            }
            if (this.getAxis(Axis.ROWS).getDimensions().size() == 0) {
                throw new OlapException("A valid Query requires at least one dimension on the rows axis.");
            }
            if (this.getAxis(Axis.COLUMNS).getDimensions().size() == 0) {
                throw new OlapException("A valid Query requires at least one dimension on the columns axis.");
            }
            this.getSelect();
        }
        catch (Exception e) {
            throw new OlapException("Query validation failed.", e);
        }
    }

    public CellSet execute() throws OlapException {
        SelectNode mdx = this.getSelect();
        Catalog catalog = this.cube.getSchema().getCatalog();
        try {
            this.connection.setCatalog(catalog.getName());
        }
        catch (SQLException e) {
            throw new OlapException("Error while executing query", e);
        }
        OlapStatement olapStatement = this.connection.createStatement();
        return olapStatement.executeOlapQuery(mdx);
    }

    public String getName() {
        return this.name;
    }

    public Locale getLocale() {
        return Locale.getDefault();
    }

    SelectionFactory getSelectionFactory() {
        return this.selectionFactory;
    }

    public void setSelectDefaultMembers(boolean selectDefaultMembers) {
        this.selectDefaultMembers = selectDefaultMembers;
    }
}

