/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.db;

import com.sleepycat.db.Database;
import com.sleepycat.db.DatabaseEntry;
import com.sleepycat.db.DatabaseException;
import com.sleepycat.db.JoinConfig;
import com.sleepycat.db.LockMode;
import com.sleepycat.db.OperationStatus;
import com.sleepycat.db.internal.Dbc;

public class JoinCursor {
    private Database database;
    private Dbc dbc;
    private JoinConfig config;

    JoinCursor(Database database, Dbc dbc, JoinConfig joinConfig) {
        this.database = database;
        this.dbc = dbc;
        this.config = joinConfig;
    }

    public void close() throws DatabaseException {
        this.dbc.close();
    }

    public Database getDatabase() {
        return this.database;
    }

    public JoinConfig getConfig() {
        return this.config;
    }

    public OperationStatus getNext(DatabaseEntry databaseEntry, LockMode lockMode) throws DatabaseException {
        return OperationStatus.fromInt(this.dbc.get(databaseEntry, DatabaseEntry.IGNORE, 0xC | LockMode.getFlag(lockMode)));
    }

    public OperationStatus getNext(DatabaseEntry databaseEntry, DatabaseEntry databaseEntry2, LockMode lockMode) throws DatabaseException {
        return OperationStatus.fromInt(this.dbc.get(databaseEntry, databaseEntry2, LockMode.getFlag(lockMode) | (databaseEntry2 == null ? 0 : databaseEntry2.getMultiFlag())));
    }
}

