/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.d2j.dex.writer.item;

import com.googlecode.d2j.dex.writer.io.DataOut;
import com.googlecode.d2j.dex.writer.item.BaseItem;
import com.googlecode.d2j.dex.writer.item.ClassDefItem;
import com.googlecode.d2j.dex.writer.item.FieldIdItem;
import com.googlecode.d2j.dex.writer.item.MapListItem;
import com.googlecode.d2j.dex.writer.item.MethodIdItem;
import com.googlecode.d2j.dex.writer.item.ProtoIdItem;
import com.googlecode.d2j.dex.writer.item.SectionItem;
import com.googlecode.d2j.dex.writer.item.StringIdItem;
import com.googlecode.d2j.dex.writer.item.TypeIdItem;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;

public class HeadItem
extends BaseItem {
    public int version = 0x303335;
    public SectionItem<MapListItem> mapSection;
    public SectionItem<StringIdItem> stringIdSection;
    public SectionItem<TypeIdItem> typeIdSection;
    public SectionItem<ProtoIdItem> protoIdSection;
    public SectionItem<FieldIdItem> fieldIdSection;
    public SectionItem<MethodIdItem> methodIdSection;
    public SectionItem<ClassDefItem> classDefSection;
    public int fileSize = -1;

    @Override
    public void write(DataOut out) {
        out.uint("magic", 175662436);
        out.bytes("version", HeadItem.writeBigEndian(this.version << 8));
        out.skip4("checksum");
        out.skip("signature", 20);
        out.uint("file_size", this.fileSize);
        out.uint("head_size", 112);
        out.uint("endian_tag", 305419896);
        out.skip("link_size,link_off", 8);
        out.uint("map_off", this.mapSection.items.size() == 0 ? 0 : this.mapSection.offset);
        out.uint("string_ids_size", this.stringIdSection.items.size());
        out.uint("string_ids_off", this.stringIdSection.items.size() == 0 ? 0 : this.stringIdSection.offset);
        out.uint("type_ids_size", this.typeIdSection.items.size());
        out.uint("type_ids_off", this.typeIdSection.items.size() == 0 ? 0 : this.typeIdSection.offset);
        out.uint("proto_ids_size", this.protoIdSection.items.size());
        out.uint("proto_ids_off", this.protoIdSection.items.size() == 0 ? 0 : this.protoIdSection.offset);
        out.uint("field_ids_size", this.fieldIdSection.items.size());
        out.uint("field_ids_off", this.fieldIdSection.items.size() == 0 ? 0 : this.fieldIdSection.offset);
        out.uint("method_ids_size", this.methodIdSection.items.size());
        out.uint("method_ids_off", this.methodIdSection.items.size() == 0 ? 0 : this.methodIdSection.offset);
        out.uint("class_defs_size", this.classDefSection.items.size());
        out.uint("class_defs_off", this.classDefSection.items.size() == 0 ? 0 : this.classDefSection.offset);
        out.uint("data_size", this.fileSize - this.mapSection.offset);
        out.uint("data_off", this.mapSection.offset);
    }

    private static byte[] writeBigEndian(int value) {
        return ByteBuffer.allocate(4).order(ByteOrder.BIG_ENDIAN).putInt(value).array();
    }

    @Override
    public int place(int offset) {
        return offset + 112;
    }
}

