/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.common.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import net.sf.freecol.common.model.AbstractGoods;
import net.sf.freecol.common.model.GoodsType;
import net.sf.freecol.common.model.Market;
import net.sf.freecol.common.model.MarketData;
import net.sf.freecol.common.model.ObjectWas;
import net.sf.freecol.common.model.Player;
import net.sf.freecol.common.model.TransactionListener;

public class MarketWas
extends ObjectWas {
    private static final Logger logger = Logger.getLogger(MarketWas.class.getName());
    private final Market market;
    private final int tax;
    private final Map<GoodsType, Integer> costToBuy;
    private final Map<GoodsType, Integer> paidForSale;
    private final List<AbstractGoods> transactions = new ArrayList<AbstractGoods>();

    public MarketWas(Player player) {
        this.market = player.getMarket();
        this.tax = player.getTax();
        Collection<MarketData> mdv = this.market.getMarketDataValues();
        this.costToBuy = new HashMap<GoodsType, Integer>(mdv.size());
        this.paidForSale = new HashMap<GoodsType, Integer>(mdv.size());
        for (MarketData md : mdv) {
            this.costToBuy.put(md.getGoodsType(), md.getCostToBuy());
            this.paidForSale.put(md.getGoodsType(), md.getPaidForSale());
        }
    }

    public void add(AbstractGoods ag) {
        this.transactions.add(ag);
    }

    public void addAll(List<AbstractGoods> ag) {
        this.transactions.addAll(ag);
    }

    private void fireChange(GoodsType type, int amount) {
        for (TransactionListener l : this.market.getTransactionListener()) {
            if (amount < 0) {
                int buy = this.costToBuy.get(type);
                l.logPurchase(type, -amount, buy);
                int buyNow = this.market.getCostToBuy(type);
                if (buy == buyNow) continue;
                this.market.getMarketData(type).firePropertyChange("priceChange", buy, buyNow);
                continue;
            }
            if (amount <= 0) continue;
            int sell = this.paidForSale.get(type);
            l.logSale(type, amount, sell, this.tax);
            int sellNow = this.market.getPaidForSale(type);
            if (sell == sellNow) continue;
            this.market.getMarketData(type).firePropertyChange("priceChange", sell, sellNow);
        }
    }

    @Override
    public boolean fireChanges() {
        if (this.transactions.isEmpty()) {
            return false;
        }
        for (AbstractGoods ag : this.transactions) {
            this.fireChange(ag.getType(), ag.getAmount());
        }
        this.transactions.clear();
        return true;
    }
}

