/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.common.option;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.Mixer;
import javax.xml.stream.XMLStreamException;
import net.sf.freecol.common.i18n.Messages;
import net.sf.freecol.common.io.FreeColXMLWriter;
import net.sf.freecol.common.model.Specification;
import net.sf.freecol.common.option.AbstractOption;
import net.sf.freecol.common.util.CollectionUtils;

public class AudioMixerOption
extends AbstractOption<MixerWrapper> {
    private static Logger logger = Logger.getLogger(AudioMixerOption.class.getName());
    public static final String TAG = "audioMixerOption";
    public static final String AUTO_NAME = Messages.message("clientOptions.audio.audioMixer.automatic");
    private static final Mixer AUTODETECTED_MIXER;
    private static final MixerWrapper DEFAULT_MIXER_WRAPPER;
    private static final List<MixerWrapper> audioMixers;
    private MixerWrapper value = null;

    public AudioMixerOption(Specification specification) {
        super(specification);
    }

    private MixerWrapper getMixerWrapperByName(String name) {
        return CollectionUtils.find(audioMixers, mw -> mw.getKey().equals(name));
    }

    public List<MixerWrapper> getChoices() {
        return new ArrayList<MixerWrapper>(audioMixers);
    }

    @Override
    public AudioMixerOption cloneOption() {
        AudioMixerOption result = new AudioMixerOption(this.getSpecification());
        result.setValues(this);
        return result;
    }

    @Override
    public final MixerWrapper getValue() {
        return this.value;
    }

    @Override
    public final void setValue(MixerWrapper newValue) {
        MixerWrapper oldValue = this.value;
        if (newValue == null) {
            newValue = DEFAULT_MIXER_WRAPPER;
        }
        this.value = newValue;
        if (!newValue.equals(oldValue)) {
            this.firePropertyChange("value", oldValue, this.value);
        }
    }

    @Override
    @SuppressFBWarnings(value={"NP_LOAD_OF_KNOWN_NULL_VALUE"})
    protected void setValue(String valueString, String defaultValueString) {
        MixerWrapper mw = null;
        if (mw == null && valueString != null) {
            mw = this.getMixerWrapperByName(valueString);
        }
        if (mw == null && defaultValueString != null) {
            mw = this.getMixerWrapperByName(defaultValueString);
        }
        if (mw == null) {
            mw = DEFAULT_MIXER_WRAPPER;
        }
        this.setValue(mw);
    }

    @Override
    protected void writeAttributes(FreeColXMLWriter xw) throws XMLStreamException {
        super.writeAttributes(xw);
        if (this.value != null) {
            xw.writeAttribute("value", this.value.getKey());
        }
    }

    @Override
    public String getXMLTagName() {
        return TAG;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder(16);
        sb.append('[').append(this.getId()).append(' ').append(this.getValue()).append(']');
        return sb.toString();
    }

    static {
        Mixer mixer = null;
        try {
            mixer = AudioSystem.getMixer(null);
        }
        catch (IllegalArgumentException e) {
            logger.log(Level.FINE, "No Audio Mixer installed on the system.", e);
        }
        AUTODETECTED_MIXER = mixer;
        DEFAULT_MIXER_WRAPPER = new MixerWrapper(AUTO_NAME, AUTODETECTED_MIXER == null ? null : AUTODETECTED_MIXER.getMixerInfo());
        audioMixers = new ArrayList<MixerWrapper>();
        audioMixers.addAll(CollectionUtils.transform(AudioSystem.getMixerInfo(), CollectionUtils.alwaysTrue(), mi -> new MixerWrapper(mi.getName(), (Mixer.Info)mi), Comparator.naturalOrder()));
        audioMixers.add(0, DEFAULT_MIXER_WRAPPER);
    }

    public static class MixerWrapper
    implements Comparable<MixerWrapper> {
        private final String name;
        private final Mixer.Info mixerInfo;

        public MixerWrapper(String name, Mixer.Info mixerInfo) {
            this.name = name;
            this.mixerInfo = mixerInfo;
        }

        public String getKey() {
            return this.name;
        }

        public Mixer.Info getMixerInfo() {
            return this.mixerInfo;
        }

        @Override
        public int compareTo(MixerWrapper mw) {
            return this.getKey().compareTo(mw.getKey());
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o instanceof MixerWrapper) {
                return ((MixerWrapper)o).getKey().equals(this.getKey());
            }
            return false;
        }

        public int hashCode() {
            return this.getKey().hashCode();
        }

        public String toString() {
            StringBuilder sb = new StringBuilder(32);
            sb.append(this.name).append('/').append(this.mixerInfo == null ? "null" : this.mixerInfo.toString());
            return sb.toString();
        }
    }
}

