/*
 * Copyright (c) 2012, 2026, Oracle and/or its affiliates. All rights reserved.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This code is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 only, as
 * published by the Free Software Foundation.  Oracle designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Oracle in the LICENSE file that accompanied this code.
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 2 for more details (a copy is included in the LICENSE file that
 * accompanied this code).
 *
 * You should have received a copy of the GNU General Public License version
 * 2 along with this work; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 * Please contact Oracle, 500 Oracle Parkway, Redwood Shores, CA 94065 USA
 * or visit www.oracle.com if you need additional information or have any
 * questions.
 */

/*
 * COPYRIGHT AND PERMISSION NOTICE
 *
 * Copyright (C) 1991-2016 Unicode, Inc. All rights reserved.
 * Distributed under the Terms of Use in 
 * http://www.unicode.org/copyright.html.
 *
 * Permission is hereby granted, free of charge, to any person obtaining
 * a copy of the Unicode data files and any associated documentation
 * (the "Data Files") or Unicode software and any associated documentation
 * (the "Software") to deal in the Data Files or Software
 * without restriction, including without limitation the rights to use,
 * copy, modify, merge, publish, distribute, and/or sell copies of
 * the Data Files or Software, and to permit persons to whom the Data Files
 * or Software are furnished to do so, provided that
 * (a) this copyright and permission notice appear with all copies 
 * of the Data Files or Software,
 * (b) this copyright and permission notice appear in associated 
 * documentation, and
 * (c) there is clear notice in each modified Data File or in the Software
 * as well as in the documentation associated with the Data File(s) or
 * Software that the data or software has been modified.
 *
 * THE DATA FILES AND SOFTWARE ARE PROVIDED "AS IS", WITHOUT WARRANTY OF
 * ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 * NONINFRINGEMENT OF THIRD PARTY RIGHTS.
 * IN NO EVENT SHALL THE COPYRIGHT HOLDER OR HOLDERS INCLUDED IN THIS
 * NOTICE BE LIABLE FOR ANY CLAIM, OR ANY SPECIAL INDIRECT OR CONSEQUENTIAL
 * DAMAGES, OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE,
 * DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER
 * TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
 * PERFORMANCE OF THE DATA FILES OR SOFTWARE.
 *
 * Except as contained in this notice, the name of a copyright holder
 * shall not be used in advertising or otherwise to promote the sale,
 * use or other dealings in these Data Files or Software without prior
 * written authorization of the copyright holder.
 */

package sun.util.resources.cldr.ext;

import sun.util.resources.OpenListResourceBundle;

public class LocaleNames_fo extends OpenListResourceBundle {
    @Override
    protected final Object[][] getContents() {
        final String metaValue_bn = "bangla";
        final String metaValue_bo = "tibetskt";
        final String metaValue_el = "grikskt";
        final String metaValue_gu = "gujarati";
        final String metaValue_he = "hebraiskt";
        final String metaValue_hy = "armenskt";
        final String metaValue_ja = "japanskt";
        final String metaValue_km = "khmer";
        final String metaValue_kn = "kannada";
        final String metaValue_ko = "koreanskt";
        final String metaValue_ml = "malayalam";
        final String metaValue_or = "odia";
        final String metaValue_ta = "tamilskt";
        final String metaValue_te = "telugu";
        final String metaValue_th = "tailendskt";
        final Object[][] data = new Object[][] {
            { "ksh", "k\u00f8lnskt" },
            { "mwl", "mirandesiskt" },
            { "Zsym", "tekin" },
            { "Zsye", "emoji" },
            { "tem", "timne" },
            { "teo", "teso" },
            { "rap", "rapanui" },
            { "AC", "Ascension" },
            { "rar", "rarotongiskt" },
            { "tet", "tetum" },
            { "AD", "Andorra" },
            { "AE", "Sameindu Emirr\u00edkini" },
            { "nl_BE", "flamskt" },
            { "AF", "Afganistan" },
            { "AG", "Antigua & Barbuda" },
            { "type.ca.ethiopic", "etiopiskur kalendari" },
            { "AI", "Anguilla" },
            { "AL", "Albania" },
            { "AM", "Armenia" },
            { "AO", "Angola" },
            { "AQ", "Antarktis" },
            { "AR", "Argentina" },
            { "AS", "Amerikanska Samoa" },
            { "AT", "Eysturr\u00edki" },
            { "AU", "Avstralia" },
            { "AW", "Aruba" },
            { "AX", "\u00c1land" },
            { "AZ", "Aserbadjan" },
            { "BA", "Bosnia-Hersegovina" },
            { "BB", "Barbados" },
            { "ceb", "cebuano" },
            { "BD", "Bangladesj" },
            { "kum", "kumyk" },
            { "BE", "Belgia" },
            { "BF", "Burkina Faso" },
            { "BG", "Bulgaria" },
            { "BH", "Barein" },
            { "BI", "Burundi" },
            { "BJ", "Benin" },
            { "BL", "St. Barth\u00e9lemy" },
            { "BM", "Bermuda" },
            { "myv", "erzya" },
            { "BN", "Brunei" },
            { "BO", "Bolivia" },
            { "BQ", "Ni\u00f0urlonds Karibia" },
            { "BR", "Brasil" },
            { "BS", "Bahamaoyggjar" },
            { "xog", "soga" },
            { "BT", "Butan" },
            { "BV", "Bouvetoyggj" },
            { "BW", "Botsvana" },
            { "BY", "Hv\u00edtarussland" },
            { "BZ", "Belis" },
            { "type.ca.persian", "persiskur kalendari" },
            { "type.nu.hebr", "hebraisk t\u00f8l" },
            { "CA", "Kanada" },
            { "CC", "Kokosoyggjar" },
            { "mzn", "mazanderani" },
            { "CD", "Kongo, Dem. L\u00fd\u00f0veldi\u00f0" },
            { "CF", "Mi\u00f0afrikal\u00fd\u00f0veldi\u00f0" },
            { "CG", "Kongo" },
            { "CH", "Sveis" },
            { "CI", "F\u00edlabeinsstrondin" },
            { "CK", "Cooksoyggjar" },
            { "CL", "Kili" },
            { "CM", "Kamerun" },
            { "CN", "Kina" },
            { "CO", "Kolombia" },
            { "CP", "Clipperton" },
            { "CR", "Kosta Rika" },
            { "CU", "Kuba" },
            { "CV", "Gr\u00f8nh\u00f8vdaoyggjar" },
            { "CW", "Cura\u00e7ao" },
            { "CX", "J\u00f3laoyggjin" },
            { "CY", "K\u00fdpros" },
            { "CZ", "Kekkia" },
            { "eka", "ekajuk" },
            { "DE", "T\u00fdskland" },
            { "ace", "achinese" },
            { "cgg", "chiga" },
            { "DG", "Diego Garcia" },
            { "type.nu.deva", "devanagarik t\u00f8l" },
            { "DJ", "Djibuti" },
            { "DK", "Danmark" },
            { "Brai", "blindaskrift" },
            { "DM", "Dominika" },
            { "type.nu.armnlow", "armensk t\u00f8l (sm\u00e1ir b\u00f3kstavir)" },
            { "DO", "Dominikal\u00fd\u00f0veldi\u00f0" },
            { "gor", "gorontalo" },
            { "zun", "zuni" },
            { "tig", "tigre" },
            { "DZ", "Algeria" },
            { "pag", "pangasinan" },
            { "EA", "Ceuta & Melilla" },
            { "pam", "pampanga" },
            { "EC", "Ekvador" },
            { "pap", "papiamento" },
            { "ada", "adangme" },
            { "EE", "Estland" },
            { "EG", "Egyptaland" },
            { "EH", "Vestursahara" },
            { "pau", "palauan" },
            { "chk", "chuukese" },
            { "chm", "mari" },
            { "cho", "choctaw" },
            { "chr", "cherokee" },
            { "ER", "Eritrea" },
            { "ES", "Spania" },
            { "ET", "Etiopia" },
            { "EU", "Evropasamveldi\u00f0" },
            { "type.ca.gregorian", "gregorianskur kalendari" },
            { "EZ", "Evrasona" },
            { "chy", "cheyenne" },
            { "type.nu.gujr", "gujaratik t\u00f8l" },
            { "ady", "adyghe" },
            { "FI", "Finnland" },
            { "FJ", "Fiji" },
            { "FK", "Falklandsoyggjar" },
            { "FM", "Mikronesiasamveldi\u00f0" },
            { "FO", "F\u00f8royar" },
            { "Taml", metaValue_ta },
            { "FR", "Frakland" },
            { "root", "root" },
            { "GA", "Gabon" },
            { "GB", "St\u00f3rabretland" },
            { "pcm", "nigeriskt pidgin" },
            { "GD", "Grenada" },
            { "GE", "Georgia" },
            { "GF", "Franska Gujana" },
            { "GG", "Guernsey" },
            { "GH", "Gana" },
            { "GI", "Gibraltar" },
            { "GL", "Gr\u00f8nland" },
            { "GM", "Gambia" },
            { "GN", "Guinea" },
            { "GP", "Guadeloupe" },
            { "GQ", "Ekvatorguinea" },
            { "GR", "Grikkaland" },
            { "GS", "Su\u00f0urgeorgia og Su\u00f0ursandwichoyggjar" },
            { "GT", "Guatemala" },
            { "GU", "Guam" },
            { "GW", "Guinea-Bissau" },
            { "tlh", "klingonskt" },
            { "GY", "Gujana" },
            { "ckb", "mi\u00f0kurdiskt" },
            { "zxx", "einki m\u00e1lsligt innihald" },
            { "HK", "Hong Kong SAR Kina" },
            { "HM", "Heard og McDonaldoyggjar" },
            { "HN", "Honduras" },
            { "HR", "Kroatia" },
            { "agq", "aghem" },
            { "gsw", "t\u00fdskt (Sveis)" },
            { "HT", "Haiti" },
            { "HU", "Ungarn" },
            { "IC", "Kanariuoyggjar" },
            { "nan", "min nan kinesiskt" },
            { "ID", "Indonesia" },
            { "IE", "\u00cdrland" },
            { "nap", "napolitanskt" },
            { "naq", "nama" },
            { "zza", "zaza" },
            { "IL", "\u00cdsrael" },
            { "IM", "Isle of Man" },
            { "IN", "India" },
            { "type.co.eor", "r\u00f6\u00f0ina fyrir fj\u00f6ltyngi evr\u00f3pskum skj\u00f6lum" },
            { "IO", "St\u00f3ra Bretlands Indiahavoyggjar" },
            { "IQ", "Irak" },
            { "IR", "Iran" },
            { "IS", "\u00cdsland" },
            { "IT", "Italia" },
            { "Zmth", "st\u00f8ddfr\u00f8\u00f0ilig teknskipan" },
            { "type.nu.thai", "tailendsk t\u00f8l" },
            { "type.nu.beng", "bangla t\u00f8l" },
            { "JE", "Jersey" },
            { "type.ca.islamic", "islamiskur kalendari" },
            { "Beng", metaValue_bn },
            { "JM", "Jamaika" },
            { "JO", "Jordan" },
            { "JP", "Japan" },
            { "ain", "ainu" },
            { "guz", "gusii" },
            { "type.nu.knda", "kannada t\u00f8l" },
            { "de_CH", "h\u00f8gt t\u00fdskt (Sveis)" },
            { "type.ca.buddhist", "buddistiskur kalendari" },
            { "KE", "Kenja" },
            { "419", "Lat\u00ednamerika" },
            { "KG", "Kirgisia" },
            { "KH", "Kambodja" },
            { "KI", "Kiribati" },
            { "KM", "Komoroyggjar" },
            { "Knda", metaValue_kn },
            { "KN", "St. Kitts & Nevis" },
            { "KP", "Nor\u00f0urkorea" },
            { "KR", "Su\u00f0urkorea" },
            { "KW", "Kuvait" },
            { "tpi", "tok pisin" },
            { "KY", "Caymanoyggjar" },
            { "KZ", "Kasakstan" },
            { "Cyrl", "kyrilliskt" },
            { "LA", "Laos" },
            { "LB", "Libanon" },
            { "LC", "St. Lusia" },
            { "gwi", "gwich\u2019in" },
            { "nds", "l\u00e1gt t\u00fdskt" },
            { "LI", "Liktinstein" },
            { "LK", "Sri Lanka" },
            { "LR", "Liberia" },
            { "LS", "Lesoto" },
            { "LT", "Litava" },
            { "LU", "Luksemborg" },
            { "LV", "Lettland" },
            { "Kana", "katakana" },
            { "LY", "Libya" },
            { "lad", "ladino" },
            { "vun", "vunjo" },
            { "lah", "lahnda" },
            { "lag", "langi" },
            { "Thaa", "thaana" },
            { "MA", "Marokko" },
            { "MC", "Monako" },
            { "MD", "Moldova" },
            { "ME", "Montenegro" },
            { "MF", "St-Martin" },
            { "MG", "Madagaskar" },
            { "Thai", metaValue_th },
            { "MH", "Marshalloyggjar" },
            { "ale", "aleut" },
            { "MK", "Maked\u00f3nia" },
            { "ML", "Mali" },
            { "MM", "Myanmar (Burma)" },
            { "MN", "Mongolia" },
            { "new", "newari" },
            { "MO", "Makao SAR Kina" },
            { "MP", "Nor\u00f0aru Mariuoyggjar" },
            { "MQ", "Martinique" },
            { "MR", "M\u00f3ritania" },
            { "MS", "Montserrat" },
            { "MT", "Malta" },
            { "MU", "M\u00f3ritius" },
            { "alt", "su\u00f0ur altai" },
            { "MV", "Maldivoyggjar" },
            { "MW", "Malavi" },
            { "MX", "Meksiko" },
            { "type.ca.japanese", "japanskur kalendari" },
            { "MY", "Malaisia" },
            { "MZ", "Mosambik" },
            { "NA", "Namibia" },
            { "202", "Afrika sunnanfyri Sahara" },
            { "type.ca.hebrew", "hebraiskur kalendari" },
            { "NC", "N\u00fdkaled\u00f3nia" },
            { "%%WADEGILE", "Wade-Giles" },
            { "NE", "Niger" },
            { "NF", "Norfolksoyggj" },
            { "NG", "Nigeria" },
            { "trv", "taroko" },
            { "NI", "Nikaragua" },
            { "NL", "Ni\u00f0urlond" },
            { "NO", "Noreg" },
            { "NP", "Nepal" },
            { "NR", "Nauru" },
            { "NU", "Niue" },
            { "rof", "rombo" },
            { "NZ", "N\u00fds\u00e6land" },
            { "OM", "Oman" },
            { "anp", "angika" },
            { "crs", "seselwa creole franskt" },
            { "PA", "Panama" },
            { "PE", "Peru" },
            { "PF", "Franska Polynesia" },
            { "PG", "Papua N\u00fdguinea" },
            { "PH", "Filipsoyggjar" },
            { "PK", "Pakistan" },
            { "PL", "P\u00f3lland" },
            { "ewo", "ewondo" },
            { "PM", "Saint Pierre & Miquelon" },
            { "PN", "Pitcairnoyggjar" },
            { "PR", "Puerto Riko" },
            { "PS", "Palestinskt land\u00f8ki" },
            { "PT", "Portugal" },
            { "PW", "Palau" },
            { "nia", "nias" },
            { "type.nu.greklow", "grikskt t\u00f8l (sm\u00e1ir b\u00f3kstavir)" },
            { "PY", "Paraguai" },
            { "tum", "tumbuka" },
            { "Hebr", metaValue_he },
            { "QA", "Katar" },
            { "niu", "niuean" },
            { "QO", "fjarskoti Osiania" },
            { "lez", "lezghian" },
            { "tvl", "tuvalu" },
            { "001", "heimur" },
            { "002", "Afrika" },
            { "003", "Nor\u00f0uramerika" },
            { "RE", "R\u00e9union" },
            { "005", "Su\u00f0uramerika" },
            { "jbo", "lojban" },
            { "009", "Osiania" },
            { "RO", "Rumenia" },
            { "RS", "Serbia" },
            { "RU", "Russland" },
            { "RW", "Ruanda" },
            { "SA", "Saudiarabia" },
            { "SB", "Salomonoyggjar" },
            { "twq", "tasawaq" },
            { "011", "Vesturafrika" },
            { "SC", "Seyskelloyggjar" },
            { "SD", "Sudan" },
            { "013", "Mi\u00f0amerika" },
            { "SE", "Sv\u00f8r\u00edki" },
            { "014", "Eysturafrika" },
            { "015", "Nor\u00f0urafrika" },
            { "SG", "Singapor" },
            { "SH", "St. Helena" },
            { "type.lb.strict", "strangur reglubrot st\u00edlur" },
            { "017", "Mi\u00f0afrika" },
            { "SI", "Slovenia" },
            { "018", "sunnari partur av Afrika" },
            { "SJ", "Svalbard & Jan Mayen" },
            { "019", "Amerika" },
            { "SK", "Slovakia" },
            { "SL", "Sierra Leona" },
            { "SM", "San Marino" },
            { "SN", "Senegal" },
            { "SO", "Somalia" },
            { "arn", "mapuche" },
            { "arp", "arapaho" },
            { "type.nu.taml", "vanlig tamilsk t\u00f8l" },
            { "SR", "Surinam" },
            { "SS", "Su\u00f0ursudan" },
            { "ST", "Sao Tome & Prinsipi" },
            { "SV", "El Salvador" },
            { "SX", "Sint Maarten" },
            { "SY", "S\u00fdria" },
            { "SZ", "Svasiland" },
            { "TA", "Tristan da Cunha" },
            { "asa", "asu" },
            { "type.ms.ussystem", "m\u00e1tingareind (USA)" },
            { "021", "Amerika nor\u00f0anfyri Meksiko" },
            { "TC", "Turks- og Caicosoyggjar" },
            { "yav", "yangben" },
            { "TD", "Kjad" },
            { "TF", "Fronsku sunnaru landa\u00f8ki" },
            { "TG", "Togo" },
            { "TH", "Tailand" },
            { "TJ", "Tadsjikistan" },
            { "029", "Karibia" },
            { "TK", "Tokelau" },
            { "TL", "Eysturtimor" },
            { "ybb", "yemba" },
            { "TM", "Turkmenistan" },
            { "TN", "Tunesia" },
            { "TO", "Tonga" },
            { "TR", "Turkaland" },
            { "TT", "Trinidad & Tobago" },
            { "TV", "Tuvalu" },
            { "TW", "Taivan" },
            { "ast", "asturianskt" },
            { "TZ", "Tansania" },
            { "nmg", "kwasio" },
            { "Zzzz", "\u00f3kend skrift" },
            { "UA", "Ukraina" },
            { "rup", "aromenskt" },
            { "030", "Eysturasia" },
            { "tyv", "tuvinian" },
            { "sw_CD", "kongo svahili" },
            { "034", "Su\u00f0urasia" },
            { "035", "\u00datsynningsasia" },
            { "UG", "Uganda" },
            { "hak", "hakka kinesiskt" },
            { "039", "Su\u00f0urevropa" },
            { "Sinh", "sinhala" },
            { "UM", "Sambandsr\u00edki Amerikas fjarskotnu oyggjar" },
            { "UN", "Sameindu Tj\u00f3\u00f0ir" },
            { "US", "Sambandsr\u00edki Amerika" },
            { "haw", "hawaiianskt" },
            { "UY", "Uruguai" },
            { "prg", "prusslanskt" },
            { "UZ", "Usbekistan" },
            { "tzm", "mi\u00f0atlasfj\u00f8ll tamazight" },
            { "nnh", "ngiemboon" },
            { "VA", "Vatikanb\u00fdur" },
            { "VC", "St. Vinsent & Grenadinoyggjar" },
            { "VE", "Venesuela" },
            { "VG", "St\u00f3ra Bretlands Jomfr\u00faoyggjar" },
            { "VI", "Sambandsr\u00edki Amerikas Jomfr\u00faoyggjar" },
            { "VN", "Vjetnam" },
            { "VU", "Vanuatu" },
            { "nog", "nogai" },
            { "rwk", "rwa" },
            { "053", "Avstralasia" },
            { "054", "Melanesia" },
            { "WF", "Wallis- og Futunaoyggjar" },
            { "057", "Mikronesi \u00f8ki" },
            { "jgo", "ngomba" },
            { "lkt", "lakota" },
            { "wae", "walser" },
            { "WS", "Samoa" },
            { "wal", "wolaytta" },
            { "war", "waray" },
            { "awa", "awadhi" },
            { "061", "Polynesia" },
            { "XK", "Kosovo" },
            { "Gujr", metaValue_gu },
            { "Zxxx", "\u00f3skriva" },
            { "wbp", "warlpiri" },
            { "YE", "Jemen" },
            { "nqo", "n\u02bcko" },
            { "type.co.standard", "vanlig ra\u00f0skipan" },
            { "YT", "Mayotte" },
            { "ZA", "Su\u00f0urafrika" },
            { "type.lb.loose", "leysur reglubrot st\u00edlur" },
            { "Deva", "devanagari" },
            { "type.nu.geor", "gregoriansk t\u00f8l" },
            { "Hira", "hiragana" },
            { "ZM", "Sambia" },
            { "%%PINYIN", "pinyin" },
            { "ZW", "Simbabvi" },
            { "ZZ", "\u00f3kent \u00f8ki" },
            { "type.ms.metric", "metralag" },
            { "type.ca.iso8601", "ISO-8601 kalendari" },
            { "nso", "nor\u00f0ur sotho" },
            { "type.nu.telu", "telugu t\u00f8l" },
            { "loz", "lozi" },
            { "jmc", "machame" },
            { "type.nu.hansfin", "einkul kinesisk f\u00edggjarlig t\u00f8l" },
            { "hil", "hiligaynon" },
            { "type.nu.arabext", "v\u00ed\u00f0ka\u00f0 arabisk t\u00f8l" },
            { "nus", "nuer" },
            { "dak", "dakota" },
            { "type.nu.fullwide", "t\u00f8l \u00ed fullari longd" },
            { "dar", "dargwa" },
            { "dav", "taita" },
            { "lrc", "nor\u00f0ur luri" },
            { "udm", "udmurt" },
            { "Khmr", metaValue_km },
            { "sad", "sandawe" },
            { "type.nu.roman", "r\u00f3mart\u00f8l" },
            { "sah", "sakha" },
            { "saq", "samburu" },
            { "sat", "santali" },
            { "sba", "ngambay" },
            { "Guru", "gurmukhi" },
            { "lua", "luba-lulua" },
            { "sbp", "sangu" },
            { "nyn", "nyankole" },
            { "lun", "lunda" },
            { "luo", "luo" },
            { "fil", "filipiniskt" },
            { "hmn", "hmong" },
            { "lus", "mizo" },
            { "ban", "balinesiskt" },
            { "luy", "luyia" },
            { "bas", "basaa" },
            { "sco", "skotskt" },
            { "scn", "sisilanskt" },
            { "aa", "afar" },
            { "ab", "abkhasiskt" },
            { "af", "afrikaans" },
            { "ak", "akan" },
            { "am", "amhariskt" },
            { "an", "aragoniskt" },
            { "Arab", "arabisk" },
            { "Jpan", metaValue_ja },
            { "ar", "arabiskt" },
            { "Hrkt", "japanskir stavir" },
            { "as", "assamesiskt" },
            { "av", "avariskt" },
            { "sdh", "su\u00f0ur kurdiskt" },
            { "ay", "aymara" },
            { "az", "aserbajdsjanskt" },
            { "ba", "bashkir" },
            { "be", "hvitarussiskt" },
            { "bg", "bulgarskt" },
            { "bi", "bislama" },
            { "bm", "bambara" },
            { "bn", metaValue_bn },
            { "bo", metaValue_bo },
            { "dgr", "dogrib" },
            { "br", "bretonskt" },
            { "bs", "bosniskt" },
            { "Mymr", "myanmarskt" },
            { "type.nu.laoo", "lao t\u00f8l" },
            { "seh", "sena" },
            { "ca", "katalani" },
            { "ses", "koyraboro senni" },
            { "ce", "tjetjenskt" },
            { "ch", "chamorro" },
            { "co", "korsikanskt" },
            { "Orya", metaValue_or },
            { "cs", "kekkiskt" },
            { "cu", "kirkju sl\u00e1viskt" },
            { "cv", "chuvash" },
            { "cy", "walisiskt" },
            { "type.nu.ethi", "etiopisk t\u00f8l" },
            { "da", "danskt" },
            { "pt_PT", "portugiskiskt (Evropa)" },
            { "de", "t\u00fdskt" },
            { "type.cf.standard", "vanlig gjaldoyra format" },
            { "bem", "bemba" },
            { "dv", "divehi" },
            { "dz", "dzongkha" },
            { "bez", "bena" },
            { "type.ca.chinese", "kinesiskur kalendari" },
            { "dje", "sarma" },
            { "type.nu.grek", "grikskt t\u00f8l" },
            { "ee", "ewe" },
            { "type.lb.normal", "vanligur reglubrot st\u00edlur" },
            { "ro_MD", "moldaviskt" },
            { "el", metaValue_el },
            { "en", "enskt" },
            { "eo", "esperanto" },
            { "es", "spanskt" },
            { "et", "estiskt" },
            { "Hanb", "hanb" },
            { "eu", "baskiskt" },
            { "Hang", "hangul" },
            { "shi", "tachelhit" },
            { "hsb", "ovara sorbian" },
            { "Hani", "han" },
            { "shn", "shan" },
            { "fa", "persiskt" },
            { "Hans", "einkult" },
            { "type.nu.latn", "vesturlendsk t\u00f8l" },
            { "Hant", "vanligt" },
            { "ff", "fulah" },
            { "hsn", "xiang kinesiskt" },
            { "fi", "finskt" },
            { "fj", "fijim\u00e1l" },
            { "fon", "fon" },
            { "bgn", "vestur balochi" },
            { "yue", "kantonesiskt" },
            { "fo", "f\u00f8royskt" },
            { "umb", "umbundu" },
            { "fr", "franskt" },
            { "fy", "vestur fr\u00edsiskt" },
            { "ga", "\u00edrskt" },
            { "gd", "skotskt g\u00e6liskt" },
            { "gl", "galisiskt" },
            { "gn", "guarani" },
            { "bho", "bhojpuri" },
            { "und", "\u00f3kent m\u00e1l" },
            { "gu", metaValue_gu },
            { "gv", "manx" },
            { "ha", "hausa" },
            { "he", metaValue_he },
            { "hi", "hindi" },
            { "hup", "hupa" },
            { "bin", "bini" },
            { "hr", "kroatiskt" },
            { "ht", "haitiskt creole" },
            { "hu", "ungarskt" },
            { "hy", metaValue_hy },
            { "hz", "herero" },
            { "ia", "interlingua" },
            { "Jamo", "jamo" },
            { "id", "indonesiskt" },
            { "type.nu.tibt", "tibetsk t\u00f8l" },
            { "ie", "interlingue" },
            { "ig", "igbo" },
            { "ii", "sichuan yi" },
            { "io", "ido" },
            { "is", "\u00edslendskt" },
            { "it", "italskt" },
            { "iu", "inuktitut" },
            { "ja", metaValue_ja },
            { "Mlym", metaValue_ml },
            { "sma", "su\u00f0ur s\u00e1miskt" },
            { "jv", "javanskt" },
            { "mad", "maduresiskt" },
            { "smj", "lule s\u00e1miskt" },
            { "mag", "magahi" },
            { "mai", "maithili" },
            { "smn", "inari sami" },
            { "ka", "georgiskt" },
            { "bla", "siksika" },
            { "mak", "makasar" },
            { "wuu", "wu kinesiskt" },
            { "sms", "skolt s\u00e1miskt" },
            { "ki", "kikuyu" },
            { "mas", "masai" },
            { "kj", "kuanyama" },
            { "kk", "kazakh" },
            { "kl", "kalaallisut" },
            { "km", metaValue_km },
            { "kn", metaValue_kn },
            { "ko", metaValue_ko },
            { "kr", "kanuri" },
            { "ks", "kashmiri" },
            { "ku", "kurdiskt" },
            { "kv", "komi" },
            { "kw", "corniskt" },
            { "ky", "kyrgyz" },
            { "snk", "soninke" },
            { "la", "lat\u00edn" },
            { "lb", "luksemborgskt" },
            { "type.nu.mlym", "malayalam t\u00f8l" },
            { "lg", "ganda" },
            { "li", "limburgiskt" },
            { "Tibt", metaValue_bo },
            { "ln", "lingala" },
            { "fur", "friuliskt" },
            { "lo", "laoskt" },
            { "type.ms.uksystem", "m\u00e1tingareind (UK)" },
            { "lt", "litaviskt" },
            { "lu", "luba-katanga" },
            { "lv", "lettiskt" },
            { "mg", "malagassiskt" },
            { "mh", "marshallesiskt" },
            { "type.co.ducet", "forsett Unicode ra\u00f0skipan" },
            { "mi", "maori" },
            { "mk", "maked\u00f3nskt" },
            { "ml", metaValue_ml },
            { "mn", "mongolskt" },
            { "mr", "marathi" },
            { "ms", "malaiiskt" },
            { "mt", "maltiskt" },
            { "my", "burmesiskt" },
            { "Armn", metaValue_hy },
            { "mdf", "moksha" },
            { "dsb", "l\u00e1gt sorbian" },
            { "na", "nauru" },
            { "type.co.search", "vanlig leiting" },
            { "nb", "norskt b\u00f3km\u00e1l" },
            { "nd", "nor\u00f0ur ndebele" },
            { "ne", "nepalskt" },
            { "ng", "ndonga" },
            { "nl", "h\u00e1lendskt" },
            { "nn", "n\u00fdnorskt" },
            { "no", "norskt" },
            { "nr", "su\u00f0ur ndebele" },
            { "nv", "navajo" },
            { "ny", "nyanja" },
            { "kac", "kachin" },
            { "kab", "kabyle" },
            { "%%POLYTON", "polyton\u00edsk" },
            { "oc", "occitanskt" },
            { "kaj", "jju" },
            { "kam", "kamba" },
            { "men", "mende" },
            { "mer", "meru" },
            { "type.nu.armn", "armensk t\u00f8l" },
            { "om", "oromo" },
            { "or", metaValue_or },
            { "os", "ossetiskt" },
            { "kbd", "kabardinskt" },
            { "mfe", "morisyen" },
            { "srn", "sranan tongo" },
            { "pa", "punjabi" },
            { "dua", "duala" },
            { "pl", "p\u00f3lskt" },
            { "type.ca.dangi", "dangi kalendari" },
            { "ps", "pashto" },
            { "pt", "portugiskiskt" },
            { "key.co", "ra\u00f0skipan" },
            { "pt_BR", "portugiskiskt (Brasilia)" },
            { "kcg", "tyap" },
            { "mgh", "makhuwa-meetto" },
            { "key.cf", "gjaldoyra format" },
            { "key.ca", "kalendari" },
            { "Laoo", "lao" },
            { "mgo", "meta\u02bc" },
            { "type.hc.h23", "24 t\u00edmar klokkuskipan (0\u201323)" },
            { "type.hc.h24", "24 t\u00edmar klokkuskipan (1\u201324)" },
            { "ssy", "saho" },
            { "type.nu.mymr", "myanmarsk t\u00f8l" },
            { "qu", "quechua" },
            { "brx", "bodo" },
            { "kde", "makonde" },
            { "Ethi", "etiopiskt" },
            { "type.hc.h12", "12 t\u00edmar klokkuskipan (1\u201312)" },
            { "type.hc.h11", "12 t\u00edmar klokkuskipan (0\u201311)" },
            { "rm", "retoromanskt" },
            { "rn", "rundi" },
            { "key.cu", "gjaldoyra" },
            { "ro", "rumenskt" },
            { "type.nu.orya", "odia t\u00f8l" },
            { "type.nu.hanidec", "kinesisk desimal t\u00f8l" },
            { "ru", "russiskt" },
            { "bss", "bakossi" },
            { "rw", "kinyarwanda" },
            { "kea", "gr\u00f8nh\u00f8vdaoyggjarskt" },
            { "mic", "micmac" },
            { "suk", "sukuma" },
            { "sa", "sanskrit" },
            { "sc", "sardiskt" },
            { "sd", "sindhi" },
            { "se", "nor\u00f0ur s\u00e1miskt" },
            { "min", "minangkabau" },
            { "sg", "sango" },
            { "sh", "serbokroatiskt" },
            { "si", "singalesiskt" },
            { "sk", "slovakiskt" },
            { "sl", "slovenskt" },
            { "sm", "s\u00e1moiskt" },
            { "sn", "shona" },
            { "so", "somaliskt" },
            { "type.nu.arab", "arabisk t\u00f8l" },
            { "sq", "albanskt" },
            { "sr", "serbiskt" },
            { "ss", "swatiskt" },
            { "type.cf.account", "gjaldoyras roknskaparf\u00f8rsla format" },
            { "st", "sesotho" },
            { "su", "sundanesiskt" },
            { "sv", "svenskt" },
            { "sw", "swahili" },
            { "type.nu.hantfin", "vanlig kinesisk f\u00edggjarlig t\u00f8l" },
            { "ibb", "ibibio" },
            { "iba", "iban" },
            { "ta", metaValue_ta },
            { "142", "Asia" },
            { "143", "Mi\u00f0asia" },
            { "te", metaValue_te },
            { "145", "Vesturasia" },
            { "tg", "tajik" },
            { "th", metaValue_th },
            { "ti", "tigrinya" },
            { "bug", "buginesiskt" },
            { "kfo", "koro" },
            { "tk", "turkmenskt" },
            { "tl", "tagalog" },
            { "tn", "tswana" },
            { "to", "tonganskt" },
            { "dyo", "jola-fonyi" },
            { "type.nu.jpan", "japanskt t\u00f8l" },
            { "tr", "turkiskt" },
            { "ts", "tsonga" },
            { "swb", "komoriskt" },
            { "tt", "tatar" },
            { "tw", "twi" },
            { "ty", "tahitiskt" },
            { "150", "Evropa" },
            { "151", "Eysturevropa" },
            { "154", "Nor\u00f0urevropa" },
            { "dzg", "dazaga" },
            { "155", "Vesturevropa" },
            { "ug", "uyghur" },
            { "Kore", metaValue_ko },
            { "Zyyy", "vanlig" },
            { "uk", "ukrainskt" },
            { "ur", "urdu" },
            { "xal", "kalmyk" },
            { "uz", "usbekiskt" },
            { "kha", "khasi" },
            { "nds_NL", "l\u00e1gt saksiskt" },
            { "ve", "venda" },
            { "type.ca.roc", "minguo kalendari" },
            { "vi", "vjetnamesiskt" },
            { "khq", "koyra chiini" },
            { "key.hc", "klokkuskipan (12 \u00edm\u00f3ti 24)" },
            { "vo", "volapykk" },
            { "quc", "k\u02bciche\u02bc" },
            { "gaa", "ga" },
            { "wa", "walloon" },
            { "gag", "gagauz" },
            { "syr", "syriac" },
            { "Grek", metaValue_el },
            { "gan", "gan kinesiskt" },
            { "wo", "wolof" },
            { "zgh", "vanligt marokanskt tamazight" },
            { "ar_001", "n\u00fat\u00ed\u00f0ar vanligt arabiskt" },
            { "Mong", "mongolsk" },
            { "mni", "manupuri" },
            { "Latn", "lat\u00ednskt" },
            { "type.nu.hans", "einkul kinesisk t\u00f8l" },
            { "type.nu.hant", "vanlig kinesisk t\u00f8l" },
            { "xh", "xhosa" },
            { "type.nu.romanlow", "r\u00f3mart\u00f8l (sm\u00e1ir b\u00f3kstavir)" },
            { "byn", "blin" },
            { "moh", "mohawk" },
            { "kkj", "kako" },
            { "yi", "jiddiskt" },
            { "mos", "mossi" },
            { "yo", "yoruba" },
            { "vai", "vai" },
            { "kln", "kalenjin" },
            { "zh", "kinesiskt" },
            { "Bopo", "bopomofo" },
            { "key.lb", "reglubrot st\u00edlur" },
            { "zu", "sulu" },
            { "%%MONOTON", "monoton\u00edsk" },
            { "Geor", "georgianskt" },
            { "kmb", "kimbundu" },
            { "type.nu.jpanfin", "japanskt f\u00edggjarlig t\u00f8l" },
            { "gez", "geez" },
            { "ebu", "embu" },
            { "zh_Hans", "einkult kinesiskt" },
            { "koi", "komi-permyak" },
            { "kok", "konkani" },
            { "zh_Hant", "vanligt kinesiskt" },
            { "kpe", "kpelle" },
            { "type.nu.khmr", "khmer t\u00f8l" },
            { "ilo", "iloko" },
            { "mua", "mundang" },
            { "type.nu.guru", "gurmukhik t\u00f8l" },
            { "mul", "ymisk m\u00e1l" },
            { "key.ms", "m\u00e1tingareind" },
            { "mus", "creek" },
            { "gil", "kiribatiskt" },
            { "type.nu.tamldec", "tamilsk t\u00f8l" },
            { "krc", "karachay-balkar" },
            { "inh", "inguish" },
            { "krl", "karelskt" },
            { "efi", "efik" },
            { "key.nu", "t\u00f8l" },
            { "kru", "kurukh" },
            { "ksb", "shambala" },
            { "Telu", metaValue_te },
            { "ksf", "bafia" },
        };
        return data;
    }
}
