/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.engine.internal;

import org.hibernate.engine.internal.VersionLogger;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.generator.EventType;
import org.hibernate.metamodel.mapping.EntityVersionMapping;
import org.hibernate.persister.entity.EntityPersister;
import org.hibernate.type.descriptor.java.JavaType;

public final class Versioning {
    private static final VersionLogger LOG = VersionLogger.INSTANCE;

    private Versioning() {
    }

    public static Object seed(EntityVersionMapping versionMapping, SharedSessionContractImplementor session) {
        Object seed = versionMapping.getJavaType().seed(versionMapping.getLength(), versionMapping.getTemporalPrecision() != null ? versionMapping.getTemporalPrecision() : versionMapping.getPrecision(), versionMapping.getScale(), session);
        LOG.seed(seed);
        return seed;
    }

    public static boolean seedVersion(Object entity, Object[] fields, EntityPersister persister, SharedSessionContractImplementor session) {
        int versionProperty = persister.getVersionProperty();
        Object initialVersion = fields[versionProperty];
        if (Versioning.isNullInitialVersion(initialVersion)) {
            fields[versionProperty] = persister.getVersionGenerator().generate(session, entity, initialVersion, EventType.INSERT);
            return true;
        }
        LOG.initial(initialVersion);
        return false;
    }

    public static boolean isNullInitialVersion(Object initialVersion) {
        Number number;
        return initialVersion == null || initialVersion instanceof Number && (number = (Number)initialVersion).longValue() < 0L;
    }

    public static Object incrementVersion(Object entity, Object currentVersion, EntityPersister persister, SharedSessionContractImplementor session) {
        return persister.getVersionGenerator().generate(session, entity, currentVersion, EventType.UPDATE);
    }

    public static Object increment(Object version, EntityVersionMapping versionMapping, SharedSessionContractImplementor session) {
        JavaType versionType = versionMapping.getJavaType();
        Object next = versionType.next(version, versionMapping.getLength(), versionMapping.getTemporalPrecision() != null ? versionMapping.getTemporalPrecision() : versionMapping.getPrecision(), versionMapping.getScale(), session);
        LOG.incrementing(version, next);
        return next;
    }

    public static void setVersion(Object[] fields, Object version, EntityPersister persister) {
        if (persister.isVersioned()) {
            fields[persister.getVersionProperty()] = version;
        }
    }

    public static Object getVersion(Object[] fields, EntityPersister persister) {
        return persister.isVersioned() ? fields[persister.getVersionProperty()] : null;
    }

    public static boolean isVersionIncrementRequired(int[] dirtyProperties, boolean hasDirtyCollections, boolean[] propertyVersionability) {
        if (hasDirtyCollections) {
            return true;
        }
        if (dirtyProperties != null) {
            for (int dirtyProperty : dirtyProperties) {
                if (!propertyVersionability[dirtyProperty]) continue;
                return true;
            }
        }
        return false;
    }
}

