/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.quarkus.runtime.cli;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import org.keycloak.config.OptionCategory;
import org.keycloak.quarkus.runtime.cli.OptionRenderer;
import org.keycloak.quarkus.runtime.configuration.mappers.PropertyMapper;
import org.keycloak.quarkus.runtime.configuration.mappers.PropertyMappers;
import org.keycloak.utils.StringUtil;
import picocli.CommandLine;

public final class Help
extends CommandLine.Help {
    static final String[] OPTION_NAMES = new String[]{"-h", "--help"};
    private static final int HELP_WIDTH = 100;
    private static final String DEFAULT_OPTION_LIST_HEADING = "Options:";
    private static final String DEFAULT_COMMAND_LIST_HEADING = "Commands:";
    private static boolean ALL_OPTIONS;

    Help(CommandLine.Model.CommandSpec commandSpec, CommandLine.Help.ColorScheme colorScheme) {
        super(commandSpec, colorScheme);
        this.configureUsageMessage(commandSpec);
    }

    public String optionList(CommandLine.Help.Layout layout, Comparator<CommandLine.Model.OptionSpec> optionSort, CommandLine.Help.IParamLabelRenderer valueLabelRenderer) {
        List<CommandLine.Model.OptionSpec> visibleOptionsNotInGroups = this.excludeHiddenAndGroupOptions(this.commandSpec().options());
        return this.optionListExcludingGroups(visibleOptionsNotInGroups, layout, optionSort, valueLabelRenderer) + this.optionListGroupSections();
    }

    private List<CommandLine.Model.OptionSpec> excludeHiddenAndGroupOptions(List<CommandLine.Model.OptionSpec> all) {
        ArrayList<CommandLine.Model.OptionSpec> result = new ArrayList<CommandLine.Model.OptionSpec>(all);
        for (CommandLine.Model.ArgGroupSpec group : this.optionSectionGroups()) {
            result.removeAll(group.allOptionsNested());
        }
        Iterator iter = result.iterator();
        while (iter.hasNext()) {
            CommandLine.Model.OptionSpec optionSpec = (CommandLine.Model.OptionSpec)iter.next();
            if (this.isVisible(optionSpec)) continue;
            iter.remove();
        }
        return result;
    }

    public CommandLine.Help.Layout createDefaultLayout() {
        return new CommandLine.Help.Layout(this.colorScheme(), this.createTextTable(), this.createDefaultOptionRenderer(), this.createDefaultParameterRenderer()){

            public void addOptions(List<CommandLine.Model.OptionSpec> options, CommandLine.Help.IParamLabelRenderer paramLabelRenderer) {
                for (CommandLine.Model.OptionSpec optionSpec : options) {
                    if (!Help.this.isVisible(optionSpec)) continue;
                    this.addOption(optionSpec, paramLabelRenderer);
                }
            }
        };
    }

    private CommandLine.Help.TextTable createTextTable() {
        int longOptionsColumnWidth = this.commandSpec().commandLine().getUsageHelpLongOptionsMaxWidth();
        int descriptionWidth = 100 - longOptionsColumnWidth;
        CommandLine.Help.TextTable textTable = CommandLine.Help.TextTable.forColumns((CommandLine.Help.ColorScheme)this.colorScheme(), (CommandLine.Help.Column[])new CommandLine.Help.Column[]{new CommandLine.Help.Column(longOptionsColumnWidth, 0, CommandLine.Help.Column.Overflow.SPAN), new CommandLine.Help.Column(descriptionWidth, 1, CommandLine.Help.Column.Overflow.WRAP)});
        textTable.setAdjustLineBreaksForWideCJKCharacters(this.commandSpec().usageMessage().adjustLineBreaksForWideCJKCharacters());
        return textTable;
    }

    public CommandLine.Help.IOptionRenderer createDefaultOptionRenderer() {
        return new OptionRenderer();
    }

    public String createHeading(String text, Object ... params) {
        if (StringUtil.isBlank((String)text)) {
            return super.createHeading(text, params);
        }
        return super.createHeading("%n@|bold " + text + "|@%n%n", params);
    }

    public CommandLine.Help.IParameterRenderer createDefaultParameterRenderer() {
        return new CommandLine.Help.IParameterRenderer(){

            public CommandLine.Help.Ansi.Text[][] render(CommandLine.Model.PositionalParamSpec param, CommandLine.Help.IParamLabelRenderer parameterLabelRenderer, CommandLine.Help.ColorScheme scheme) {
                return new CommandLine.Help.Ansi.Text[0][];
            }
        };
    }

    public List<CommandLine.Model.ArgGroupSpec> optionSectionGroups() {
        List allGroupSpecs = super.optionSectionGroups();
        ArrayList<CommandLine.Model.ArgGroupSpec> nonEmptyGroups = new ArrayList<CommandLine.Model.ArgGroupSpec>(allGroupSpecs);
        Iterator argGroupSpecsIt = nonEmptyGroups.iterator();
        while (argGroupSpecsIt.hasNext()) {
            CommandLine.Model.ArgGroupSpec argGroupSpec = (CommandLine.Model.ArgGroupSpec)argGroupSpecsIt.next();
            if (argGroupSpec.options().stream().anyMatch(this::isVisible)) continue;
            argGroupSpecsIt.remove();
        }
        return nonEmptyGroups;
    }

    private void configureUsageMessage(CommandLine.Model.CommandSpec commandSpec) {
        commandSpec.usageMessage().abbreviateSynopsis(true).optionListHeading(DEFAULT_OPTION_LIST_HEADING).commandListHeading(DEFAULT_COMMAND_LIST_HEADING);
    }

    private boolean isVisible(CommandLine.Model.OptionSpec option) {
        String kcKey;
        if (option.description().length == 0 || option.hidden()) {
            return false;
        }
        if (ALL_OPTIONS) {
            return true;
        }
        String optionName = OptionRenderer.undecorateDuplicitOptionName(option.longestName());
        OptionCategory category = null;
        if (option.group() != null && option.group().heading() != null) {
            category = OptionCategory.fromHeading((String)StringUtil.removeSuffix((String)option.group().heading(), (String)":"));
        }
        if ((kcKey = (String)PropertyMappers.getKcKeyFromCliKey(optionName).orElse(null)) == null) {
            return true;
        }
        PropertyMapper<?> mapper = PropertyMappers.getMapper(kcKey, category);
        if (mapper == null) {
            Optional<PropertyMapper<?>> disabledMapper = PropertyMappers.getDisabledMapper(kcKey);
            return disabledMapper.flatMap(PropertyMapper::getEnabledWhen).isEmpty();
        }
        return PropertyMappers.isSupported(mapper);
    }

    public static void setAllOptions(boolean allOptions) {
        ALL_OPTIONS = allOptions;
    }
}

