/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.security.mechanism.scram;

import java.security.Provider;
import java.security.SecureRandom;
import java.util.function.Supplier;
import javax.security.auth.callback.CallbackHandler;
import org.wildfly.security.auth.callback.ChannelBindingCallback;
import org.wildfly.security.mechanism.AuthenticationMechanismException;
import org.wildfly.security.mechanism.scram.ScramClient;
import org.wildfly.security.mechanism.scram.ScramServer;

public final class ScramMechanism {
    private final int hashSize;
    private final String messageDigestName;
    private final String hmacName;
    private final boolean plus;
    private final String passwordAlgorithm;
    private final String toString;
    public static final ScramMechanism SCRAM_SHA_1 = new ScramMechanism(20, "SHA-1", "HmacSHA1", false, "scram-sha-1");
    public static final ScramMechanism SCRAM_SHA_1_PLUS = new ScramMechanism(20, "SHA-1", "HmacSHA1", true, "scram-sha-1");
    public static final ScramMechanism SCRAM_SHA_256 = new ScramMechanism(32, "SHA-256", "HmacSHA256", false, "scram-sha-256");
    public static final ScramMechanism SCRAM_SHA_256_PLUS = new ScramMechanism(32, "SHA-256", "HmacSHA256", true, "scram-sha-256");
    public static final ScramMechanism SCRAM_SHA_384 = new ScramMechanism(48, "SHA-384", "HmacSHA384", false, "scram-sha-384");
    public static final ScramMechanism SCRAM_SHA_384_PLUS = new ScramMechanism(32, "SHA-384", "HmacSHA384", true, "scram-sha-384");
    public static final ScramMechanism SCRAM_SHA_512 = new ScramMechanism(64, "SHA-512", "HmacSHA512", false, "scram-sha-512");
    public static final ScramMechanism SCRAM_SHA_512_PLUS = new ScramMechanism(64, "SHA-512", "HmacSHA512", true, "scram-sha-512");

    private ScramMechanism(int hashSize, String messageDigestName, String hmacName, boolean plus, String passwordAlgorithm) {
        this.hashSize = hashSize;
        this.messageDigestName = messageDigestName;
        this.hmacName = hmacName;
        this.plus = plus;
        this.passwordAlgorithm = passwordAlgorithm;
        StringBuilder b = new StringBuilder();
        b.append("SCRAM ").append(messageDigestName).append(' ');
        if (plus) {
            b.append("(PLUS channel binding) ");
        }
        b.append(hashSize * 8).append(" bits");
        this.toString = b.toString();
    }

    public ScramClient createClient(String authorizationId, CallbackHandler callbackHandler, SecureRandom secureRandom, ChannelBindingCallback bindingCallback, int minimumIterationCount, int maximumIterationCount, Supplier<Provider[]> providers) throws AuthenticationMechanismException {
        String bindingType;
        byte[] bindingData;
        if (bindingCallback != null) {
            bindingData = bindingCallback.getBindingData();
            bindingType = bindingCallback.getBindingType();
        } else {
            if (this.plus) {
                return null;
            }
            bindingData = null;
            bindingType = null;
        }
        return new ScramClient(this, authorizationId, callbackHandler, secureRandom, bindingData, bindingType, minimumIterationCount, maximumIterationCount, providers);
    }

    public ScramServer createServer(CallbackHandler callbackHandler, SecureRandom random, ChannelBindingCallback bindingCallback, int minimumIterationCount, int maximumIterationCount, Supplier<Provider[]> providers) throws AuthenticationMechanismException {
        String bindingType;
        byte[] bindingData;
        if (bindingCallback != null) {
            bindingData = bindingCallback.getBindingData();
            bindingType = bindingCallback.getBindingType();
        } else {
            if (this.plus) {
                return null;
            }
            bindingData = null;
            bindingType = null;
        }
        return new ScramServer(this, callbackHandler, random, bindingData, bindingType, minimumIterationCount, maximumIterationCount, providers);
    }

    public int getHashSize() {
        return this.hashSize;
    }

    public String getMessageDigestName() {
        return this.messageDigestName;
    }

    public String getHmacName() {
        return this.hmacName;
    }

    public boolean isPlus() {
        return this.plus;
    }

    public String getPasswordAlgorithm() {
        return this.passwordAlgorithm;
    }

    public String toString() {
        return this.toString;
    }
}

