/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.openxr;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class XrSceneMeshBuffersMSFT
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int TYPE;
    public static final int NEXT;

    public XrSceneMeshBuffersMSFT(ByteBuffer container) {
        super(MemoryUtil.memAddress((ByteBuffer)container), XrSceneMeshBuffersMSFT.__checkContainer((ByteBuffer)container, (int)SIZEOF));
    }

    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="XrStructureType")
    public int type() {
        return XrSceneMeshBuffersMSFT.ntype(this.address());
    }

    @NativeType(value="void *")
    public long next() {
        return XrSceneMeshBuffersMSFT.nnext(this.address());
    }

    public XrSceneMeshBuffersMSFT type(@NativeType(value="XrStructureType") int value) {
        XrSceneMeshBuffersMSFT.ntype(this.address(), value);
        return this;
    }

    public XrSceneMeshBuffersMSFT type$Default() {
        return this.type(1000097015);
    }

    public XrSceneMeshBuffersMSFT next(@NativeType(value="void *") long value) {
        XrSceneMeshBuffersMSFT.nnext(this.address(), value);
        return this;
    }

    public XrSceneMeshBuffersMSFT set(int type, long next) {
        this.type(type);
        this.next(next);
        return this;
    }

    public XrSceneMeshBuffersMSFT set(XrSceneMeshBuffersMSFT src) {
        MemoryUtil.memCopy((long)src.address(), (long)this.address(), (long)SIZEOF);
        return this;
    }

    public static XrSceneMeshBuffersMSFT malloc() {
        return (XrSceneMeshBuffersMSFT)XrSceneMeshBuffersMSFT.wrap(XrSceneMeshBuffersMSFT.class, (long)MemoryUtil.nmemAllocChecked((long)SIZEOF));
    }

    public static XrSceneMeshBuffersMSFT calloc() {
        return (XrSceneMeshBuffersMSFT)XrSceneMeshBuffersMSFT.wrap(XrSceneMeshBuffersMSFT.class, (long)MemoryUtil.nmemCallocChecked((long)1L, (long)SIZEOF));
    }

    public static XrSceneMeshBuffersMSFT create() {
        ByteBuffer container = BufferUtils.createByteBuffer((int)SIZEOF);
        return (XrSceneMeshBuffersMSFT)XrSceneMeshBuffersMSFT.wrap(XrSceneMeshBuffersMSFT.class, (long)MemoryUtil.memAddress((ByteBuffer)container), (ByteBuffer)container);
    }

    public static XrSceneMeshBuffersMSFT create(long address) {
        return (XrSceneMeshBuffersMSFT)XrSceneMeshBuffersMSFT.wrap(XrSceneMeshBuffersMSFT.class, (long)address);
    }

    @Nullable
    public static XrSceneMeshBuffersMSFT createSafe(long address) {
        return address == 0L ? null : (XrSceneMeshBuffersMSFT)XrSceneMeshBuffersMSFT.wrap(XrSceneMeshBuffersMSFT.class, (long)address);
    }

    public static Buffer malloc(int capacity) {
        return (Buffer)XrSceneMeshBuffersMSFT.wrap(Buffer.class, (long)MemoryUtil.nmemAllocChecked((long)XrSceneMeshBuffersMSFT.__checkMalloc((int)capacity, (int)SIZEOF)), (int)capacity);
    }

    public static Buffer calloc(int capacity) {
        return (Buffer)XrSceneMeshBuffersMSFT.wrap(Buffer.class, (long)MemoryUtil.nmemCallocChecked((long)capacity, (long)SIZEOF), (int)capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = XrSceneMeshBuffersMSFT.__create((int)capacity, (int)SIZEOF);
        return (Buffer)XrSceneMeshBuffersMSFT.wrap(Buffer.class, (long)MemoryUtil.memAddress((ByteBuffer)container), (int)capacity, (ByteBuffer)container);
    }

    public static Buffer create(long address, int capacity) {
        return (Buffer)XrSceneMeshBuffersMSFT.wrap(Buffer.class, (long)address, (int)capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : (Buffer)XrSceneMeshBuffersMSFT.wrap(Buffer.class, (long)address, (int)capacity);
    }

    public static XrSceneMeshBuffersMSFT malloc(MemoryStack stack) {
        return (XrSceneMeshBuffersMSFT)XrSceneMeshBuffersMSFT.wrap(XrSceneMeshBuffersMSFT.class, (long)stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static XrSceneMeshBuffersMSFT calloc(MemoryStack stack) {
        return (XrSceneMeshBuffersMSFT)XrSceneMeshBuffersMSFT.wrap(XrSceneMeshBuffersMSFT.class, (long)stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return (Buffer)XrSceneMeshBuffersMSFT.wrap(Buffer.class, (long)stack.nmalloc(ALIGNOF, capacity * SIZEOF), (int)capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return (Buffer)XrSceneMeshBuffersMSFT.wrap(Buffer.class, (long)stack.ncalloc(ALIGNOF, capacity, SIZEOF), (int)capacity);
    }

    public static int ntype(long struct) {
        return UNSAFE.getInt(null, struct + (long)TYPE);
    }

    public static long nnext(long struct) {
        return MemoryUtil.memGetAddress((long)(struct + (long)NEXT));
    }

    public static void ntype(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)TYPE, value);
    }

    public static void nnext(long struct, long value) {
        MemoryUtil.memPutAddress((long)(struct + (long)NEXT), (long)value);
    }

    static {
        Struct.Layout layout = XrSceneMeshBuffersMSFT.__struct((Struct.Member[])new Struct.Member[]{XrSceneMeshBuffersMSFT.__member((int)4), XrSceneMeshBuffersMSFT.__member((int)POINTER_SIZE)});
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        TYPE = layout.offsetof(0);
        NEXT = layout.offsetof(1);
    }

    public static class Buffer
    extends StructBuffer<XrSceneMeshBuffersMSFT, Buffer>
    implements NativeResource {
        private static final XrSceneMeshBuffersMSFT ELEMENT_FACTORY = XrSceneMeshBuffersMSFT.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        protected Buffer self() {
            return this;
        }

        protected XrSceneMeshBuffersMSFT getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="XrStructureType")
        public int type() {
            return XrSceneMeshBuffersMSFT.ntype(this.address());
        }

        @NativeType(value="void *")
        public long next() {
            return XrSceneMeshBuffersMSFT.nnext(this.address());
        }

        public Buffer type(@NativeType(value="XrStructureType") int value) {
            XrSceneMeshBuffersMSFT.ntype(this.address(), value);
            return this;
        }

        public Buffer type$Default() {
            return this.type(1000097015);
        }

        public Buffer next(@NativeType(value="void *") long value) {
            XrSceneMeshBuffersMSFT.nnext(this.address(), value);
            return this;
        }
    }
}

