/*
 * Decompiled with CFR 0.152.
 */
package org.openhab.core.io.rest.sse.internal;

import java.util.HashMap;
import java.util.IllegalFormatException;
import java.util.Locale;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.measure.Unit;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.sse.OutboundSseEvent;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.jdt.annotation.Nullable;
import org.openhab.core.i18n.TimeZoneProvider;
import org.openhab.core.io.rest.LocaleService;
import org.openhab.core.io.rest.sse.internal.dto.StateDTO;
import org.openhab.core.items.Item;
import org.openhab.core.items.ItemNotFoundException;
import org.openhab.core.items.ItemRegistry;
import org.openhab.core.library.types.DateTimeType;
import org.openhab.core.library.types.DecimalType;
import org.openhab.core.library.types.QuantityType;
import org.openhab.core.service.StartLevelService;
import org.openhab.core.transform.TransformationException;
import org.openhab.core.transform.TransformationHelper;
import org.openhab.core.transform.TransformationService;
import org.openhab.core.types.State;
import org.openhab.core.types.StateDescription;
import org.openhab.core.types.StateOption;
import org.openhab.core.types.UnDefType;
import org.openhab.core.types.util.UnitUtils;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(service={SseItemStatesEventBuilder.class})
@NonNullByDefault
public class SseItemStatesEventBuilder {
    private static final Pattern EXTRACT_TRANSFORM_FUNCTION_PATTERN = Pattern.compile("(.*?)\\((.*)\\):(.*)");
    private final Logger logger = LoggerFactory.getLogger(SseItemStatesEventBuilder.class);
    private final ItemRegistry itemRegistry;
    private final LocaleService localeService;
    private final TimeZoneProvider timeZoneProvider;
    private final StartLevelService startLevelService;

    @Activate
    public SseItemStatesEventBuilder(@Reference ItemRegistry itemRegistry, @Reference LocaleService localeService, @Reference TimeZoneProvider timeZoneProvider, @Reference StartLevelService startLevelService) {
        this.itemRegistry = itemRegistry;
        this.localeService = localeService;
        this.timeZoneProvider = timeZoneProvider;
        this.startLevelService = startLevelService;
    }

    /*
     * WARNING - void declaration
     */
    public @Nullable OutboundSseEvent buildEvent(OutboundSseEvent.Builder eventBuilder, Set<String> itemNames) {
        HashMap<String, StateDTO> payload = new HashMap<String, StateDTO>(itemNames.size());
        for (String itemName : itemNames) {
            try {
                State state;
                State state2;
                Item item = this.itemRegistry.getItem(itemName);
                StateDTO stateDto = new StateDTO();
                stateDto.state = item.getState().toString();
                stateDto.type = SseItemStatesEventBuilder.getStateType(item.getState());
                String displayState = this.getDisplayState(item, this.localeService.getLocale(null));
                if (stateDto.state != null && !stateDto.state.equals(displayState)) {
                    stateDto.displayState = displayState;
                }
                if ((state2 = item.getState()) instanceof DecimalType) {
                    void decimalState;
                    DecimalType cfr_ignored_0 = (DecimalType)state2;
                    DecimalType cfr_ignored_1 = (DecimalType)state2;
                    stateDto.numericState = Float.valueOf(decimalState.floatValue());
                }
                if ((state = item.getState()) instanceof QuantityType) {
                    void quantityState;
                    QuantityType cfr_ignored_2 = (QuantityType)state;
                    QuantityType cfr_ignored_3 = (QuantityType)state;
                    stateDto.numericState = Float.valueOf(quantityState.floatValue());
                    stateDto.unit = quantityState.getUnit().toString();
                }
                payload.put(itemName, stateDto);
            }
            catch (ItemNotFoundException e) {
                if (this.startLevelService.getStartLevel() < 20) continue;
                this.logger.warn("Attempting to send a state update of an item which doesn't exist: {}", (Object)itemName);
            }
        }
        if (!payload.isEmpty()) {
            return eventBuilder.mediaType(MediaType.APPLICATION_JSON_TYPE).data(payload).build();
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    protected @Nullable String getDisplayState(Item item, Locale locale) {
        String displayState;
        block23: {
            StateDescription stateDescription = item.getStateDescription(locale);
            State state = item.getState();
            displayState = state.toString();
            if (stateDescription != null) {
                Matcher matcher;
                String pattern = stateDescription.getPattern();
                if (pattern != null && (matcher = EXTRACT_TRANSFORM_FUNCTION_PATTERN.matcher(pattern)).find()) {
                    try {
                        String type = matcher.group(1);
                        String function = matcher.group(2);
                        String value = matcher.group(3);
                        TransformationService transformation = TransformationHelper.getTransformationService((String)type);
                        if (transformation != null) {
                            String format = state instanceof UnDefType ? "%s" : value;
                            try {
                                displayState = transformation.transform(function, state.format(format));
                                if (displayState == null) {
                                    displayState = state.toString();
                                }
                                break block23;
                            }
                            catch (IllegalArgumentException e) {
                                throw new TransformationException("Cannot format state '" + String.valueOf(state) + "' to format '" + format + "'", (Throwable)e);
                            }
                            catch (RuntimeException e) {
                                throw new TransformationException("Transformation service of type '" + type + "' threw an exception: " + e.getMessage(), (Throwable)e);
                            }
                        }
                        throw new TransformationException("Transformation service of type '" + type + "' is not available.");
                    }
                    catch (TransformationException e) {
                        this.logger.warn("Failed transforming the state '{}' on item '{}' with pattern '{}': {}", new Object[]{state, item.getName(), pattern, e.getMessage()});
                    }
                } else if (!(state instanceof UnDefType)) {
                    boolean optionMatched = false;
                    if (!stateDescription.getOptions().isEmpty()) {
                        for (StateOption option : stateDescription.getOptions()) {
                            String label = option.getLabel();
                            if (!option.getValue().equals(state.toString()) || label == null) continue;
                            optionMatched = true;
                            try {
                                displayState = pattern == null ? label : String.format(pattern, label);
                            }
                            catch (IllegalFormatException e) {
                                this.logger.debug("Unable to format option label '{}' of item {} using format pattern '{}': {}, displaying option label", new Object[]{label, item.getName(), pattern, e.getMessage()});
                                displayState = label;
                            }
                            break;
                        }
                    }
                    if (pattern != null && !optionMatched) {
                        Unit patternUnit;
                        State state2 = state;
                        if (state2 instanceof QuantityType) {
                            QuantityType quantityState;
                            StateOption option;
                            option = (QuantityType)state2;
                            QuantityType cfr_ignored_0 = (QuantityType)state2;
                            patternUnit = UnitUtils.parseUnit((String)pattern);
                            if (patternUnit != null && !quantityState.getUnit().equals(patternUnit)) {
                                quantityState = quantityState.toInvertibleUnit(patternUnit);
                            }
                            if (quantityState != null) {
                                state = quantityState;
                            }
                        }
                        try {
                            State state3 = state;
                            if (state3 instanceof DateTimeType) {
                                void dateTimeState;
                                patternUnit = (DateTimeType)state3;
                                DateTimeType cfr_ignored_1 = (DateTimeType)state3;
                                displayState = dateTimeState.format(pattern, this.timeZoneProvider.getTimeZone());
                            } else {
                                displayState = state.format(pattern);
                            }
                        }
                        catch (IllegalArgumentException e) {
                            this.logger.debug("Unable to format value '{}' of item {} using format pattern '{}': {}, displaying raw state", new Object[]{state, item.getName(), pattern, e.getMessage()});
                            displayState = state.toString();
                        }
                    }
                }
            }
        }
        return displayState;
    }

    private static String getStateType(State state) {
        String stateClassName = state.getClass().getSimpleName();
        return stateClassName.substring(0, stateClassName.length() - "Type".length());
    }
}

