/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.core;

import java.io.IOException;
import java.util.Date;
import org.apache.commons.vfs.FileObject;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.Messages;
import org.pentaho.di.core.RowMetaAndData;
import org.pentaho.di.core.row.ValueMeta;
import org.pentaho.di.core.vfs.KettleVFS;
import org.pentaho.di.core.xml.XMLHandler;
import org.w3c.dom.Node;

public class ResultFile
implements Cloneable {
    public static final int FILE_TYPE_GENERAL = 0;
    public static final int FILE_TYPE_LOG = 1;
    public static final int FILE_TYPE_ERRORLINE = 2;
    public static final int FILE_TYPE_ERROR = 3;
    public static final int FILE_TYPE_WARNING = 4;
    public static final String[] fileTypeCode = new String[]{"GENERAL", "LOG", "ERRORLINE", "ERROR", "WARNING"};
    public static final String[] fileTypeDesc = new String[]{Messages.getString("ResultFile.FileType.General"), Messages.getString("ResultFile.FileType.Log"), Messages.getString("ResultFile.FileType.ErrorLine"), Messages.getString("ResultFile.FileType.Error"), Messages.getString("ResultFile.FileType.Warning")};
    private static final String XML_TAG = "result-file";
    private int type;
    private FileObject file;
    private String originParent;
    private String origin;
    private String comment;
    private Date timestamp;

    public ResultFile(int type, FileObject file, String originParent, String origin) {
        this.type = type;
        this.file = file;
        this.originParent = originParent;
        this.origin = origin;
        this.timestamp = new Date();
    }

    protected ResultFile clone() throws CloneNotSupportedException {
        return (ResultFile)super.clone();
    }

    public String getComment() {
        return this.comment;
    }

    public void setComment(String comment) {
        this.comment = comment;
    }

    public FileObject getFile() {
        return this.file;
    }

    public void setFile(FileObject file) {
        this.file = file;
    }

    public String getOrigin() {
        return this.origin;
    }

    public void setOrigin(String origin) {
        this.origin = origin;
    }

    public String getOriginParent() {
        return this.originParent;
    }

    public void setOriginParent(String originParent) {
        this.originParent = originParent;
    }

    public int getType() {
        return this.type;
    }

    public void setType(int type) {
        this.type = type;
    }

    public String getTypeDesc() {
        return fileTypeDesc[this.type];
    }

    public String getTypeCode() {
        return fileTypeCode[this.type];
    }

    public static final int getType(String typeString) {
        int idx = Const.indexOfString(typeString, fileTypeDesc);
        if (idx >= 0) {
            return idx;
        }
        idx = Const.indexOfString(typeString, fileTypeCode);
        if (idx >= 0) {
            return idx;
        }
        return 0;
    }

    public static final String getTypeCode(int fileType) {
        return fileTypeCode[fileType];
    }

    public static final String getTypeDesc(int fileType) {
        return fileTypeDesc[fileType];
    }

    public static final String[] getAllTypeDesc() {
        return fileTypeDesc;
    }

    public Date getTimestamp() {
        return this.timestamp;
    }

    public void setTimestamp(Date timestamp) {
        this.timestamp = timestamp;
    }

    public RowMetaAndData getRow() {
        RowMetaAndData row = new RowMetaAndData();
        row.addValue(new ValueMeta("type", 2), this.getTypeDesc());
        row.addValue(new ValueMeta("filename", 2), this.file.getName().getBaseName());
        row.addValue(new ValueMeta("path", 2), this.file.getName().getURI());
        row.addValue(new ValueMeta("parentorigin", 2), this.originParent);
        row.addValue(new ValueMeta("origin", 2), this.origin);
        row.addValue(new ValueMeta("comment", 2), this.comment);
        row.addValue(new ValueMeta("timestamp", 3), this.timestamp);
        return row;
    }

    public String getXML() {
        StringBuffer xml = new StringBuffer();
        xml.append(XMLHandler.openTag(XML_TAG));
        xml.append(XMLHandler.addTagValue("type", this.getTypeCode()));
        xml.append(XMLHandler.addTagValue("file", this.file.getName().toString()));
        xml.append(XMLHandler.addTagValue("parentorigin", this.originParent));
        xml.append(XMLHandler.addTagValue("origin", this.origin));
        xml.append(XMLHandler.addTagValue("comment", this.comment));
        xml.append(XMLHandler.addTagValue("timestamp", this.timestamp));
        xml.append(XMLHandler.closeTag(XML_TAG));
        return xml.toString();
    }

    public ResultFile(Node node) throws IOException {
        this.type = ResultFile.getType(XMLHandler.getTagValue(node, "type"));
        this.file = KettleVFS.getFileObject(XMLHandler.getTagValue(node, "file"));
        this.originParent = XMLHandler.getTagValue(node, "parentorigin");
        this.origin = XMLHandler.getTagValue(node, "origin");
        this.comment = XMLHandler.getTagValue(node, "comment");
        this.timestamp = XMLHandler.stringToDate(XMLHandler.getTagValue(node, "timestamp"));
    }
}

