/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.www;

import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.List;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.pentaho.di.core.logging.LogWriter;
import org.pentaho.di.core.xml.XMLHandler;
import org.pentaho.di.www.Messages;
import org.pentaho.di.www.SlaveServerDetection;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GetSlavesServlet
extends HttpServlet {
    public static final String XML_TAG_SLAVESERVER_DETECTIONS = "SlaveServerDetections";
    private static final long serialVersionUID = -5472184538138241050L;
    public static final String CONTEXT_PATH = "/kettle/getSlaves";
    private static LogWriter log = LogWriter.getInstance();
    private List<SlaveServerDetection> detections;

    public GetSlavesServlet(List<SlaveServerDetection> slaveServers) {
        this.detections = slaveServers;
    }

    protected void doPut(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.doGet(request, response);
    }

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        if (!request.getContextPath().equals(CONTEXT_PATH)) {
            return;
        }
        if (log.isDebug()) {
            log.logDebug(this.toString(), Messages.getString("GetStatusServlet.StatusRequested"), new Object[0]);
        }
        response.setStatus(200);
        response.setContentType("text/xml");
        response.setCharacterEncoding("UTF-8");
        PrintStream out = new PrintStream((OutputStream)response.getOutputStream());
        out.print(XMLHandler.getXMLHeader((String)"UTF-8"));
        out.println(XMLHandler.openTag((String)XML_TAG_SLAVESERVER_DETECTIONS));
        for (SlaveServerDetection slaveServer : this.detections) {
            out.println(slaveServer.getXML());
        }
        out.println(XMLHandler.closeTag((String)XML_TAG_SLAVESERVER_DETECTIONS));
    }

    public String toString() {
        return "Get list of slave servers";
    }
}

