/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmc.flightrecorder.jdk;

import java.text.MessageFormat;
import org.openjdk.jmc.common.item.Aggregators;
import org.openjdk.jmc.common.item.IAggregator;
import org.openjdk.jmc.common.item.IAttribute;
import org.openjdk.jmc.common.item.ItemFilters;
import org.openjdk.jmc.common.unit.IQuantity;
import org.openjdk.jmc.common.unit.UnitLookup;
import org.openjdk.jmc.flightrecorder.JfrAttributes;
import org.openjdk.jmc.flightrecorder.jdk.JdkAttributes;
import org.openjdk.jmc.flightrecorder.jdk.JdkFilters;
import org.openjdk.jmc.flightrecorder.jdk.messages.internal.Messages;

public final class JdkAggregators {
    public static final IAggregator<String, ?> JVM_NAME = Aggregators.distinctAsString("jdk.JVMInformation", JdkAttributes.JVM_NAME);
    public static final IAggregator<IQuantity, ?> JVM_PID = Aggregators.min(JdkAttributes.JVM_PID.getName(), null, "jdk.JVMInformation", JdkAttributes.JVM_PID);
    public static final IAggregator<IQuantity, ?> JVM_START_TIME = Aggregators.min(JdkAttributes.JVM_START_TIME.getName(), null, "jdk.JVMInformation", JdkAttributes.JVM_START_TIME);
    public static final IAggregator<String, ?> JVM_VERSION = Aggregators.distinctAsString("jdk.JVMInformation", JdkAttributes.JVM_VERSION);
    public static final IAggregator<String, ?> JAVA_ARGUMENTS = Aggregators.distinctAsString("jdk.JVMInformation", JdkAttributes.JAVA_ARGUMENTS);
    public static final IAggregator<String, ?> JVM_ARGUMENTS = Aggregators.distinctAsString("jdk.JVMInformation", JdkAttributes.JVM_ARGUMENTS);
    public static final IAggregator<IQuantity, ?> JVM_SHUTDOWN_TIME = Aggregators.min(Messages.getString("ATTR_SHUTDOWN_TIME"), null, "jdk.Shutdown", JfrAttributes.START_TIME);
    public static final IAggregator<String, ?> JVM_SHUTDOWN_REASON = Aggregators.distinctAsString("jdk.Shutdown", JdkAttributes.SHUTDOWN_REASON);
    public static final IAggregator<IQuantity, ?> MIN_HW_THREADS = Aggregators.min(JdkAttributes.HW_THREADS.getName(), null, "jdk.CPUInformation", JdkAttributes.HW_THREADS);
    public static final IAggregator<IQuantity, ?> MIN_NUMBER_OF_CORES = Aggregators.min(JdkAttributes.NUMBER_OF_CORES.getName(), null, "jdk.CPUInformation", JdkAttributes.NUMBER_OF_CORES);
    public static final IAggregator<IQuantity, ?> MIN_NUMBER_OF_SOCKETS = Aggregators.min(JdkAttributes.NUMBER_OF_SOCKETS.getName(), null, "jdk.CPUInformation", JdkAttributes.NUMBER_OF_SOCKETS);
    public static final IAggregator<String, ?> CPU_DESCRIPTION = Aggregators.distinctAsString("jdk.CPUInformation", JdkAttributes.CPU_DESCRIPTION);
    public static final IAggregator<String, ?> CPU_TYPE = Aggregators.distinctAsString("jdk.CPUInformation", JdkAttributes.CPU_TYPE);
    public static final IAggregator<String, ?> OS_VERSION = Aggregators.distinctAsString("jdk.OSInformation", JdkAttributes.OS_VERSION);
    public static final IAggregator<IQuantity, ?> MAX_USED_MEMORY = Aggregators.max(Messages.getString("AGGR_MAX_USED_MEMORY"), null, "jdk.PhysicalMemory", JdkAttributes.OS_MEMORY_USED);
    public static final IAggregator<IQuantity, ?> MIN_TOTAL_MEMORY = Aggregators.min(Messages.getString("AGGR_MIN_TOTAL_MEMORY"), null, "jdk.PhysicalMemory", JdkAttributes.OS_MEMORY_TOTAL);
    public static final IAggregator<IQuantity, ?> HEAP_CONF_MAX_SIZE = Aggregators.max(JdkAttributes.HEAP_MAX_SIZE.getName(), null, "jdk.GCHeapConfiguration", JdkAttributes.HEAP_MAX_SIZE);
    public static final IAggregator<IQuantity, ?> HEAP_CONF_MIN_SIZE = Aggregators.min(JdkAttributes.HEAP_MIN_SIZE.getName(), null, "jdk.GCHeapConfiguration", JdkAttributes.HEAP_MIN_SIZE);
    public static final IAggregator<IQuantity, ?> HEAP_CONF_INITIAL_SIZE_MIN = Aggregators.min(JdkAttributes.HEAP_INITIAL_SIZE.getName(), null, "jdk.GCHeapConfiguration", JdkAttributes.HEAP_INITIAL_SIZE);
    public static final IAggregator<IQuantity, ?> HEAP_OBJECT_ALIGNMENT_MIN = Aggregators.min(JdkAttributes.HEAP_OBJECT_ALIGNMENT.getName(), null, "jdk.GCHeapConfiguration", JdkAttributes.HEAP_OBJECT_ALIGNMENT);
    public static final IAggregator<IQuantity, ?> HEAP_ADDRESS_SIZE_MIN = Aggregators.min(JdkAttributes.HEAP_ADDRESS_SIZE.getName(), null, "jdk.GCHeapConfiguration", JdkAttributes.HEAP_ADDRESS_SIZE);
    public static final IAggregator<Boolean, ?> USE_COMPRESSED_OOPS = Aggregators.or("jdk.GCHeapConfiguration", JdkAttributes.HEAP_USE_COMPRESSED_OOPS);
    public static final IAggregator<String, ?> COMPRESSED_OOPS_MODE = Aggregators.distinctAsString("jdk.GCHeapConfiguration", JdkAttributes.HEAP_COMPRESSED_OOPS_MODE);
    public static final IAggregator<String, ?> OLD_COLLECTOR = Aggregators.distinctAsString("jdk.GCConfiguration", JdkAttributes.OLD_COLLECTOR);
    public static final IAggregator<String, ?> YOUNG_COLLECTOR = Aggregators.distinctAsString("jdk.GCConfiguration", JdkAttributes.YOUNG_COLLECTOR);
    public static final IAggregator<IQuantity, ?> PARALLEL_GC_THREAD_COUNT_MAX = Aggregators.max("jdk.GCConfiguration", JdkAttributes.PARALLEL_GC_THREADS);
    public static final IAggregator<IQuantity, ?> PARALLEL_GC_THREAD_COUNT_MIN = Aggregators.min(JdkAttributes.PARALLEL_GC_THREADS.getName(), null, "jdk.GCConfiguration", JdkAttributes.PARALLEL_GC_THREADS);
    public static final IAggregator<IQuantity, ?> CONCURRENT_GC_THREAD_COUNT_MIN = Aggregators.min(JdkAttributes.CONCURRENT_GC_THREADS.getName(), null, "jdk.GCConfiguration", JdkAttributes.CONCURRENT_GC_THREADS);
    public static final IAggregator<Boolean, ?> EXPLICIT_GC_CONCURRENT = Aggregators.or("jdk.GCConfiguration", JdkAttributes.EXPLICIT_GC_CONCURRENT);
    public static final IAggregator<Boolean, ?> EXPLICIT_GC_DISABLED = Aggregators.or("jdk.GCConfiguration", JdkAttributes.EXPLICIT_GC_DISABLED);
    public static final IAggregator<Boolean, ?> USE_DYNAMIC_GC_THREADS = Aggregators.or("jdk.GCConfiguration", JdkAttributes.USE_DYNAMIC_GC_THREADS);
    public static final IAggregator<IQuantity, ?> GC_TIME_RATIO_MIN = Aggregators.min(JdkAttributes.GC_TIME_RATIO.getName(), null, "jdk.GCConfiguration", JdkAttributes.GC_TIME_RATIO);
    public static final IAggregator<IQuantity, ?> YOUNG_GENERATION_MIN_SIZE = Aggregators.max(JdkAttributes.YOUNG_GENERATION_MIN_SIZE.getName(), null, "jdk.YoungGenerationConfiguration", JdkAttributes.YOUNG_GENERATION_MIN_SIZE);
    public static final IAggregator<IQuantity, ?> YOUNG_GENERATION_MAX_SIZE = Aggregators.min(JdkAttributes.YOUNG_GENERATION_MAX_SIZE.getName(), null, "jdk.YoungGenerationConfiguration", JdkAttributes.YOUNG_GENERATION_MIN_SIZE);
    public static final IAggregator<IQuantity, ?> NEW_RATIO_MIN = Aggregators.min(JdkAttributes.NEW_RATIO.getName(), null, "jdk.YoungGenerationConfiguration", JdkAttributes.NEW_RATIO);
    public static final IAggregator<IQuantity, ?> TENURING_THRESHOLD_INITIAL_MIN = Aggregators.min(JdkAttributes.TENURING_THRESHOLD_INITIAL.getName(), null, "jdk.GCSurvivorConfiguration", JdkAttributes.TENURING_THRESHOLD_INITIAL);
    public static final IAggregator<IQuantity, ?> TENURING_THRESHOLD_MAX = Aggregators.max(JdkAttributes.TENURING_THRESHOLD_MAXIMUM.getName(), null, "jdk.GCSurvivorConfiguration", JdkAttributes.TENURING_THRESHOLD_MAXIMUM);
    public static final IAggregator<Boolean, ?> USES_TLABS = Aggregators.or("jdk.GCTLABConfiguration", JdkAttributes.USES_TLABS);
    public static final IAggregator<IQuantity, ?> TLAB_MIN_SIZE = Aggregators.min(JdkAttributes.TLAB_MIN_SIZE.getName(), null, "jdk.GCTLABConfiguration", JdkAttributes.TLAB_MIN_SIZE);
    public static final IAggregator<IQuantity, ?> TLAB_MAX_SIZE = Aggregators.max(JdkAttributes.TLAB_MAX_SIZE.getName(), null, "jdk.GCTLABConfiguration", JdkAttributes.TLAB_MAX_SIZE);
    public static final IAggregator<IQuantity, ?> TLAB_REFILL_WASTE_LIMIT_MIN = Aggregators.min(JdkAttributes.TLAB_REFILL_WASTE_LIMIT.getName(), null, "jdk.GCTLABConfiguration", JdkAttributes.TLAB_REFILL_WASTE_LIMIT);
    public static final IAggregator<IQuantity, ?> AVG_HEAP_USED_BEFORE_GC = Aggregators.filter(Messages.getString("AGGR_AVG_HEAP_USED_BEFORE_GC"), null, Aggregators.avg("jdk.GCHeapSummary", JdkAttributes.HEAP_USED), JdkFilters.BEFORE_GC);
    public static final IAggregator<IQuantity, ?> AVG_HEAP_USED_AFTER_GC = Aggregators.filter(Messages.getString("AGGR_AVG_HEAP_USED_AFTER_GC"), null, Aggregators.avg("jdk.GCHeapSummary", JdkAttributes.HEAP_USED), JdkFilters.AFTER_GC);
    public static final IAggregator<IQuantity, ?> SUM_HEAP_USED_BEFORE_GC = Aggregators.filter("SUM_HEAP_USED_BEFORE_GC", null, Aggregators.sum("jdk.GCHeapSummary", JdkAttributes.HEAP_USED), JdkFilters.BEFORE_GC);
    public static final IAggregator<IQuantity, ?> SUM_HEAP_USED_AFTER_GC = Aggregators.filter("SUM_HEAP_USED_AFTER_GC", null, Aggregators.sum("jdk.GCHeapSummary", JdkAttributes.HEAP_USED), JdkFilters.AFTER_GC);
    public static final IAggregator<IQuantity, ?> OBJECT_COUNT_MAX_SIZE = Aggregators.max(Messages.getString("AGGR_OBJECT_COUNT_MAX_SIZE"), Messages.getString("AGGR_OBJECT_COUNT_MAX_SIZE_DESC"), "jdk.ObjectCount", JdkAttributes.HEAP_TOTAL);
    public static final IAggregator<IQuantity, ?> OBJECT_COUNT_MAX_INSTANCES = Aggregators.max(Messages.getString("AGGR_OBJECT_COUNT_MAX_INSTANCES"), Messages.getString("AGGR_OBJECT_COUNT_MAX_INSTANCES_DESC"), "jdk.ObjectCount", JdkAttributes.COUNT);
    public static final IAggregator<Boolean, ?> UNLOCK_EXPERIMENTAL_VM_OPTIONS = Aggregators.filter(Messages.getString("AGGR_UNLOCK_EXPERIMENTAL_VM_OPTIONS"), null, Aggregators.or("jdk.BooleanFlag", JdkAttributes.FLAG_VALUE_BOOLEAN), ItemFilters.equals(JdkAttributes.FLAG_NAME, "UnlockExperimentalVMOptions"));
    public static final IAggregator<Boolean, ?> IGNORE_UNRECOGNIZED_VM_OPTIONS = Aggregators.filter(Messages.getString("AGGR_IGNORE_UNRECOGNIZED_VM_OPTIONS"), null, Aggregators.or("jdk.BooleanFlag", JdkAttributes.FLAG_VALUE_BOOLEAN), ItemFilters.equals(JdkAttributes.FLAG_NAME, "IgnoreUnrecognizedVMOptions"));
    public static final IAggregator<Boolean, ?> USE_STRING_DEDUPLICATION = Aggregators.filter("UseStringDeduplication", null, Aggregators.or("jdk.BooleanFlag", JdkAttributes.FLAG_VALUE_BOOLEAN), ItemFilters.equals(JdkAttributes.FLAG_NAME, "UseStringDeduplication"));
    public static final IAggregator<Boolean, ?> USE_G1_GC = Aggregators.filter("UseG1GC", null, Aggregators.or("jdk.BooleanFlag", JdkAttributes.FLAG_VALUE_BOOLEAN), ItemFilters.equals(JdkAttributes.FLAG_NAME, "UseG1GC"));
    public static final IAggregator<Boolean, ?> USE_SHENANDOAH_GC = Aggregators.filter("UseShenandoahGC", null, Aggregators.or("jdk.BooleanFlag", JdkAttributes.FLAG_VALUE_BOOLEAN), ItemFilters.equals(JdkAttributes.FLAG_NAME, "UseShenandoahGC"));
    public static final IAggregator<Boolean, ?> COMPACT_STRINGS = Aggregators.filter("CompactStrings", null, Aggregators.or("jdk.BooleanFlag", JdkAttributes.FLAG_VALUE_BOOLEAN), ItemFilters.equals(JdkAttributes.FLAG_NAME, "CompactStrings"));
    public static final IAggregator<IQuantity, ?> LARGEST_MAX_HEAP_SIZE_FROM_FLAG = Aggregators.filter(Messages.getString("AGGR_LARGEST_MAX_HEAP_SIZE_FROM_FLAG"), null, Aggregators.max("jdk.UnsignedLongFlag", JdkAttributes.FLAG_VALUE_NUMBER), ItemFilters.equals(JdkAttributes.FLAG_NAME, "MaxHeapSize"));
    public static final IAggregator<IQuantity, ?> OUTSIDE_TLAB_COUNT = Aggregators.count(Messages.getString("AGGR_OUTSIDE_TLAB_COUNT"), Messages.getString("AGGR_OUTSIDE_TLAB_COUNT_DESC"), JdkFilters.ALLOC_OUTSIDE_TLAB);
    public static final IAggregator<IQuantity, ?> INSIDE_TLAB_COUNT = Aggregators.count(Messages.getString("AGGR_INSIDE_TLAB_COUNT"), Messages.getString("AGGR_INSIDE_TLAB_COUNT_DESC"), JdkFilters.ALLOC_INSIDE_TLAB);
    public static final IAggregator<IQuantity, ?> FILE_WRITE_LONGEST = Aggregators.max("jdk.FileWrite", JfrAttributes.DURATION);
    public static final IAggregator<IQuantity, ?> FILE_WRITE_LARGEST = Aggregators.max("jdk.FileWrite", JdkAttributes.IO_FILE_BYTES_WRITTEN);
    public static final IAggregator<IQuantity, ?> FILE_READ_LONGEST = Aggregators.max("jdk.FileRead", JfrAttributes.DURATION);
    public static final IAggregator<IQuantity, ?> FILE_READ_LARGEST = Aggregators.max("jdk.FileRead", JdkAttributes.IO_FILE_BYTES_READ);
    public static final IAggregator<IQuantity, ?> FILE_WRITE_SIZE = Aggregators.sum(Messages.getString("AGGR_FILE_WRITE_SIZE"), Messages.getString("AGGR_FILE_WRITE_SIZE_DESC"), "jdk.FileWrite", JdkAttributes.IO_FILE_BYTES_WRITTEN);
    public static final IAggregator<IQuantity, ?> FILE_READ_SIZE = Aggregators.sum(Messages.getString("AGGR_FILE_READ_SIZE"), Messages.getString("AGGR_FILE_READ_SIZE_DESC"), "jdk.FileRead", JdkAttributes.IO_FILE_BYTES_READ);
    public static final IAggregator<IQuantity, ?> FILE_WRITE_COUNT = Aggregators.count(Messages.getString("AGGR_FILE_WRITE_COUNT"), Messages.getString("AGGR_FILE_WRITE_COUNT_DESC"), JdkFilters.FILE_WRITE);
    public static final IAggregator<IQuantity, ?> FILE_READ_COUNT = Aggregators.count(Messages.getString("AGGR_FILE_READ_COUNT"), Messages.getString("AGGR_FILE_READ_COUNT_DESC"), JdkFilters.FILE_READ);
    public static final IAggregator<IQuantity, ?> ERROR_COUNT = Aggregators.count(Messages.getString("AGGR_ERROR_COUNT"), Messages.getString("AGGR_ERROR_COUNT_DESC"), JdkFilters.ERRORS);
    public static final IAggregator<IQuantity, ?> EXCEPTIONS_COUNT = Aggregators.count(Messages.getString("AGGR_EXCEPTIONS_COUNT"), Messages.getString("AGGR_EXCEPTIONS_COUNT_DESC"), JdkFilters.EXCEPTIONS);
    public static final IAggregator<IQuantity, ?> THROWABLES_COUNT = Aggregators.count(Messages.getString("AGGR_THROWABLES_COUNT"), Messages.getString("AGGR_THROWABLES_COUNT_DESC"), JdkFilters.THROWABLES);
    public static final IAggregator<IQuantity, ?> CODE_CACHE_FULL_COUNT = Aggregators.count(Messages.getString("AGGR_CODE_CACHE_FULL_COUNT"), Messages.getString("AGGR_CODE_CACHE_FULL_COUNT_DESC"), JdkFilters.CODE_CACHE_FULL);
    public static final IAggregator<IQuantity, ?> SOCKET_WRITE_LONGEST = Aggregators.max("jdk.SocketWrite", JfrAttributes.DURATION);
    public static final IAggregator<IQuantity, ?> SOCKET_WRITE_LARGEST = Aggregators.max("jdk.SocketWrite", JdkAttributes.IO_SOCKET_BYTES_WRITTEN);
    public static final IAggregator<IQuantity, ?> SOCKET_READ_LONGEST = Aggregators.max("jdk.SocketRead", JfrAttributes.DURATION);
    public static final IAggregator<IQuantity, ?> SOCKET_READ_LARGEST = Aggregators.max("jdk.SocketRead", JdkAttributes.IO_SOCKET_BYTES_READ);
    public static final IAggregator<IQuantity, ?> SOCKET_WRITE_SIZE = Aggregators.sum(Messages.getString("AGGR_SOCKET_WRITE_SIZE"), Messages.getString("AGGR_SOCKET_WRITE_SIZE_DESC"), "jdk.SocketWrite", JdkAttributes.IO_SOCKET_BYTES_WRITTEN);
    public static final IAggregator<IQuantity, ?> SOCKET_READ_SIZE = Aggregators.sum(Messages.getString("AGGR_SOCKET_READ_SIZE"), Messages.getString("AGGR_SOCKET_READ_SIZE_DESC"), "jdk.SocketRead", JdkAttributes.IO_SOCKET_BYTES_READ);
    public static final IAggregator<IQuantity, ?> SOCKET_WRITE_COUNT = Aggregators.count(Messages.getString("AGGR_SOCKET_WRITE_COUNT"), Messages.getString("AGGR_SOCKET_WRITE_COUNT_DESC"), JdkFilters.SOCKET_WRITE);
    public static final IAggregator<IQuantity, ?> SOCKET_READ_COUNT = Aggregators.count(Messages.getString("AGGR_SOCKET_READ_COUNT"), Messages.getString("AGGR_SOCKET_READ_COUNT_DESC"), JdkFilters.SOCKET_READ);
    public static final IAggregator<IQuantity, ?> NUMBER_OF_DISTINCT_PORTS = Aggregators.filter(Aggregators.countDistinct(Messages.getString("AGGR_NUMBER_OF_DISTINCT_PORTS"), Messages.getString("AGGR_NUMBER_OF_DISTINCT_PORTS_DESC"), JdkAttributes.IO_PORT), JdkFilters.SOCKET_READ_OR_WRITE);
    public static final IAggregator<IQuantity, ?> NUMBER_OF_DISTINCT_HOSTS = Aggregators.filter(Aggregators.countDistinct(Messages.getString("AGGR_NUMBER_OF_DISTINCT_HOSTS"), Messages.getString("AGGR_NUMBER_OF_DISTINCT_HOSTS_DESC"), JdkAttributes.IO_ADDRESS), JdkFilters.SOCKET_READ_OR_WRITE);
    public static final IAggregator<String, ?> HOST_NAMES_DISTINCT = Aggregators.filter(Aggregators.distinctAsString(JdkAttributes.IO_HOST, ","), JdkFilters.SOCKET_READ_OR_WRITE);
    public static final IAggregator<IQuantity, ?> LONGEST_GC_PAUSE = Aggregators.max(Messages.getString("AGGR_LONGEST_GC_PAUSE"), Messages.getString("AGGR_LONGEST_GC_PAUSE_DESC"), "jdk.GCPhasePause", JfrAttributes.DURATION);
    public static final IAggregator<IQuantity, ?> AVERAGE_GC_PAUSE = Aggregators.avg(Messages.getString("AGGR_AVERAGE_GC_PAUSE"), Messages.getString("AGGR_AVERAGE_GC_PAUSE_DESC"), "jdk.GCPhasePause", JfrAttributes.DURATION);
    public static final IAggregator<IQuantity, ?> TOTAL_GC_PAUSE = Aggregators.sum(Messages.getString("AGGR_TOTAL_GC_PAUSE"), Messages.getString("AGGR_TOTAL_GC_PAUSE_DESC"), "jdk.GCPhasePause", JfrAttributes.DURATION);
    public static final IAggregator<IQuantity, ?> YOUNG_COLLECTION_GC_COUNT = Aggregators.count(Messages.getString("AGGR_YOUNG_COLLECTION_GC_COUNT"), Messages.getString("AGGR_YOUNG_COLLECTION_GC_COUNT_DESC"), JdkFilters.YOUNG_GARBAGE_COLLECTION);
    public static final IAggregator<IQuantity, ?> YOUNG_COLLECTION_MAX_GC_TIME = Aggregators.max(Messages.getString("AGGR_YOUNG_COLLECTION_MAX_GC_TIME"), Messages.getString("AGGR_YOUNG_COLLECTION_MAX_GC_TIME_DESC"), "jdk.YoungGarbageCollection", JfrAttributes.DURATION);
    public static final IAggregator<IQuantity, ?> YOUNG_COLLECTION_AVG_GC_TIME = Aggregators.avg(Messages.getString("AGGR_YOUNG_COLLECTION_AVG_GC_TIME"), Messages.getString("AGGR_YOUNG_COLLECTION_AVG_GC_TIME_DESC"), "jdk.YoungGarbageCollection", JfrAttributes.DURATION);
    public static final IAggregator<IQuantity, ?> YOUNG_COLLECTION_TOTAL_GC_TIME = Aggregators.sum(Messages.getString("AGGR_YOUNG_COLLECTION_TOTAL_GC_TIME"), Messages.getString("AGGR_YOUNG_COLLECTION_TOTAL_GC_TIME_DESC"), "jdk.YoungGarbageCollection", JfrAttributes.DURATION);
    public static final IAggregator<IQuantity, ?> OLD_COLLECTION_GC_COUNT = Aggregators.count(Messages.getString("AGGR_OLD_COLLECTION_GC_COUNT"), Messages.getString("AGGR_OLD_COLLECTION_GC_COUNT_DESC"), JdkFilters.OLD_GARBAGE_COLLECTION);
    public static final IAggregator<IQuantity, ?> OLD_COLLECTION_MAX_GC_TIME = Aggregators.max(Messages.getString("AGGR_OLD_COLLECTION_MAX_GC_TIME"), Messages.getString("AGGR_OLD_COLLECTION_MAX_GC_TIME_DESC"), "jdk.OldGarbageCollection", JfrAttributes.DURATION);
    public static final IAggregator<IQuantity, ?> OLD_COLLECTION_AVG_GC_TIME = Aggregators.avg(Messages.getString("AGGR_OLD_COLLECTION_AVG_GC_TIME"), Messages.getString("AGGR_OLD_COLLECTION_AVG_GC_TIME_DESC"), "jdk.OldGarbageCollection", JfrAttributes.DURATION);
    public static final IAggregator<IQuantity, ?> OLD_COLLECTION_TOTAL_GC_TIME = Aggregators.sum(Messages.getString("AGGR_OLD_COLLECTION_TOTAL_GC_TIME"), Messages.getString("AGGR_OLD_COLLECTION_TOTAL_GC_TIME_DESC"), "jdk.OldGarbageCollection", JfrAttributes.DURATION);
    public static final IAggregator<IQuantity, ?> ALL_COLLECTION_GC_COUNT = Aggregators.count(Messages.getString("AGGR_ALL_COLLECTION_GC_COUNT"), Messages.getString("AGGR_ALL_COLLECTION_GC_COUNT_DESC"), JdkFilters.GARBAGE_COLLECTION);
    public static final IAggregator<IQuantity, ?> ALL_COLLECTION_MAX_GC_TIME = Aggregators.max(Messages.getString("AGGR_ALL_COLLECTION_MAX_GC_TIME"), Messages.getString("AGGR_ALL_COLLECTION_MAX_GC_TIME_DESC"), "jdk.GarbageCollection", JfrAttributes.DURATION);
    public static final IAggregator<IQuantity, ?> ALL_COLLECTION_AVG_GC_TIME = Aggregators.avg(Messages.getString("AGGR_ALL_COLLECTION_AVG_GC_TIME"), Messages.getString("AGGR_ALL_COLLECTION_AVG_GC_TIME_DESC"), "jdk.GarbageCollection", JfrAttributes.DURATION);
    public static final IAggregator<IQuantity, ?> ALL_COLLECTION_TOTAL_GC_TIME = Aggregators.sum(Messages.getString("AGGR_ALL_COLLECTION_TOTAL_GC_TIME"), Messages.getString("AGGR_ALL_COLLECTION_TOTAL_GC_TIME_DESC"), "jdk.GarbageCollection", JfrAttributes.DURATION);
    public static final IAggregator<IQuantity, ?> JFR_DATA_LOST_COUNT = Aggregators.count(Messages.getString("AGGR_JFR_DATA_LOST_COUNT"), Messages.getString("AGGR_JFR_DATA_LOST_COUNT_DESC"), JdkFilters.JFR_DATA_LOST);
    public static final IAggregator<IQuantity, ?> FLR_DATA_LOST_SIZE = Aggregators.sum(Messages.getString("AGGR_FLR_DATA_LOST_SIZE"), Messages.getString("AGGR_FLR_DATA_LOST_SIZE_DESC"), "jdk.DataLoss", JfrAttributes.FLR_DATA_LOST);
    public static final IAggregator<IQuantity, ?> AVG_JVM_USER_CPU = Aggregators.avg("jdk.CPULoad", JdkAttributes.JVM_USER);
    public static final IAggregator<IQuantity, ?> AVG_JVM_TOTAL_CPU = Aggregators.avg("jdk.CPULoad", JdkAttributes.JVM_TOTAL);
    public static final IAggregator<IQuantity, ?> EXECUTION_SAMPLE_COUNT = Aggregators.count(Messages.getString("AGGR_EXECUTION_SAMPLE_COUNT"), Messages.getString("AGGR_EXECUTION_SAMPLE_COUNT_DESC"), JdkFilters.EXECUTION_SAMPLE);
    public static final IAggregator<IQuantity, ?> METASPACE_OOM_COUNT = Aggregators.count(Messages.getString("AGGR_METASPACE_OOM_COUNT"), Messages.getString("AGGR_METASPACE_OOM_COUNT_DESC"), JdkFilters.METASPACE_OOM);
    public static final IAggregator<IQuantity, ?> TOTAL_BLOCKED_TIME = Aggregators.sum(Messages.getString("AGGR_TOTAL_BLOCKED_TIME"), Messages.getString("AGGR_TOTAL_BLOCKED_TIME_DESC"), "jdk.JavaMonitorEnter", JfrAttributes.DURATION);
    public static final IAggregator<IQuantity, ?> TOTAL_BLOCKED_COUNT = Aggregators.count(Messages.getString("AGGR_TOTAL_BLOCKED_COUNT"), Messages.getString("AGGR_TOTAL_BLOCKED_COUNT_DESC"), JdkFilters.MONITOR_ENTER);
    public static final IAggregator<IQuantity, ?> MAX_BLOCKED_TIME = Aggregators.max(Messages.getString("AGGR_MAX_BLOCKED_TIME"), Messages.getString("AGGR_MAX_BLOCKED_TIME_DESC"), "jdk.JavaMonitorEnter", JfrAttributes.DURATION);
    public static final IAggregator<IQuantity, ?> AVG_BLOCKED_TIME = Aggregators.avg(Messages.getString("AGGR_AVG_BLOCKED_TIME"), Messages.getString("AGGR_AVG_BLOCKED_TIME_DESC"), "jdk.JavaMonitorEnter", JfrAttributes.DURATION);
    public static final IAggregator<IQuantity, ?> STDDEV_BLOCKED_TIME = Aggregators.stddevp(Messages.getString("AGGR_STDDEV_BLOCKED_TIME"), Messages.getString("AGGR_STDDEV_BLOCKED_TIME_DESC"), JfrAttributes.DURATION);
    public static final IAggregator<IQuantity, ?> ALLOC_INSIDE_TLAB_AVG = Aggregators.avg(Messages.getString("AGGR_ALLOC_INSIDE_TLAB_AVG"), Messages.getString("AGGR_ALLOC_INSIDE_TLAB_AVG_DESC"), "jdk.ObjectAllocationInNewTLAB", JdkAttributes.ALLOCATION_SIZE);
    public static final IAggregator<IQuantity, ?> ALLOC_TLAB_AVG = Aggregators.avg(Messages.getString("AGGR_ALLOC_TLAB_AVG"), Messages.getString("AGGR_ALLOC_TLAB_AVG_DESC"), "jdk.ObjectAllocationInNewTLAB", JdkAttributes.TLAB_SIZE);
    public static final IAggregator<IQuantity, ?> ALLOC_OUTSIDE_TLAB_AVG = Aggregators.avg(Messages.getString("AGGR_ALLOC_OUTSIDE_TLAB_AVG"), Messages.getString("AGGR_ALLOC_OUTSIDE_TLAB_AVG_DESC"), "jdk.ObjectAllocationOutsideTLAB", JdkAttributes.ALLOCATION_SIZE);
    public static final IAggregator<IQuantity, ?> ALLOC_INSIDE_TLAB_MAX = Aggregators.max(Messages.getString("AGGR_ALLOC_INSIDE_TLAB_MAX"), Messages.getString("AGGR_ALLOC_INSIDE_TLAB_MAX_DESC"), "jdk.ObjectAllocationInNewTLAB", JdkAttributes.TLAB_SIZE);
    public static final IAggregator<IQuantity, ?> ALLOC_OUTSIDE_TLAB_MAX = Aggregators.max(Messages.getString("AGGR_ALLOC_OUTSIDE_TLAB_MAX"), Messages.getString("AGGR_ALLOC_OUTSIDE_TLAB_MAX_DESC"), "jdk.ObjectAllocationOutsideTLAB", JdkAttributes.ALLOCATION_SIZE);
    public static final IAggregator<IQuantity, ?> ALLOC_INSIDE_TLAB_MIN = Aggregators.min(Messages.getString("AGGR_ALLOC_INSIDE_TLAB_MIN"), Messages.getString("AGGR_ALLOC_INSIDE_TLAB_MIN_DESC"), "jdk.ObjectAllocationInNewTLAB", JdkAttributes.TLAB_SIZE);
    public static final IAggregator<IQuantity, ?> ALLOC_OUTSIDE_TLAB_MIN = Aggregators.min(Messages.getString("AGGR_ALLOC_OUTSIDE_TLAB_MIN"), Messages.getString("AGGR_ALLOC_OUTSIDE_TLAB_MIN_DESC"), "jdk.ObjectAllocationOutsideTLAB", JdkAttributes.ALLOCATION_SIZE);
    public static final IAggregator<IQuantity, ?> ALLOC_INSIDE_TLAB_SUM = Aggregators.sum(Messages.getString("AGGR_ALLOC_INSIDE_TLAB_SUM"), Messages.getString("AGGR_ALLOC_INSIDE_TLAB_SUM_DESC"), "jdk.ObjectAllocationInNewTLAB", JdkAttributes.TLAB_SIZE);
    public static final IAggregator<IQuantity, ?> ALLOC_OUTSIDE_TLAB_SUM = Aggregators.sum(Messages.getString("AGGR_ALLOC_OUTSIDE_TLAB_SUM"), Messages.getString("AGGR_ALLOC_OUTSIDE_TLAB_SUM_DESC"), "jdk.ObjectAllocationOutsideTLAB", JdkAttributes.ALLOCATION_SIZE);
    public static final IAggregator<IQuantity, ?> OBJ_ALLOC_TOTAL_SUM = Aggregators.sum(Messages.getString("AGGR_OBJ_ALLOC_SUM"), Messages.getString("AGGR_OBJ_ALLOC_SUM_DESC"), "jdk.ObjectAllocationSample", JdkAttributes.SAMPLE_WEIGHT);
    public static final IAggregator<IQuantity, ?> SWEEP_METHOD_SUM = Aggregators.sum(Messages.getString("AGGR_SWEEP_METHOD_SUM"), Messages.getString("AGGR_SWEEP_METHOD_SUM_DESC"), "jdk.SweepCodeCache", JdkAttributes.SWEEP_METHOD_SWEPT);
    public static final IAggregator<IQuantity, ?> SWEEP_FLUSHED_SUM = Aggregators.sum(Messages.getString("AGGR_SWEEP_FLUSHED_SUM"), Messages.getString("AGGR_SWEEP_FLUSHED_SUM_DESC"), "jdk.SweepCodeCache", JdkAttributes.SWEEP_METHOD_FLUSHED);
    public static final IAggregator<IQuantity, ?> SWEEP_ZOMBIFIED_SUM = Aggregators.sum(Messages.getString("AGGR_SWEEP_ZOMBIFIED_SUM"), Messages.getString("AGGR_SWEEP_ZOMBIFIED_SUM_DESC"), "jdk.SweepCodeCache", JdkAttributes.SWEEP_METHOD_ZOMBIFIED);
    public static final IAggregator<IQuantity, ?> SWEEP_RECLAIMED_SUM = Aggregators.sum(Messages.getString("AGGR_SWEEP_RECLAIMED_SUM"), Messages.getString("AGGR_SWEEP_RECLAIMED_SUM_DESC"), "jdk.SweepCodeCache", JdkAttributes.SWEEP_METHOD_RECLAIMED);
    public static final IAggregator<IQuantity, ?> LONGEST_EVENT = Aggregators.max(JfrAttributes.DURATION);
    public static final IAggregator<IQuantity, ?> ITEM_COUNT = Aggregators.count(Messages.getString("AGGR_ITEM_COUNT"), Messages.getString("AGGR_ITEM_COUNT_DESC"));
    public static final IAggregator<IQuantity, ?> ALLOCATION_TOTAL = Aggregators.sum(Messages.getString("AGGR_ALLOCATION_TOTAL"), Messages.getString("AGGR_ALLOCATION_TOTAL_DESC"), UnitLookup.MEMORY, JdkAttributes.TOTAL_ALLOCATION_SIZE);
    public static final IAggregator<IQuantity, ?> TOTAL_IO_TIME = Aggregators.filter(Aggregators.sum(Messages.getString("AGGR_TOTAL_IO_TIME"), Messages.getString("AGGR_TOTAL_IO_TIME_DESC"), JfrAttributes.DURATION), JdkFilters.FILE_OR_SOCKET_IO);
    public static final IAggregator<IQuantity, ?> MAX_IO_TIME = Aggregators.filter(Aggregators.max(Messages.getString("AGGR_MAX_IO_TIME"), Messages.getString("AGGR_MAX_IO_TIME_DESC"), JfrAttributes.DURATION), JdkFilters.FILE_OR_SOCKET_IO);
    public static final IAggregator<IQuantity, ?> AVG_IO_TIME = Aggregators.filter(Aggregators.avg(Messages.getString("AGGR_AVG_IO_TIME"), Messages.getString("AGGR_AVG_IO_TIME_DESC"), JfrAttributes.DURATION), JdkFilters.FILE_OR_SOCKET_IO);
    public static final IAggregator<IQuantity, ?> STDDEV_IO_TIME = Aggregators.filter(Aggregators.stddevp(Messages.getString("AGGR_STDDEV_IO_TIME"), Messages.getString("AGGR_STDDEV_IO_TIME_DESC"), JfrAttributes.DURATION), JdkFilters.FILE_OR_SOCKET_IO);
    public static final IAggregator<IQuantity, ?> TOTAL_IO_COUNT = Aggregators.count(Messages.getString("AGGR_TOTAL_IO_COUNT"), Messages.getString("AGGR_TOTAL_IO_COUNT_DESC"), JdkFilters.FILE_OR_SOCKET_IO);
    public static final IAggregator<IQuantity, ?> CLASS_LOADING_COUNT = Aggregators.count(Messages.getString("AGGR_CLASS_LOADING_COUNT"), Messages.getString("AGGR_CLASS_LOADING_COUNT_DESC"), JdkFilters.CLASS_LOAD);
    public static final IAggregator<IQuantity, ?> CLASS_LOADING_TIME_SUM = Aggregators.sum(Messages.getString("AGGR_CLASS_LOADING_TIME_SUM"), Messages.getString("AGGR_CLASS_LOADING_TIME_SUM_DESC"), "jdk.ClassLoad", JfrAttributes.DURATION);
    public static final IAggregator<IQuantity, ?> VM_OPERATION_COUNT = Aggregators.count(Messages.getString("AGGR_VM_OPERATION_COUNT"), Messages.getString("AGGR_VM_OPERATION_COUNT_DESC"), JdkFilters.VM_OPERATIONS);
    public static final IAggregator<IQuantity, ?> VM_OPERATION_DURATION = Aggregators.sum(Messages.getString("AGGR_VM_OPERATION_DURATION"), Messages.getString("AGGR_VM_OPERATION_DURATION_DESC"), "jdk.ExecuteVMOperation", JfrAttributes.DURATION);
    public static final IAggregator<IQuantity, ?> COMPILATIONS_COUNT = Aggregators.count(Messages.getString("AGGR_COMPILATIONS_COUNT"), Messages.getString("AGGR_COMPILATIONS_COUNT_DESC"), JdkFilters.COMPILATION);
    public static final IAggregator<IQuantity, ?> LONGEST_COMPILATION = Aggregators.filter(Aggregators.max(JfrAttributes.DURATION), JdkFilters.COMPILATION);
    public static final IAggregator<String, ?> DUMP_REASON = Aggregators.distinctAsString("jdk.DumpReason", JdkAttributes.DUMP_REASON);
    public static final IAggregator<IQuantity, ?> ADDRESSES_COUNT = Aggregators.countDistinct(Messages.getString("AGGR_ADDRESSES_COUNT"), Messages.getString("AGGR_ADDRESSES_COUNT_DESC"), JdkAttributes.MONITOR_ADDRESS);
    public static final IAggregator<IQuantity, ?> OLD_OBJECT_ADDRESSES_COUNT = Aggregators.countDistinct(Messages.getString("AGGR_ADDRESSES_COUNT"), Messages.getString("AGGR_ADDRESSES_COUNT_DESC"), JdkAttributes.OLD_OBJECT_ADDRESS);
    public static final IAggregator<?, ?> BASE_ADDRESS = Aggregators.min("jdk.NativeLibrary", JdkAttributes.BASE_ADDRESS);
    public static final IAggregator<?, ?> TOP_ADDRESS = Aggregators.min("jdk.NativeLibrary", JdkAttributes.TOP_ADDRESS);

    public static <V> IAggregator<V, ?> first(IAttribute<V> attribute) {
        return new Aggregators.AdvancedMinAggregator<V, IQuantity>(MessageFormat.format(Messages.getString("AGGR_FIRST_ATTRIBUTE"), attribute.getName()), MessageFormat.format(Messages.getString("AGGR_FIRST_ATTRIBUTE_DESC"), attribute.getName()), attribute, JfrAttributes.START_TIME);
    }

    public static <V> IAggregator<V, ?> last(IAttribute<V> attribute) {
        return new Aggregators.AdvancedMaxAggregator<V, IQuantity>(MessageFormat.format(Messages.getString("AGGR_LAST_ATTRIBUTE"), attribute.getName()), MessageFormat.format(Messages.getString("AGGR_LAST_ATTRIBUTE_DESC"), attribute.getName()), attribute, JfrAttributes.END_TIME);
    }
}

