/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.svn.history;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.ContentRevision;
import com.intellij.openapi.vcs.history.VcsRevisionNumber;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.vcsUtil.VcsUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.idea.svn.RootUrlInfo;
import org.jetbrains.idea.svn.SvnRevisionNumber;
import org.jetbrains.idea.svn.SvnUtil;
import org.jetbrains.idea.svn.SvnVcs;
import org.jetbrains.idea.svn.api.ErrorCategory;
import org.jetbrains.idea.svn.api.Revision;
import org.jetbrains.idea.svn.api.Target;
import org.jetbrains.idea.svn.api.Url;
import org.jetbrains.idea.svn.auth.SvnAuthenticationNotifier;
import org.jetbrains.idea.svn.commandLine.SvnBindException;
import org.jetbrains.idea.svn.history.LogEntry;
import org.jetbrains.idea.svn.history.LogEntryConsumer;
import org.jetbrains.idea.svn.history.SvnChangeList;
import org.jetbrains.idea.svn.history.SvnCopyPathTracker;
import org.jetbrains.idea.svn.history.SvnRepositoryLocation;

public class SingleCommittedListProvider {
    private static final Logger LOG = Logger.getInstance(SingleCommittedListProvider.class);
    @NotNull
    private final SvnVcs myVcs;
    @NotNull
    private final Project myProject;
    @NotNull
    private final VirtualFile file;
    @NotNull
    private final VcsRevisionNumber number;
    private SvnChangeList[] changeList;
    private Revision revisionBefore;
    private Url repositoryUrl;
    private Url svnRootUrl;
    private SvnRepositoryLocation svnRootLocation;
    private String repositoryRelativeUrl;
    private FilePath filePath;

    public SingleCommittedListProvider(@NotNull SvnVcs vcs, @NotNull VirtualFile file, @NotNull VcsRevisionNumber number) {
        if (vcs == null) {
            SingleCommittedListProvider.$$$reportNull$$$0(0);
        }
        if (file == null) {
            SingleCommittedListProvider.$$$reportNull$$$0(1);
        }
        if (number == null) {
            SingleCommittedListProvider.$$$reportNull$$$0(2);
        }
        this.myVcs = vcs;
        this.myProject = vcs.getProject();
        this.file = file;
        this.number = number;
    }

    public Pair<SvnChangeList, FilePath> run() throws VcsException {
        Pair result = null;
        if (this.setup()) {
            this.calculate();
            result = Pair.create((Object)this.changeList[0], (Object)this.filePath);
        }
        return result;
    }

    private boolean setup() {
        boolean result = false;
        RootUrlInfo rootUrlInfo = this.myVcs.getSvnFileUrlMapping().getWcRootForFilePath(VcsUtil.getFilePath((VirtualFile)this.file));
        if (rootUrlInfo != null) {
            this.changeList = new SvnChangeList[1];
            this.revisionBefore = ((SvnRevisionNumber)this.number).getRevision();
            this.repositoryUrl = rootUrlInfo.getRepositoryUrl();
            this.svnRootUrl = rootUrlInfo.getUrl();
            this.svnRootLocation = new SvnRepositoryLocation(rootUrlInfo.getUrl());
            this.repositoryRelativeUrl = SvnUtil.ensureStartSlash(SvnUtil.join(SvnUtil.getRelativeUrl(this.repositoryUrl, this.svnRootUrl), SvnUtil.getRelativePath(rootUrlInfo.getPath(), this.file.getPath())));
            this.filePath = VcsUtil.getFilePath((VirtualFile)this.file);
            result = true;
        }
        return result;
    }

    private void calculate() throws VcsException {
        Change targetChange;
        ContentRevision afterRevision;
        this.filePath = !this.searchForUrl(this.svnRootUrl) && (!this.hasAccess(this.repositoryUrl) || !this.searchForUrl(this.repositoryUrl)) ? this.searchFromHead(this.svnRootUrl) : (this.changeList[0].getChanges().size() == 1 ? ((afterRevision = this.changeList[0].getChanges().iterator().next().getAfterRevision()) != null ? afterRevision.getFile() : this.filePath) : ((targetChange = this.changeList[0].getByPath(this.repositoryRelativeUrl)) == null ? this.searchFromHead(this.svnRootUrl) : this.filePath));
    }

    private boolean hasAccess(@NotNull Url url) {
        if (url == null) {
            SingleCommittedListProvider.$$$reportNull$$$0(3);
        }
        return SvnAuthenticationNotifier.passiveValidation(this.myVcs, url);
    }

    private FilePath searchFromHead(@NotNull Url url) throws VcsException {
        if (url == null) {
            SingleCommittedListProvider.$$$reportNull$$$0(4);
        }
        SvnCopyPathTracker pathTracker = new SvnCopyPathTracker(this.repositoryUrl, this.repositoryRelativeUrl);
        Target target = Target.on(url);
        this.myVcs.getFactory(target).createHistoryClient().doLog(target, Revision.HEAD, this.revisionBefore, false, true, false, 0L, null, logEntry -> {
            this.checkDisposed();
            if (logEntry.getDate() != null) {
                pathTracker.accept((LogEntry)logEntry);
                if (logEntry.getRevision() == this.revisionBefore.getNumber()) {
                    this.changeList[0] = this.createChangeList((LogEntry)logEntry);
                }
            }
        });
        FilePath path = pathTracker.getFilePath(this.myVcs);
        return path == null ? this.filePath : path;
    }

    @NotNull
    private SvnChangeList createChangeList(@NotNull LogEntry logEntry) {
        if (logEntry == null) {
            SingleCommittedListProvider.$$$reportNull$$$0(5);
        }
        return new SvnChangeList(this.myVcs, this.svnRootLocation, logEntry, this.repositoryUrl);
    }

    private void checkDisposed() {
        if (this.myProject.isDisposed()) {
            throw new ProcessCanceledException();
        }
    }

    private boolean searchForUrl(@NotNull Url url) throws VcsException {
        block3: {
            if (url == null) {
                SingleCommittedListProvider.$$$reportNull$$$0(6);
            }
            LogEntryConsumer handler = logEntry -> {
                this.checkDisposed();
                if (logEntry.getDate() != null) {
                    this.changeList[0] = this.createChangeList((LogEntry)logEntry);
                }
            };
            Target target = Target.on(url);
            try {
                this.myVcs.getFactory(target).createHistoryClient().doLog(target, this.revisionBefore, this.revisionBefore, false, true, false, 1L, null, handler);
            }
            catch (SvnBindException e) {
                LOG.info((Throwable)((Object)e));
                if (e.containsCategory(ErrorCategory.FS)) break block3;
                throw e;
            }
        }
        return this.changeList[0] != null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "vcs";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "number";
                break;
            }
            case 3: 
            case 4: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "url";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "logEntry";
                break;
            }
        }
        objectArray2[1] = "org/jetbrains/idea/svn/history/SingleCommittedListProvider";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "hasAccess";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "searchFromHead";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "createChangeList";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "searchForUrl";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

