/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.history;

import java.awt.GridBagLayout;
import java.util.ArrayList;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.JPanel;
import org.openstreetmap.josm.actions.JosmAction;
import org.openstreetmap.josm.data.osm.DataSet;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.history.HistoryOsmPrimitive;
import org.openstreetmap.josm.gui.MainApplication;
import org.openstreetmap.josm.gui.history.HistoryBrowserModel;
import org.openstreetmap.josm.gui.history.PointInTimeType;
import org.openstreetmap.josm.gui.history.VersionInfoPanel;
import org.openstreetmap.josm.tools.Destroyable;

public abstract class HistoryBrowserPanel
extends JPanel
implements Destroyable {
    protected transient HistoryBrowserModel model;
    protected VersionInfoPanel referenceInfoPanel;
    protected VersionInfoPanel currentInfoPanel;
    private final List<JosmAction> josmActions = new ArrayList<JosmAction>();

    protected HistoryBrowserPanel() {
        super(new GridBagLayout());
    }

    protected void registerAsChangeListener(HistoryBrowserModel model) {
        if (this.currentInfoPanel != null) {
            model.addChangeListener(this.currentInfoPanel);
        }
        if (this.referenceInfoPanel != null) {
            model.addChangeListener(this.referenceInfoPanel);
        }
    }

    protected void unregisterAsChangeListener(HistoryBrowserModel model) {
        if (this.currentInfoPanel != null) {
            model.removeChangeListener(this.currentInfoPanel);
        }
        if (this.referenceInfoPanel != null) {
            model.removeChangeListener(this.referenceInfoPanel);
        }
    }

    protected final void setModel(HistoryBrowserModel model) {
        if (this.model != null) {
            this.unregisterAsChangeListener(this.model);
        }
        this.model = model;
        if (this.model != null) {
            this.registerAsChangeListener(model);
        }
    }

    protected OsmPrimitive getPrimitiveFromDataSet(PointInTimeType pointInTime) {
        DataSet dataSet = MainApplication.getLayerManager().getEditDataSet();
        HistoryOsmPrimitive primitiveId = this.model.getPointInTime(pointInTime);
        if (dataSet == null || primitiveId == null) {
            return null;
        }
        return (OsmPrimitive)dataSet.getPrimitiveById(primitiveId.getUniqueId(), primitiveId.getType());
    }

    protected final <T extends AbstractAction> T trackJosmAction(T action) {
        if (action instanceof JosmAction) {
            this.josmActions.add((JosmAction)action);
        }
        return action;
    }

    @Override
    public void destroy() {
        this.setModel(null);
        if (this.referenceInfoPanel != null) {
            this.referenceInfoPanel.destroy();
        }
        if (this.currentInfoPanel != null) {
            this.currentInfoPanel.destroy();
        }
        this.josmActions.forEach(JosmAction::destroy);
        this.josmActions.clear();
    }
}

