/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.action.internal;

import org.hibernate.LockMode;
import org.hibernate.action.internal.EntityAction;
import org.hibernate.collection.spi.PersistentCollection;
import org.hibernate.engine.internal.ForeignKeys;
import org.hibernate.engine.internal.NonNullableTransientDependencies;
import org.hibernate.engine.internal.Nullability;
import org.hibernate.engine.internal.Versioning;
import org.hibernate.engine.spi.CachedNaturalIdValueSource;
import org.hibernate.engine.spi.CollectionKey;
import org.hibernate.engine.spi.EntityEntry;
import org.hibernate.engine.spi.EntityHolder;
import org.hibernate.engine.spi.EntityKey;
import org.hibernate.engine.spi.PersistenceContext;
import org.hibernate.engine.spi.Status;
import org.hibernate.event.spi.EventSource;
import org.hibernate.metamodel.mapping.AttributeMapping;
import org.hibernate.metamodel.mapping.AttributeMappingsList;
import org.hibernate.metamodel.mapping.EmbeddableMappingType;
import org.hibernate.metamodel.mapping.NaturalIdMapping;
import org.hibernate.metamodel.mapping.PluralAttributeMapping;
import org.hibernate.metamodel.mapping.internal.EmbeddedAttributeMapping;
import org.hibernate.persister.collection.CollectionPersister;
import org.hibernate.persister.entity.AbstractEntityPersister;
import org.hibernate.persister.entity.EntityPersister;

public abstract class AbstractEntityInsertAction
extends EntityAction {
    private transient Object[] state;
    private final boolean isVersionIncrementDisabled;
    private boolean isExecuted;
    private boolean areTransientReferencesNullified;

    protected AbstractEntityInsertAction(Object id, Object[] state, Object instance, boolean isVersionIncrementDisabled, EntityPersister persister, EventSource session) {
        super(session, id, instance, persister);
        this.state = state;
        this.isVersionIncrementDisabled = isVersionIncrementDisabled;
        this.isExecuted = false;
        this.areTransientReferencesNullified = false;
        if (id != null) {
            this.handleNaturalIdPreSaveNotifications();
        }
    }

    public Object[] getState() {
        return this.state;
    }

    public abstract boolean isEarlyInsert();

    public NonNullableTransientDependencies findNonNullableTransientEntities() {
        return ForeignKeys.findNonNullableTransientEntities(this.getPersister().getEntityName(), this.getInstance(), this.getState(), this.isEarlyInsert(), this.getSession());
    }

    protected final void nullifyTransientReferencesIfNotAlready() {
        if (!this.areTransientReferencesNullified) {
            new ForeignKeys.Nullifier(this.getInstance(), false, this.isEarlyInsert(), this.getSession(), this.getPersister()).nullifyTransientReferences(this.getState());
            new Nullability(this.getSession(), Nullability.NullabilityCheckType.CREATE).checkNullability(this.getState(), this.getPersister());
            this.areTransientReferencesNullified = true;
        }
    }

    public final void makeEntityManaged() {
        this.nullifyTransientReferencesIfNotAlready();
        Object version = Versioning.getVersion(this.getState(), this.getPersister());
        PersistenceContext persistenceContextInternal = this.getSession().getPersistenceContextInternal();
        EntityHolder entityHolder = persistenceContextInternal.addEntityHolder(this.getEntityKey(), this.getInstance());
        EntityEntry entityEntry = persistenceContextInternal.addEntry(this.getInstance(), this.getPersister().isMutable() ? Status.MANAGED : Status.READ_ONLY, this.getState(), this.getRowId(), this.getEntityKey().getIdentifier(), version, LockMode.WRITE, this.isExecuted, this.getPersister(), this.isVersionIncrementDisabled);
        entityHolder.setEntityEntry(entityEntry);
        if (this.isEarlyInsert()) {
            this.addCollectionsByKeyToPersistenceContext(persistenceContextInternal, this.getState());
        }
    }

    protected void addCollectionsByKeyToPersistenceContext(PersistenceContext persistenceContext, Object[] objects) {
        for (int i = 0; i < objects.length; ++i) {
            AttributeMapping attributeMapping = this.getPersister().getAttributeMapping(i);
            if (attributeMapping.isEmbeddedAttributeMapping()) {
                this.visitEmbeddedAttributeMapping(attributeMapping.asEmbeddedAttributeMapping(), objects[i], persistenceContext);
                continue;
            }
            if (!attributeMapping.isPluralAttributeMapping()) continue;
            this.addCollectionKey(attributeMapping.asPluralAttributeMapping(), objects[i], persistenceContext);
        }
    }

    private void visitEmbeddedAttributeMapping(EmbeddedAttributeMapping attributeMapping, Object object, PersistenceContext persistenceContext) {
        if (object != null) {
            EmbeddableMappingType descriptor = attributeMapping.getEmbeddableTypeDescriptor();
            EmbeddableMappingType.ConcreteEmbeddableType concreteEmbeddableType = descriptor.findSubtypeBySubclass(object.getClass().getName());
            AttributeMappingsList attributeMappings = descriptor.getAttributeMappings();
            for (int i = 0; i < attributeMappings.size(); ++i) {
                AttributeMapping attribute = attributeMappings.get(i);
                if (!concreteEmbeddableType.declaresAttribute(attribute)) continue;
                if (attribute.isPluralAttributeMapping()) {
                    this.addCollectionKey(attribute.asPluralAttributeMapping(), descriptor.getValue(object, i), persistenceContext);
                    continue;
                }
                if (!attribute.isEmbeddedAttributeMapping()) continue;
                this.visitEmbeddedAttributeMapping(attribute.asEmbeddedAttributeMapping(), descriptor.getValue(object, i), persistenceContext);
            }
        }
    }

    private void addCollectionKey(PluralAttributeMapping pluralAttributeMapping, Object object, PersistenceContext persistenceContext) {
        CollectionPersister collectionPersister;
        Object key;
        if (object instanceof PersistentCollection && (key = AbstractEntityPersister.getCollectionKey(collectionPersister = pluralAttributeMapping.getCollectionDescriptor(), this.getInstance(), persistenceContext.getEntry(this.getInstance()), this.getSession())) != null) {
            CollectionKey collectionKey = new CollectionKey(collectionPersister, key);
            persistenceContext.addCollectionByKey(collectionKey, (PersistentCollection)object);
        }
    }

    protected void markExecuted() {
        this.isExecuted = true;
    }

    protected abstract EntityKey getEntityKey();

    protected abstract Object getRowId();

    @Override
    public void afterDeserialize(EventSource session) {
        super.afterDeserialize(session);
        if (session != null) {
            EntityEntry entityEntry = session.getPersistenceContextInternal().getEntry(this.getInstance());
            this.state = entityEntry.getLoadedState();
        }
    }

    protected void handleNaturalIdPreSaveNotifications() {
        NaturalIdMapping naturalIdMapping = this.getPersister().getNaturalIdMapping();
        if (naturalIdMapping != null) {
            this.getSession().getPersistenceContextInternal().getNaturalIdResolutions().manageLocalResolution(this.getId(), naturalIdMapping.extractNaturalIdFromEntityState(this.state), this.getPersister(), CachedNaturalIdValueSource.INSERT);
        }
    }

    public void handleNaturalIdPostSaveNotifications(Object generatedId) {
        NaturalIdMapping naturalIdMapping = this.getPersister().getNaturalIdMapping();
        if (naturalIdMapping != null) {
            Object naturalIdValues = naturalIdMapping.extractNaturalIdFromEntityState(this.state);
            if (this.isEarlyInsert()) {
                this.getSession().getPersistenceContextInternal().getNaturalIdResolutions().manageLocalResolution(generatedId, naturalIdValues, this.getPersister(), CachedNaturalIdValueSource.INSERT);
            }
            this.getSession().getPersistenceContextInternal().getNaturalIdResolutions().manageSharedResolution(generatedId, naturalIdValues, null, this.getPersister(), CachedNaturalIdValueSource.INSERT);
        }
    }
}

