/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.sql.ppl.parser;

import java.math.BigDecimal;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import org.antlr.v4.runtime.ParserRuleContext;
import org.antlr.v4.runtime.RuleContext;
import org.antlr.v4.runtime.tree.ParseTree;
import org.opensearch.sql.ast.dsl.AstDSL;
import org.opensearch.sql.ast.expression.AggregateFunction;
import org.opensearch.sql.ast.expression.Alias;
import org.opensearch.sql.ast.expression.AllFields;
import org.opensearch.sql.ast.expression.And;
import org.opensearch.sql.ast.expression.Argument;
import org.opensearch.sql.ast.expression.Between;
import org.opensearch.sql.ast.expression.Case;
import org.opensearch.sql.ast.expression.Cast;
import org.opensearch.sql.ast.expression.Compare;
import org.opensearch.sql.ast.expression.DataType;
import org.opensearch.sql.ast.expression.EqualTo;
import org.opensearch.sql.ast.expression.Field;
import org.opensearch.sql.ast.expression.Function;
import org.opensearch.sql.ast.expression.In;
import org.opensearch.sql.ast.expression.Interval;
import org.opensearch.sql.ast.expression.IntervalUnit;
import org.opensearch.sql.ast.expression.LambdaFunction;
import org.opensearch.sql.ast.expression.Let;
import org.opensearch.sql.ast.expression.Literal;
import org.opensearch.sql.ast.expression.Not;
import org.opensearch.sql.ast.expression.Or;
import org.opensearch.sql.ast.expression.QualifiedName;
import org.opensearch.sql.ast.expression.RelevanceFieldList;
import org.opensearch.sql.ast.expression.SearchAnd;
import org.opensearch.sql.ast.expression.SearchComparison;
import org.opensearch.sql.ast.expression.SearchExpression;
import org.opensearch.sql.ast.expression.SearchGroup;
import org.opensearch.sql.ast.expression.SearchIn;
import org.opensearch.sql.ast.expression.SearchLiteral;
import org.opensearch.sql.ast.expression.SearchNot;
import org.opensearch.sql.ast.expression.SearchOr;
import org.opensearch.sql.ast.expression.UnresolvedArgument;
import org.opensearch.sql.ast.expression.UnresolvedExpression;
import org.opensearch.sql.ast.expression.When;
import org.opensearch.sql.ast.expression.WindowFunction;
import org.opensearch.sql.ast.expression.Xor;
import org.opensearch.sql.ast.expression.subquery.ExistsSubquery;
import org.opensearch.sql.ast.expression.subquery.InSubquery;
import org.opensearch.sql.ast.expression.subquery.ScalarSubquery;
import org.opensearch.sql.ast.tree.Trendline;
import org.opensearch.sql.common.antlr.SyntaxCheckException;
import org.opensearch.sql.common.setting.Settings;
import org.opensearch.sql.common.utils.StringUtils;
import org.opensearch.sql.exception.SemanticCheckException;
import org.opensearch.sql.expression.function.BuiltinFunctionName;
import org.opensearch.sql.ppl.antlr.parser.OpenSearchPPLParser;
import org.opensearch.sql.ppl.antlr.parser.OpenSearchPPLParserBaseVisitor;
import org.opensearch.sql.ppl.parser.AstBuilder;
import org.opensearch.sql.ppl.utils.ArgumentFactory;
import org.opensearch.sql.ppl.utils.UnresolvedPlanHelper;
import org.opensearch.sql.utils.DateTimeUtils;
import shaded.com.google.common.collect.ImmutableList;
import shaded.com.google.common.collect.ImmutableMap;

public class AstExpressionBuilder
extends OpenSearchPPLParserBaseVisitor<UnresolvedExpression> {
    private static final int DEFAULT_TAKE_FUNCTION_SIZE_VALUE = 10;
    private static final Map<String, String> FUNCTION_NAME_MAPPING = new ImmutableMap.Builder().put((Object)"isnull", (Object)BuiltinFunctionName.IS_NULL.getName().getFunctionName()).put((Object)"isnotnull", (Object)BuiltinFunctionName.IS_NOT_NULL.getName().getFunctionName()).put((Object)"regex_match", (Object)BuiltinFunctionName.REGEXP_MATCH.getName().getFunctionName()).put((Object)"regexp_replace", (Object)BuiltinFunctionName.REPLACE.getName().getFunctionName()).build();
    private final AstBuilder astBuilder;

    public AstExpressionBuilder(AstBuilder astBuilder) {
        this.astBuilder = astBuilder;
    }

    @Override
    public UnresolvedExpression visitEvalClause(OpenSearchPPLParser.EvalClauseContext ctx) {
        return new Let((Field)this.visit((ParseTree)ctx.fieldExpression()), (UnresolvedExpression)this.visit((ParseTree)ctx.logicalExpression()));
    }

    @Override
    public Trendline.TrendlineComputation visitTrendlineClause(OpenSearchPPLParser.TrendlineClauseContext ctx) {
        int numberOfDataPoints = Integer.parseInt(ctx.numberOfDataPoints.getText());
        if (numberOfDataPoints < 1) {
            throw new SyntaxCheckException("Number of trendline data-points must be greater than or equal to 1");
        }
        Field dataField = (Field)this.visitFieldExpression(ctx.field);
        String alias = ctx.alias != null ? ctx.alias.getText() : dataField.getChild().get(0).toString() + "_trendline";
        Trendline.TrendlineType computationType = Trendline.TrendlineType.valueOf(ctx.trendlineType().getText().toUpperCase(Locale.ROOT));
        return new Trendline.TrendlineComputation(numberOfDataPoints, dataField, alias, computationType);
    }

    @Override
    public UnresolvedExpression visitLogicalNot(OpenSearchPPLParser.LogicalNotContext ctx) {
        return new Not((UnresolvedExpression)this.visit((ParseTree)ctx.logicalExpression()));
    }

    @Override
    public UnresolvedExpression visitLogicalOr(OpenSearchPPLParser.LogicalOrContext ctx) {
        return new Or((UnresolvedExpression)this.visit((ParseTree)ctx.left), (UnresolvedExpression)this.visit((ParseTree)ctx.right));
    }

    @Override
    public UnresolvedExpression visitLogicalAnd(OpenSearchPPLParser.LogicalAndContext ctx) {
        return new And((UnresolvedExpression)this.visit((ParseTree)ctx.left), (UnresolvedExpression)this.visit((ParseTree)ctx.right));
    }

    @Override
    public UnresolvedExpression visitLogicalXor(OpenSearchPPLParser.LogicalXorContext ctx) {
        return new Xor((UnresolvedExpression)this.visit((ParseTree)ctx.left), (UnresolvedExpression)this.visit((ParseTree)ctx.right));
    }

    @Override
    public UnresolvedExpression visitLambda(OpenSearchPPLParser.LambdaContext ctx) {
        List<QualifiedName> arguments = ctx.ident().stream().map(x -> this.visitIdentifiers(Collections.singletonList(x))).collect(Collectors.toList());
        UnresolvedExpression function = (UnresolvedExpression)this.visit((ParseTree)ctx.logicalExpression());
        return new LambdaFunction(function, arguments);
    }

    @Override
    public UnresolvedExpression visitCompareExpr(OpenSearchPPLParser.CompareExprContext ctx) {
        String operator = ctx.comparisonOperator().getText();
        if ("==".equals(operator)) {
            operator = BuiltinFunctionName.EQUAL.getName().getFunctionName();
        } else if (BuiltinFunctionName.LIKE.getName().getFunctionName().equalsIgnoreCase(operator) && UnresolvedPlanHelper.isCalciteEnabled(this.astBuilder.getSettings())) {
            operator = UnresolvedPlanHelper.legacyPreferred(this.astBuilder.getSettings()) ? BuiltinFunctionName.ILIKE.getName().getFunctionName() : BuiltinFunctionName.LIKE.getName().getFunctionName();
        } else if (BuiltinFunctionName.ILIKE.getName().getFunctionName().equalsIgnoreCase(operator)) {
            operator = BuiltinFunctionName.ILIKE.getName().getFunctionName();
        }
        return new Compare(operator, (UnresolvedExpression)this.visit((ParseTree)ctx.left), (UnresolvedExpression)this.visit((ParseTree)ctx.right));
    }

    @Override
    public UnresolvedExpression visitInExpr(OpenSearchPPLParser.InExprContext ctx) {
        In expr = new In((UnresolvedExpression)this.visit((ParseTree)ctx.expression()), ctx.valueList().literalValue().stream().map(this::visitLiteralValue).collect(Collectors.toList()));
        return ctx.NOT() != null ? new Not(expr) : expr;
    }

    @Override
    public UnresolvedExpression visitBinaryArithmetic(OpenSearchPPLParser.BinaryArithmeticContext ctx) {
        return new Function(ctx.binaryOperator.getText(), this.buildArguments(ctx.left, ctx.right));
    }

    private List<UnresolvedExpression> buildArguments(OpenSearchPPLParser.ValueExpressionContext ... ctx) {
        ImmutableList.Builder builder = ImmutableList.builder();
        for (OpenSearchPPLParser.ValueExpressionContext value : ctx) {
            UnresolvedExpression unresolvedExpression = (UnresolvedExpression)this.visit((ParseTree)value);
            if (unresolvedExpression == null) continue;
            builder.add((Object)unresolvedExpression);
        }
        return builder.build();
    }

    @Override
    public UnresolvedExpression visitNestedValueExpr(OpenSearchPPLParser.NestedValueExprContext ctx) {
        return (UnresolvedExpression)this.visit((ParseTree)ctx.logicalExpression());
    }

    @Override
    public UnresolvedExpression visitFieldExpression(OpenSearchPPLParser.FieldExpressionContext ctx) {
        return new Field((QualifiedName)this.visit((ParseTree)ctx.qualifiedName()));
    }

    @Override
    public UnresolvedExpression visitWcFieldExpression(OpenSearchPPLParser.WcFieldExpressionContext ctx) {
        return new Field((QualifiedName)this.visit((ParseTree)ctx.wcQualifiedName()));
    }

    @Override
    public UnresolvedExpression visitSelectFieldExpression(OpenSearchPPLParser.SelectFieldExpressionContext ctx) {
        if (ctx.STAR() != null) {
            return AllFields.of();
        }
        return new Field((QualifiedName)this.visit((ParseTree)ctx.wcQualifiedName()));
    }

    @Override
    public UnresolvedExpression visitRenameFieldExpression(OpenSearchPPLParser.RenameFieldExpressionContext ctx) {
        if (ctx.STAR() != null) {
            return new Field(QualifiedName.of("*", new String[0]));
        }
        return new Field((QualifiedName)this.visit((ParseTree)ctx.wcQualifiedName()));
    }

    @Override
    public UnresolvedExpression visitPrefixSortField(OpenSearchPPLParser.PrefixSortFieldContext ctx) {
        return this.buildSortField(ctx.sortFieldExpression(), ctx);
    }

    @Override
    public UnresolvedExpression visitSuffixSortField(OpenSearchPPLParser.SuffixSortFieldContext ctx) {
        return this.buildSortField(ctx.sortFieldExpression(), ctx);
    }

    @Override
    public UnresolvedExpression visitDefaultSortField(OpenSearchPPLParser.DefaultSortFieldContext ctx) {
        return this.buildSortField(ctx.sortFieldExpression(), ctx);
    }

    @Override
    public UnresolvedExpression visitInvalidMixedSortField(OpenSearchPPLParser.InvalidMixedSortFieldContext ctx) {
        String prefixOperator;
        String string = prefixOperator = ctx.PLUS() != null ? "+" : "-";
        String suffixKeyword = ctx.ASC() != null ? "asc" : (ctx.A() != null ? "a" : (ctx.DESC() != null ? "desc" : "d"));
        throw new SemanticCheckException(String.format("Cannot use both prefix (%s) and suffix (%s) sort direction syntax on the same field. Use either '%s%s' or '%s %s', not both.", prefixOperator, suffixKeyword, prefixOperator, ctx.sortFieldExpression().getText(), ctx.sortFieldExpression().getText(), suffixKeyword));
    }

    private Field buildSortField(OpenSearchPPLParser.SortFieldExpressionContext sortFieldExpr, OpenSearchPPLParser.SortFieldContext parentCtx) {
        UnresolvedExpression fieldExpression = (UnresolvedExpression)this.visit((ParseTree)sortFieldExpr.fieldExpression().qualifiedName());
        if (sortFieldExpr.IP() != null) {
            fieldExpression = new Cast(fieldExpression, AstDSL.stringLiteral("ip"));
        } else if (sortFieldExpr.NUM() != null) {
            fieldExpression = new Cast(fieldExpression, AstDSL.stringLiteral("double"));
        } else if (sortFieldExpr.STR() != null) {
            fieldExpression = new Cast(fieldExpression, AstDSL.stringLiteral("string"));
        }
        return new Field(fieldExpression, ArgumentFactory.getArgumentList(parentCtx));
    }

    @Override
    public UnresolvedExpression visitPatternMethod(OpenSearchPPLParser.PatternMethodContext ctx) {
        return new Literal(StringUtils.unquoteText(ctx.getText()), DataType.STRING);
    }

    @Override
    public UnresolvedExpression visitPatternMode(OpenSearchPPLParser.PatternModeContext ctx) {
        return new Literal(StringUtils.unquoteText(ctx.getText()), DataType.STRING);
    }

    @Override
    public UnresolvedExpression visitStatsFunctionCall(OpenSearchPPLParser.StatsFunctionCallContext ctx) {
        return this.buildAggregateFunction(ctx.statsFunctionName().getText(), ctx.functionArgs().functionArg());
    }

    @Override
    public UnresolvedExpression visitValuesAggFunctionCall(OpenSearchPPLParser.ValuesAggFunctionCallContext ctx) {
        Integer settingValue;
        ImmutableList.Builder builder = ImmutableList.builder();
        int limit = 0;
        if (this.astBuilder.getSettings() != null && (settingValue = (Integer)this.astBuilder.getSettings().getSettingValue(Settings.Key.PPL_VALUES_MAX_LIMIT)) != null) {
            limit = settingValue;
        }
        if (limit > 0) {
            builder.add((Object)new UnresolvedArgument("limit", AstDSL.intLiteral(limit)));
        }
        return new AggregateFunction("values", (UnresolvedExpression)this.visit((ParseTree)ctx.valuesAggFunction().valueExpression()), (List<UnresolvedExpression>)builder.build());
    }

    private AggregateFunction buildAggregateFunction(String functionName, List<OpenSearchPPLParser.FunctionArgContext> args) {
        List unresolvedArgs = args.stream().map(this::visitFunctionArg).collect(Collectors.toList());
        return new AggregateFunction(functionName, (UnresolvedExpression)unresolvedArgs.get(0), unresolvedArgs.subList(1, unresolvedArgs.size()));
    }

    @Override
    public UnresolvedExpression visitCountAllFunctionCall(OpenSearchPPLParser.CountAllFunctionCallContext ctx) {
        return new AggregateFunction("count", AllFields.of());
    }

    @Override
    public UnresolvedExpression visitCountEvalFunctionCall(OpenSearchPPLParser.CountEvalFunctionCallContext ctx) {
        return new AggregateFunction("count", (UnresolvedExpression)this.visit((ParseTree)ctx.evalExpression()));
    }

    @Override
    public UnresolvedExpression visitDistinctCountFunctionCall(OpenSearchPPLParser.DistinctCountFunctionCallContext ctx) {
        String funcName = ctx.DISTINCT_COUNT_APPROX() != null ? "distinct_count_approx" : "count";
        return new AggregateFunction(funcName, (UnresolvedExpression)this.visit((ParseTree)ctx.valueExpression()), true);
    }

    @Override
    public UnresolvedExpression visitEvalExpression(OpenSearchPPLParser.EvalExpressionContext ctx) {
        UnresolvedExpression predicate = (UnresolvedExpression)this.visit((ParseTree)ctx.logicalExpression());
        return AstDSL.caseWhen(null, AstDSL.when(predicate, AstDSL.intLiteral(1)));
    }

    @Override
    public UnresolvedExpression visitPercentileApproxFunctionCall(OpenSearchPPLParser.PercentileApproxFunctionCallContext ctx) {
        ImmutableList.Builder builder = ImmutableList.builder();
        builder.add((Object)new UnresolvedArgument("percent", (UnresolvedExpression)this.visit((ParseTree)ctx.percentileApproxFunction().percent)));
        if (ctx.percentileApproxFunction().compression != null) {
            builder.add((Object)new UnresolvedArgument("compression", (UnresolvedExpression)this.visit((ParseTree)ctx.percentileApproxFunction().compression)));
        }
        return new AggregateFunction("percentile", (UnresolvedExpression)this.visit((ParseTree)ctx.percentileApproxFunction().aggField), (List<UnresolvedExpression>)builder.build());
    }

    @Override
    public UnresolvedExpression visitTakeAggFunctionCall(OpenSearchPPLParser.TakeAggFunctionCallContext ctx) {
        ImmutableList.Builder builder = ImmutableList.builder();
        builder.add((Object)new UnresolvedArgument("size", ctx.takeAggFunction().size != null ? (UnresolvedExpression)this.visit((ParseTree)ctx.takeAggFunction().size) : AstDSL.intLiteral(10)));
        return new AggregateFunction("take", (UnresolvedExpression)this.visit((ParseTree)ctx.takeAggFunction().fieldExpression()), (List<UnresolvedExpression>)builder.build());
    }

    @Override
    public UnresolvedExpression visitPercentileShortcutFunctionCall(OpenSearchPPLParser.PercentileShortcutFunctionCallContext ctx) {
        String functionName;
        int prefixLength = (functionName = ctx.getStart().getText()).toLowerCase().startsWith("perc") ? 4 : 1;
        String percentileValue = functionName.substring(prefixLength);
        double percent = Double.parseDouble(percentileValue);
        if (percent < 0.0 || percent > 100.0) {
            throw new SyntaxCheckException(String.format("Percentile value must be between 0 and 100, got: %s", percent));
        }
        return new AggregateFunction("percentile", (UnresolvedExpression)this.visit((ParseTree)ctx.valueExpression()), Collections.singletonList(new UnresolvedArgument("percent", AstDSL.doubleLiteral(percent))));
    }

    @Override
    public UnresolvedExpression visitCaseFunctionCall(OpenSearchPPLParser.CaseFunctionCallContext ctx) {
        List<When> whens = IntStream.range(0, ctx.logicalExpression().size()).mapToObj(index -> {
            UnresolvedExpression condition = (UnresolvedExpression)this.visit((ParseTree)ctx.logicalExpression(index));
            UnresolvedExpression result = (UnresolvedExpression)this.visit((ParseTree)ctx.valueExpression(index));
            return new When(condition, result);
        }).collect(Collectors.toList());
        UnresolvedExpression elseValue = null;
        if (ctx.ELSE() != null) {
            elseValue = (UnresolvedExpression)this.visit((ParseTree)ctx.valueExpression(ctx.valueExpression().size() - 1));
        }
        return new Case(null, whens, Optional.ofNullable(elseValue));
    }

    @Override
    public UnresolvedExpression visitEvalFunctionCall(OpenSearchPPLParser.EvalFunctionCallContext ctx) {
        String functionName = ctx.evalFunctionName().getText();
        String mappedName = FUNCTION_NAME_MAPPING.getOrDefault(functionName.toLowerCase(Locale.ROOT), functionName);
        if (BuiltinFunctionName.SUM.getName().getFunctionName().equalsIgnoreCase(mappedName) || BuiltinFunctionName.AVG.getName().getFunctionName().equalsIgnoreCase(mappedName)) {
            return this.rewriteSumAvgFunction(mappedName, ctx.functionArgs().functionArg());
        }
        return this.buildFunction(mappedName, ctx.functionArgs().functionArg());
    }

    private Function buildFunction(String functionName, List<OpenSearchPPLParser.FunctionArgContext> args) {
        return new Function(functionName, args.stream().map(this::visitFunctionArg).collect(Collectors.toList()));
    }

    @Override
    public UnresolvedExpression visitDataTypeFunctionCall(OpenSearchPPLParser.DataTypeFunctionCallContext ctx) {
        return new Cast((UnresolvedExpression)this.visit((ParseTree)ctx.logicalExpression()), (UnresolvedExpression)this.visit((ParseTree)ctx.convertedDataType()));
    }

    @Override
    public UnresolvedExpression visitConvertedDataType(OpenSearchPPLParser.ConvertedDataTypeContext ctx) {
        return AstDSL.stringLiteral(ctx.getText());
    }

    private UnresolvedExpression rewriteSumAvgFunction(String functionName, List<OpenSearchPPLParser.FunctionArgContext> args) {
        if (args.isEmpty()) {
            throw new SyntaxCheckException(functionName + " function requires at least one argument");
        }
        List<UnresolvedExpression> arguments = args.stream().map(this::visitFunctionArg).collect(Collectors.toList());
        UnresolvedExpression functionExpr = this.buildBalancedTree("+", arguments);
        if (BuiltinFunctionName.AVG.getName().getFunctionName().equalsIgnoreCase(functionName)) {
            Literal count = AstDSL.doubleLiteral(Double.valueOf(arguments.size()));
            functionExpr = new Function("/", Arrays.asList(functionExpr, count));
        }
        return functionExpr;
    }

    private UnresolvedExpression buildBalancedTree(String operator, List<UnresolvedExpression> expressions) {
        if (expressions.size() == 1) {
            return expressions.get(0);
        }
        if (expressions.size() == 2) {
            return new Function(operator, Arrays.asList(expressions.get(0), expressions.get(1)));
        }
        int mid = expressions.size() / 2;
        UnresolvedExpression left = this.buildBalancedTree(operator, expressions.subList(0, mid));
        UnresolvedExpression right = this.buildBalancedTree(operator, expressions.subList(mid, expressions.size()));
        return new Function(operator, Arrays.asList(left, right));
    }

    @Override
    public UnresolvedExpression visitSingleFieldRelevanceFunction(OpenSearchPPLParser.SingleFieldRelevanceFunctionContext ctx) {
        return new Function(ctx.singleFieldRelevanceFunctionName().getText().toLowerCase(Locale.ROOT), this.singleFieldRelevanceArguments(ctx));
    }

    @Override
    public UnresolvedExpression visitMultiFieldRelevanceFunction(OpenSearchPPLParser.MultiFieldRelevanceFunctionContext ctx) {
        return new Function(ctx.multiFieldRelevanceFunctionName().getText().toLowerCase(Locale.ROOT), this.multiFieldRelevanceArguments(ctx));
    }

    @Override
    public UnresolvedExpression visitTableSource(OpenSearchPPLParser.TableSourceContext ctx) {
        if (ctx.getChild(0) instanceof OpenSearchPPLParser.IdentsAsTableQualifiedNameContext) {
            return this.visitIdentsAsTableQualifiedName((OpenSearchPPLParser.IdentsAsTableQualifiedNameContext)ctx.getChild(0));
        }
        return this.visitIdentifiers(Arrays.asList(ctx));
    }

    @Override
    public UnresolvedExpression visitPositionFunctionCall(OpenSearchPPLParser.PositionFunctionCallContext ctx) {
        return new Function(BuiltinFunctionName.POSITION.getName().getFunctionName(), Arrays.asList((UnresolvedExpression)this.visitFunctionArg(ctx.functionArg(0)), (UnresolvedExpression)this.visitFunctionArg(ctx.functionArg(1))));
    }

    @Override
    public UnresolvedExpression visitExtractFunctionCall(OpenSearchPPLParser.ExtractFunctionCallContext ctx) {
        return new Function(ctx.EXTRACT().toString(), this.getExtractFunctionArguments(ctx));
    }

    private List<UnresolvedExpression> getExtractFunctionArguments(OpenSearchPPLParser.ExtractFunctionCallContext ctx) {
        List<UnresolvedExpression> args = Arrays.asList(new Literal(ctx.datetimePart().getText(), DataType.STRING), (UnresolvedExpression)this.visitFunctionArg(ctx.functionArg()));
        return args;
    }

    @Override
    public UnresolvedExpression visitGetFormatFunctionCall(OpenSearchPPLParser.GetFormatFunctionCallContext ctx) {
        return new Function(ctx.GET_FORMAT().toString(), this.getFormatFunctionArguments(ctx));
    }

    private List<UnresolvedExpression> getFormatFunctionArguments(OpenSearchPPLParser.GetFormatFunctionCallContext ctx) {
        List<UnresolvedExpression> args = Arrays.asList(new Literal(ctx.getFormatType().getText(), DataType.STRING), (UnresolvedExpression)this.visitFunctionArg(ctx.functionArg()));
        return args;
    }

    @Override
    public UnresolvedExpression visitTimestampFunctionCall(OpenSearchPPLParser.TimestampFunctionCallContext ctx) {
        return new Function(ctx.timestampFunctionName().getText(), this.timestampFunctionArguments(ctx));
    }

    private List<UnresolvedExpression> timestampFunctionArguments(OpenSearchPPLParser.TimestampFunctionCallContext ctx) {
        List<UnresolvedExpression> args = Arrays.asList(new Literal(ctx.simpleDateTimePart().getText(), DataType.STRING), (UnresolvedExpression)this.visitFunctionArg(ctx.firstArg), (UnresolvedExpression)this.visitFunctionArg(ctx.secondArg));
        return args;
    }

    @Override
    public UnresolvedExpression visitPerFunctionCall(OpenSearchPPLParser.PerFunctionCallContext ctx) {
        String perFuncName = ctx.perFunction().funcName.getText();
        boolean foundTimechartContext = false;
        for (ParserRuleContext current = ctx.getParent(); current != null; current = current.getParent()) {
            if (!(current instanceof OpenSearchPPLParser.TimechartCommandContext)) continue;
            foundTimechartContext = true;
            break;
        }
        if (!foundTimechartContext) {
            throw new SyntaxCheckException(perFuncName + " function can only be used within timechart command");
        }
        return this.buildAggregateFunction(perFuncName, Collections.singletonList(ctx.perFunction().functionArg()));
    }

    @Override
    public UnresolvedExpression visitIdentsAsQualifiedName(OpenSearchPPLParser.IdentsAsQualifiedNameContext ctx) {
        return this.visitIdentifiers(ctx.ident());
    }

    @Override
    public UnresolvedExpression visitIdentsAsTableQualifiedName(OpenSearchPPLParser.IdentsAsTableQualifiedNameContext ctx) {
        return this.visitIdentifiers(Stream.concat(Stream.of(ctx.tableIdent()), ctx.ident().stream()).collect(Collectors.toList()));
    }

    @Override
    public UnresolvedExpression visitIdentsAsWildcardQualifiedName(OpenSearchPPLParser.IdentsAsWildcardQualifiedNameContext ctx) {
        return this.visitIdentifiers(ctx.wildcard());
    }

    @Override
    public UnresolvedExpression visitIntervalLiteral(OpenSearchPPLParser.IntervalLiteralContext ctx) {
        return new Interval((UnresolvedExpression)this.visit((ParseTree)ctx.valueExpression()), IntervalUnit.of(ctx.intervalUnit().getText()));
    }

    @Override
    public UnresolvedExpression visitStringLiteral(OpenSearchPPLParser.StringLiteralContext ctx) {
        return new Literal(StringUtils.unquoteText(ctx.getText()), DataType.STRING);
    }

    @Override
    public UnresolvedExpression visitIntegerLiteral(OpenSearchPPLParser.IntegerLiteralContext ctx) {
        long number = Long.parseLong(ctx.getText());
        if (Integer.MIN_VALUE <= number && number <= Integer.MAX_VALUE) {
            return new Literal((int)number, DataType.INTEGER);
        }
        return new Literal(number, DataType.LONG);
    }

    @Override
    public UnresolvedExpression visitDecimalLiteral(OpenSearchPPLParser.DecimalLiteralContext ctx) {
        return new Literal(new BigDecimal(ctx.getText()), DataType.DECIMAL);
    }

    @Override
    public UnresolvedExpression visitDoubleLiteral(OpenSearchPPLParser.DoubleLiteralContext ctx) {
        return new Literal(Double.valueOf(ctx.getText()), DataType.DOUBLE);
    }

    @Override
    public UnresolvedExpression visitFloatLiteral(OpenSearchPPLParser.FloatLiteralContext ctx) {
        return new Literal(Float.valueOf(ctx.getText()), DataType.FLOAT);
    }

    @Override
    public UnresolvedExpression visitBooleanLiteral(OpenSearchPPLParser.BooleanLiteralContext ctx) {
        return new Literal(Boolean.valueOf(ctx.getText()), DataType.BOOLEAN);
    }

    @Override
    public UnresolvedExpression visitBySpanClause(OpenSearchPPLParser.BySpanClauseContext ctx) {
        String name = ctx.spanClause().getText();
        return ctx.alias != null ? new Alias(StringUtils.unquoteIdentifier(ctx.alias.getText()), (UnresolvedExpression)this.visit((ParseTree)ctx.spanClause())) : new Alias(name, (UnresolvedExpression)this.visit((ParseTree)ctx.spanClause()));
    }

    @Override
    public UnresolvedExpression visitSpanClause(OpenSearchPPLParser.SpanClauseContext ctx) {
        UnresolvedExpression fieldExpression = ctx.fieldExpression() != null ? (UnresolvedExpression)this.visit((ParseTree)ctx.fieldExpression()) : AstDSL.implicitTimestampField();
        Literal literal = (Literal)this.visit((ParseTree)ctx.value);
        return AstDSL.spanFromSpanLengthLiteral(fieldExpression, literal);
    }

    @Override
    public UnresolvedExpression visitLeftHint(OpenSearchPPLParser.LeftHintContext ctx) {
        return new EqualTo(new Literal(ctx.leftHintKey.getText(), DataType.STRING), (UnresolvedExpression)this.visit((ParseTree)ctx.leftHintValue));
    }

    @Override
    public UnresolvedExpression visitRightHint(OpenSearchPPLParser.RightHintContext ctx) {
        return new EqualTo(new Literal(ctx.rightHintKey.getText(), DataType.STRING), (UnresolvedExpression)this.visit((ParseTree)ctx.rightHintValue));
    }

    @Override
    public UnresolvedExpression visitInSubqueryExpr(OpenSearchPPLParser.InSubqueryExprContext ctx) {
        List<UnresolvedExpression> s = ctx.valueExpression().stream().map(arg_0 -> ((AstExpressionBuilder)this).visit(arg_0)).collect(Collectors.toList());
        InSubquery expr = new InSubquery(s, this.astBuilder.visitSubSearch(ctx.subSearch()));
        return ctx.NOT() != null ? new Not(expr) : expr;
    }

    @Override
    public UnresolvedExpression visitScalarSubqueryExpr(OpenSearchPPLParser.ScalarSubqueryExprContext ctx) {
        return new ScalarSubquery(this.astBuilder.visitSubSearch(ctx.subSearch()));
    }

    @Override
    public UnresolvedExpression visitExistsSubqueryExpr(OpenSearchPPLParser.ExistsSubqueryExprContext ctx) {
        return new ExistsSubquery(this.astBuilder.visitSubSearch(ctx.subSearch()));
    }

    @Override
    public UnresolvedExpression visitBetween(OpenSearchPPLParser.BetweenContext ctx) {
        Between betweenExpr = new Between((UnresolvedExpression)this.visit((ParseTree)ctx.expression(0)), (UnresolvedExpression)this.visit((ParseTree)ctx.expression(1)), (UnresolvedExpression)this.visit((ParseTree)ctx.expression(2)));
        return ctx.NOT() != null ? new Not(betweenExpr) : betweenExpr;
    }

    @Override
    public UnresolvedExpression visitWindowFunction(OpenSearchPPLParser.WindowFunctionContext ctx) {
        Function f = this.buildFunction(ctx.windowFunctionName().getText(), ctx.functionArgs().functionArg());
        return new WindowFunction(f);
    }

    @Override
    public UnresolvedExpression visitOverwriteOption(OpenSearchPPLParser.OverwriteOptionContext ctx) {
        return new Argument("overwrite", (Literal)this.visit((ParseTree)ctx.booleanLiteral()));
    }

    @Override
    public UnresolvedExpression visitJoinType(OpenSearchPPLParser.JoinTypeContext ctx) {
        return ArgumentFactory.getArgumentValue(ctx);
    }

    @Override
    public UnresolvedExpression visitMaxOption(OpenSearchPPLParser.MaxOptionContext ctx) {
        return new Argument("max", (Literal)this.visit((ParseTree)ctx.integerLiteral()));
    }

    public QualifiedName visitIdentifiers(List<? extends ParserRuleContext> ctx) {
        return new QualifiedName(ctx.stream().map(RuleContext::getText).map(StringUtils::unquoteIdentifier).collect(Collectors.toList()));
    }

    private List<UnresolvedExpression> singleFieldRelevanceArguments(OpenSearchPPLParser.SingleFieldRelevanceFunctionContext ctx) {
        ImmutableList.Builder builder = ImmutableList.builder();
        builder.add((Object)new UnresolvedArgument("field", new QualifiedName(StringUtils.unquoteText(ctx.field.getText()))));
        builder.add((Object)new UnresolvedArgument("query", new Literal(StringUtils.unquoteText(ctx.query.getText()), DataType.STRING)));
        ctx.relevanceArg().forEach(v -> builder.add((Object)new UnresolvedArgument(v.relevanceArgName().getText().toLowerCase(Locale.ROOT), new Literal(StringUtils.unquoteText(v.relevanceArgValue().getText()), DataType.STRING))));
        return builder.build();
    }

    private List<UnresolvedExpression> multiFieldRelevanceArguments(OpenSearchPPLParser.MultiFieldRelevanceFunctionContext ctx) {
        ImmutableList.Builder builder = ImmutableList.builder();
        List fieldContexts = ctx.getRuleContexts(OpenSearchPPLParser.RelevanceFieldAndWeightContext.class);
        if (fieldContexts != null && !fieldContexts.isEmpty()) {
            RelevanceFieldList fields = new RelevanceFieldList(fieldContexts.stream().collect(Collectors.toMap(f -> StringUtils.unquoteText(f.field.getText()), f -> Float.valueOf(f.weight == null ? 1.0f : Float.parseFloat(f.weight.getText())))));
            builder.add((Object)new UnresolvedArgument("fields", fields));
        }
        builder.add((Object)new UnresolvedArgument("query", new Literal(StringUtils.unquoteText(ctx.query.getText()), DataType.STRING)));
        ctx.relevanceArg().forEach(v -> builder.add((Object)new UnresolvedArgument(v.relevanceArgName().getText().toLowerCase(Locale.ROOT), new Literal(StringUtils.unquoteText(v.relevanceArgValue().getText()), DataType.STRING))));
        return builder.build();
    }

    @Override
    public UnresolvedExpression visitSpanLiteral(OpenSearchPPLParser.SpanLiteralContext ctx) {
        if (ctx.INTEGER_LITERAL() != null) {
            return AstDSL.intLiteral(Integer.parseInt(ctx.INTEGER_LITERAL().getText()));
        }
        if (ctx.DECIMAL_LITERAL() != null) {
            return AstDSL.decimalLiteral(new BigDecimal(ctx.DECIMAL_LITERAL().getText()));
        }
        if (ctx.DECIMAL_SPANLENGTH() != null || ctx.DOUBLE_LITERAL() != null) {
            throw new IllegalArgumentException(StringUtils.format("Span length [%s] is invalid: floating-point time intervals are not supported.", ctx.DECIMAL_SPANLENGTH() != null ? ctx.DECIMAL_SPANLENGTH().getText() : ctx.DOUBLE_LITERAL().getText()));
        }
        return AstDSL.stringLiteral(ctx.getText());
    }

    @Override
    public UnresolvedExpression visitNumericSpanValue(OpenSearchPPLParser.NumericSpanValueContext ctx) {
        return (UnresolvedExpression)this.visit((ParseTree)ctx.spanLiteral());
    }

    @Override
    public UnresolvedExpression visitLogWithBaseSpan(OpenSearchPPLParser.LogWithBaseSpanContext ctx) {
        return AstDSL.stringLiteral(ctx.getText());
    }

    @Override
    public SearchExpression visitGroupedExpression(OpenSearchPPLParser.GroupedExpressionContext ctx) {
        return new SearchGroup((SearchExpression)this.visit((ParseTree)ctx.searchExpression()));
    }

    @Override
    public SearchExpression visitNotExpression(OpenSearchPPLParser.NotExpressionContext ctx) {
        return new SearchNot((SearchExpression)this.visit((ParseTree)ctx.searchExpression()));
    }

    @Override
    public SearchExpression visitAndExpression(OpenSearchPPLParser.AndExpressionContext ctx) {
        SearchExpression left = (SearchExpression)this.visit((ParseTree)ctx.searchExpression(0));
        SearchExpression right = (SearchExpression)this.visit((ParseTree)ctx.searchExpression(1));
        return new SearchGroup(new SearchAnd(left, right));
    }

    @Override
    public SearchExpression visitOrExpression(OpenSearchPPLParser.OrExpressionContext ctx) {
        SearchExpression left = (SearchExpression)this.visit((ParseTree)ctx.searchExpression(0));
        SearchExpression right = (SearchExpression)this.visit((ParseTree)ctx.searchExpression(1));
        return new SearchGroup(new SearchOr(left, right));
    }

    @Override
    public SearchExpression visitTermExpression(OpenSearchPPLParser.TermExpressionContext ctx) {
        return (SearchExpression)this.visit((ParseTree)ctx.searchTerm());
    }

    @Override
    public SearchExpression visitSearchLiteralTerm(OpenSearchPPLParser.SearchLiteralTermContext ctx) {
        return this.visitSearchLiteral(ctx.searchLiteral());
    }

    @Override
    public SearchExpression visitSearchComparisonTerm(OpenSearchPPLParser.SearchComparisonTermContext ctx) {
        OpenSearchPPLParser.SearchFieldCompareContext fieldComp = (OpenSearchPPLParser.SearchFieldCompareContext)ctx.searchFieldComparison();
        Field field = (Field)this.visit((ParseTree)fieldComp.fieldExpression());
        SearchComparison.Operator op = this.visitSearchComparisonOperator(fieldComp.searchComparisonOperator());
        SearchLiteral searchLit = this.visitSearchLiteral(fieldComp.searchLiteral());
        return new SearchComparison(field, op, searchLit);
    }

    @Override
    public SearchExpression visitSearchInListTerm(OpenSearchPPLParser.SearchInListTermContext ctx) {
        OpenSearchPPLParser.SearchFieldInValuesContext fieldIn = (OpenSearchPPLParser.SearchFieldInValuesContext)ctx.searchFieldInList();
        Field field = (Field)this.visit((ParseTree)fieldIn.fieldExpression());
        OpenSearchPPLParser.SearchLiteralsContext valueList = (OpenSearchPPLParser.SearchLiteralsContext)fieldIn.searchLiteralList();
        List<SearchLiteral> values = valueList.searchLiteral().stream().map(this::visitSearchLiteral).collect(Collectors.toList());
        return new SearchIn(field, values);
    }

    private SearchComparison.Operator visitSearchComparisonOperator(OpenSearchPPLParser.SearchComparisonOperatorContext ctx) {
        if (ctx instanceof OpenSearchPPLParser.EqualsContext) {
            return SearchComparison.Operator.EQUALS;
        }
        if (ctx instanceof OpenSearchPPLParser.NotEqualsContext) {
            return SearchComparison.Operator.NOT_EQUALS;
        }
        if (ctx instanceof OpenSearchPPLParser.LessThanContext) {
            return SearchComparison.Operator.LESS_THAN;
        }
        if (ctx instanceof OpenSearchPPLParser.LessOrEqualContext) {
            return SearchComparison.Operator.LESS_OR_EQUAL;
        }
        if (ctx instanceof OpenSearchPPLParser.GreaterThanContext) {
            return SearchComparison.Operator.GREATER_THAN;
        }
        if (ctx instanceof OpenSearchPPLParser.GreaterOrEqualContext) {
            return SearchComparison.Operator.GREATER_OR_EQUAL;
        }
        return SearchComparison.Operator.EQUALS;
    }

    @Override
    public SearchLiteral visitSearchLiteral(OpenSearchPPLParser.SearchLiteralContext ctx) {
        if (ctx.stringLiteral() != null) {
            Literal stringLit = (Literal)this.visit((ParseTree)ctx.stringLiteral());
            String content = (String)stringLit.getValue();
            return new SearchLiteral(new Literal(content, DataType.STRING), content.contains(" "));
        }
        if (ctx.numericLiteral() != null) {
            Literal numericLiteral = (Literal)this.visit((ParseTree)ctx.numericLiteral());
            return new SearchLiteral(numericLiteral, false);
        }
        if (ctx.booleanLiteral() != null) {
            Literal booleanLiteral = (Literal)this.visit((ParseTree)ctx.booleanLiteral());
            return new SearchLiteral(booleanLiteral, false);
        }
        return new SearchLiteral(new Literal(ctx.getText(), DataType.STRING), false);
    }

    @Override
    public UnresolvedExpression visitTimeModifierValue(OpenSearchPPLParser.TimeModifierValueContext ctx) {
        String osDateMathExpression;
        if (ctx.DECIMAL_LITERAL() != null) {
            String decimal = ctx.DECIMAL_LITERAL().getText();
            BigDecimal unixSecondDecimal = new BigDecimal(decimal);
            BigDecimal unixMilliDecimal = unixSecondDecimal.multiply(BigDecimal.valueOf(1000L)).stripTrailingZeros();
            osDateMathExpression = unixMilliDecimal.toString();
        } else if (ctx.INTEGER_LITERAL() != null) {
            String integer = ctx.INTEGER_LITERAL().getText();
            osDateMathExpression = String.valueOf(Long.parseLong(integer) * 1000L);
        } else if (ctx.NOW() != null) {
            osDateMathExpression = ctx.NOW().getText().toLowerCase(Locale.ROOT);
        } else {
            String pplTimeModifier = ctx.stringLiteral() != null ? (String)((Literal)this.visit((ParseTree)ctx.stringLiteral())).getValue() : ctx.getText().strip();
            osDateMathExpression = DateTimeUtils.resolveTimeModifier(pplTimeModifier);
        }
        return AstDSL.stringLiteral(osDateMathExpression);
    }

    @Override
    public UnresolvedExpression visitTimeModifierExpression(OpenSearchPPLParser.TimeModifierExpressionContext ctx) {
        Literal timeModifierValue = (Literal)this.visitTimeModifierValue(ctx.timeModifier().timeModifierValue());
        SearchLiteral osDateMathLiteral = new SearchLiteral(timeModifierValue, false);
        Field implicitTimestampField = new Field(new QualifiedName("@timestamp"), List.of());
        SearchComparison.Operator operator = ctx.timeModifier().EARLIEST() != null ? SearchComparison.Operator.GREATER_OR_EQUAL : SearchComparison.Operator.LESS_OR_EQUAL;
        return new SearchComparison(implicitTimestampField, operator, osDateMathLiteral);
    }

    @Override
    public UnresolvedExpression visitBinOption(OpenSearchPPLParser.BinOptionContext ctx) {
        UnresolvedExpression option;
        if (ctx.span != null) {
            option = (UnresolvedExpression)this.visit((ParseTree)ctx.span);
        } else if (ctx.bins != null) {
            option = (UnresolvedExpression)this.visit((ParseTree)ctx.bins);
        } else if (ctx.minspan != null) {
            option = (UnresolvedExpression)this.visit((ParseTree)ctx.minspan);
        } else if (ctx.aligntime != null) {
            option = ctx.aligntime.EARLIEST() != null ? AstDSL.stringLiteral("earliest") : (ctx.aligntime.LATEST() != null ? AstDSL.stringLiteral("latest") : (UnresolvedExpression)this.visit((ParseTree)ctx.aligntime.literalValue()));
        } else if (ctx.start != null) {
            option = (UnresolvedExpression)this.visit((ParseTree)ctx.start);
        } else if (ctx.end != null) {
            option = (UnresolvedExpression)this.visit((ParseTree)ctx.end);
        } else {
            throw new SyntaxCheckException(StringUtils.format("Unknown bin option: %s", ctx.getText()));
        }
        return option;
    }

    @Override
    public UnresolvedExpression visitRowSplit(OpenSearchPPLParser.RowSplitContext ctx) {
        Field field = (Field)this.visit((ParseTree)ctx.fieldExpression());
        for (OpenSearchPPLParser.BinOptionContext option : ctx.binOption()) {
            if (option.span == null) continue;
            return AstDSL.alias(field.getField().toString(), AstDSL.spanFromSpanLengthLiteral(field, (Literal)this.visit((ParseTree)option.binSpanValue())));
        }
        return AstDSL.alias(ctx.fieldExpression().getText(), field);
    }

    @Override
    public UnresolvedExpression visitColumnSplit(OpenSearchPPLParser.ColumnSplitContext ctx) {
        Field field = (Field)this.visit((ParseTree)ctx.fieldExpression());
        for (OpenSearchPPLParser.BinOptionContext option : ctx.binOption()) {
            if (option.span == null) continue;
            return AstDSL.alias(field.getField().toString(), AstDSL.spanFromSpanLengthLiteral(field, (Literal)this.visit((ParseTree)option.binSpanValue())));
        }
        return AstDSL.alias(ctx.fieldExpression().getText(), field);
    }
}

