/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.alerting.transport;

import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.opensearch.OpenSearchStatusException;
import org.opensearch.alerting.settings.AlertingSettings;
import org.opensearch.alerting.transport.SecureTransportActionKt;
import org.opensearch.cluster.service.ClusterService;
import org.opensearch.commons.alerting.util.AlertingException;
import org.opensearch.commons.authuser.User;
import org.opensearch.core.action.ActionListener;
import org.opensearch.core.rest.RestStatus;
import org.opensearch.transport.client.Client;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u0002\bf\u0018\u00002\u00020\u0001J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0012\u0010\f\u001a\u0004\u0018\u00010\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\u0012\u0010\u0010\u001a\u00020\u00032\b\u0010\u0011\u001a\u0004\u0018\u00010\rH\u0016J\u0012\u0010\u0012\u001a\u00020\u00032\b\u0010\u0011\u001a\u0004\u0018\u00010\rH\u0016J*\u0010\u0013\u001a\u00020\u0003\"\b\b\u0000\u0010\u0014*\u00020\u00012\b\u0010\u0011\u001a\u0004\u0018\u00010\r2\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u0002H\u00140\u0016H\u0016JD\u0010\u0017\u001a\u00020\u0003\"\b\b\u0000\u0010\u0014*\u00020\u00012\b\u0010\u0018\u001a\u0004\u0018\u00010\r2\b\u0010\u0019\u001a\u0004\u0018\u00010\r2\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u0002H\u00140\u00162\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001bH\u0016R\u0018\u0010\u0002\u001a\u00020\u0003X\u00a6\u000e\u00a2\u0006\f\u001a\u0004\b\u0004\u0010\u0005\"\u0004\b\u0006\u0010\u0007\u00a8\u0006\u001d\u00c0\u0006\u0003"}, d2={"Lorg/opensearch/alerting/transport/SecureTransportAction;", "", "filterByEnabled", "", "getFilterByEnabled", "()Z", "setFilterByEnabled", "(Z)V", "listenFilterBySettingChange", "", "clusterService", "Lorg/opensearch/cluster/service/ClusterService;", "readUserFromThreadContext", "Lorg/opensearch/commons/authuser/User;", "client", "Lorg/opensearch/transport/client/Client;", "doFilterForUser", "user", "isAdmin", "validateUserBackendRoles", "T", "actionListener", "Lorg/opensearch/core/action/ActionListener;", "checkUserPermissionsWithResource", "requesterUser", "resourceUser", "resourceType", "", "resourceId", "opensearch-alerting"})
public interface SecureTransportAction {
    public boolean getFilterByEnabled();

    public void setFilterByEnabled(boolean var1);

    default public void listenFilterBySettingChange(@NotNull ClusterService clusterService) {
        Intrinsics.checkNotNullParameter((Object)clusterService, (String)"clusterService");
        clusterService.getClusterSettings().addSettingsUpdateConsumer(AlertingSettings.Companion.getFILTER_BY_BACKEND_ROLES(), arg_0 -> SecureTransportAction.listenFilterBySettingChange$lambda$0(this, arg_0));
    }

    @Nullable
    default public User readUserFromThreadContext(@NotNull Client client) {
        Intrinsics.checkNotNullParameter((Object)client, (String)"client");
        String userStr = (String)client.threadPool().getThreadContext().getTransient("_opendistro_security_user_info");
        SecureTransportActionKt.access$getLog$p().debug("User and roles string from thread context: " + userStr);
        return User.parse((String)userStr);
    }

    default public boolean doFilterForUser(@Nullable User user) {
        SecureTransportActionKt.access$getLog$p().debug("Is filterByEnabled: " + this.getFilterByEnabled() + " ; Is admin user: " + this.isAdmin(user));
        return this.isAdmin(user) ? false : this.getFilterByEnabled();
    }

    default public boolean isAdmin(@Nullable User user) {
        boolean bl;
        if (user == null) {
            bl = false;
        } else {
            List list = user.getRoles();
            boolean bl2 = list != null ? ((Collection)list).isEmpty() : false;
            if (bl2) {
                bl = false;
            } else {
                List list2 = user.getRoles();
                bl = list2 != null ? list2.contains("all_access") : false;
            }
        }
        return bl;
    }

    default public <T> boolean validateUserBackendRoles(@Nullable User user, @NotNull ActionListener<T> actionListener) {
        Intrinsics.checkNotNullParameter(actionListener, (String)"actionListener");
        if (this.getFilterByEnabled()) {
            if (user == null) {
                actionListener.onFailure((Exception)AlertingException.Companion.wrap((Exception)new OpenSearchStatusException("Filter by user backend roles is enabled with security disabled.", RestStatus.FORBIDDEN, new Object[0])));
                return false;
            }
            if (this.isAdmin(user)) {
                return true;
            }
            Collection collection = user.getBackendRoles();
            if (collection == null || collection.isEmpty()) {
                actionListener.onFailure((Exception)AlertingException.Companion.wrap((Exception)new OpenSearchStatusException("User doesn't have backend roles configured. Contact administrator", RestStatus.FORBIDDEN, new Object[0])));
                return false;
            }
        }
        return true;
    }

    default public <T> boolean checkUserPermissionsWithResource(@Nullable User requesterUser, @Nullable User resourceUser, @NotNull ActionListener<T> actionListener, @NotNull String resourceType, @NotNull String resourceId) {
        List requesterBackendRoles;
        Intrinsics.checkNotNullParameter(actionListener, (String)"actionListener");
        Intrinsics.checkNotNullParameter((Object)resourceType, (String)"resourceType");
        Intrinsics.checkNotNullParameter((Object)resourceId, (String)"resourceId");
        if (!this.doFilterForUser(requesterUser)) {
            return true;
        }
        User user = resourceUser;
        List resourceBackendRoles = user != null ? user.getBackendRoles() : null;
        User user2 = requesterUser;
        List list = requesterBackendRoles = user2 != null ? user2.getBackendRoles() : null;
        if (resourceBackendRoles == null || requesterBackendRoles == null || CollectionsKt.intersect((Iterable)resourceBackendRoles, (Iterable)requesterBackendRoles).isEmpty()) {
            actionListener.onFailure((Exception)AlertingException.Companion.wrap((Exception)new OpenSearchStatusException("Do not have permissions to resource, " + resourceType + ", with id, " + resourceId, RestStatus.FORBIDDEN, new Object[0])));
            return false;
        }
        return true;
    }

    private static void listenFilterBySettingChange$lambda$0(SecureTransportAction this$0, Boolean it) {
        Intrinsics.checkNotNull((Object)it);
        this$0.setFilterByEnabled(it);
    }

    @Metadata(mv={2, 2, 0}, k=3, xi=48)
    public static final class DefaultImpls {
        @Deprecated
        public static void listenFilterBySettingChange(@NotNull SecureTransportAction $this, @NotNull ClusterService clusterService) {
            Intrinsics.checkNotNullParameter((Object)clusterService, (String)"clusterService");
            $this.listenFilterBySettingChange(clusterService);
        }

        @Deprecated
        @Nullable
        public static User readUserFromThreadContext(@NotNull SecureTransportAction $this, @NotNull Client client) {
            Intrinsics.checkNotNullParameter((Object)client, (String)"client");
            return $this.readUserFromThreadContext(client);
        }

        @Deprecated
        public static boolean doFilterForUser(@NotNull SecureTransportAction $this, @Nullable User user) {
            return $this.doFilterForUser(user);
        }

        @Deprecated
        public static boolean isAdmin(@NotNull SecureTransportAction $this, @Nullable User user) {
            return $this.isAdmin(user);
        }

        @Deprecated
        public static <T> boolean validateUserBackendRoles(@NotNull SecureTransportAction $this, @Nullable User user, @NotNull ActionListener<T> actionListener) {
            Intrinsics.checkNotNullParameter(actionListener, (String)"actionListener");
            return $this.validateUserBackendRoles(user, actionListener);
        }

        @Deprecated
        public static <T> boolean checkUserPermissionsWithResource(@NotNull SecureTransportAction $this, @Nullable User requesterUser, @Nullable User resourceUser, @NotNull ActionListener<T> actionListener, @NotNull String resourceType, @NotNull String resourceId) {
            Intrinsics.checkNotNullParameter(actionListener, (String)"actionListener");
            Intrinsics.checkNotNullParameter((Object)resourceType, (String)"resourceType");
            Intrinsics.checkNotNullParameter((Object)resourceId, (String)"resourceId");
            return $this.checkUserPermissionsWithResource(requesterUser, resourceUser, actionListener, resourceType, resourceId);
        }
    }
}

