/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.searchrelevance.stats.info;

import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import lombok.Generated;
import org.opensearch.Version;
import org.opensearch.searchrelevance.settings.SearchRelevanceSettingsAccessor;
import org.opensearch.searchrelevance.stats.common.StatSnapshot;
import org.opensearch.searchrelevance.stats.info.CountableInfoStatSnapshot;
import org.opensearch.searchrelevance.stats.info.InfoStatName;
import org.opensearch.searchrelevance.stats.info.InfoStatType;
import org.opensearch.searchrelevance.stats.info.SettableInfoStatSnapshot;

public class InfoStatsManager {
    private SearchRelevanceSettingsAccessor settingsAccessor;

    public Map<InfoStatName, StatSnapshot<?>> getStats(EnumSet<InfoStatName> statsToRetrieve) {
        Map<InfoStatName, CountableInfoStatSnapshot> countableInfoStats = this.getCountableStats();
        Map<InfoStatName, SettableInfoStatSnapshot<?>> settableInfoStats = this.getSettableStats();
        HashMap<InfoStatName, StatSnapshot<Long>> prefilteredStats = new HashMap<InfoStatName, StatSnapshot<Long>>();
        prefilteredStats.putAll(countableInfoStats);
        prefilteredStats.putAll(settableInfoStats);
        Map<InfoStatName, StatSnapshot<?>> filteredStats = prefilteredStats.entrySet().stream().filter(entry -> statsToRetrieve.contains(entry.getKey())).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
        return filteredStats;
    }

    private Map<InfoStatName, CountableInfoStatSnapshot> getCountableStats() {
        HashMap<InfoStatName, CountableInfoStatSnapshot> countableInfoStats = new HashMap<InfoStatName, CountableInfoStatSnapshot>();
        for (InfoStatName stat : EnumSet.allOf(InfoStatName.class)) {
            if (stat.getStatType() != InfoStatType.INFO_COUNTER) continue;
            countableInfoStats.put(stat, new CountableInfoStatSnapshot(stat));
        }
        return countableInfoStats;
    }

    private Map<InfoStatName, SettableInfoStatSnapshot<?>> getSettableStats() {
        HashMap settableInfoStats = new HashMap();
        for (InfoStatName statName : EnumSet.allOf(InfoStatName.class)) {
            switch (statName.getStatType()) {
                case INFO_BOOLEAN: {
                    settableInfoStats.put(statName, new SettableInfoStatSnapshot(statName));
                    break;
                }
                case INFO_STRING: {
                    settableInfoStats.put(statName, new SettableInfoStatSnapshot(statName));
                }
            }
        }
        this.addClusterVersionStat(settableInfoStats);
        return settableInfoStats;
    }

    private void addClusterVersionStat(Map<InfoStatName, SettableInfoStatSnapshot<?>> stats) {
        InfoStatName infoStatName = InfoStatName.CLUSTER_VERSION;
        stats.put(infoStatName, new SettableInfoStatSnapshot<Version>(infoStatName, Version.CURRENT));
    }

    private <T> T getValue(Map<String, Object> map, String key, Class<T> clazz) {
        if (map == null || key == null) {
            return null;
        }
        Object value = map.get(key);
        return clazz.isInstance(value) ? (T)clazz.cast(value) : null;
    }

    private Map<String, Object> asMap(Object value) {
        return value instanceof Map ? (Map)value : null;
    }

    private List<Map<String, Object>> asListOfMaps(Object value) {
        if (value instanceof List) {
            List list = (List)value;
            for (Object item : list) {
                if (item instanceof Map) continue;
                return null;
            }
            return (List)value;
        }
        return null;
    }

    @Generated
    public InfoStatsManager(SearchRelevanceSettingsAccessor settingsAccessor) {
        this.settingsAccessor = settingsAccessor;
    }
}

