/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.rest.action.admin.indices;

import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.opensearch.OpenSearchParseException;
import org.opensearch.OpenSearchTimeoutException;
import org.opensearch.action.ActionRunnable;
import org.opensearch.action.admin.indices.mapping.get.GetMappingsRequest;
import org.opensearch.action.admin.indices.mapping.get.GetMappingsResponse;
import org.opensearch.action.support.IndicesOptions;
import org.opensearch.common.logging.DeprecationLogger;
import org.opensearch.common.unit.TimeValue;
import org.opensearch.core.action.ActionListener;
import org.opensearch.core.common.Strings;
import org.opensearch.core.rest.RestStatus;
import org.opensearch.core.xcontent.XContentBuilder;
import org.opensearch.rest.BaseRestHandler;
import org.opensearch.rest.BytesRestResponse;
import org.opensearch.rest.RestHandler;
import org.opensearch.rest.RestRequest;
import org.opensearch.rest.RestResponse;
import org.opensearch.rest.action.RestActionListener;
import org.opensearch.rest.action.RestBuilderListener;
import org.opensearch.threadpool.ThreadPool;
import org.opensearch.transport.client.node.NodeClient;

public class RestGetMappingAction
extends BaseRestHandler {
    private static final DeprecationLogger deprecationLogger = DeprecationLogger.getLogger(RestGetMappingAction.class);
    private static final String MASTER_TIMEOUT_DEPRECATED_MESSAGE = "Parameter [master_timeout] is deprecated and will be removed in 3.0. To support inclusive language, please use [cluster_manager_timeout] instead.";
    private static final String DUPLICATE_PARAMETER_ERROR_MESSAGE = "Please only use one of the request parameters [master_timeout, cluster_manager_timeout].";
    private final ThreadPool threadPool;

    public RestGetMappingAction(ThreadPool threadPool) {
        this.threadPool = threadPool;
    }

    @Override
    public List<RestHandler.Route> routes() {
        return Collections.unmodifiableList(Arrays.asList(new RestHandler.Route(RestRequest.Method.GET, "/_mapping"), new RestHandler.Route(RestRequest.Method.GET, "/_mappings"), new RestHandler.Route(RestRequest.Method.GET, "/{index}/_mapping"), new RestHandler.Route(RestRequest.Method.GET, "/{index}/_mappings")));
    }

    @Override
    public String getName() {
        return "get_mapping_action";
    }

    @Override
    public BaseRestHandler.RestChannelConsumer prepareRequest(final RestRequest request, NodeClient client) throws IOException {
        String[] indices = Strings.splitStringByCommaToArray((String)request.param("index"));
        GetMappingsRequest getMappingsRequest = new GetMappingsRequest();
        getMappingsRequest.indices(indices);
        getMappingsRequest.indicesOptions(IndicesOptions.fromRequest(request, getMappingsRequest.indicesOptions()));
        TimeValue clusterManagerTimeout = request.paramAsTime("cluster_manager_timeout", getMappingsRequest.clusterManagerNodeTimeout());
        if (request.hasParam("master_timeout")) {
            deprecationLogger.deprecate("get_mapping_master_timeout_parameter", MASTER_TIMEOUT_DEPRECATED_MESSAGE, new Object[0]);
            if (request.hasParam("cluster_manager_timeout")) {
                throw new OpenSearchParseException(DUPLICATE_PARAMETER_ERROR_MESSAGE, new Object[0]);
            }
            clusterManagerTimeout = request.paramAsTime("master_timeout", getMappingsRequest.clusterManagerNodeTimeout());
        }
        final TimeValue timeout = clusterManagerTimeout;
        getMappingsRequest.clusterManagerNodeTimeout(timeout);
        getMappingsRequest.local(request.paramAsBoolean("local", getMappingsRequest.local()));
        return channel -> client.admin().indices().getMappings(getMappingsRequest, (ActionListener<GetMappingsResponse>)new RestActionListener<GetMappingsResponse>(this, channel){
            final /* synthetic */ RestGetMappingAction this$0;
            {
                this.this$0 = this$0;
                super(channel);
            }

            @Override
            protected void processResponse(GetMappingsResponse getMappingsResponse) {
                final long startTimeMs = this.this$0.threadPool.relativeTimeInMillis();
                this.this$0.threadPool.executor("management").execute(ActionRunnable.wrap(this, l -> new RestBuilderListener<GetMappingsResponse>(this, this.channel){
                    final /* synthetic */ 1 this$1;
                    {
                        this.this$1 = this$1;
                        super(channel);
                    }

                    @Override
                    public RestResponse buildResponse(GetMappingsResponse response, XContentBuilder builder) throws Exception {
                        if (this.this$1.this$0.threadPool.relativeTimeInMillis() - startTimeMs > timeout.millis()) {
                            throw new OpenSearchTimeoutException("Timed out getting mappings", new Object[0]);
                        }
                        builder.startObject();
                        response.toXContent(builder, request);
                        builder.endObject();
                        return new BytesRestResponse(RestStatus.OK, builder);
                    }
                }.onResponse(getMappingsResponse)));
            }
        });
    }
}

