/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.index.codec.customcodecs;

import java.util.Set;
import java.util.function.Supplier;
import org.apache.lucene.codecs.Codec;
import org.apache.lucene.codecs.FilterCodec;
import org.apache.lucene.codecs.StoredFieldsFormat;
import org.apache.lucene.codecs.lucene103.Lucene103Codec;
import org.opensearch.index.codec.customcodecs.Lucene103CustomStoredFieldsFormat;
import org.opensearch.index.codec.customcodecs.backward_codecs.lucene99.Lucene99CustomCodec;

public abstract class Lucene103CustomCodec
extends FilterCodec {
    private final StoredFieldsFormat storedFieldsFormat;

    public Lucene103CustomCodec(Mode mode) {
        this(mode, Lucene99CustomCodec.DEFAULT_COMPRESSION_LEVEL);
    }

    public Lucene103CustomCodec(Mode mode, int compressionLevel) {
        super(mode.getCodec(), (Codec)new Lucene103Codec());
        this.storedFieldsFormat = new Lucene103CustomStoredFieldsFormat(mode, compressionLevel);
    }

    public Lucene103CustomCodec(Mode mode, int compressionLevel, Supplier<Codec> defaultCodecSupplier) {
        super(mode.getCodec(), defaultCodecSupplier.get());
        this.storedFieldsFormat = new Lucene103CustomStoredFieldsFormat(mode, compressionLevel);
    }

    public StoredFieldsFormat storedFieldsFormat() {
        return this.storedFieldsFormat;
    }

    public String toString() {
        return ((Object)((Object)this)).getClass().getSimpleName();
    }

    public static enum Mode {
        ZSTD("ZSTD103", Set.of("zstd")),
        ZSTD_NO_DICT("ZSTDNODICT103", Set.of("zstd_no_dict"));

        private final String codec;
        private final Set<String> aliases;

        private Mode(String codec, Set<String> aliases) {
            this.codec = codec;
            this.aliases = aliases;
        }

        public String getCodec() {
            return this.codec;
        }

        public Set<String> getAliases() {
            return this.aliases;
        }
    }
}

