/*
 * Decompiled with CFR 0.152.
 */
package dafny;

import dafny.Helpers;
import dafny.TypeDescriptor;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class DafnyMultiset<T> {
    private Map<T, BigInteger> innerMap;
    private static final DafnyMultiset<Object> EMPTY = DafnyMultiset.of(new Object[0]);

    public DafnyMultiset() {
        this.innerMap = new HashMap<T, BigInteger>();
    }

    public DafnyMultiset(Map<T, BigInteger> m) {
        assert (m != null) : "Precondition Violation";
        this.innerMap = new HashMap<T, BigInteger>();
        for (Map.Entry<T, BigInteger> e : m.entrySet()) {
            BigInteger n = e.getValue();
            int cmp = n.compareTo(BigInteger.ZERO);
            assert (0 <= cmp) : "Precondition Violation";
            if (0 >= cmp) continue;
            this.innerMap.put(e.getKey(), n);
        }
    }

    public DafnyMultiset(Set<T> s) {
        assert (s != null) : "Precondition Violation";
        this.innerMap = new HashMap<T, BigInteger>();
        for (T t : s) {
            this.incrementMultiplicity(t, BigInteger.ONE);
        }
    }

    public DafnyMultiset(Collection<T> c) {
        assert (c != null) : "Precondition Violation";
        this.innerMap = new HashMap<T, BigInteger>();
        for (T t : c) {
            this.incrementMultiplicity(t, BigInteger.ONE);
        }
    }

    public DafnyMultiset(List<T> l) {
        assert (l != null) : "Precondition Violation";
        this.innerMap = new HashMap<T, BigInteger>();
        for (T t : l) {
            this.incrementMultiplicity(t, BigInteger.ONE);
        }
    }

    @SafeVarargs
    public static <T> DafnyMultiset<T> of(T ... args) {
        return new DafnyMultiset<T>(Arrays.asList(args));
    }

    public static <T> DafnyMultiset<T> empty() {
        return EMPTY;
    }

    public static <T> TypeDescriptor<DafnyMultiset<? extends T>> _typeDescriptor(TypeDescriptor<T> elementType) {
        return TypeDescriptor.referenceWithDefault(DafnyMultiset.class, DafnyMultiset.empty());
    }

    public BigInteger cardinality() {
        BigInteger sum = BigInteger.ZERO;
        for (BigInteger m : this.innerMap.values()) {
            sum = sum.add(m);
        }
        return sum;
    }

    public int cardinalityInt() {
        int sum = 0;
        for (BigInteger m : this.innerMap.values()) {
            sum += m.intValue();
        }
        return sum;
    }

    public boolean isSubsetOf(DafnyMultiset other) {
        assert (other != null) : "Precondition Violation";
        for (Map.Entry<T, BigInteger> entry : this.innerMap.entrySet()) {
            if (DafnyMultiset.multiplicity(other, entry.getKey()).compareTo(entry.getValue()) >= 0) continue;
            return false;
        }
        return true;
    }

    public boolean isProperSubsetOf(DafnyMultiset other) {
        assert (other != null) : "Precondition Violation";
        return this.isSubsetOf(other) && this.cardinality().compareTo(other.cardinality()) < 0;
    }

    public boolean contains(Object t) {
        return this.innerMap.containsKey(t);
    }

    public <U> boolean disjoint(DafnyMultiset<? extends U> other) {
        assert (other != null) : "Precondition Violation";
        for (T u : other.innerMap.keySet()) {
            if (!this.innerMap.containsKey(u)) continue;
            return false;
        }
        return true;
    }

    public static <T> BigInteger multiplicity(DafnyMultiset<? extends T> th, T t) {
        BigInteger m = th.innerMap.get(t);
        return m == null ? BigInteger.ZERO : m;
    }

    public static <T> DafnyMultiset<T> update(DafnyMultiset<? extends T> th, T t, BigInteger b) {
        assert (th != null) : "Precondition Violation";
        assert (b != null && b.compareTo(BigInteger.ZERO) >= 0) : "Precondition Violation";
        DafnyMultiset<T> copy = new DafnyMultiset<T>(th.innerMap);
        super.setMultiplicity(t, b);
        return copy;
    }

    private void setMultiplicity(T t, BigInteger b) {
        assert (b != null) : "Precondition Violation";
        if (b.compareTo(BigInteger.ZERO) > 0) {
            this.innerMap.put(t, b);
        } else {
            this.innerMap.remove(t);
        }
    }

    private void incrementMultiplicity(T t, BigInteger b) {
        assert (b != null) : "Precondition Violation";
        this.setMultiplicity(t, DafnyMultiset.multiplicity(this, t).add(b));
    }

    public static <T> DafnyMultiset<T> union(DafnyMultiset<? extends T> th, DafnyMultiset<? extends T> other) {
        assert (th != null) : "Precondition Violation";
        assert (other != null) : "Precondition Violation";
        DafnyMultiset<T> u = new DafnyMultiset<T>(th.innerMap);
        for (Map.Entry<T, BigInteger> entry : other.innerMap.entrySet()) {
            super.incrementMultiplicity(entry.getKey(), entry.getValue());
        }
        return u;
    }

    public static <T> DafnyMultiset<T> difference(DafnyMultiset<? extends T> th, DafnyMultiset<? extends T> other) {
        assert (th != null) : "Precondition Violation";
        assert (other != null) : "Precondition Violation";
        DafnyMultiset<T> u = new DafnyMultiset<T>(th.innerMap);
        for (Map.Entry<T, BigInteger> entry : other.innerMap.entrySet()) {
            T key = entry.getKey();
            BigInteger m0 = DafnyMultiset.multiplicity(u, key);
            BigInteger m1 = entry.getValue();
            super.setMultiplicity(key, m0.subtract(m1));
        }
        return u;
    }

    public static <T> DafnyMultiset<T> intersection(DafnyMultiset<? extends T> th, DafnyMultiset<? extends T> other) {
        assert (th != null) : "Precondition Violation";
        assert (other != null) : "Precondition Violation";
        DafnyMultiset<T> u = new DafnyMultiset<T>();
        for (Map.Entry<T, BigInteger> entry : th.innerMap.entrySet()) {
            T key = entry.getKey();
            BigInteger m0 = entry.getValue();
            BigInteger m1 = DafnyMultiset.multiplicity(other, key);
            super.setMultiplicity(key, m0.min(m1));
        }
        return u;
    }

    public Iterable<T> Elements() {
        ArrayList<T> r = new ArrayList<T>();
        for (Map.Entry<T, BigInteger> e : this.innerMap.entrySet()) {
            for (int i = 0; i < e.getValue().intValue(); ++i) {
                r.add(e.getKey());
            }
        }
        return r;
    }

    public Iterable<T> UniqueElements() {
        return this.innerMap.keySet();
    }

    protected Object clone() throws CloneNotSupportedException {
        return super.clone();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        DafnyMultiset o = (DafnyMultiset)obj;
        return this.innerMap.equals(o.innerMap);
    }

    public int hashCode() {
        return this.innerMap.hashCode();
    }

    public String toString() {
        String s = "multiset{";
        String sep = "";
        for (Map.Entry<T, BigInteger> entry : this.innerMap.entrySet()) {
            String t = Helpers.toString(entry.getKey());
            BigInteger n = entry.getValue();
            BigInteger i = BigInteger.ZERO;
            while (i.compareTo(n) < 0) {
                s = s + sep + t;
                sep = ", ";
                i = i.add(BigInteger.ONE);
            }
        }
        return s + "}";
    }
}

