/* [config]
 * expect_result: pass
 * glsl_version: 1.30
 * [end config]
 *
 * Check that the following test vectors are constant folded correctly:
 * (uvec2(38u, 35u) / 6u) => uvec2(6u, 5u)
 * (uvec2(38u, 35u) / 12u) => uvec2(3u, 2u)
 * (uvec2(38u, 35u) / 32u) => uvec2(1u, 1u)
 * (uvec2(38u, 35u) / 74u) => uvec2(0u, 0u)
 * (uvec2(64u, 9u) / 6u) => uvec2(10u, 1u)
 * (uvec2(64u, 9u) / 12u) => uvec2(5u, 0u)
 * (uvec2(64u, 9u) / 32u) => uvec2(2u, 0u)
 * (uvec2(64u, 9u) / 74u) => uvec2(0u, 0u)
 */
#version 130

void main()
{
  float[all(equal((uvec2(38u, 35u) / 6u), uvec2(6u, 5u))) ? 1 : -1] array0;
  float[all(equal((uvec2(38u, 35u) / 12u), uvec2(3u, 2u))) ? 1 : -1] array1;
  float[all(equal((uvec2(38u, 35u) / 32u), uvec2(1u, 1u))) ? 1 : -1] array2;
  float[all(equal((uvec2(38u, 35u) / 74u), uvec2(0u, 0u))) ? 1 : -1] array3;
  float[all(equal((uvec2(64u, 9u) / 6u), uvec2(10u, 1u))) ? 1 : -1] array4;
  float[all(equal((uvec2(64u, 9u) / 12u), uvec2(5u, 0u))) ? 1 : -1] array5;
  float[all(equal((uvec2(64u, 9u) / 32u), uvec2(2u, 0u))) ? 1 : -1] array6;
  float[all(equal((uvec2(64u, 9u) / 74u), uvec2(0u, 0u))) ? 1 : -1] array7;
  gl_Position = vec4(array0.length() + array1.length() + array2.length() + array3.length() + array4.length() + array5.length() + array6.length() + array7.length());
}
