/* [config]
 * expect_result: pass
 * glsl_version: 4.00
 * [end config]
 *
 * Check that the following test vectors are constant folded correctly:
 * trunc(dvec4(-2.0lf, -1.4285714285714286lf, -0.8571428571428572lf, -0.2857142857142858lf)) => dvec4(-2.0lf, -1.0lf, -0.0lf, -0.0lf)
 * trunc(dvec4(0.2857142857142856lf, 0.8571428571428568lf, 1.4285714285714284lf, 2.0lf)) => dvec4(0.0lf, 0.0lf, 1.0lf, 2.0lf)
 * trunc(dvec4(0.0lf, 45027112.98414lf, -45027112.98414lf, 19584198736.47329lf)) => dvec4(0.0lf, 45027112.0lf, -45027112.0lf, 19584198736.0lf)
 * trunc(dvec4(-19584198736.47329lf, 7.51654162319e+17lf, -7.51654162319e+17lf, 4.502711234095857e+19lf)) => dvec4(-19584198736.0lf, 7.51654162319e+17lf, -7.51654162319e+17lf, 4.502711234095857e+19lf)
 * trunc(dvec4(-4.502711234095857e+19lf, 8.654196813385455e+39lf, -8.654196813385455e+39lf, 6.54965168513655e+83lf)) => dvec4(-4.502711234095857e+19lf, 8.654196813385455e+39lf, -8.654196813385455e+39lf, 6.54965168513655e+83lf)
 * trunc(dvec4(-6.54965168513655e+83lf, -2.0lf, -1.4285714285714286lf, -0.8571428571428572lf)) => dvec4(-6.54965168513655e+83lf, -2.0lf, -1.0lf, -0.0lf)
 */
#version 400

void main()
{
  double[distance(trunc(dvec4(-2.0lf, -1.4285714285714286lf, -0.8571428571428572lf, -0.2857142857142858lf)), dvec4(-2.0lf, -1.0lf, -0.0lf, -0.0lf)) <= 2.2360679774997898e-05lf ? 1 : -1] array0;
  double[distance(trunc(dvec4(0.2857142857142856lf, 0.8571428571428568lf, 1.4285714285714284lf, 2.0lf)), dvec4(0.0lf, 0.0lf, 1.0lf, 2.0lf)) <= 2.2360679774997898e-05lf ? 1 : -1] array1;
  double[distance(trunc(dvec4(0.0lf, 45027112.98414lf, -45027112.98414lf, 19584198736.47329lf)), dvec4(0.0lf, 45027112.0lf, -45027112.0lf, 19584198736.0lf)) <= 195843.02260044246lf ? 1 : -1] array2;
  double[distance(trunc(dvec4(-19584198736.47329lf, 7.51654162319e+17lf, -7.51654162319e+17lf, 4.502711234095857e+19lf)), dvec4(-19584198736.0lf, 7.51654162319e+17lf, -7.51654162319e+17lf, 4.502711234095857e+19lf)) <= 450396582327704.5lf ? 1 : -1] array3;
  double[distance(trunc(dvec4(-4.502711234095857e+19lf, 8.654196813385455e+39lf, -8.654196813385455e+39lf, 6.54965168513655e+83lf)), dvec4(-4.502711234095857e+19lf, 8.654196813385455e+39lf, -8.654196813385455e+39lf, 6.54965168513655e+83lf)) <= 6.54965168513655e+78lf ? 1 : -1] array4;
  double[distance(trunc(dvec4(-6.54965168513655e+83lf, -2.0lf, -1.4285714285714286lf, -0.8571428571428572lf)), dvec4(-6.54965168513655e+83lf, -2.0lf, -1.0lf, -0.0lf)) <= 6.54965168513655e+78lf ? 1 : -1] array5;
  gl_Position = vec4(array0.length() + array1.length() + array2.length() + array3.length() + array4.length() + array5.length());
}
