/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.performancePlugin.ui;

import com.intellij.ide.BrowserUtil;
import com.intellij.ide.actions.RevealFileAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.util.PlatformUtils;
import com.jetbrains.performancePlugin.PerformanceTestingBundle;
import com.jetbrains.performancePlugin.profilers.Profiler;
import com.jetbrains.performancePlugin.profilers.ProfilersController;
import com.jetbrains.performancePlugin.utils.StatisticCollector;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.io.File;
import java.util.ArrayList;
import java.util.Locale;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.plaf.FontUIResource;
import javax.swing.text.StyleContext;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FinishScriptDialog
extends DialogWrapper {
    private JPanel myMainPanel;
    private JTextField snapshotLabel;
    private JTextArea metricsPanel;
    private File snapshot = null;

    public FinishScriptDialog(@Nullable Project project) {
        super(project);
        this.$$$setupUI$$$();
        if (ProfilersController.getInstance().isStoppedByScript()) {
            String path = ProfilersController.getInstance().getReportsPath();
            try {
                this.snapshot = ProfilersController.getInstance().getCurrentProfilerHandler().compressResults(path, Profiler.formatSnapshotName(false));
                ProfilersController.getInstance().setReportsPath(this.snapshot.getParentFile().getAbsolutePath());
                this.snapshotLabel.setText(PerformanceTestingBundle.message("finish.path", this.snapshot.getAbsolutePath()));
                this.setTitle(PerformanceTestingBundle.message("finish.title", new Object[0]));
                this.snapshotLabel.setEditable(false);
                this.snapshotLabel.setBorder(BorderFactory.createEmptyBorder(10, 0, 0, 0));
            }
            catch (Exception ex) {
                throw new RuntimeException(ex.getMessage());
            }
        }
        String metrics = new StatisticCollector(project).collectMetrics(true);
        this.metricsPanel.setText(metrics);
        this.metricsPanel.setLineWrap(true);
        this.init();
        this.pack();
    }

    protected Action @NotNull [] createActions() {
        ArrayList<Object> dialogActions = new ArrayList<Object>(3);
        dialogActions.add(new DialogWrapper.DialogWrapperAction(PerformanceTestingBundle.message("summary.action", new Object[0])){

            protected void doAction(ActionEvent e) {
                if (!PlatformUtils.isRider()) {
                    BrowserUtil.browse((String)PerformanceTestingBundle.message("summary.link", new Object[0]));
                } else {
                    BrowserUtil.browse((String)PerformanceTestingBundle.message("summary.link.rider", new Object[0]));
                }
            }
        });
        if (this.snapshot != null) {
            dialogActions.add(new DialogWrapper.DialogWrapperAction(PerformanceTestingBundle.message("finish.open", RevealFileAction.getFileManagerName())){

                protected void doAction(ActionEvent e) {
                    RevealFileAction.openDirectory((File)FinishScriptDialog.this.snapshot.getParentFile());
                }
            });
        }
        dialogActions.add(this.getOKAction());
        Action[] actionArray = dialogActions.toArray(new Action[0]);
        if (actionArray == null) {
            FinishScriptDialog.$$$reportNull$$$0(0);
        }
        return actionArray;
    }

    @Nullable
    protected JComponent createCenterPanel() {
        return this.myMainPanel;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/performancePlugin/ui/FinishScriptDialog", "createActions"));
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JTextArea jTextArea;
        JTextField jTextField;
        JPanel jPanel;
        this.myMainPanel = jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout(0, 0));
        this.snapshotLabel = jTextField = new JTextField();
        Font font = this.$$$getFont$$$(null, 1, -1, jTextField.getFont());
        if (font != null) {
            jTextField.setFont(font);
        }
        jTextField.setText("");
        jPanel.add((Component)jTextField, "South");
        JBScrollPane jBScrollPane = new JBScrollPane();
        jPanel.add((Component)jBScrollPane, "Center");
        this.metricsPanel = jTextArea = new JTextArea();
        jBScrollPane.setViewportView(jTextArea);
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myMainPanel;
    }

    private /* synthetic */ Font $$$getFont$$$(String string, int n, int n2, Font font) {
        Font font2;
        if (font == null) {
            return null;
        }
        String string2 = string == null ? font.getName() : ((font2 = new Font(string, 0, 10)).canDisplay('a') && font2.canDisplay('1') ? string : font.getName());
        Font font3 = new Font(string2, n >= 0 ? n : font.getStyle(), n2 >= 0 ? n2 : font.getSize());
        boolean bl = System.getProperty("os.name", "").toLowerCase(Locale.ENGLISH).startsWith("mac");
        Font font4 = bl ? new Font(font3.getFamily(), font3.getStyle(), font3.getSize()) : new StyleContext().getFont(font3.getFamily(), font3.getStyle(), font3.getSize());
        return font4 instanceof FontUIResource ? font4 : new FontUIResource(font4);
    }
}

