/*----------------------------------------------------------------------------*/
/* This file is generated by the templates/template.rb script and should not  */
/* be modified manually.                                                      */
/* To change the template see                                                 */
/* templates/src/ast.c.erb                                                    */
/*----------------------------------------------------------------------------*/

#line 2 "prism/templates/src/ast.c.erb"
#include "rbs/ast.h"

#include <stdio.h>
#include <stdlib.h>

const char *rbs_node_type_name(rbs_node_t *node) {
    switch (node->type) {
    case RBS_AST_ANNOTATION:
        return "RBS::AST::Annotation";
    case RBS_AST_BOOL:
        return "RBS::AST::Bool";
    case RBS_AST_COMMENT:
        return "RBS::AST::Comment";
    case RBS_AST_DECLARATIONS_CLASS:
        return "RBS::AST::Declarations::Class";
    case RBS_AST_DECLARATIONS_CLASS_SUPER:
        return "RBS::AST::Declarations::Class::Super";
    case RBS_AST_DECLARATIONS_CLASS_ALIAS:
        return "RBS::AST::Declarations::ClassAlias";
    case RBS_AST_DECLARATIONS_CONSTANT:
        return "RBS::AST::Declarations::Constant";
    case RBS_AST_DECLARATIONS_GLOBAL:
        return "RBS::AST::Declarations::Global";
    case RBS_AST_DECLARATIONS_INTERFACE:
        return "RBS::AST::Declarations::Interface";
    case RBS_AST_DECLARATIONS_MODULE:
        return "RBS::AST::Declarations::Module";
    case RBS_AST_DECLARATIONS_MODULE_SELF:
        return "RBS::AST::Declarations::Module::Self";
    case RBS_AST_DECLARATIONS_MODULE_ALIAS:
        return "RBS::AST::Declarations::ModuleAlias";
    case RBS_AST_DECLARATIONS_TYPE_ALIAS:
        return "RBS::AST::Declarations::TypeAlias";
    case RBS_AST_DIRECTIVES_USE:
        return "RBS::AST::Directives::Use";
    case RBS_AST_DIRECTIVES_USE_SINGLE_CLAUSE:
        return "RBS::AST::Directives::Use::SingleClause";
    case RBS_AST_DIRECTIVES_USE_WILDCARD_CLAUSE:
        return "RBS::AST::Directives::Use::WildcardClause";
    case RBS_AST_INTEGER:
        return "RBS::AST::Integer";
    case RBS_AST_MEMBERS_ALIAS:
        return "RBS::AST::Members::Alias";
    case RBS_AST_MEMBERS_ATTR_ACCESSOR:
        return "RBS::AST::Members::AttrAccessor";
    case RBS_AST_MEMBERS_ATTR_READER:
        return "RBS::AST::Members::AttrReader";
    case RBS_AST_MEMBERS_ATTR_WRITER:
        return "RBS::AST::Members::AttrWriter";
    case RBS_AST_MEMBERS_CLASS_INSTANCE_VARIABLE:
        return "RBS::AST::Members::ClassInstanceVariable";
    case RBS_AST_MEMBERS_CLASS_VARIABLE:
        return "RBS::AST::Members::ClassVariable";
    case RBS_AST_MEMBERS_EXTEND:
        return "RBS::AST::Members::Extend";
    case RBS_AST_MEMBERS_INCLUDE:
        return "RBS::AST::Members::Include";
    case RBS_AST_MEMBERS_INSTANCE_VARIABLE:
        return "RBS::AST::Members::InstanceVariable";
    case RBS_AST_MEMBERS_METHOD_DEFINITION:
        return "RBS::AST::Members::MethodDefinition";
    case RBS_AST_MEMBERS_METHOD_DEFINITION_OVERLOAD:
        return "RBS::AST::Members::MethodDefinition::Overload";
    case RBS_AST_MEMBERS_PREPEND:
        return "RBS::AST::Members::Prepend";
    case RBS_AST_MEMBERS_PRIVATE:
        return "RBS::AST::Members::Private";
    case RBS_AST_MEMBERS_PUBLIC:
        return "RBS::AST::Members::Public";
    case RBS_AST_STRING:
        return "RBS::AST::String";
    case RBS_AST_TYPE_PARAM:
        return "RBS::AST::TypeParam";
    case RBS_METHOD_TYPE:
        return "RBS::MethodType";
    case RBS_NAMESPACE:
        return "RBS::Namespace";
    case RBS_SIGNATURE:
        return "RBS::Signature";
    case RBS_TYPE_NAME:
        return "RBS::TypeName";
    case RBS_TYPES_ALIAS:
        return "RBS::Types::Alias";
    case RBS_TYPES_BASES_ANY:
        return "RBS::Types::Bases::Any";
    case RBS_TYPES_BASES_BOOL:
        return "RBS::Types::Bases::Bool";
    case RBS_TYPES_BASES_BOTTOM:
        return "RBS::Types::Bases::Bottom";
    case RBS_TYPES_BASES_CLASS:
        return "RBS::Types::Bases::Class";
    case RBS_TYPES_BASES_INSTANCE:
        return "RBS::Types::Bases::Instance";
    case RBS_TYPES_BASES_NIL:
        return "RBS::Types::Bases::Nil";
    case RBS_TYPES_BASES_SELF:
        return "RBS::Types::Bases::Self";
    case RBS_TYPES_BASES_TOP:
        return "RBS::Types::Bases::Top";
    case RBS_TYPES_BASES_VOID:
        return "RBS::Types::Bases::Void";
    case RBS_TYPES_BLOCK:
        return "RBS::Types::Block";
    case RBS_TYPES_CLASS_INSTANCE:
        return "RBS::Types::ClassInstance";
    case RBS_TYPES_CLASS_SINGLETON:
        return "RBS::Types::ClassSingleton";
    case RBS_TYPES_FUNCTION:
        return "RBS::Types::Function";
    case RBS_TYPES_FUNCTION_PARAM:
        return "RBS::Types::Function::Param";
    case RBS_TYPES_INTERFACE:
        return "RBS::Types::Interface";
    case RBS_TYPES_INTERSECTION:
        return "RBS::Types::Intersection";
    case RBS_TYPES_LITERAL:
        return "RBS::Types::Literal";
    case RBS_TYPES_OPTIONAL:
        return "RBS::Types::Optional";
    case RBS_TYPES_PROC:
        return "RBS::Types::Proc";
    case RBS_TYPES_RECORD:
        return "RBS::Types::Record";
    case RBS_TYPES_RECORD_FIELD_TYPE:
        return "RBS::Types::Record::FieldType";
    case RBS_TYPES_TUPLE:
        return "RBS::Types::Tuple";
    case RBS_TYPES_UNION:
        return "RBS::Types::Union";
    case RBS_TYPES_UNTYPED_FUNCTION:
        return "RBS::Types::UntypedFunction";
    case RBS_TYPES_VARIABLE:
        return "RBS::Types::Variable";
    case RBS_AST_SYMBOL:
        return "Symbol";
    default:
        return "Unknown";
    }
}

/* rbs_node_list */

rbs_node_list_t *rbs_node_list_new(rbs_allocator_t *allocator) {
    rbs_node_list_t *list = rbs_allocator_alloc(allocator, rbs_node_list_t);
    *list = (rbs_node_list_t) {
        .allocator = allocator,
        .head = NULL,
        .tail = NULL,
        .length = 0,
    };

    return list;
}

void rbs_node_list_append(rbs_node_list_t *list, rbs_node_t *node) {
    rbs_node_list_node_t *new_node = rbs_allocator_alloc(list->allocator, rbs_node_list_node_t);
    *new_node = (rbs_node_list_node_t) {
        .node = node,
        .next = NULL,
    };

    if (list->tail == NULL) {
        list->head = new_node;
        list->tail = new_node;
    } else {
        list->tail->next = new_node;
        list->tail = new_node;
    }

    list->length++;
}

/* rbs_hash */

rbs_hash_t *rbs_hash_new(rbs_allocator_t *allocator) {
    rbs_hash_t *hash = rbs_allocator_alloc(allocator, rbs_hash_t);
    *hash = (rbs_hash_t) {
        .allocator = allocator,
        .head = NULL,
        .tail = NULL,
        .length = 0,
    };

    return hash;
}

bool rbs_node_equal(rbs_node_t *lhs, rbs_node_t *rhs) {
    if (lhs == rhs) return true;
    if (lhs->type != rhs->type) return false;

    switch (lhs->type) {
    case RBS_AST_SYMBOL:
        return ((rbs_ast_symbol_t *) lhs)->constant_id == ((rbs_ast_symbol_t *) rhs)->constant_id;
    case RBS_KEYWORD:
        return ((rbs_keyword_t *) lhs)->constant_id == ((rbs_keyword_t *) rhs)->constant_id;
    case RBS_AST_BOOL:
        return ((rbs_ast_bool_t *) lhs)->value == ((rbs_ast_bool_t *) rhs)->value;
    case RBS_AST_INTEGER:
        return rbs_string_equal(((rbs_ast_integer_t *) lhs)->string_representation, ((rbs_ast_integer_t *) rhs)->string_representation);
    case RBS_AST_STRING:
        return rbs_string_equal(((rbs_ast_string_t *) lhs)->string, ((rbs_ast_string_t *) rhs)->string);
    default:
        printf("Unhandled node type: %d\n", lhs->type);
        return false;
    }
}

rbs_hash_node_t *rbs_hash_find(rbs_hash_t *hash, rbs_node_t *key) {
    rbs_hash_node_t *current = hash->head;

    while (current != NULL) {
        if (rbs_node_equal(key, current->key)) {
            return current;
        }
        current = current->next;
    }

    return NULL;
}

void rbs_hash_set(rbs_hash_t *hash, rbs_node_t *key, rbs_node_t *value) {
    rbs_hash_node_t *existing_node = rbs_hash_find(hash, key);
    if (existing_node != NULL) {
        existing_node->value = value;
        return;
    }

    rbs_hash_node_t *new_node = rbs_allocator_alloc(hash->allocator, rbs_hash_node_t);
    new_node->key = key;
    new_node->value = value;
    new_node->next = NULL;

    if (hash->tail == NULL) {
        hash->head = new_node;
        hash->tail = new_node;
    } else {
        hash->tail->next = new_node;
        hash->tail = new_node;
    }
}

rbs_node_t *rbs_hash_get(rbs_hash_t *hash, rbs_node_t *key) {
    rbs_hash_node_t *node = rbs_hash_find(hash, key);
    return node ? node->value : NULL;
}

rbs_keyword_t *rbs_keyword_new(rbs_allocator_t *allocator, rbs_location_t *location, rbs_constant_id_t constant_id) {
    rbs_keyword_t *instance = rbs_allocator_alloc(allocator, rbs_keyword_t);

    *instance = (rbs_keyword_t) {
        .base = (rbs_node_t) {
            .type = RBS_KEYWORD,
            .location = location,
        },
        .constant_id = constant_id,
    };

    return instance;
}

rbs_ast_symbol_t *rbs_ast_symbol_new(rbs_allocator_t *allocator, rbs_location_t *location, rbs_constant_pool_t *constant_pool, rbs_constant_id_t constant_id) {
    rbs_ast_symbol_t *instance = rbs_allocator_alloc(allocator, rbs_ast_symbol_t);

    *instance = (rbs_ast_symbol_t) {
        .base = (rbs_node_t) {
            .type = RBS_AST_SYMBOL,
            .location = location,
        },
        .constant_id = constant_id,
    };

    return instance;
}

#line 156 "prism/templates/src/ast.c.erb"
rbs_ast_annotation_t *rbs_ast_annotation_new(rbs_allocator_t *allocator, rbs_location_t *location, rbs_string_t string) {
    rbs_ast_annotation_t *instance = rbs_allocator_alloc(allocator, rbs_ast_annotation_t);

    *instance = (rbs_ast_annotation_t) {
        .base = (rbs_node_t) {
            .type = RBS_AST_ANNOTATION,
            .location = location,
        },
        .string = string,
    };

    return instance;
}
#line 156 "prism/templates/src/ast.c.erb"
rbs_ast_bool_t *rbs_ast_bool_new(rbs_allocator_t *allocator, rbs_location_t *location, bool value) {
    rbs_ast_bool_t *instance = rbs_allocator_alloc(allocator, rbs_ast_bool_t);

    *instance = (rbs_ast_bool_t) {
        .base = (rbs_node_t) {
            .type = RBS_AST_BOOL,
            .location = location,
        },
        .value = value,
    };

    return instance;
}
#line 156 "prism/templates/src/ast.c.erb"
rbs_ast_comment_t *rbs_ast_comment_new(rbs_allocator_t *allocator, rbs_location_t *location, rbs_string_t string) {
    rbs_ast_comment_t *instance = rbs_allocator_alloc(allocator, rbs_ast_comment_t);

    *instance = (rbs_ast_comment_t) {
        .base = (rbs_node_t) {
            .type = RBS_AST_COMMENT,
            .location = location,
        },
        .string = string,
    };

    return instance;
}
#line 156 "prism/templates/src/ast.c.erb"
rbs_ast_declarations_class_t *rbs_ast_declarations_class_new(rbs_allocator_t *allocator, rbs_location_t *location, rbs_type_name_t *name, rbs_node_list_t *type_params, rbs_ast_declarations_class_super_t *super_class, rbs_node_list_t *members, rbs_node_list_t *annotations, rbs_ast_comment_t *comment) {
    rbs_ast_declarations_class_t *instance = rbs_allocator_alloc(allocator, rbs_ast_declarations_class_t);

    *instance = (rbs_ast_declarations_class_t) {
        .base = (rbs_node_t) {
            .type = RBS_AST_DECLARATIONS_CLASS,
            .location = location,
        },
        .name = name,
        .type_params = type_params,
        .super_class = super_class,
        .members = members,
        .annotations = annotations,
        .comment = comment,
    };

    return instance;
}
#line 156 "prism/templates/src/ast.c.erb"
rbs_ast_declarations_class_super_t *rbs_ast_declarations_class_super_new(rbs_allocator_t *allocator, rbs_location_t *location, rbs_type_name_t *name, rbs_node_list_t *args) {
    rbs_ast_declarations_class_super_t *instance = rbs_allocator_alloc(allocator, rbs_ast_declarations_class_super_t);

    *instance = (rbs_ast_declarations_class_super_t) {
        .base = (rbs_node_t) {
            .type = RBS_AST_DECLARATIONS_CLASS_SUPER,
            .location = location,
        },
        .name = name,
        .args = args,
    };

    return instance;
}
#line 156 "prism/templates/src/ast.c.erb"
rbs_ast_declarations_class_alias_t *rbs_ast_declarations_class_alias_new(rbs_allocator_t *allocator, rbs_location_t *location, rbs_type_name_t *new_name, rbs_type_name_t *old_name, rbs_ast_comment_t *comment, rbs_node_list_t *annotations) {
    rbs_ast_declarations_class_alias_t *instance = rbs_allocator_alloc(allocator, rbs_ast_declarations_class_alias_t);

    *instance = (rbs_ast_declarations_class_alias_t) {
        .base = (rbs_node_t) {
            .type = RBS_AST_DECLARATIONS_CLASS_ALIAS,
            .location = location,
        },
        .new_name = new_name,
        .old_name = old_name,
        .comment = comment,
        .annotations = annotations,
    };

    return instance;
}
#line 156 "prism/templates/src/ast.c.erb"
rbs_ast_declarations_constant_t *rbs_ast_declarations_constant_new(rbs_allocator_t *allocator, rbs_location_t *location, rbs_type_name_t *name, rbs_node_t *type, rbs_ast_comment_t *comment, rbs_node_list_t *annotations) {
    rbs_ast_declarations_constant_t *instance = rbs_allocator_alloc(allocator, rbs_ast_declarations_constant_t);

    *instance = (rbs_ast_declarations_constant_t) {
        .base = (rbs_node_t) {
            .type = RBS_AST_DECLARATIONS_CONSTANT,
            .location = location,
        },
        .name = name,
        .type = type,
        .comment = comment,
        .annotations = annotations,
    };

    return instance;
}
#line 156 "prism/templates/src/ast.c.erb"
rbs_ast_declarations_global_t *rbs_ast_declarations_global_new(rbs_allocator_t *allocator, rbs_location_t *location, rbs_ast_symbol_t *name, rbs_node_t *type, rbs_ast_comment_t *comment, rbs_node_list_t *annotations) {
    rbs_ast_declarations_global_t *instance = rbs_allocator_alloc(allocator, rbs_ast_declarations_global_t);

    *instance = (rbs_ast_declarations_global_t) {
        .base = (rbs_node_t) {
            .type = RBS_AST_DECLARATIONS_GLOBAL,
            .location = location,
        },
        .name = name,
        .type = type,
        .comment = comment,
        .annotations = annotations,
    };

    return instance;
}
#line 156 "prism/templates/src/ast.c.erb"
rbs_ast_declarations_interface_t *rbs_ast_declarations_interface_new(rbs_allocator_t *allocator, rbs_location_t *location, rbs_type_name_t *name, rbs_node_list_t *type_params, rbs_node_list_t *members, rbs_node_list_t *annotations, rbs_ast_comment_t *comment) {
    rbs_ast_declarations_interface_t *instance = rbs_allocator_alloc(allocator, rbs_ast_declarations_interface_t);

    *instance = (rbs_ast_declarations_interface_t) {
        .base = (rbs_node_t) {
            .type = RBS_AST_DECLARATIONS_INTERFACE,
            .location = location,
        },
        .name = name,
        .type_params = type_params,
        .members = members,
        .annotations = annotations,
        .comment = comment,
    };

    return instance;
}
#line 156 "prism/templates/src/ast.c.erb"
rbs_ast_declarations_module_t *rbs_ast_declarations_module_new(rbs_allocator_t *allocator, rbs_location_t *location, rbs_type_name_t *name, rbs_node_list_t *type_params, rbs_node_list_t *self_types, rbs_node_list_t *members, rbs_node_list_t *annotations, rbs_ast_comment_t *comment) {
    rbs_ast_declarations_module_t *instance = rbs_allocator_alloc(allocator, rbs_ast_declarations_module_t);

    *instance = (rbs_ast_declarations_module_t) {
        .base = (rbs_node_t) {
            .type = RBS_AST_DECLARATIONS_MODULE,
            .location = location,
        },
        .name = name,
        .type_params = type_params,
        .self_types = self_types,
        .members = members,
        .annotations = annotations,
        .comment = comment,
    };

    return instance;
}
#line 156 "prism/templates/src/ast.c.erb"
rbs_ast_declarations_module_self_t *rbs_ast_declarations_module_self_new(rbs_allocator_t *allocator, rbs_location_t *location, rbs_type_name_t *name, rbs_node_list_t *args) {
    rbs_ast_declarations_module_self_t *instance = rbs_allocator_alloc(allocator, rbs_ast_declarations_module_self_t);

    *instance = (rbs_ast_declarations_module_self_t) {
        .base = (rbs_node_t) {
            .type = RBS_AST_DECLARATIONS_MODULE_SELF,
            .location = location,
        },
        .name = name,
        .args = args,
    };

    return instance;
}
#line 156 "prism/templates/src/ast.c.erb"
rbs_ast_declarations_module_alias_t *rbs_ast_declarations_module_alias_new(rbs_allocator_t *allocator, rbs_location_t *location, rbs_type_name_t *new_name, rbs_type_name_t *old_name, rbs_ast_comment_t *comment, rbs_node_list_t *annotations) {
    rbs_ast_declarations_module_alias_t *instance = rbs_allocator_alloc(allocator, rbs_ast_declarations_module_alias_t);

    *instance = (rbs_ast_declarations_module_alias_t) {
        .base = (rbs_node_t) {
            .type = RBS_AST_DECLARATIONS_MODULE_ALIAS,
            .location = location,
        },
        .new_name = new_name,
        .old_name = old_name,
        .comment = comment,
        .annotations = annotations,
    };

    return instance;
}
#line 156 "prism/templates/src/ast.c.erb"
rbs_ast_declarations_type_alias_t *rbs_ast_declarations_type_alias_new(rbs_allocator_t *allocator, rbs_location_t *location, rbs_type_name_t *name, rbs_node_list_t *type_params, rbs_node_t *type, rbs_node_list_t *annotations, rbs_ast_comment_t *comment) {
    rbs_ast_declarations_type_alias_t *instance = rbs_allocator_alloc(allocator, rbs_ast_declarations_type_alias_t);

    *instance = (rbs_ast_declarations_type_alias_t) {
        .base = (rbs_node_t) {
            .type = RBS_AST_DECLARATIONS_TYPE_ALIAS,
            .location = location,
        },
        .name = name,
        .type_params = type_params,
        .type = type,
        .annotations = annotations,
        .comment = comment,
    };

    return instance;
}
#line 156 "prism/templates/src/ast.c.erb"
rbs_ast_directives_use_t *rbs_ast_directives_use_new(rbs_allocator_t *allocator, rbs_location_t *location, rbs_node_list_t *clauses) {
    rbs_ast_directives_use_t *instance = rbs_allocator_alloc(allocator, rbs_ast_directives_use_t);

    *instance = (rbs_ast_directives_use_t) {
        .base = (rbs_node_t) {
            .type = RBS_AST_DIRECTIVES_USE,
            .location = location,
        },
        .clauses = clauses,
    };

    return instance;
}
#line 156 "prism/templates/src/ast.c.erb"
rbs_ast_directives_use_single_clause_t *rbs_ast_directives_use_single_clause_new(rbs_allocator_t *allocator, rbs_location_t *location, rbs_type_name_t *type_name, rbs_ast_symbol_t *new_name) {
    rbs_ast_directives_use_single_clause_t *instance = rbs_allocator_alloc(allocator, rbs_ast_directives_use_single_clause_t);

    *instance = (rbs_ast_directives_use_single_clause_t) {
        .base = (rbs_node_t) {
            .type = RBS_AST_DIRECTIVES_USE_SINGLE_CLAUSE,
            .location = location,
        },
        .type_name = type_name,
        .new_name = new_name,
    };

    return instance;
}
#line 156 "prism/templates/src/ast.c.erb"
rbs_ast_directives_use_wildcard_clause_t *rbs_ast_directives_use_wildcard_clause_new(rbs_allocator_t *allocator, rbs_location_t *location, rbs_namespace_t *rbs_namespace) {
    rbs_ast_directives_use_wildcard_clause_t *instance = rbs_allocator_alloc(allocator, rbs_ast_directives_use_wildcard_clause_t);

    *instance = (rbs_ast_directives_use_wildcard_clause_t) {
        .base = (rbs_node_t) {
            .type = RBS_AST_DIRECTIVES_USE_WILDCARD_CLAUSE,
            .location = location,
        },
        .rbs_namespace = rbs_namespace,
    };

    return instance;
}
#line 156 "prism/templates/src/ast.c.erb"
rbs_ast_integer_t *rbs_ast_integer_new(rbs_allocator_t *allocator, rbs_location_t *location, rbs_string_t string_representation) {
    rbs_ast_integer_t *instance = rbs_allocator_alloc(allocator, rbs_ast_integer_t);

    *instance = (rbs_ast_integer_t) {
        .base = (rbs_node_t) {
            .type = RBS_AST_INTEGER,
            .location = location,
        },
        .string_representation = string_representation,
    };

    return instance;
}
#line 156 "prism/templates/src/ast.c.erb"
rbs_ast_members_alias_t *rbs_ast_members_alias_new(rbs_allocator_t *allocator, rbs_location_t *location, rbs_ast_symbol_t *new_name, rbs_ast_symbol_t *old_name, rbs_keyword_t *kind, rbs_node_list_t *annotations, rbs_ast_comment_t *comment) {
    rbs_ast_members_alias_t *instance = rbs_allocator_alloc(allocator, rbs_ast_members_alias_t);

    *instance = (rbs_ast_members_alias_t) {
        .base = (rbs_node_t) {
            .type = RBS_AST_MEMBERS_ALIAS,
            .location = location,
        },
        .new_name = new_name,
        .old_name = old_name,
        .kind = kind,
        .annotations = annotations,
        .comment = comment,
    };

    return instance;
}
#line 156 "prism/templates/src/ast.c.erb"
rbs_ast_members_attr_accessor_t *rbs_ast_members_attr_accessor_new(rbs_allocator_t *allocator, rbs_location_t *location, rbs_ast_symbol_t *name, rbs_node_t *type, rbs_node_t *ivar_name, rbs_keyword_t *kind, rbs_node_list_t *annotations, rbs_ast_comment_t *comment, rbs_keyword_t *visibility) {
    rbs_ast_members_attr_accessor_t *instance = rbs_allocator_alloc(allocator, rbs_ast_members_attr_accessor_t);

    *instance = (rbs_ast_members_attr_accessor_t) {
        .base = (rbs_node_t) {
            .type = RBS_AST_MEMBERS_ATTR_ACCESSOR,
            .location = location,
        },
        .name = name,
        .type = type,
        .ivar_name = ivar_name,
        .kind = kind,
        .annotations = annotations,
        .comment = comment,
        .visibility = visibility,
    };

    return instance;
}
#line 156 "prism/templates/src/ast.c.erb"
rbs_ast_members_attr_reader_t *rbs_ast_members_attr_reader_new(rbs_allocator_t *allocator, rbs_location_t *location, rbs_ast_symbol_t *name, rbs_node_t *type, rbs_node_t *ivar_name, rbs_keyword_t *kind, rbs_node_list_t *annotations, rbs_ast_comment_t *comment, rbs_keyword_t *visibility) {
    rbs_ast_members_attr_reader_t *instance = rbs_allocator_alloc(allocator, rbs_ast_members_attr_reader_t);

    *instance = (rbs_ast_members_attr_reader_t) {
        .base = (rbs_node_t) {
            .type = RBS_AST_MEMBERS_ATTR_READER,
            .location = location,
        },
        .name = name,
        .type = type,
        .ivar_name = ivar_name,
        .kind = kind,
        .annotations = annotations,
        .comment = comment,
        .visibility = visibility,
    };

    return instance;
}
#line 156 "prism/templates/src/ast.c.erb"
rbs_ast_members_attr_writer_t *rbs_ast_members_attr_writer_new(rbs_allocator_t *allocator, rbs_location_t *location, rbs_ast_symbol_t *name, rbs_node_t *type, rbs_node_t *ivar_name, rbs_keyword_t *kind, rbs_node_list_t *annotations, rbs_ast_comment_t *comment, rbs_keyword_t *visibility) {
    rbs_ast_members_attr_writer_t *instance = rbs_allocator_alloc(allocator, rbs_ast_members_attr_writer_t);

    *instance = (rbs_ast_members_attr_writer_t) {
        .base = (rbs_node_t) {
            .type = RBS_AST_MEMBERS_ATTR_WRITER,
            .location = location,
        },
        .name = name,
        .type = type,
        .ivar_name = ivar_name,
        .kind = kind,
        .annotations = annotations,
        .comment = comment,
        .visibility = visibility,
    };

    return instance;
}
#line 156 "prism/templates/src/ast.c.erb"
rbs_ast_members_class_instance_variable_t *rbs_ast_members_class_instance_variable_new(rbs_allocator_t *allocator, rbs_location_t *location, rbs_ast_symbol_t *name, rbs_node_t *type, rbs_ast_comment_t *comment) {
    rbs_ast_members_class_instance_variable_t *instance = rbs_allocator_alloc(allocator, rbs_ast_members_class_instance_variable_t);

    *instance = (rbs_ast_members_class_instance_variable_t) {
        .base = (rbs_node_t) {
            .type = RBS_AST_MEMBERS_CLASS_INSTANCE_VARIABLE,
            .location = location,
        },
        .name = name,
        .type = type,
        .comment = comment,
    };

    return instance;
}
#line 156 "prism/templates/src/ast.c.erb"
rbs_ast_members_class_variable_t *rbs_ast_members_class_variable_new(rbs_allocator_t *allocator, rbs_location_t *location, rbs_ast_symbol_t *name, rbs_node_t *type, rbs_ast_comment_t *comment) {
    rbs_ast_members_class_variable_t *instance = rbs_allocator_alloc(allocator, rbs_ast_members_class_variable_t);

    *instance = (rbs_ast_members_class_variable_t) {
        .base = (rbs_node_t) {
            .type = RBS_AST_MEMBERS_CLASS_VARIABLE,
            .location = location,
        },
        .name = name,
        .type = type,
        .comment = comment,
    };

    return instance;
}
#line 156 "prism/templates/src/ast.c.erb"
rbs_ast_members_extend_t *rbs_ast_members_extend_new(rbs_allocator_t *allocator, rbs_location_t *location, rbs_type_name_t *name, rbs_node_list_t *args, rbs_node_list_t *annotations, rbs_ast_comment_t *comment) {
    rbs_ast_members_extend_t *instance = rbs_allocator_alloc(allocator, rbs_ast_members_extend_t);

    *instance = (rbs_ast_members_extend_t) {
        .base = (rbs_node_t) {
            .type = RBS_AST_MEMBERS_EXTEND,
            .location = location,
        },
        .name = name,
        .args = args,
        .annotations = annotations,
        .comment = comment,
    };

    return instance;
}
#line 156 "prism/templates/src/ast.c.erb"
rbs_ast_members_include_t *rbs_ast_members_include_new(rbs_allocator_t *allocator, rbs_location_t *location, rbs_type_name_t *name, rbs_node_list_t *args, rbs_node_list_t *annotations, rbs_ast_comment_t *comment) {
    rbs_ast_members_include_t *instance = rbs_allocator_alloc(allocator, rbs_ast_members_include_t);

    *instance = (rbs_ast_members_include_t) {
        .base = (rbs_node_t) {
            .type = RBS_AST_MEMBERS_INCLUDE,
            .location = location,
        },
        .name = name,
        .args = args,
        .annotations = annotations,
        .comment = comment,
    };

    return instance;
}
#line 156 "prism/templates/src/ast.c.erb"
rbs_ast_members_instance_variable_t *rbs_ast_members_instance_variable_new(rbs_allocator_t *allocator, rbs_location_t *location, rbs_ast_symbol_t *name, rbs_node_t *type, rbs_ast_comment_t *comment) {
    rbs_ast_members_instance_variable_t *instance = rbs_allocator_alloc(allocator, rbs_ast_members_instance_variable_t);

    *instance = (rbs_ast_members_instance_variable_t) {
        .base = (rbs_node_t) {
            .type = RBS_AST_MEMBERS_INSTANCE_VARIABLE,
            .location = location,
        },
        .name = name,
        .type = type,
        .comment = comment,
    };

    return instance;
}
#line 156 "prism/templates/src/ast.c.erb"
rbs_ast_members_method_definition_t *rbs_ast_members_method_definition_new(rbs_allocator_t *allocator, rbs_location_t *location, rbs_ast_symbol_t *name, rbs_keyword_t *kind, rbs_node_list_t *overloads, rbs_node_list_t *annotations, rbs_ast_comment_t *comment, bool overloading, rbs_keyword_t *visibility) {
    rbs_ast_members_method_definition_t *instance = rbs_allocator_alloc(allocator, rbs_ast_members_method_definition_t);

    *instance = (rbs_ast_members_method_definition_t) {
        .base = (rbs_node_t) {
            .type = RBS_AST_MEMBERS_METHOD_DEFINITION,
            .location = location,
        },
        .name = name,
        .kind = kind,
        .overloads = overloads,
        .annotations = annotations,
        .comment = comment,
        .overloading = overloading,
        .visibility = visibility,
    };

    return instance;
}
#line 156 "prism/templates/src/ast.c.erb"
rbs_ast_members_method_definition_overload_t *rbs_ast_members_method_definition_overload_new(rbs_allocator_t *allocator, rbs_location_t *location, rbs_node_list_t *annotations, rbs_node_t *method_type) {
    rbs_ast_members_method_definition_overload_t *instance = rbs_allocator_alloc(allocator, rbs_ast_members_method_definition_overload_t);

    *instance = (rbs_ast_members_method_definition_overload_t) {
        .base = (rbs_node_t) {
            .type = RBS_AST_MEMBERS_METHOD_DEFINITION_OVERLOAD,
            .location = location,
        },
        .annotations = annotations,
        .method_type = method_type,
    };

    return instance;
}
#line 156 "prism/templates/src/ast.c.erb"
rbs_ast_members_prepend_t *rbs_ast_members_prepend_new(rbs_allocator_t *allocator, rbs_location_t *location, rbs_type_name_t *name, rbs_node_list_t *args, rbs_node_list_t *annotations, rbs_ast_comment_t *comment) {
    rbs_ast_members_prepend_t *instance = rbs_allocator_alloc(allocator, rbs_ast_members_prepend_t);

    *instance = (rbs_ast_members_prepend_t) {
        .base = (rbs_node_t) {
            .type = RBS_AST_MEMBERS_PREPEND,
            .location = location,
        },
        .name = name,
        .args = args,
        .annotations = annotations,
        .comment = comment,
    };

    return instance;
}
#line 156 "prism/templates/src/ast.c.erb"
rbs_ast_members_private_t *rbs_ast_members_private_new(rbs_allocator_t *allocator, rbs_location_t *location) {
    rbs_ast_members_private_t *instance = rbs_allocator_alloc(allocator, rbs_ast_members_private_t);

    *instance = (rbs_ast_members_private_t) {
        .base = (rbs_node_t) {
            .type = RBS_AST_MEMBERS_PRIVATE,
            .location = location,
        },
    };

    return instance;
}
#line 156 "prism/templates/src/ast.c.erb"
rbs_ast_members_public_t *rbs_ast_members_public_new(rbs_allocator_t *allocator, rbs_location_t *location) {
    rbs_ast_members_public_t *instance = rbs_allocator_alloc(allocator, rbs_ast_members_public_t);

    *instance = (rbs_ast_members_public_t) {
        .base = (rbs_node_t) {
            .type = RBS_AST_MEMBERS_PUBLIC,
            .location = location,
        },
    };

    return instance;
}
#line 156 "prism/templates/src/ast.c.erb"
rbs_ast_string_t *rbs_ast_string_new(rbs_allocator_t *allocator, rbs_location_t *location, rbs_string_t string) {
    rbs_ast_string_t *instance = rbs_allocator_alloc(allocator, rbs_ast_string_t);

    *instance = (rbs_ast_string_t) {
        .base = (rbs_node_t) {
            .type = RBS_AST_STRING,
            .location = location,
        },
        .string = string,
    };

    return instance;
}
#line 156 "prism/templates/src/ast.c.erb"
rbs_ast_type_param_t *rbs_ast_type_param_new(rbs_allocator_t *allocator, rbs_location_t *location, rbs_ast_symbol_t *name, rbs_keyword_t *variance, rbs_node_t *upper_bound, rbs_node_t *default_type, bool unchecked) {
    rbs_ast_type_param_t *instance = rbs_allocator_alloc(allocator, rbs_ast_type_param_t);

    *instance = (rbs_ast_type_param_t) {
        .base = (rbs_node_t) {
            .type = RBS_AST_TYPE_PARAM,
            .location = location,
        },
        .name = name,
        .variance = variance,
        .upper_bound = upper_bound,
        .default_type = default_type,
        .unchecked = unchecked,
    };

    return instance;
}
#line 156 "prism/templates/src/ast.c.erb"
rbs_method_type_t *rbs_method_type_new(rbs_allocator_t *allocator, rbs_location_t *location, rbs_node_list_t *type_params, rbs_node_t *type, rbs_types_block_t *block) {
    rbs_method_type_t *instance = rbs_allocator_alloc(allocator, rbs_method_type_t);

    *instance = (rbs_method_type_t) {
        .base = (rbs_node_t) {
            .type = RBS_METHOD_TYPE,
            .location = location,
        },
        .type_params = type_params,
        .type = type,
        .block = block,
    };

    return instance;
}
#line 156 "prism/templates/src/ast.c.erb"
rbs_namespace_t *rbs_namespace_new(rbs_allocator_t *allocator, rbs_location_t *location, rbs_node_list_t *path, bool absolute) {
    rbs_namespace_t *instance = rbs_allocator_alloc(allocator, rbs_namespace_t);

    *instance = (rbs_namespace_t) {
        .base = (rbs_node_t) {
            .type = RBS_NAMESPACE,
            .location = location,
        },
        .path = path,
        .absolute = absolute,
    };

    return instance;
}
#line 156 "prism/templates/src/ast.c.erb"
rbs_signature_t *rbs_signature_new(rbs_allocator_t *allocator, rbs_location_t *location, rbs_node_list_t *directives, rbs_node_list_t *declarations) {
    rbs_signature_t *instance = rbs_allocator_alloc(allocator, rbs_signature_t);

    *instance = (rbs_signature_t) {
        .base = (rbs_node_t) {
            .type = RBS_SIGNATURE,
            .location = location,
        },
        .directives = directives,
        .declarations = declarations,
    };

    return instance;
}
#line 156 "prism/templates/src/ast.c.erb"
rbs_type_name_t *rbs_type_name_new(rbs_allocator_t *allocator, rbs_location_t *location, rbs_namespace_t *rbs_namespace, rbs_ast_symbol_t *name) {
    rbs_type_name_t *instance = rbs_allocator_alloc(allocator, rbs_type_name_t);

    *instance = (rbs_type_name_t) {
        .base = (rbs_node_t) {
            .type = RBS_TYPE_NAME,
            .location = location,
        },
        .rbs_namespace = rbs_namespace,
        .name = name,
    };

    return instance;
}
#line 156 "prism/templates/src/ast.c.erb"
rbs_types_alias_t *rbs_types_alias_new(rbs_allocator_t *allocator, rbs_location_t *location, rbs_type_name_t *name, rbs_node_list_t *args) {
    rbs_types_alias_t *instance = rbs_allocator_alloc(allocator, rbs_types_alias_t);

    *instance = (rbs_types_alias_t) {
        .base = (rbs_node_t) {
            .type = RBS_TYPES_ALIAS,
            .location = location,
        },
        .name = name,
        .args = args,
    };

    return instance;
}
#line 156 "prism/templates/src/ast.c.erb"
rbs_types_bases_any_t *rbs_types_bases_any_new(rbs_allocator_t *allocator, rbs_location_t *location, bool todo) {
    rbs_types_bases_any_t *instance = rbs_allocator_alloc(allocator, rbs_types_bases_any_t);

    *instance = (rbs_types_bases_any_t) {
        .base = (rbs_node_t) {
            .type = RBS_TYPES_BASES_ANY,
            .location = location,
        },
        .todo = todo,
    };

    return instance;
}
#line 156 "prism/templates/src/ast.c.erb"
rbs_types_bases_bool_t *rbs_types_bases_bool_new(rbs_allocator_t *allocator, rbs_location_t *location) {
    rbs_types_bases_bool_t *instance = rbs_allocator_alloc(allocator, rbs_types_bases_bool_t);

    *instance = (rbs_types_bases_bool_t) {
        .base = (rbs_node_t) {
            .type = RBS_TYPES_BASES_BOOL,
            .location = location,
        },
    };

    return instance;
}
#line 156 "prism/templates/src/ast.c.erb"
rbs_types_bases_bottom_t *rbs_types_bases_bottom_new(rbs_allocator_t *allocator, rbs_location_t *location) {
    rbs_types_bases_bottom_t *instance = rbs_allocator_alloc(allocator, rbs_types_bases_bottom_t);

    *instance = (rbs_types_bases_bottom_t) {
        .base = (rbs_node_t) {
            .type = RBS_TYPES_BASES_BOTTOM,
            .location = location,
        },
    };

    return instance;
}
#line 156 "prism/templates/src/ast.c.erb"
rbs_types_bases_class_t *rbs_types_bases_class_new(rbs_allocator_t *allocator, rbs_location_t *location) {
    rbs_types_bases_class_t *instance = rbs_allocator_alloc(allocator, rbs_types_bases_class_t);

    *instance = (rbs_types_bases_class_t) {
        .base = (rbs_node_t) {
            .type = RBS_TYPES_BASES_CLASS,
            .location = location,
        },
    };

    return instance;
}
#line 156 "prism/templates/src/ast.c.erb"
rbs_types_bases_instance_t *rbs_types_bases_instance_new(rbs_allocator_t *allocator, rbs_location_t *location) {
    rbs_types_bases_instance_t *instance = rbs_allocator_alloc(allocator, rbs_types_bases_instance_t);

    *instance = (rbs_types_bases_instance_t) {
        .base = (rbs_node_t) {
            .type = RBS_TYPES_BASES_INSTANCE,
            .location = location,
        },
    };

    return instance;
}
#line 156 "prism/templates/src/ast.c.erb"
rbs_types_bases_nil_t *rbs_types_bases_nil_new(rbs_allocator_t *allocator, rbs_location_t *location) {
    rbs_types_bases_nil_t *instance = rbs_allocator_alloc(allocator, rbs_types_bases_nil_t);

    *instance = (rbs_types_bases_nil_t) {
        .base = (rbs_node_t) {
            .type = RBS_TYPES_BASES_NIL,
            .location = location,
        },
    };

    return instance;
}
#line 156 "prism/templates/src/ast.c.erb"
rbs_types_bases_self_t *rbs_types_bases_self_new(rbs_allocator_t *allocator, rbs_location_t *location) {
    rbs_types_bases_self_t *instance = rbs_allocator_alloc(allocator, rbs_types_bases_self_t);

    *instance = (rbs_types_bases_self_t) {
        .base = (rbs_node_t) {
            .type = RBS_TYPES_BASES_SELF,
            .location = location,
        },
    };

    return instance;
}
#line 156 "prism/templates/src/ast.c.erb"
rbs_types_bases_top_t *rbs_types_bases_top_new(rbs_allocator_t *allocator, rbs_location_t *location) {
    rbs_types_bases_top_t *instance = rbs_allocator_alloc(allocator, rbs_types_bases_top_t);

    *instance = (rbs_types_bases_top_t) {
        .base = (rbs_node_t) {
            .type = RBS_TYPES_BASES_TOP,
            .location = location,
        },
    };

    return instance;
}
#line 156 "prism/templates/src/ast.c.erb"
rbs_types_bases_void_t *rbs_types_bases_void_new(rbs_allocator_t *allocator, rbs_location_t *location) {
    rbs_types_bases_void_t *instance = rbs_allocator_alloc(allocator, rbs_types_bases_void_t);

    *instance = (rbs_types_bases_void_t) {
        .base = (rbs_node_t) {
            .type = RBS_TYPES_BASES_VOID,
            .location = location,
        },
    };

    return instance;
}
#line 156 "prism/templates/src/ast.c.erb"
rbs_types_block_t *rbs_types_block_new(rbs_allocator_t *allocator, rbs_location_t *location, rbs_node_t *type, bool required, rbs_node_t *self_type) {
    rbs_types_block_t *instance = rbs_allocator_alloc(allocator, rbs_types_block_t);

    *instance = (rbs_types_block_t) {
        .base = (rbs_node_t) {
            .type = RBS_TYPES_BLOCK,
            .location = location,
        },
        .type = type,
        .required = required,
        .self_type = self_type,
    };

    return instance;
}
#line 156 "prism/templates/src/ast.c.erb"
rbs_types_class_instance_t *rbs_types_class_instance_new(rbs_allocator_t *allocator, rbs_location_t *location, rbs_type_name_t *name, rbs_node_list_t *args) {
    rbs_types_class_instance_t *instance = rbs_allocator_alloc(allocator, rbs_types_class_instance_t);

    *instance = (rbs_types_class_instance_t) {
        .base = (rbs_node_t) {
            .type = RBS_TYPES_CLASS_INSTANCE,
            .location = location,
        },
        .name = name,
        .args = args,
    };

    return instance;
}
#line 156 "prism/templates/src/ast.c.erb"
rbs_types_class_singleton_t *rbs_types_class_singleton_new(rbs_allocator_t *allocator, rbs_location_t *location, rbs_type_name_t *name) {
    rbs_types_class_singleton_t *instance = rbs_allocator_alloc(allocator, rbs_types_class_singleton_t);

    *instance = (rbs_types_class_singleton_t) {
        .base = (rbs_node_t) {
            .type = RBS_TYPES_CLASS_SINGLETON,
            .location = location,
        },
        .name = name,
    };

    return instance;
}
#line 156 "prism/templates/src/ast.c.erb"
rbs_types_function_t *rbs_types_function_new(rbs_allocator_t *allocator, rbs_location_t *location, rbs_node_list_t *required_positionals, rbs_node_list_t *optional_positionals, rbs_node_t *rest_positionals, rbs_node_list_t *trailing_positionals, rbs_hash_t *required_keywords, rbs_hash_t *optional_keywords, rbs_node_t *rest_keywords, rbs_node_t *return_type) {
    rbs_types_function_t *instance = rbs_allocator_alloc(allocator, rbs_types_function_t);

    *instance = (rbs_types_function_t) {
        .base = (rbs_node_t) {
            .type = RBS_TYPES_FUNCTION,
            .location = location,
        },
        .required_positionals = required_positionals,
        .optional_positionals = optional_positionals,
        .rest_positionals = rest_positionals,
        .trailing_positionals = trailing_positionals,
        .required_keywords = required_keywords,
        .optional_keywords = optional_keywords,
        .rest_keywords = rest_keywords,
        .return_type = return_type,
    };

    return instance;
}
#line 156 "prism/templates/src/ast.c.erb"
rbs_types_function_param_t *rbs_types_function_param_new(rbs_allocator_t *allocator, rbs_location_t *location, rbs_node_t *type, rbs_ast_symbol_t *name) {
    rbs_types_function_param_t *instance = rbs_allocator_alloc(allocator, rbs_types_function_param_t);

    *instance = (rbs_types_function_param_t) {
        .base = (rbs_node_t) {
            .type = RBS_TYPES_FUNCTION_PARAM,
            .location = location,
        },
        .type = type,
        .name = name,
    };

    return instance;
}
#line 156 "prism/templates/src/ast.c.erb"
rbs_types_interface_t *rbs_types_interface_new(rbs_allocator_t *allocator, rbs_location_t *location, rbs_type_name_t *name, rbs_node_list_t *args) {
    rbs_types_interface_t *instance = rbs_allocator_alloc(allocator, rbs_types_interface_t);

    *instance = (rbs_types_interface_t) {
        .base = (rbs_node_t) {
            .type = RBS_TYPES_INTERFACE,
            .location = location,
        },
        .name = name,
        .args = args,
    };

    return instance;
}
#line 156 "prism/templates/src/ast.c.erb"
rbs_types_intersection_t *rbs_types_intersection_new(rbs_allocator_t *allocator, rbs_location_t *location, rbs_node_list_t *types) {
    rbs_types_intersection_t *instance = rbs_allocator_alloc(allocator, rbs_types_intersection_t);

    *instance = (rbs_types_intersection_t) {
        .base = (rbs_node_t) {
            .type = RBS_TYPES_INTERSECTION,
            .location = location,
        },
        .types = types,
    };

    return instance;
}
#line 156 "prism/templates/src/ast.c.erb"
rbs_types_literal_t *rbs_types_literal_new(rbs_allocator_t *allocator, rbs_location_t *location, rbs_node_t *literal) {
    rbs_types_literal_t *instance = rbs_allocator_alloc(allocator, rbs_types_literal_t);

    *instance = (rbs_types_literal_t) {
        .base = (rbs_node_t) {
            .type = RBS_TYPES_LITERAL,
            .location = location,
        },
        .literal = literal,
    };

    return instance;
}
#line 156 "prism/templates/src/ast.c.erb"
rbs_types_optional_t *rbs_types_optional_new(rbs_allocator_t *allocator, rbs_location_t *location, rbs_node_t *type) {
    rbs_types_optional_t *instance = rbs_allocator_alloc(allocator, rbs_types_optional_t);

    *instance = (rbs_types_optional_t) {
        .base = (rbs_node_t) {
            .type = RBS_TYPES_OPTIONAL,
            .location = location,
        },
        .type = type,
    };

    return instance;
}
#line 156 "prism/templates/src/ast.c.erb"
rbs_types_proc_t *rbs_types_proc_new(rbs_allocator_t *allocator, rbs_location_t *location, rbs_node_t *type, rbs_types_block_t *block, rbs_node_t *self_type) {
    rbs_types_proc_t *instance = rbs_allocator_alloc(allocator, rbs_types_proc_t);

    *instance = (rbs_types_proc_t) {
        .base = (rbs_node_t) {
            .type = RBS_TYPES_PROC,
            .location = location,
        },
        .type = type,
        .block = block,
        .self_type = self_type,
    };

    return instance;
}
#line 156 "prism/templates/src/ast.c.erb"
rbs_types_record_t *rbs_types_record_new(rbs_allocator_t *allocator, rbs_location_t *location, rbs_hash_t *all_fields) {
    rbs_types_record_t *instance = rbs_allocator_alloc(allocator, rbs_types_record_t);

    *instance = (rbs_types_record_t) {
        .base = (rbs_node_t) {
            .type = RBS_TYPES_RECORD,
            .location = location,
        },
        .all_fields = all_fields,
    };

    return instance;
}
#line 156 "prism/templates/src/ast.c.erb"
rbs_types_record_field_type_t *rbs_types_record_field_type_new(rbs_allocator_t *allocator, rbs_location_t *location, rbs_node_t *type, bool required) {
    rbs_types_record_field_type_t *instance = rbs_allocator_alloc(allocator, rbs_types_record_field_type_t);

    *instance = (rbs_types_record_field_type_t) {
        .base = (rbs_node_t) {
            .type = RBS_TYPES_RECORD_FIELD_TYPE,
            .location = location,
        },
        .type = type,
        .required = required,
    };

    return instance;
}
#line 156 "prism/templates/src/ast.c.erb"
rbs_types_tuple_t *rbs_types_tuple_new(rbs_allocator_t *allocator, rbs_location_t *location, rbs_node_list_t *types) {
    rbs_types_tuple_t *instance = rbs_allocator_alloc(allocator, rbs_types_tuple_t);

    *instance = (rbs_types_tuple_t) {
        .base = (rbs_node_t) {
            .type = RBS_TYPES_TUPLE,
            .location = location,
        },
        .types = types,
    };

    return instance;
}
#line 156 "prism/templates/src/ast.c.erb"
rbs_types_union_t *rbs_types_union_new(rbs_allocator_t *allocator, rbs_location_t *location, rbs_node_list_t *types) {
    rbs_types_union_t *instance = rbs_allocator_alloc(allocator, rbs_types_union_t);

    *instance = (rbs_types_union_t) {
        .base = (rbs_node_t) {
            .type = RBS_TYPES_UNION,
            .location = location,
        },
        .types = types,
    };

    return instance;
}
#line 156 "prism/templates/src/ast.c.erb"
rbs_types_untyped_function_t *rbs_types_untyped_function_new(rbs_allocator_t *allocator, rbs_location_t *location, rbs_node_t *return_type) {
    rbs_types_untyped_function_t *instance = rbs_allocator_alloc(allocator, rbs_types_untyped_function_t);

    *instance = (rbs_types_untyped_function_t) {
        .base = (rbs_node_t) {
            .type = RBS_TYPES_UNTYPED_FUNCTION,
            .location = location,
        },
        .return_type = return_type,
    };

    return instance;
}
#line 156 "prism/templates/src/ast.c.erb"
rbs_types_variable_t *rbs_types_variable_new(rbs_allocator_t *allocator, rbs_location_t *location, rbs_ast_symbol_t *name) {
    rbs_types_variable_t *instance = rbs_allocator_alloc(allocator, rbs_types_variable_t);

    *instance = (rbs_types_variable_t) {
        .base = (rbs_node_t) {
            .type = RBS_TYPES_VARIABLE,
            .location = location,
        },
        .name = name,
    };

    return instance;
}
