/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.ir.backend.js.lower;

import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.backend.common.CompilationExceptionKt;
import org.jetbrains.kotlin.backend.common.Mapping;
import org.jetbrains.kotlin.backend.common.MappingsKt;
import org.jetbrains.kotlin.backend.common.lower.InnerClassesSupport;
import org.jetbrains.kotlin.descriptors.DescriptorVisibilities;
import org.jetbrains.kotlin.ir.backend.js.JsMapping;
import org.jetbrains.kotlin.ir.backend.js.ir.JsIrBuilder;
import org.jetbrains.kotlin.ir.backend.js.utils.Namer;
import org.jetbrains.kotlin.ir.builders.declarations.DeclarationBuildersKt;
import org.jetbrains.kotlin.ir.builders.declarations.IrFieldBuilder;
import org.jetbrains.kotlin.ir.builders.declarations.IrFunctionBuilder;
import org.jetbrains.kotlin.ir.builders.declarations.IrValueParameterBuilder;
import org.jetbrains.kotlin.ir.declarations.IrClass;
import org.jetbrains.kotlin.ir.declarations.IrConstructor;
import org.jetbrains.kotlin.ir.declarations.IrDeclaration;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationBase;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationOrigin;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationParent;
import org.jetbrains.kotlin.ir.declarations.IrFactory;
import org.jetbrains.kotlin.ir.declarations.IrField;
import org.jetbrains.kotlin.ir.declarations.IrFunction;
import org.jetbrains.kotlin.ir.declarations.IrTypeParametersContainer;
import org.jetbrains.kotlin.ir.declarations.IrValueParameter;
import org.jetbrains.kotlin.ir.types.IrSimpleType;
import org.jetbrains.kotlin.ir.util.IrUtilsKt;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.utils.MemoryOptimizedCollectionUtilKt;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0010\u0010\u000f\u001a\u00020\u000b2\u0006\u0010\u0010\u001a\u00020\nH\u0016J\u0010\u0010\u0011\u001a\u00020\r2\u0006\u0010\u0012\u001a\u00020\rH\u0016J\u0012\u0010\u0013\u001a\u0004\u0018\u00010\r2\u0006\u0010\u0010\u001a\u00020\nH\u0016J\u0010\u0010\u0014\u001a\u00020\r2\u0006\u0010\u0015\u001a\u00020\rH\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u000b0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\f\u001a\u000e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\r0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u000e\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\r0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lorg/jetbrains/kotlin/ir/backend/js/lower/JsInnerClassesSupport;", "Lorg/jetbrains/kotlin/backend/common/lower/InnerClassesSupport;", "mapping", "Lorg/jetbrains/kotlin/ir/backend/js/JsMapping;", "irFactory", "Lorg/jetbrains/kotlin/ir/declarations/IrFactory;", "<init>", "(Lorg/jetbrains/kotlin/ir/backend/js/JsMapping;Lorg/jetbrains/kotlin/ir/declarations/IrFactory;)V", "outerThisFieldSymbols", "Lorg/jetbrains/kotlin/backend/common/Mapping$DeclarationMapping;", "Lorg/jetbrains/kotlin/ir/declarations/IrClass;", "Lorg/jetbrains/kotlin/ir/declarations/IrField;", "innerClassConstructors", "Lorg/jetbrains/kotlin/ir/declarations/IrConstructor;", "originalInnerClassPrimaryConstructorByClass", "getOuterThisField", "innerClass", "getInnerClassConstructorWithOuterThisParameter", "innerClassConstructor", "getInnerClassOriginalPrimaryConstructorOrNull", "createInnerClassConstructorWithOuterThisParameter", "oldConstructor", "backend.js"})
@SourceDebugExtension(value={"SMAP\nJsInnerClassesSupport.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JsInnerClassesSupport.kt\norg/jetbrains/kotlin/ir/backend/js/lower/JsInnerClassesSupport\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 declarationBuilders.kt\norg/jetbrains/kotlin/ir/builders/declarations/DeclarationBuildersKt\n*L\n1#1,106:1\n1#2:107\n283#3,4:108\n345#3,4:112\n74#3,4:116\n*S KotlinDebug\n*F\n+ 1 JsInnerClassesSupport.kt\norg/jetbrains/kotlin/ir/backend/js/lower/JsInnerClassesSupport\n*L\n80#1:108,4\n90#1:112,4\n43#1:116,4\n*E\n"})
public final class JsInnerClassesSupport
implements InnerClassesSupport {
    @NotNull
    private final IrFactory irFactory;
    @NotNull
    private final Mapping.DeclarationMapping<IrClass, IrField> outerThisFieldSymbols;
    @NotNull
    private final Mapping.DeclarationMapping<IrConstructor, IrConstructor> innerClassConstructors;
    @NotNull
    private final Mapping.DeclarationMapping<IrClass, IrConstructor> originalInnerClassPrimaryConstructorByClass;

    public JsInnerClassesSupport(@NotNull JsMapping mapping, @NotNull IrFactory irFactory) {
        Intrinsics.checkNotNullParameter((Object)mapping, (String)"mapping");
        Intrinsics.checkNotNullParameter((Object)irFactory, (String)"irFactory");
        this.irFactory = irFactory;
        this.outerThisFieldSymbols = mapping.getOuterThisFieldSymbols();
        this.innerClassConstructors = mapping.getInnerClassConstructors();
        this.originalInnerClassPrimaryConstructorByClass = mapping.getOriginalInnerClassPrimaryConstructorByClass();
    }

    @Override
    @NotNull
    public IrField getOuterThisField(@NotNull IrClass innerClass) {
        Intrinsics.checkNotNullParameter((Object)innerClass, (String)"innerClass");
        if (!innerClass.isInner()) {
            CompilationExceptionKt.compilationException("Class is not inner", innerClass);
            throw null;
        }
        return MappingsKt.getOrPut(this.outerThisFieldSymbols, (IrDeclaration)innerClass, () -> JsInnerClassesSupport.getOuterThisField$lambda$2(innerClass, this));
    }

    @Override
    @NotNull
    public IrConstructor getInnerClassConstructorWithOuterThisParameter(@NotNull IrConstructor innerClassConstructor) {
        IrConstructor irConstructor;
        Intrinsics.checkNotNullParameter((Object)innerClassConstructor, (String)"innerClassConstructor");
        IrDeclarationParent irDeclarationParent = innerClassConstructor.getParent();
        Intrinsics.checkNotNull((Object)irDeclarationParent, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.ir.declarations.IrClass");
        IrClass innerClass = (IrClass)irDeclarationParent;
        boolean bl = innerClass.isInner();
        if (_Assertions.ENABLED && !bl) {
            boolean $i$a$-assert-JsInnerClassesSupport$getInnerClassConstructorWithOuterThisParameter$22 = false;
            String $i$a$-assert-JsInnerClassesSupport$getInnerClassConstructorWithOuterThisParameter$22 = "Class is not inner: " + innerClass;
            throw new AssertionError((Object)$i$a$-assert-JsInnerClassesSupport$getInnerClassConstructorWithOuterThisParameter$22);
        }
        IrConstructor it = irConstructor = MappingsKt.getOrPut(this.innerClassConstructors, (IrDeclaration)innerClassConstructor, () -> JsInnerClassesSupport.getInnerClassConstructorWithOuterThisParameter$lambda$4(this, innerClassConstructor));
        boolean bl2 = false;
        if (innerClassConstructor.isPrimary()) {
            this.originalInnerClassPrimaryConstructorByClass.set((IrClass)((IrDeclaration)innerClass), innerClassConstructor);
        }
        return irConstructor;
    }

    @Override
    @Nullable
    public IrConstructor getInnerClassOriginalPrimaryConstructorOrNull(@NotNull IrClass innerClass) {
        Intrinsics.checkNotNullParameter((Object)innerClass, (String)"innerClass");
        boolean bl = innerClass.isInner();
        if (_Assertions.ENABLED && !bl) {
            boolean bl2 = false;
            String string2 = "Class is not inner: " + innerClass;
            throw new AssertionError((Object)string2);
        }
        return this.originalInnerClassPrimaryConstructorByClass.get((IrClass)((IrDeclaration)innerClass));
    }

    /*
     * WARNING - void declaration
     */
    private final IrConstructor createInnerClassConstructorWithOuterThisParameter(IrConstructor oldConstructor) {
        void $this$createInnerClassConstructorWithOuterThisParameter_u24lambda_u249;
        IrDeclarationParent irDeclarationParent = oldConstructor.getParent();
        Intrinsics.checkNotNull((Object)irDeclarationParent, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.ir.declarations.IrClass");
        IrClass irClass = (IrClass)irDeclarationParent;
        IrDeclarationParent irDeclarationParent2 = irClass.getParent();
        Intrinsics.checkNotNull((Object)irDeclarationParent2, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.ir.declarations.IrClass");
        IrSimpleType outerThisType = IrUtilsKt.getDefaultType((IrClass)irDeclarationParent2);
        Object $this$buildConstructor$iv = this.irFactory;
        boolean $i$f$buildConstructor = false;
        IrFunctionBuilder $this$buildConstructor_u24lambda_u2424$iv = new IrFunctionBuilder();
        boolean bl = false;
        IrFunctionBuilder $this$createInnerClassConstructorWithOuterThisParameter_u24lambda_u247 = $this$buildConstructor_u24lambda_u2424$iv;
        boolean $i$a$-buildConstructor-JsInnerClassesSupport$createInnerClassConstructorWithOuterThisParameter$newConstructor$22 = false;
        $this$createInnerClassConstructorWithOuterThisParameter_u24lambda_u247.updateFrom(oldConstructor);
        $this$createInnerClassConstructorWithOuterThisParameter_u24lambda_u247.setReturnType(oldConstructor.getReturnType());
        Object it = $this$buildConstructor$iv = DeclarationBuildersKt.buildConstructor((IrFactory)$this$buildConstructor$iv, $this$buildConstructor_u24lambda_u2424$iv);
        boolean bl2 = false;
        ((IrDeclarationBase)it).setParent(oldConstructor.getParent());
        it.setAnnotations(oldConstructor.getAnnotations());
        Object newConstructor = $this$buildConstructor$iv;
        IrUtilsKt.copyTypeParametersFrom$default((IrTypeParametersContainer)newConstructor, oldConstructor, null, null, 6, null);
        IrValueParameter[] irValueParameterArray = new IrValueParameter[1];
        boolean $i$f$buildValueParameter = false;
        IrValueParameterBuilder $this$buildValueParameter_u24lambda_u2430$iv = new IrValueParameterBuilder();
        boolean bl3 = false;
        IrValueParameterBuilder $i$a$-buildConstructor-JsInnerClassesSupport$createInnerClassConstructorWithOuterThisParameter$newConstructor$22 = $this$buildValueParameter_u24lambda_u2430$iv;
        int n = 0;
        Object[] objectArray = irValueParameterArray;
        boolean bl4 = false;
        $this$createInnerClassConstructorWithOuterThisParameter_u24lambda_u249.setOrigin(JsIrBuilder.INSTANCE.getSYNTHESIZED_DECLARATION());
        $this$createInnerClassConstructorWithOuterThisParameter_u24lambda_u249.setName(Name.identifier(Namer.INSTANCE.getOUTER_NAME()));
        $this$createInnerClassConstructorWithOuterThisParameter_u24lambda_u249.setIndex(0);
        $this$createInnerClassConstructorWithOuterThisParameter_u24lambda_u249.setType(outerThisType);
        Unit unit = Unit.INSTANCE;
        objectArray[n] = DeclarationBuildersKt.buildValueParameter(((IrDeclaration)newConstructor).getFactory(), $this$buildValueParameter_u24lambda_u2430$iv, (IrDeclarationParent)((Object)((IrDeclaration)newConstructor)));
        List newValueParameters = CollectionsKt.mutableListOf((Object[])irValueParameterArray);
        for (IrValueParameter p : oldConstructor.getValueParameters()) {
            ((Collection)newValueParameters).add(IrUtilsKt.copyTo$default(p, (IrFunction)newConstructor, null, p.getIndex() + 1, 0, 0, null, null, null, null, null, false, false, false, 8186, null));
        }
        ((IrFunction)newConstructor).setValueParameters(MemoryOptimizedCollectionUtilKt.memoryOptimizedPlus(((IrFunction)newConstructor).getValueParameters(), newValueParameters));
        return newConstructor;
    }

    private static final IrField getOuterThisField$lambda$2(IrClass $innerClass, JsInnerClassesSupport this$0) {
        IrField irField;
        IrDeclarationParent irDeclarationParent = $innerClass.getParent();
        IrClass irClass = irDeclarationParent instanceof IrClass ? (IrClass)irDeclarationParent : null;
        if (irClass == null) {
            CompilationExceptionKt.compilationException("No containing class for inner class", $innerClass);
            throw null;
        }
        IrClass outerClass = irClass;
        IrFactory $this$buildField$iv = this$0.irFactory;
        boolean $i$f$buildField = false;
        IrFieldBuilder $this$buildField_u24lambda_u244$iv = new IrFieldBuilder();
        boolean bl = false;
        IrFieldBuilder $this$getOuterThisField_u24lambda_u242_u24lambda_u240 = $this$buildField_u24lambda_u244$iv;
        boolean bl2 = false;
        $this$getOuterThisField_u24lambda_u242_u24lambda_u240.setOrigin(IrDeclarationOrigin.Companion.getFIELD_FOR_OUTER_THIS());
        $this$getOuterThisField_u24lambda_u242_u24lambda_u240.setName(Name.identifier(Namer.INSTANCE.getSYNTHETIC_RECEIVER_NAME()));
        $this$getOuterThisField_u24lambda_u242_u24lambda_u240.setType(IrUtilsKt.getDefaultType(outerClass));
        $this$getOuterThisField_u24lambda_u242_u24lambda_u240.setVisibility(DescriptorVisibilities.PROTECTED);
        $this$getOuterThisField_u24lambda_u242_u24lambda_u240.setFinal(true);
        $this$getOuterThisField_u24lambda_u242_u24lambda_u240.setExternal(false);
        $this$getOuterThisField_u24lambda_u242_u24lambda_u240.setStatic(false);
        IrField it = irField = DeclarationBuildersKt.buildField($this$buildField$iv, $this$buildField_u24lambda_u244$iv);
        boolean bl3 = false;
        it.setParent($innerClass);
        return irField;
    }

    private static final IrConstructor getInnerClassConstructorWithOuterThisParameter$lambda$4(JsInnerClassesSupport this$0, IrConstructor $innerClassConstructor) {
        return this$0.createInnerClassConstructorWithOuterThisParameter($innerClassConstructor);
    }
}

