/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Color;
import java.awt.Font;
import java.awt.GraphicsEnvironment;
import java.util.Random;
import javax.swing.tree.DefaultMutableTreeNode;

public class DynamicTreeNode
extends DefaultMutableTreeNode {
    protected static float nameCount;
    protected static final String[] NAMES;
    protected static Font[] fonts;
    protected static Random nameGen;
    protected static final int DEFAULT_CHILDREN_COUNT = 7;
    protected boolean hasLoaded;

    public DynamicTreeNode(Object object) {
        super(object);
    }

    @Override
    public boolean isLeaf() {
        return false;
    }

    @Override
    public int getChildCount() {
        if (!this.hasLoaded) {
            this.loadChildren();
        }
        return super.getChildCount();
    }

    protected void loadChildren() {
        for (int i = 0; i < 7; ++i) {
            int n = (int)(nameGen.nextFloat() * nameCount);
            String string = NAMES[n];
            Font font = fonts == null || fonts[n].canDisplayUpTo(string) != -1 ? null : fonts[n];
            SampleData sampleData = i % 2 == 0 ? new SampleData(font, Color.red, string) : new SampleData(font, Color.blue, string);
            DynamicTreeNode dynamicTreeNode = new DynamicTreeNode(sampleData);
            this.insert(dynamicTreeNode, i);
        }
        this.hasLoaded = true;
    }

    static {
        String[] stringArray;
        try {
            stringArray = GraphicsEnvironment.getLocalGraphicsEnvironment().getAvailableFontFamilyNames();
        }
        catch (Exception exception) {
            stringArray = null;
        }
        if (stringArray == null || stringArray.length == 0) {
            NAMES = new String[]{"Mark Andrews", "Tom Ball", "Alan Chung", "Rob Davis", "Jeff Dinkins", "Amy Fowler", "James Gosling", "David Karlton", "Dave Kloba", "Dave Moore", "Hans Muller", "Rick Levenson", "Tim Prinzing", "Chester Rose", "Ray Ryan", "Georges Saab", "Scott Violet", "Kathy Walrath", "Arnaud Weber"};
        } else {
            int n = 12;
            NAMES = stringArray;
            fonts = new Font[NAMES.length];
            int n2 = NAMES.length;
            for (int i = 0; i < n2; ++i) {
                try {
                    DynamicTreeNode.fonts[i] = new Font(stringArray[i], 0, n);
                }
                catch (Exception exception) {
                    DynamicTreeNode.fonts[i] = null;
                }
                n = (n + 2 - 12) % 12 + 12;
            }
        }
        nameCount = NAMES.length;
        nameGen = new Random(System.currentTimeMillis());
    }
}

