/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.search.matcher;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.channels.spi.AbstractInterruptibleChannel;
import java.nio.charset.Charset;
import java.util.LinkedList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.netbeans.api.search.SearchPattern;
import org.netbeans.api.search.provider.SearchListener;
import org.netbeans.modules.search.Constants;
import org.netbeans.modules.search.MatchingObject;
import org.netbeans.modules.search.TextDetail;
import org.netbeans.modules.search.TextRegexpUtil;
import org.netbeans.modules.search.matcher.AbstractMatcher;
import org.netbeans.modules.search.matcher.MatcherUtils;
import org.netbeans.modules.search.matcher.MultiLineMappedMatcherSmall;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;

public class AsciiMultiLineMappedMatcher
extends AbstractMatcher {
    private SearchPattern searchPattern;
    private Pattern pattern;
    private int fileMatches = 0;
    private int itemMatches = 0;

    public AsciiMultiLineMappedMatcher(SearchPattern searchPattern) {
        this.searchPattern = searchPattern;
        this.pattern = TextRegexpUtil.makeTextPattern(searchPattern);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected MatchingObject.Def checkMeasuredInternal(FileObject fileObject, SearchListener searchListener) {
        MatchingObject.Def def;
        AbstractInterruptibleChannel abstractInterruptibleChannel;
        MappedByteBuffer mappedByteBuffer;
        block18: {
            block19: {
                MatchingObject.Def def2;
                block16: {
                    block17: {
                        FileInputStream fileInputStream;
                        mappedByteBuffer = null;
                        abstractInterruptibleChannel = null;
                        try {
                            searchListener.fileContentMatchingStarted(fileObject.getPath());
                            File file = FileUtil.toFile((FileObject)fileObject);
                            fileInputStream = new FileInputStream(file);
                            abstractInterruptibleChannel = fileInputStream.getChannel();
                            int n = (int)((FileChannel)abstractInterruptibleChannel).size();
                            mappedByteBuffer = ((FileChannel)abstractInterruptibleChannel).map(FileChannel.MapMode.READ_ONLY, 0L, n);
                            List<TextDetail> list = this.matchWholeFile(new FastCharSequence(mappedByteBuffer, 0), fileObject);
                            if (list != null && !list.isEmpty()) {
                                def2 = new MatchingObject.Def(fileObject, Charset.forName("ASCII"), list);
                                if (abstractInterruptibleChannel == null) break block16;
                                break block17;
                            }
                            def = null;
                            if (abstractInterruptibleChannel == null) break block18;
                            break block19;
                        }
                        catch (Exception exception) {
                            searchListener.generalError(exception);
                            fileInputStream = null;
                            return fileInputStream;
                        }
                    }
                    try {
                        abstractInterruptibleChannel.close();
                    }
                    catch (IOException iOException) {
                        searchListener.generalError(iOException);
                    }
                }
                MatcherUtils.unmap(mappedByteBuffer);
                return def2;
            }
            try {
                abstractInterruptibleChannel.close();
            }
            catch (IOException iOException) {
                searchListener.generalError(iOException);
            }
        }
        MatcherUtils.unmap(mappedByteBuffer);
        return def;
        finally {
            if (abstractInterruptibleChannel != null) {
                try {
                    abstractInterruptibleChannel.close();
                }
                catch (IOException iOException) {
                    searchListener.generalError(iOException);
                }
            }
            MatcherUtils.unmap(mappedByteBuffer);
        }
    }

    private List<TextDetail> matchWholeFile(CharSequence charSequence, FileObject fileObject) throws DataObjectNotFoundException {
        Matcher matcher = this.pattern.matcher(charSequence);
        DataObject dataObject = null;
        MultiLineMappedMatcherSmall.LineInfoHelper lineInfoHelper = new MultiLineMappedMatcherSmall.LineInfoHelper(charSequence);
        LinkedList<TextDetail> linkedList = null;
        while (matcher.find()) {
            if (linkedList == null) {
                linkedList = new LinkedList<TextDetail>();
                dataObject = DataObject.find((FileObject)fileObject);
                ++this.fileMatches;
            }
            ++this.itemMatches;
            TextDetail textDetail = new TextDetail(dataObject, this.searchPattern);
            lineInfoHelper.findAndSetPositionInfo(textDetail, matcher.start(), matcher.end(), matcher.group());
            linkedList.add(textDetail);
            if (this.fileMatches < Constants.COUNT_LIMIT && this.itemMatches < Constants.DETAILS_COUNT_LIMIT) continue;
            break;
        }
        return linkedList;
    }

    @Override
    public void terminate() {
    }

    private class FastCharSequence
    implements CharSequence {
        private ByteBuffer bb;
        private int start;

        public FastCharSequence(ByteBuffer byteBuffer, int n) {
            this.bb = byteBuffer;
            this.start = n;
        }

        @Override
        public int length() {
            return this.bb.limit();
        }

        @Override
        public char charAt(int n) {
            return (char)this.bb.get(this.start + n);
        }

        @Override
        public CharSequence subSequence(int n, int n2) {
            StringBuilder stringBuilder = new StringBuilder();
            for (int i = n; i < n2; ++i) {
                stringBuilder.append(this.charAt(i));
            }
            return stringBuilder.toString();
        }
    }
}

