/*
 * Decompiled with CFR 0.152.
 */
package com.thaiopensource.relaxng.impl;

import com.thaiopensource.relaxng.impl.DataDerivType;
import com.thaiopensource.relaxng.impl.InconsistentDataDerivType;
import com.thaiopensource.relaxng.impl.Pattern;
import com.thaiopensource.relaxng.impl.PatternMemo;
import com.thaiopensource.relaxng.impl.PatternValidator;
import com.thaiopensource.relaxng.impl.ValidatorPatternBuilder;
import com.thaiopensource.relaxng.impl.ValueDataDerivType;
import org.relaxng.datatype.Datatype;
import org.relaxng.datatype.DatatypeException;
import org.relaxng.datatype.ValidationContext;

class DataDataDerivType
extends DataDerivType {
    private final Datatype dt;
    private PatternMemo validMemo;
    private PatternMemo invalidMemo;

    DataDataDerivType(Datatype datatype) {
        this.dt = datatype;
    }

    @Override
    PatternMemo dataDeriv(ValidatorPatternBuilder validatorPatternBuilder, Pattern pattern, String string, ValidationContext validationContext) {
        try {
            this.dt.checkValid(string, validationContext);
            if (this.validMemo == null) {
                this.validMemo = super.dataDeriv(validatorPatternBuilder, pattern, string, validationContext);
            }
            return this.validMemo;
        }
        catch (DatatypeException datatypeException) {
            String string2 = datatypeException.getMessage();
            if (string2 != null && !"".equals(string2) && validationContext instanceof PatternValidator) {
                PatternValidator patternValidator = (PatternValidator)validationContext;
                patternValidator.addDatatypeError(string2, datatypeException);
            }
            if (this.invalidMemo == null) {
                this.invalidMemo = super.dataDeriv(validatorPatternBuilder, pattern, string, validationContext);
            }
            return this.invalidMemo;
        }
    }

    @Override
    DataDerivType copy() {
        return new DataDataDerivType(this.dt);
    }

    @Override
    DataDerivType combine(DataDerivType dataDerivType) {
        if (dataDerivType instanceof DataDataDerivType) {
            if (((DataDataDerivType)dataDerivType).dt == this.dt) {
                return this;
            }
            return InconsistentDataDerivType.getInstance();
        }
        if (dataDerivType instanceof ValueDataDerivType) {
            if (((ValueDataDerivType)dataDerivType).getDatatype() == this.dt) {
                return dataDerivType;
            }
            return InconsistentDataDerivType.getInstance();
        }
        return dataDerivType.combine(this);
    }
}

