/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.om;

import net.sf.saxon.om.FastStringBuffer;

public class ProcInstParser {
    private ProcInstParser() {
    }

    public static String getPseudoAttribute(String content, String name) {
        int pos = 0;
        while (pos <= content.length() - 4) {
            int nextQuote = -1;
            for (int q = pos; q < content.length(); ++q) {
                if (content.charAt(q) != '\"' && content.charAt(q) != '\'') continue;
                nextQuote = q;
                break;
            }
            if (nextQuote < 0) {
                return null;
            }
            int closingQuote = content.indexOf(content.charAt(nextQuote), nextQuote + 1);
            if (closingQuote < 0) {
                return null;
            }
            int nextName = content.indexOf(name, pos);
            if (nextName < 0) {
                return null;
            }
            if (nextName < nextQuote) {
                boolean found = true;
                for (int s = nextName + name.length(); s < nextQuote; ++s) {
                    char c = content.charAt(s);
                    if (Character.isWhitespace(c) || c == '=') continue;
                    found = false;
                    break;
                }
                if (found) {
                    String val = content.substring(nextQuote + 1, closingQuote);
                    return ProcInstParser.unescape(val);
                }
            }
            pos = closingQuote + 1;
        }
        return null;
    }

    private static String unescape(String value) {
        if (value.indexOf(38) < 0) {
            return value;
        }
        FastStringBuffer sb = new FastStringBuffer(value.length());
        for (int i = 0; i < value.length(); ++i) {
            char c = value.charAt(i);
            if (c == '&') {
                if (i + 2 < value.length() && value.charAt(i + 1) == '#') {
                    int digit;
                    int x;
                    int charval;
                    if (value.charAt(i + 2) == 'x') {
                        charval = 0;
                        for (x = i + 3; x < value.length() && value.charAt(x) != ';'; ++x) {
                            digit = "0123456789abcdef".indexOf(value.charAt(x));
                            if (digit < 0) {
                                digit = "0123456789ABCDEF".indexOf(value.charAt(x));
                            }
                            if (digit < 0) {
                                return null;
                            }
                            charval = charval * 16 + digit;
                        }
                        char hexchar = (char)charval;
                        sb.append(hexchar);
                        i = x;
                        continue;
                    }
                    charval = 0;
                    for (x = i + 2; x < value.length() && value.charAt(x) != ';'; ++x) {
                        digit = "0123456789".indexOf(value.charAt(x));
                        if (digit < 0) {
                            return null;
                        }
                        charval = charval * 10 + digit;
                    }
                    char decchar = (char)charval;
                    sb.append(decchar);
                    i = x;
                    continue;
                }
                if (value.substring(i + 1).startsWith("lt;")) {
                    sb.append('<');
                    i += 3;
                    continue;
                }
                if (value.substring(i + 1).startsWith("gt;")) {
                    sb.append('>');
                    i += 3;
                    continue;
                }
                if (value.substring(i + 1).startsWith("amp;")) {
                    sb.append('&');
                    i += 4;
                    continue;
                }
                if (value.substring(i + 1).startsWith("quot;")) {
                    sb.append('\"');
                    i += 5;
                    continue;
                }
                if (value.substring(i + 1).startsWith("apos;")) {
                    sb.append('\'');
                    i += 5;
                    continue;
                }
                return null;
            }
            sb.append(c);
        }
        return sb.toString();
    }
}

