/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.style;

import javax.xml.transform.TransformerConfigurationException;
import net.sf.saxon.Configuration;
import net.sf.saxon.PreparedStylesheet;
import net.sf.saxon.event.PipelineConfiguration;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.instruct.Executable;
import net.sf.saxon.om.AttributeCollection;
import net.sf.saxon.om.AxisIterator;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.style.StyleElement;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.SchemaException;
import net.sf.saxon.value.Whitespace;

public class XSLImportSchema
extends StyleElement {
    public void prepareAttributes() throws XPathException {
        AttributeCollection atts = this.getAttributeList();
        String namespace = null;
        for (int a = 0; a < atts.getLength(); ++a) {
            int nc = atts.getNameCode(a);
            String f = this.getNamePool().getClarkName(nc);
            if (f.equals("schema-location")) continue;
            if (f.equals("namespace")) {
                namespace = Whitespace.trim(atts.getValue(a));
                continue;
            }
            this.checkUnknownAttribute(nc);
        }
        if ("".equals(namespace)) {
            this.compileError("The zero-length string is not a valid namespace URI. For a schema with no namespace, omit the namespace attribute");
        }
    }

    public void validate() throws XPathException {
        this.checkTopLevel(null);
    }

    public void readSchema() throws SchemaException, XPathException {
        try {
            Item child;
            String schemaLoc = Whitespace.trim(this.getAttributeValue("schema-location"));
            String namespace = Whitespace.trim(this.getAttributeValue("namespace"));
            namespace = namespace == null ? "" : namespace.trim();
            PreparedStylesheet preparedStylesheet = this.getPreparedStylesheet();
            Configuration config = preparedStylesheet.getConfiguration();
            if (!config.isSchemaAware(50)) {
                this.compileError("To use xsl:import-schema, you need the schema-aware version of Saxon from http://www.saxonica.com/", "XTSE1650");
                return;
            }
            AxisIterator kids = this.iterateAxis((byte)3);
            NodeInfo inlineSchema = null;
            while ((child = kids.next()) != null) {
                if (inlineSchema != null) {
                    this.compileError(this.getDisplayName() + " must not have more than one child element");
                }
                if ((inlineSchema = (NodeInfo)child).getFingerprint() != 620) {
                    this.compileError("The only child element permitted for " + this.getDisplayName() + " is xs:schema");
                }
                if (schemaLoc != null) {
                    this.compileError("The schema-location attribute must be absent if an inline schema is present");
                }
                namespace = config.readInlineSchema(inlineSchema, namespace, preparedStylesheet.getErrorListener());
                this.getPrincipalStylesheet().addImportedSchema(namespace);
            }
            if (inlineSchema != null) {
                return;
            }
            if (!config.isSchemaAvailable(namespace)) {
                if (schemaLoc == null) {
                    this.compileWarning("No schema for this namespace is known, and no schema-location was supplied, so no schema has been imported", "SXWN9006");
                    return;
                }
                PipelineConfiguration pipe = config.makePipelineConfiguration();
                namespace = config.readSchema(pipe, this.getBaseURI(), schemaLoc, namespace);
            }
            this.getPrincipalStylesheet().addImportedSchema(namespace);
        }
        catch (SchemaException err) {
            this.compileError(err.getMessage(), "XTSE0220");
        }
        catch (TransformerConfigurationException err) {
            this.compileError(err.getMessage(), "XTSE0220");
        }
    }

    public Expression compile(Executable exec) throws XPathException {
        exec.setReasonUnableToCompile("Cannot compile a stylesheet that imports a schema");
        return null;
    }
}

