/*
 * Decompiled with CFR 0.152.
 */
package org.w3c.css.values;

import java.util.ArrayList;
import org.w3c.css.properties.css3.CssColor;
import org.w3c.css.util.ApplContext;
import org.w3c.css.util.InvalidParamException;
import org.w3c.css.values.CssExpression;
import org.w3c.css.values.CssIdent;
import org.w3c.css.values.CssValue;
import org.w3c.css.values.CssValueList;

public class ColorMix {
    public static final CssIdent in = CssIdent.getIdent("in");
    public static final CssIdent hue = CssIdent.getIdent("hue");
    public static final CssIdent[] rectangularColorSpaceValues;
    public static final CssIdent[] polarColorSpaceValues;
    public static final CssIdent[] hueInterpolationMethodModifiers;
    String output = null;
    ArrayList<CssValue> color_percentages = new ArrayList();
    CssValue color_interpolation_method = null;
    boolean has_css_variable = false;

    public static final CssIdent getAllowedValue(CssIdent ident, CssIdent[] allowedValues) {
        for (CssIdent id : allowedValues) {
            if (!id.equals(ident)) continue;
            return id;
        }
        return null;
    }

    public static CssValue parseColorInterpolationMethod(ApplContext ac, CssExpression exp, CssValue caller) throws InvalidParamException {
        if (exp.getCount() < 2 || exp.getCount() > 4) {
            throw new InvalidParamException("unrecognize", ac);
        }
        CssValue val = exp.getValue();
        char op = exp.getOperator();
        if (val.getType() != 0) {
            throw new InvalidParamException("value", val.toString(), caller, ac);
        }
        CssIdent id = val.getIdent();
        if (!in.equals(id)) {
            throw new InvalidParamException("value", val.toString(), caller, ac);
        }
        ArrayList<CssValue> values = new ArrayList<CssValue>(4);
        values.add(val);
        if (op != ' ') {
            throw new InvalidParamException("operator", Character.toString(op), ac);
        }
        exp.next();
        val = exp.getValue();
        op = exp.getOperator();
        if (val.getType() != 0) {
            throw new InvalidParamException("value", val.toString(), caller, ac);
        }
        id = val.getIdent();
        CssIdent res = ColorMix.getAllowedValue(id, rectangularColorSpaceValues);
        if (res != null) {
            values.add(val);
            exp.next();
            if (!exp.end()) {
                throw new InvalidParamException("unrecognize", ac);
            }
            return new CssValueList(values);
        }
        res = ColorMix.getAllowedValue(id, polarColorSpaceValues);
        if (res != null) {
            values.add(val);
            if (op != ' ') {
                throw new InvalidParamException("operator", Character.toString(op), ac);
            }
            exp.next();
            if (exp.end()) {
                return new CssValueList(values);
            }
            val = exp.getValue();
            op = exp.getOperator();
            if (val.getType() == 0) {
                id = val.getIdent();
                if (ColorMix.getAllowedValue(id, hueInterpolationMethodModifiers) != null) {
                    values.add(val);
                }
                if (op != ' ') {
                    throw new InvalidParamException("operator", Character.toString(op), ac);
                }
                exp.next();
                val = exp.getValue();
                if (hue.equals(val.getIdent())) {
                    values.add(val);
                    exp.next();
                    if (!exp.end()) {
                        throw new InvalidParamException("unrecognize", ac);
                    }
                    return new CssValueList(values);
                }
            }
            throw new InvalidParamException("value", val.toString(), caller, ac);
        }
        if (id.toString().startsWith("--")) {
            values.add(val);
            if (!exp.end()) {
                throw new InvalidParamException("unrecognize", ac);
            }
            return new CssValueList(values);
        }
        throw new InvalidParamException("unrecognize", ac);
    }

    public static CssValue parseColorPercentageValue(ApplContext ac, CssExpression exp, CssValue caller) throws InvalidParamException {
        CssColor css3Color;
        CssExpression e;
        if (exp.getCount() > 2) {
            throw new InvalidParamException("unrecognize", ac);
        }
        ArrayList<CssValue> values = new ArrayList<CssValue>(2);
        boolean gotPercentage = false;
        CssValue val = exp.getValue();
        char op = exp.getOperator();
        if (val.getType() == 4) {
            gotPercentage = true;
            values.add(val);
        } else {
            e = new CssExpression();
            e.addValue(val);
            css3Color = new CssColor(ac, e);
            values.add(css3Color.getColor());
        }
        exp.next();
        if (!exp.end()) {
            if (op != ' ') {
                throw new InvalidParamException("operator", Character.toString(op), ac);
            }
            val = exp.getValue();
            if (val.getType() == 4) {
                if (gotPercentage) {
                    throw new InvalidParamException("value", val.toString(), caller, ac);
                }
                values.add(val);
            } else {
                if (!gotPercentage) {
                    throw new InvalidParamException("value", val.toString(), caller, ac);
                }
                e = new CssExpression();
                e.addValue(val);
                css3Color = new CssColor(ac, e);
                values.add(css3Color.getColor());
            }
            exp.next();
        }
        return values.size() == 1 ? (CssValue)values.get(0) : new CssValueList(values);
    }

    public final void addColorPercentageValue(ApplContext ac, CssExpression exp, CssValue caller) throws InvalidParamException {
        this.color_percentages.add(ColorMix.parseColorPercentageValue(ac, exp, caller));
    }

    public final void setColorInterpolationMethod(ApplContext ac, CssExpression exp, CssValue caller) throws InvalidParamException {
        this.color_interpolation_method = ColorMix.parseColorInterpolationMethod(ac, exp, caller);
    }

    public boolean equals(ColorMix other) {
        if (other != null) {
            // empty if block
        }
        return false;
    }

    public String toString() {
        if (this.output == null) {
            StringBuilder sb = new StringBuilder("color-mix(");
            boolean isFirst = true;
            if (this.color_interpolation_method != null) {
                sb.append(this.color_interpolation_method);
                isFirst = false;
            }
            for (CssValue v : this.color_percentages) {
                if (!isFirst) {
                    sb.append(", ");
                } else {
                    isFirst = false;
                }
                sb.append(v);
            }
            sb.append(')');
            this.output = sb.toString();
        }
        return this.output;
    }

    static {
        String[] _rectangularColorSpaceValues = new String[]{"srgb", "srgb-linear", "display-p3", "a98-rgb", "prophoto-rgb", "rec2020", "lab", "oklab", "xyz", "xyz-d50", "xyz-d65"};
        rectangularColorSpaceValues = new CssIdent[_rectangularColorSpaceValues.length];
        for (int i = 0; i < _rectangularColorSpaceValues.length; ++i) {
            ColorMix.rectangularColorSpaceValues[i] = CssIdent.getIdent(_rectangularColorSpaceValues[i]);
        }
        String[] _polarColorSpaceValues = new String[]{"hsl", "hwb", "lch", "oklch"};
        polarColorSpaceValues = new CssIdent[_polarColorSpaceValues.length];
        for (int i = 0; i < _polarColorSpaceValues.length; ++i) {
            ColorMix.polarColorSpaceValues[i] = CssIdent.getIdent(_polarColorSpaceValues[i]);
        }
        String[] _hueInterpolationMethodModifiers = new String[]{"shorter", "longer", "increasing", "decreasing"};
        hueInterpolationMethodModifiers = new CssIdent[_hueInterpolationMethodModifiers.length];
        for (int i = 0; i < _hueInterpolationMethodModifiers.length; ++i) {
            ColorMix.hueInterpolationMethodModifiers[i] = CssIdent.getIdent(_hueInterpolationMethodModifiers[i]);
        }
    }
}

