/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.compiler.plugins.kotlin.analysis;

import androidx.compose.compiler.plugins.kotlin.analysis.FqNameMatcher;
import androidx.compose.compiler.plugins.kotlin.analysis.StabilityConfigParser;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0015\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u001e\u0010\f\u001a\u00020\u00042\u0006\u0010\r\u001a\u00020\u00042\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0004R\u001a\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0011"}, d2={"Landroidx/compose/compiler/plugins/kotlin/analysis/StabilityConfigParserImpl;", "Landroidx/compose/compiler/plugins/kotlin/analysis/StabilityConfigParser;", "lines", "", "", "<init>", "(Ljava/util/List;)V", "stableTypeMatchers", "", "Landroidx/compose/compiler/plugins/kotlin/analysis/FqNameMatcher;", "getStableTypeMatchers", "()Ljava/util/Set;", "errorMessage", "line", "lineNumber", "", "message", "compiler-hosted"})
@SourceDebugExtension(value={"SMAP\nStabilityConfigParser.kt\nKotlin\n*S Kotlin\n*F\n+ 1 StabilityConfigParser.kt\nandroidx/compose/compiler/plugins/kotlin/analysis/StabilityConfigParserImpl\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,81:1\n1872#2,3:82\n*S KotlinDebug\n*F\n+ 1 StabilityConfigParser.kt\nandroidx/compose/compiler/plugins/kotlin/analysis/StabilityConfigParserImpl\n*L\n48#1:82,3\n*E\n"})
final class StabilityConfigParserImpl
implements StabilityConfigParser {
    @NotNull
    private final Set<FqNameMatcher> stableTypeMatchers;

    /*
     * WARNING - void declaration
     */
    public StabilityConfigParserImpl(@NotNull List<String> lines) {
        Intrinsics.checkNotNullParameter(lines, (String)"lines");
        Set matchers = new LinkedHashSet();
        Iterable $this$forEachIndexed$iv = lines;
        boolean $i$f$forEachIndexed = false;
        int index$iv = 0;
        for (Object item$iv : $this$forEachIndexed$iv) {
            void line;
            int n;
            if ((n = index$iv++) < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            String string = (String)item$iv;
            int index = n;
            boolean bl = false;
            String l = ((Object)StringsKt.trim((CharSequence)((CharSequence)line))).toString();
            if (StringsKt.startsWith$default((String)l, (String)"//", (boolean)false, (int)2, null) || StringsKt.isBlank((CharSequence)l)) continue;
            if (StringsKt.contains$default((CharSequence)l, (CharSequence)"//", (boolean)false, (int)2, null)) {
                throw new IllegalStateException(this.errorMessage((String)line, index, "Comments are only supported at the start of a line.").toString());
            }
            try {
                matchers.add(new FqNameMatcher(l));
            }
            catch (IllegalStateException exception) {
                String string2 = exception.getMessage();
                if (string2 == null) {
                    string2 = "";
                }
                String string3 = this.errorMessage((String)line, index, string2);
                throw new IllegalStateException(string3.toString());
            }
        }
        this.stableTypeMatchers = CollectionsKt.toSet((Iterable)matchers);
    }

    @Override
    @NotNull
    public Set<FqNameMatcher> getStableTypeMatchers() {
        return this.stableTypeMatchers;
    }

    @NotNull
    public final String errorMessage(@NotNull String line, int lineNumber, @NotNull String message) {
        Intrinsics.checkNotNullParameter((Object)line, (String)"line");
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        return StringsKt.trimIndent((String)("\n            Error parsing stability configuration file on line " + lineNumber + ".\n            " + message + "\n            " + line + "\n        "));
    }
}

