/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.rt.debugger.agent;

import com.intellij.rt.debugger.agent.CaptureAgent;
import com.intellij.rt.debugger.agent.CollectionBreakpointInstrumentor;
import com.intellij.rt.debugger.agent.SharedFlowTransformer;
import com.intellij.rt.debugger.agent.StateFlowTransformer;
import com.intellij.rt.debugger.agent.SuspendHelper;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.lang.instrument.Instrumentation;
import java.net.URI;
import java.util.Properties;

public class DebuggerAgent {
    public static void premain(String args, Instrumentation instrumentation) {
        if (DebuggerAgent.class.getClassLoader() != null) {
            System.err.println("Debugger agent: agent should be loaded by bootstrap classloader, check jar name and 'Boot-Class-Path' value in the manifest");
            return;
        }
        if (System.getProperty("intellij.debug.agent") != null) {
            System.err.println("Debugger agent: more than one agent is not allowed, skipping");
            return;
        }
        System.setProperty("intellij.debug.agent", "true");
        DebuggerAgent.readAndApplyProperties(args, instrumentation);
    }

    private static void initAll(Instrumentation instrumentation, Properties properties) {
        DebuggerAgent.initSharedFlowTransformer(instrumentation);
        CaptureAgent.init(properties, instrumentation);
        SuspendHelper.init(properties);
        CollectionBreakpointInstrumentor.init(instrumentation);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void readAndApplyProperties(String uri, Instrumentation instrumentation) {
        Properties properties = new Properties();
        File file = null;
        if (uri != null && !uri.isEmpty()) {
            try (InputStream stream = null;){
                file = new File(new URI(uri));
                stream = new FileInputStream(file);
                properties.load(stream);
            }
            catch (Exception e) {
                System.out.println("Capture agent: unable to read settings");
                e.printStackTrace();
            }
        }
        DebuggerAgent.initAll(instrumentation, properties);
        if (Boolean.parseBoolean(properties.getProperty("deleteSettings", "true")) && file != null) {
            file.delete();
        }
    }

    private static void initSharedFlowTransformer(Instrumentation instrumentation) {
        if (Boolean.getBoolean("debugger.agent.enable.coroutines") && Boolean.getBoolean("kotlinx.coroutines.debug.enable.flows.stack.trace")) {
            instrumentation.addTransformer(new SharedFlowTransformer(), true);
            if (Boolean.getBoolean("kotlinx.coroutines.debug.enable.mutable.state.flows.stack.trace")) {
                instrumentation.addTransformer(new StateFlowTransformer(), true);
            }
        }
    }
}

