/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.incremental;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.incremental.AbiSnapshot;
import org.jetbrains.kotlin.incremental.BuildUtilKt;
import org.jetbrains.kotlin.incremental.ClassProtoData;
import org.jetbrains.kotlin.incremental.Difference;
import org.jetbrains.kotlin.incremental.DifferenceCalculatorForClass;
import org.jetbrains.kotlin.incremental.DifferenceCalculatorForPackageFacade;
import org.jetbrains.kotlin.incremental.DirtyData;
import org.jetbrains.kotlin.incremental.IncrementalCacheCommon;
import org.jetbrains.kotlin.incremental.LookupSymbol;
import org.jetbrains.kotlin.incremental.PackagePartProtoData;
import org.jetbrains.kotlin.incremental.ProtoCompareGenerated;
import org.jetbrains.kotlin.incremental.ProtoData;
import org.jetbrains.kotlin.metadata.ProtoBuf;
import org.jetbrains.kotlin.metadata.deserialization.Flags;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.resolve.sam.SamConversionResolverKt;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0004\u0018\u0000 \u00042\u00020\u0001:\u0001\u0004B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003\u00a8\u0006\u0005"}, d2={"Lorg/jetbrains/kotlin/incremental/AbiSnapshotDiffService;", "", "<init>", "()V", "Companion", "incremental-compilation-impl"})
public final class AbiSnapshotDiffService {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final Map<Pair<AbiSnapshot, AbiSnapshot>, DirtyData> diffCache = new LinkedHashMap();

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001e\u0010\t\u001a\u00020\b2\u0006\u0010\n\u001a\u00020\u00072\u0006\u0010\u000b\u001a\u00020\u00072\u0006\u0010\f\u001a\u00020\rJ\u001c\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00140\u0013J,\u0010\u0015\u001a\u00020\b2\u0006\u0010\u0016\u001a\u00020\u00072\u0006\u0010\u0017\u001a\u00020\u00072\u0006\u0010\f\u001a\u00020\r2\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00140\u0013J0\u0010\u0018\u001a\u001a\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00110\u0019\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u001a0\u00190\u00062\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002R&\u0010\u0004\u001a\u001a\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00070\u0006\u0012\u0004\u0012\u00020\b0\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001d"}, d2={"Lorg/jetbrains/kotlin/incremental/AbiSnapshotDiffService$Companion;", "", "<init>", "()V", "diffCache", "", "Lkotlin/Pair;", "Lorg/jetbrains/kotlin/incremental/AbiSnapshot;", "Lorg/jetbrains/kotlin/incremental/DirtyData;", "compareJarsInternal", "oldSnapshot", "newSnapshot", "caches", "Lorg/jetbrains/kotlin/incremental/IncrementalCacheCommon;", "inScope", "", "fqName", "Lorg/jetbrains/kotlin/name/FqName;", "scopes", "", "", "doCompute", "snapshot", "actual", "addProtoInfo", "", "Lorg/jetbrains/kotlin/incremental/LookupSymbol;", "protoData", "Lorg/jetbrains/kotlin/incremental/ProtoData;", "incremental-compilation-impl"})
    @SourceDebugExtension(value={"SMAP\nAbiSnapshotDiffService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AbiSnapshotDiffService.kt\norg/jetbrains/kotlin/incremental/AbiSnapshotDiffService$Companion\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,115:1\n1755#2,3:116\n774#2:120\n865#2,2:121\n1557#2:123\n1628#2,3:124\n827#2:127\n855#2,2:128\n1557#2:130\n1628#2,3:131\n1#3:119\n*S KotlinDebug\n*F\n+ 1 AbiSnapshotDiffService.kt\norg/jetbrains/kotlin/incremental/AbiSnapshotDiffService$Companion\n*L\n27#1:116,3\n86#1:120\n86#1:121,2\n101#1:123\n101#1:124,3\n105#1:127\n105#1:128,2\n106#1:130\n106#1:131,3\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final DirtyData compareJarsInternal(@NotNull AbiSnapshot oldSnapshot, @NotNull AbiSnapshot newSnapshot, @NotNull IncrementalCacheCommon caches) {
            Intrinsics.checkNotNullParameter(oldSnapshot, "oldSnapshot");
            Intrinsics.checkNotNullParameter(newSnapshot, "newSnapshot");
            Intrinsics.checkNotNullParameter(caches, "caches");
            DirtyData dirtyData = diffCache.computeIfAbsent(new Pair<AbiSnapshot, AbiSnapshot>(oldSnapshot, newSnapshot), arg_0 -> Companion.compareJarsInternal$lambda$1(arg_0 -> Companion.compareJarsInternal$lambda$0(caches, arg_0), arg_0));
            Intrinsics.checkNotNullExpressionValue(dirtyData, "computeIfAbsent(...)");
            return dirtyData;
        }

        public final boolean inScope(@NotNull FqName fqName, @NotNull Collection<String> scopes) {
            boolean bl;
            block3: {
                Intrinsics.checkNotNullParameter(fqName, "fqName");
                Intrinsics.checkNotNullParameter(scopes, "scopes");
                Iterable $this$any$iv = scopes;
                boolean $i$f$any = false;
                if (((Collection)$this$any$iv).isEmpty()) {
                    bl = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        String scope2 = (String)element$iv;
                        boolean bl2 = false;
                        String string2 = fqName.toString();
                        Intrinsics.checkNotNullExpressionValue(string2, "toString(...)");
                        if (!StringsKt.startsWith$default(string2, scope2, false, 2, null)) continue;
                        bl = true;
                        break block3;
                    }
                    bl = false;
                }
            }
            return bl;
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public final DirtyData doCompute(@NotNull AbiSnapshot snapshot2, @NotNull AbiSnapshot actual, @NotNull IncrementalCacheCommon caches, @NotNull Collection<String> scopes) {
            void $this$filterTo$iv$iv;
            Object protoData;
            Intrinsics.checkNotNullParameter(snapshot2, "snapshot");
            Intrinsics.checkNotNullParameter(actual, "actual");
            Intrinsics.checkNotNullParameter(caches, "caches");
            Intrinsics.checkNotNullParameter(scopes, "scopes");
            List dirtyFqNames = new ArrayList();
            List dirtyLookupSymbols = new ArrayList();
            for (Map.Entry<FqName, ProtoData> object2 : snapshot2.getProtos().entrySet()) {
                Difference diff;
                FqName fqName = object2.getKey();
                protoData = object2.getValue();
                if (!this.inScope(fqName, scopes)) continue;
                ProtoData newProtoData = actual.getProtos().get(fqName);
                if (newProtoData == null) {
                    Pair<List<FqName>, List<LookupSymbol>> pair = this.addProtoInfo((ProtoData)protoData, fqName);
                    List<FqName> fqNames = pair.component1();
                    List<LookupSymbol> symbols2 = pair.component2();
                    dirtyFqNames.addAll((Collection)fqNames);
                    dirtyLookupSymbols.addAll((Collection)symbols2);
                    continue;
                }
                if (protoData instanceof ClassProtoData && newProtoData instanceof ClassProtoData) {
                    new ProtoCompareGenerated(((ClassProtoData)protoData).getNameResolver(), ((ClassProtoData)newProtoData).getNameResolver(), ((ClassProtoData)protoData).getProto().getTypeTable(), ((ClassProtoData)newProtoData).getProto().getTypeTable());
                    diff = new DifferenceCalculatorForClass((ClassProtoData)protoData, (ClassProtoData)newProtoData).difference();
                    if (diff.isClassAffected()) {
                        String scope2;
                        String name2;
                        boolean fqNames;
                        dirtyFqNames.add(fqName);
                        boolean bl = fqNames = !fqName.isRoot();
                        if (_Assertions.ENABLED && !fqNames) {
                            boolean $i$a$-assert-AbiSnapshotDiffService$Companion$doCompute$232 = false;
                            String $i$a$-assert-AbiSnapshotDiffService$Companion$doCompute$232 = fqName + " is root";
                            throw new AssertionError((Object)$i$a$-assert-AbiSnapshotDiffService$Companion$doCompute$232);
                        }
                        Intrinsics.checkNotNullExpressionValue(fqName.parent().asString(), "asString(...)");
                        Intrinsics.checkNotNullExpressionValue(fqName.shortName().getIdentifier(), "getIdentifier(...)");
                        dirtyLookupSymbols.add(new LookupSymbol(name2, scope2));
                    }
                    for (String member : diff.getChangedMembersNames()) {
                        Set<FqName> subtypeFqNames = BuildUtilKt.withSubtypes(fqName, (Iterable<? extends IncrementalCacheCommon>)CollectionsKt.listOf(caches));
                        dirtyFqNames.addAll((Collection)subtypeFqNames);
                        for (FqName subtypeFqName : subtypeFqNames) {
                            String string2 = subtypeFqName.asString();
                            Intrinsics.checkNotNullExpressionValue(string2, "asString(...)");
                            dirtyLookupSymbols.add(new LookupSymbol(member, string2));
                            String string3 = SamConversionResolverKt.getSAM_LOOKUP_NAME().asString();
                            Intrinsics.checkNotNullExpressionValue(string3, "asString(...)");
                            String string4 = subtypeFqName.asString();
                            Intrinsics.checkNotNullExpressionValue(string4, "asString(...)");
                            dirtyLookupSymbols.add(new LookupSymbol(string3, string4));
                        }
                    }
                    continue;
                }
                if (protoData instanceof PackagePartProtoData && newProtoData instanceof PackagePartProtoData) {
                    diff = new DifferenceCalculatorForPackageFacade((PackagePartProtoData)protoData, (PackagePartProtoData)newProtoData).difference();
                    for (String member : diff.getChangedMembersNames()) {
                        String string5 = fqName.asString();
                        Intrinsics.checkNotNullExpressionValue(string5, "asString(...)");
                        dirtyLookupSymbols.add(new LookupSymbol(member, string5));
                    }
                    continue;
                }
                throw new IllegalStateException("package proto and class proto have the same fqName: " + fqName);
            }
            new DirtyData(dirtyLookupSymbols, dirtyFqNames, null, 4, null);
            Set<FqName> oldFqNames = snapshot2.getProtos().keySet();
            Iterable iterable = actual.getProtos().keySet();
            List list = dirtyFqNames;
            boolean $i$f$filter = false;
            protoData = iterable;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                FqName it = (FqName)element$iv$iv;
                boolean bl = false;
                if (!(!oldFqNames.contains(it))) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            list.addAll((List)destination$iv$iv);
            return new DirtyData(dirtyLookupSymbols, dirtyFqNames, null, 4, null);
        }

        /*
         * WARNING - void declaration
         */
        private final Pair<List<FqName>, List<LookupSymbol>> addProtoInfo(ProtoData protoData, FqName fqName) {
            boolean bl;
            ArrayList<FqName> fqNames = new ArrayList<FqName>();
            ArrayList symbols2 = new ArrayList();
            ProtoData protoData2 = protoData;
            if (protoData2 instanceof ClassProtoData) {
                void $this$mapTo$iv$iv;
                void $this$map$iv;
                fqNames.add(fqName);
                Iterable iterable = DifferenceCalculatorForClass.Companion.getNonPrivateMembers((ClassProtoData)protoData);
                ArrayList arrayList = symbols2;
                boolean $i$f$map = false;
                void var8_12 = $this$map$iv;
                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    void it;
                    String string2 = (String)item$iv$iv;
                    Collection collection = destination$iv$iv;
                    boolean bl2 = false;
                    String string3 = fqName.asString();
                    Intrinsics.checkNotNullExpressionValue(string3, "asString(...)");
                    collection.add(new LookupSymbol((String)it, string3));
                }
                bl = arrayList.addAll((List)destination$iv$iv);
            } else if (protoData2 instanceof PackagePartProtoData) {
                ProtoBuf.FunctionOrBuilder it;
                Iterable $this$filterNotTo$iv$iv;
                Iterable $this$filterNot$iv;
                List<? extends ProtoBuf.FunctionOrBuilder> list = ((PackagePartProtoData)protoData).getProto().getFunctionOrBuilderList();
                Intrinsics.checkNotNullExpressionValue(list, "getFunctionOrBuilderList(...)");
                Iterable $this$map$iv = list;
                ArrayList arrayList = symbols2;
                boolean $i$f$filterNot = false;
                void $this$mapTo$iv$iv = $this$filterNot$iv;
                Collection destination$iv$iv = new ArrayList();
                boolean $i$f$filterNotTo = false;
                for (Object element$iv$iv : $this$filterNotTo$iv$iv) {
                    it = (ProtoBuf.FunctionOrBuilder)element$iv$iv;
                    boolean bl3 = false;
                    if (Flags.VISIBILITY.get(it.getFlags()) == ProtoBuf.Visibility.PRIVATE) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                $this$filterNot$iv = (List)destination$iv$iv;
                boolean $i$f$map = false;
                $this$filterNotTo$iv$iv = $this$map$iv;
                destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    it = (ProtoBuf.FunctionOrBuilder)item$iv$iv;
                    Collection collection = destination$iv$iv;
                    boolean bl4 = false;
                    String string4 = ((PackagePartProtoData)protoData).getNameResolver().getString(it.getName());
                    String string5 = fqName.asString();
                    Intrinsics.checkNotNullExpressionValue(string5, "asString(...)");
                    collection.add(new LookupSymbol(string4, string5));
                }
                bl = arrayList.addAll(CollectionsKt.toSet((List)destination$iv$iv));
            } else {
                throw new NoWhenBranchMatchedException();
            }
            return new Pair<List<FqName>, List<LookupSymbol>>(fqNames, symbols2);
        }

        private static final DirtyData compareJarsInternal$lambda$0(IncrementalCacheCommon $caches, Pair pair) {
            Intrinsics.checkNotNullParameter(pair, "<destruct>");
            AbiSnapshot snapshot2 = (AbiSnapshot)pair.component1();
            AbiSnapshot actual = (AbiSnapshot)pair.component2();
            return Companion.doCompute(snapshot2, actual, $caches, CollectionsKt.emptyList());
        }

        private static final DirtyData compareJarsInternal$lambda$1(Function1 $tmp0, Object p0) {
            return (DirtyData)$tmp0.invoke(p0);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

