/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.utils;

import java.io.File;
import java.util.ArrayList;
import java.util.Base64;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.utils.JsLibrary;
import org.jetbrains.kotlin.utils.JsLibraryUtils;
import org.jetbrains.kotlin.utils.JsMetadataVersion;
import org.jetbrains.kotlin.utils.KotlinJavascriptMetadata;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\u0012\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\u0010\r\n\u0000\n\u0002\u0010!\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\f\u001a\u00020\u00052\u0006\u0010\r\u001a\u00020\u0005J\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0005H\u0007J\u001e\u0010\u0011\u001a\u00020\u00052\u0006\u0010\u0012\u001a\u00020\u00052\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016J\u0016\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00190\u00182\u0006\u0010\u001a\u001a\u00020\u001bH\u0007J\u0016\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00190\u00182\u0006\u0010\u001c\u001a\u00020\u0005H\u0007J\u001e\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u0010\u001a\u00020\u001f2\f\u0010 \u001a\b\u0012\u0004\u0012\u00020\u00190!H\u0007R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0005X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\""}, d2={"Lorg/jetbrains/kotlin/utils/KotlinJavascriptMetadataUtils;", "", "<init>", "()V", "JS_EXT", "", "META_JS_SUFFIX", "JS_MAP_EXT", "KOTLIN_JAVASCRIPT_METHOD_NAME", "KOTLIN_JAVASCRIPT_METHOD_NAME_PATTERN", "Ljava/util/regex/Pattern;", "METADATA_PATTERN", "replaceSuffix", "filePath", "hasMetadata", "", "text", "formatMetadataAsString", "moduleName", "content", "", "metadataVersion", "Lorg/jetbrains/kotlin/utils/JsMetadataVersion;", "loadMetadata", "", "Lorg/jetbrains/kotlin/utils/KotlinJavascriptMetadata;", "file", "Ljava/io/File;", "path", "parseMetadata", "", "", "metadataList", "", "js.config"})
@SourceDebugExtension(value={"SMAP\nKotlinJavascriptMetadataUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 KotlinJavascriptMetadataUtils.kt\norg/jetbrains/kotlin/utils/KotlinJavascriptMetadataUtils\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,109:1\n1#2:110\n*E\n"})
public final class KotlinJavascriptMetadataUtils {
    @NotNull
    public static final KotlinJavascriptMetadataUtils INSTANCE = new KotlinJavascriptMetadataUtils();
    @NotNull
    public static final String JS_EXT = ".js";
    @NotNull
    public static final String META_JS_SUFFIX = ".meta.js";
    @NotNull
    public static final String JS_MAP_EXT = ".js.map";
    @NotNull
    private static final String KOTLIN_JAVASCRIPT_METHOD_NAME = "kotlin_module_metadata";
    @NotNull
    private static final Pattern KOTLIN_JAVASCRIPT_METHOD_NAME_PATTERN;
    @NotNull
    private static final Pattern METADATA_PATTERN;

    private KotlinJavascriptMetadataUtils() {
    }

    @NotNull
    public final String replaceSuffix(@NotNull String filePath) {
        Intrinsics.checkNotNullParameter(filePath, "filePath");
        return StringsKt.substringBeforeLast$default(filePath, JS_EXT, null, 2, null) + META_JS_SUFFIX;
    }

    @JvmStatic
    public static final boolean hasMetadata(@NotNull String text) {
        Intrinsics.checkNotNullParameter(text, "text");
        return KOTLIN_JAVASCRIPT_METHOD_NAME_PATTERN.matcher(text).find() && METADATA_PATTERN.matcher(text).find();
    }

    @NotNull
    public final String formatMetadataAsString(@NotNull String moduleName, @NotNull byte[] content, @NotNull JsMetadataVersion metadataVersion) {
        Intrinsics.checkNotNullParameter(moduleName, "moduleName");
        Intrinsics.checkNotNullParameter(content, "content");
        Intrinsics.checkNotNullParameter(metadataVersion, "metadataVersion");
        return "// Kotlin." + KOTLIN_JAVASCRIPT_METHOD_NAME + '(' + metadataVersion.toInteger() + ", \"" + moduleName + "\", \"" + Base64.getEncoder().encodeToString(content) + "\");\n";
    }

    @JvmStatic
    @NotNull
    public static final List<KotlinJavascriptMetadata> loadMetadata(@NotNull File file2) {
        Intrinsics.checkNotNullParameter(file2, "file");
        boolean bl = file2.exists();
        if (_Assertions.ENABLED && !bl) {
            boolean bl2 = false;
            String string2 = "Library " + file2 + " not found";
            throw new AssertionError((Object)string2);
        }
        ArrayList metadataList = new ArrayList();
        JsLibraryUtils.traverseJsLibrary(file2, arg_0 -> KotlinJavascriptMetadataUtils.loadMetadata$lambda$1(metadataList, arg_0));
        return metadataList;
    }

    @JvmStatic
    @NotNull
    public static final List<KotlinJavascriptMetadata> loadMetadata(@NotNull String path) {
        Intrinsics.checkNotNullParameter(path, "path");
        return KotlinJavascriptMetadataUtils.loadMetadata(new File(path));
    }

    @JvmStatic
    public static final void parseMetadata(@NotNull CharSequence text, @NotNull List<KotlinJavascriptMetadata> metadataList) {
        Intrinsics.checkNotNullParameter(text, "text");
        Intrinsics.checkNotNullParameter(metadataList, "metadataList");
        if (!KOTLIN_JAVASCRIPT_METHOD_NAME_PATTERN.matcher(text).find()) {
            return;
        }
        Matcher matcher = METADATA_PATTERN.matcher(text);
        while (matcher.find()) {
            String string2 = matcher.group(1);
            Intrinsics.checkNotNullExpressionValue(string2, "group(...)");
            JsMetadataVersion abiVersion = JsMetadataVersion.Companion.fromInteger(Integer.parseInt(string2));
            String moduleName = matcher.group(3);
            String data = matcher.group(5);
            Intrinsics.checkNotNull(moduleName);
            byte[] byArray = Base64.getDecoder().decode(data);
            Intrinsics.checkNotNullExpressionValue(byArray, "decode(...)");
            metadataList.add(new KotlinJavascriptMetadata(abiVersion, moduleName, byArray));
        }
    }

    private static final Unit loadMetadata$lambda$1(ArrayList $metadataList, JsLibrary library) {
        Intrinsics.checkNotNullParameter(library, "library");
        KotlinJavascriptMetadataUtils.parseMetadata(library.getContent(), $metadataList);
        return Unit.INSTANCE;
    }

    static {
        String string2 = "\\.kotlin_module_metadata\\(";
        int n = 0;
        Pattern pattern = Pattern.compile(string2, n);
        Intrinsics.checkNotNullExpressionValue(pattern, "compile(...)");
        KOTLIN_JAVASCRIPT_METHOD_NAME_PATTERN = pattern;
        string2 = "(?m)\\w+\\." + KOTLIN_JAVASCRIPT_METHOD_NAME + "\\((\\d+),\\s*(['\"])([^'\"]*)\\2,\\s*(['\"])([^'\"]*)\\4\\)";
        n = 0;
        Pattern pattern2 = Pattern.compile(string2, n);
        Intrinsics.checkNotNullExpressionValue(pattern2, "compile(...)");
        METADATA_PATTERN = pattern2;
    }
}

