/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.editorActions.smartEnter;

import com.intellij.codeInsight.editorActions.smartEnter.ASTNodeEnterProcessor;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorModificationUtilEx;
import com.intellij.openapi.editor.actionSystem.EditorActionHandler;
import com.intellij.openapi.editor.actionSystem.EditorActionManager;
import com.intellij.openapi.editor.ex.util.EditorUtil;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.impl.source.BasicElementTypes;
import com.intellij.psi.impl.source.BasicJavaAstTreeUtil;
import com.intellij.psi.impl.source.BasicJavaDocElementType;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.ParentAwareTokenSet;
import com.intellij.psi.tree.TokenSet;
import org.jetbrains.annotations.NotNull;

public class CommentBreakerEnterProcessor
implements ASTNodeEnterProcessor {
    private final ParentAwareTokenSet myCommentTypes = ParentAwareTokenSet.orSet((ParentAwareTokenSet[])new ParentAwareTokenSet[]{ParentAwareTokenSet.create((TokenSet)BasicElementTypes.BASIC_JAVA_PLAIN_COMMENT_BIT_SET), ParentAwareTokenSet.create((IElementType[])new IElementType[]{BasicJavaDocElementType.BASIC_DOC_COMMENT})});

    @Override
    public boolean doEnter(@NotNull Editor editor, @NotNull ASTNode astNode, boolean isModified) {
        if (editor == null) {
            CommentBreakerEnterProcessor.$$$reportNull$$$0(0);
        }
        if (astNode == null) {
            CommentBreakerEnterProcessor.$$$reportNull$$$0(1);
        }
        PsiElement psiElement = BasicJavaAstTreeUtil.toPsi(astNode);
        if (isModified || psiElement == null) {
            return false;
        }
        PsiElement atCaret = psiElement.getContainingFile().findElementAt(editor.getCaretModel().getOffset());
        if (atCaret == null) {
            return false;
        }
        ASTNode comment = BasicJavaAstTreeUtil.getParentOfType(atCaret.getNode(), this.myCommentTypes, false);
        if (comment != null) {
            CommentBreakerEnterProcessor.plainEnter(editor);
            if (BasicJavaAstTreeUtil.is(comment, JavaTokenType.END_OF_LINE_COMMENT)) {
                EditorModificationUtilEx.insertStringAtCaret((Editor)editor, (String)"// ");
            }
            return true;
        }
        return false;
    }

    private static void plainEnter(Editor editor) {
        CommentBreakerEnterProcessor.getEnterHandler().execute(editor, editor.getCaretModel().getCurrentCaret(), EditorUtil.getEditorDataContext((Editor)editor));
    }

    private static EditorActionHandler getEnterHandler() {
        return EditorActionManager.getInstance().getActionHandler("EditorStartNewLine");
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "editor";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "astNode";
                break;
            }
        }
        objectArray[1] = "com/intellij/codeInsight/editorActions/smartEnter/CommentBreakerEnterProcessor";
        objectArray[2] = "doEnter";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

