/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.java.decompiler.modules.decompiler.exps;

import java.util.BitSet;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.java.decompiler.main.ClassWriter;
import org.jetbrains.java.decompiler.main.ClassesProcessor;
import org.jetbrains.java.decompiler.main.DecompilerContext;
import org.jetbrains.java.decompiler.main.collectors.BytecodeMappingTracer;
import org.jetbrains.java.decompiler.main.extern.IFernflowerLogger;
import org.jetbrains.java.decompiler.main.rels.MethodWrapper;
import org.jetbrains.java.decompiler.modules.decompiler.ExprProcessor;
import org.jetbrains.java.decompiler.modules.decompiler.exps.Exprent;
import org.jetbrains.java.decompiler.modules.decompiler.stats.Statement;
import org.jetbrains.java.decompiler.modules.decompiler.vars.CheckTypesResult;
import org.jetbrains.java.decompiler.modules.decompiler.vars.VarProcessor;
import org.jetbrains.java.decompiler.modules.decompiler.vars.VarVersion;
import org.jetbrains.java.decompiler.struct.attr.StructGeneralAttribute;
import org.jetbrains.java.decompiler.struct.attr.StructLocalVariableTableAttribute;
import org.jetbrains.java.decompiler.struct.attr.StructLocalVariableTypeTableAttribute;
import org.jetbrains.java.decompiler.struct.gen.VarType;
import org.jetbrains.java.decompiler.struct.gen.generics.GenericFieldDescriptor;
import org.jetbrains.java.decompiler.struct.gen.generics.GenericMain;
import org.jetbrains.java.decompiler.struct.gen.generics.GenericType;
import org.jetbrains.java.decompiler.struct.match.IMatchable;
import org.jetbrains.java.decompiler.struct.match.MatchEngine;
import org.jetbrains.java.decompiler.struct.match.MatchNode;
import org.jetbrains.java.decompiler.util.TextBuffer;
import org.jetbrains.java.decompiler.util.TextUtil;

public class VarExprent
extends Exprent {
    public static final int STACK_BASE = 10000;
    public static final String VAR_NAMELESS_ENCLOSURE = "<VAR_NAMELESS_ENCLOSURE>";
    private int index;
    private VarType varType;
    private boolean definition = false;
    private final VarProcessor processor;
    private int version = 0;
    private boolean classDef = false;
    private boolean stack = false;
    private StructLocalVariableTableAttribute.LocalVariable lvtEntry = null;
    @Nullable
    private VarType inferredType = null;

    public VarExprent(int index, VarType varType, VarProcessor processor) {
        this(index, varType, processor, null);
    }

    public VarExprent(int index, VarType varType, VarProcessor processor, BitSet bytecode) {
        super(12);
        this.index = index;
        this.varType = varType;
        this.processor = processor;
        this.addBytecodeOffsets(bytecode);
    }

    @Override
    public VarType getExprType() {
        return this.getVarType();
    }

    @Override
    public void inferExprType(VarType upperBound) {
        if (this.lvtEntry != null && this.lvtEntry.getSignature() != null) {
            try {
                this.inferredType = GenericType.parse(this.lvtEntry.getSignature());
            }
            catch (StringIndexOutOfBoundsException ex) {
                DecompilerContext.getLogger().writeMessage("Inconsistent data: ", IFernflowerLogger.Severity.WARN, ex);
            }
        } else if (this.lvtEntry != null) {
            this.inferredType = this.lvtEntry.getVarType();
        }
    }

    @Override
    public int getExprentUse() {
        return 3;
    }

    @Override
    public List<Exprent> getAllExprents(List<Exprent> lst) {
        return lst;
    }

    @Override
    public Exprent copy() {
        VarExprent var = new VarExprent(this.index, this.getVarType(), this.processor, this.bytecode);
        var.setDefinition(this.definition);
        var.setVersion(this.version);
        var.setClassDef(this.classDef);
        var.setStack(this.stack);
        var.setLVTEntry(this.lvtEntry);
        return var;
    }

    @Override
    public TextBuffer toJava(int indent, BytecodeMappingTracer tracer) {
        TextBuffer buffer = new TextBuffer();
        tracer.addMapping(this.bytecode);
        if (this.classDef) {
            ClassesProcessor.ClassNode child = DecompilerContext.getClassProcessor().getMapRootClasses().get(this.varType.getValue());
            new ClassWriter().classToJava(child, buffer, indent, tracer);
            tracer.incrementCurrentSourceLine(buffer.countLines());
        } else {
            VarVersion varVersion = this.getVarVersion();
            if (this.definition) {
                if (this.processor != null && this.processor.getVarFinal(varVersion) == 2) {
                    buffer.append("final ");
                }
                this.appendDefinitionType(buffer);
                buffer.append(" ");
            }
            buffer.append(this.getName());
        }
        return buffer;
    }

    public int getVisibleOffset() {
        return this.bytecode == null ? -1 : this.bytecode.length();
    }

    @NotNull
    public static String getName(VarVersion versionPair) {
        String string = "var" + versionPair.var + (String)(versionPair.version == 0 ? "" : "_" + versionPair.version);
        if (string == null) {
            VarExprent.$$$reportNull$$$0(0);
        }
        return string;
    }

    public VarVersion getVarVersion() {
        return new VarVersion(this.index, this.version);
    }

    public VarType getDefinitionType() {
        if (DecompilerContext.getOption("udv")) {
            if (this.lvtEntry != null) {
                GenericFieldDescriptor descriptor;
                if (DecompilerContext.getOption("dgs") && this.lvtEntry.getSignature() != null && (descriptor = GenericMain.parseFieldSignature(this.lvtEntry.getSignature())) != null) {
                    return descriptor.type;
                }
                return this.getVarType();
            }
            MethodWrapper method = (MethodWrapper)DecompilerContext.getProperty("CURRENT_METHOD_WRAPPER");
            if (method != null) {
                int visibleOffset;
                Integer originalIndex = null;
                if (this.processor != null) {
                    originalIndex = this.processor.getVarOriginalIndex(this.index);
                }
                int n = visibleOffset = this.bytecode == null ? -1 : this.bytecode.length();
                if (originalIndex != null) {
                    String descriptor;
                    GenericFieldDescriptor descriptor2;
                    String signature;
                    StructGeneralAttribute attr;
                    if (DecompilerContext.getOption("dgs") && (attr = method.methodStruct.getAttribute(StructGeneralAttribute.ATTRIBUTE_LOCAL_VARIABLE_TYPE_TABLE)) != null && (signature = ((StructLocalVariableTypeTableAttribute)attr).getSignature(originalIndex, visibleOffset)) != null && (descriptor2 = GenericMain.parseFieldSignature(signature)) != null) {
                        return descriptor2.type;
                    }
                    attr = method.methodStruct.getLocalVariableAttr();
                    if (attr != null && (descriptor = ((StructLocalVariableTableAttribute)attr).getDescriptor(originalIndex, visibleOffset)) != null) {
                        return new VarType(descriptor);
                    }
                }
            }
        }
        return this.getVarType();
    }

    void appendDefinitionType(TextBuffer buffer) {
        buffer.append(ExprProcessor.getCastTypeName(this.getDefinitionType(), Collections.emptyList()));
    }

    public int hashCode() {
        return Objects.hash(this.index, this.version);
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof VarExprent)) {
            return false;
        }
        VarExprent ve = (VarExprent)o;
        return this.index == ve.getIndex() && this.version == ve.getVersion() && Objects.equals(this.getVarType(), ve.getVarType());
    }

    @Override
    public void fillBytecodeRange(@Nullable BitSet values) {
        this.measureBytecode(values);
    }

    public int getIndex() {
        return this.index;
    }

    public void setIndex(int index) {
        this.index = index;
    }

    public VarType getVarType() {
        if (this.inferredType != null) {
            return this.inferredType;
        }
        if (DecompilerContext.getOption("udv") && this.lvtEntry != null) {
            return new VarType(this.lvtEntry.getDescriptor());
        }
        VarType vt = null;
        if (this.processor != null) {
            vt = this.processor.getVarType(this.getVarVersion());
        }
        if (vt == null || this.varType != null && this.varType.getType() != 17) {
            vt = this.varType;
        }
        return vt == null ? VarType.VARTYPE_UNKNOWN : vt;
    }

    public void setVarType(VarType varType) {
        this.varType = varType;
    }

    public boolean isDefinition() {
        return this.definition;
    }

    public void setDefinition(boolean definition) {
        this.definition = definition;
    }

    public VarProcessor getProcessor() {
        return this.processor;
    }

    public int getVersion() {
        return this.version;
    }

    public void setVersion(int version) {
        this.version = version;
    }

    public boolean isClassDef() {
        return this.classDef;
    }

    public void setClassDef(boolean classDef) {
        this.classDef = classDef;
    }

    public boolean isStack() {
        return this.stack;
    }

    public void setStack(boolean stack) {
        this.stack = stack;
    }

    public void setLVTEntry(StructLocalVariableTableAttribute.LocalVariable var) {
        this.lvtEntry = var;
        if (this.processor != null && this.lvtEntry != null) {
            this.processor.setVarType(this.getVarVersion(), this.lvtEntry.getVarType());
        }
    }

    public StructLocalVariableTableAttribute.LocalVariable getLVTEntry() {
        return this.lvtEntry;
    }

    public String getName() {
        String ret;
        VarVersion varVersion = this.getVarVersion();
        if (this.lvtEntry != null && TextUtil.isValidIdentifier(this.lvtEntry.getName(), 66)) {
            return this.lvtEntry.getName();
        }
        if (this.processor != null && (ret = this.processor.getVarName(varVersion)) != null) {
            return ret;
        }
        return VarExprent.getName(varVersion);
    }

    @Override
    public CheckTypesResult checkExprTypeBounds() {
        if (this.lvtEntry != null) {
            CheckTypesResult ret = new CheckTypesResult();
            ret.addMinTypeExprent(this, this.lvtEntry.getVarType());
            return ret;
        }
        return null;
    }

    public boolean isVarReferenced(Statement stat, VarExprent ... whitelist) {
        for (IMatchable iMatchable : stat.getExprentsOrSequentialObjects()) {
            if (!(iMatchable instanceof Statement ? this.isVarReferenced((Statement)iMatchable, whitelist) : iMatchable instanceof Exprent && this.isVarReferenced((Exprent)iMatchable, whitelist))) continue;
            return true;
        }
        return false;
    }

    public boolean isVarReferenced(Exprent exp, VarExprent ... whitelist) {
        List<Exprent> lst = exp.getAllExprents(true);
        lst.add(exp);
        lst = lst.stream().filter(e -> e != this && e.type == 12 && this.getVarVersion().equals(((VarExprent)e).getVarVersion())).collect(Collectors.toList());
        for (Exprent var : lst) {
            boolean allowed = false;
            for (VarExprent white : whitelist) {
                if (var != white) continue;
                allowed = true;
                break;
            }
            if (allowed) continue;
            return true;
        }
        return false;
    }

    @Override
    public String toString() {
        return "VarExprent[" + this.index + "," + this.version + "]";
    }

    @Override
    public boolean match(MatchNode matchNode, MatchEngine engine) {
        if (!super.match(matchNode, engine)) {
            return false;
        }
        MatchNode.RuleValue rule = matchNode.getRules().get((Object)IMatchable.MatchProperties.EXPRENT_VAR_INDEX);
        if (rule != null) {
            if (rule.isVariable()) {
                return engine.checkAndSetVariableValue((String)rule.value, this.index);
            }
            return this.index == Integer.parseInt((String)rule.value);
        }
        return true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/java/decompiler/modules/decompiler/exps/VarExprent", "getName"));
    }
}

