/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.plugins.relaxNG.model.annotation;

import com.intellij.icons.AllIcons;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.editor.markup.GutterIconRenderer;
import com.intellij.openapi.project.DumbAware;
import com.intellij.psi.search.PsiElementProcessor;
import com.intellij.psi.xml.XmlFile;
import com.intellij.util.SmartList;
import java.util.Collection;
import java.util.List;
import javax.swing.Icon;
import org.intellij.plugins.relaxNG.RelaxngBundle;
import org.intellij.plugins.relaxNG.model.Define;
import org.intellij.plugins.relaxNG.model.Grammar;
import org.intellij.plugins.relaxNG.model.annotation.OverriddenDefineSearcher;
import org.intellij.plugins.relaxNG.model.annotation.OverridingDefineRenderer;
import org.intellij.plugins.relaxNG.model.resolve.GrammarFactory;
import org.intellij.plugins.relaxNG.model.resolve.RelaxIncludeIndex;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class OverriddenDefineRenderer
extends GutterIconRenderer
implements DumbAware {
    private final Define myDefine;

    OverriddenDefineRenderer(@NotNull Define define) {
        if (define == null) {
            OverriddenDefineRenderer.$$$reportNull$$$0(0);
        }
        this.myDefine = define;
    }

    @NotNull
    public Icon getIcon() {
        Icon icon = AllIcons.Gutter.OverridenMethod;
        if (icon == null) {
            OverriddenDefineRenderer.$$$reportNull$$$0(1);
        }
        return icon;
    }

    @Nullable
    public AnAction getClickAction() {
        return new AnAction(){

            public void actionPerformed(@NotNull AnActionEvent e) {
                Object element;
                if (e == null) {
                    1.$$$reportNull$$$0(0);
                }
                if ((element = OverriddenDefineRenderer.this.myDefine.getPsiElement()) == null || !element.isValid()) {
                    return;
                }
                PsiElementProcessor.CollectElements collector = new PsiElementProcessor.CollectElements();
                XmlFile localFile = (XmlFile)element.getContainingFile();
                RelaxIncludeIndex.processBackwardDependencies(localFile, (PsiElementProcessor<? super XmlFile>)collector);
                Collection files = collector.getCollection();
                SmartList result2 = new SmartList();
                OverriddenDefineSearcher searcher = new OverriddenDefineSearcher(OverriddenDefineRenderer.this.myDefine, localFile, (List<? super Define<?, ?>>)result2);
                for (XmlFile file : files) {
                    Grammar grammar = GrammarFactory.getGrammar(file);
                    if (grammar == null) continue;
                    grammar.acceptChildren(searcher);
                }
                if (result2.size() > 0) {
                    OverridingDefineRenderer.doClickAction(e, (Collection<? extends Define>)result2, RelaxngBundle.message("relaxng.gutter.go-to-overriding-defines", new Object[0]));
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "org/intellij/plugins/relaxNG/model/annotation/OverriddenDefineRenderer$1", "actionPerformed"));
            }
        };
    }

    public boolean isNavigateAction() {
        return true;
    }

    @Nullable
    public String getTooltipText() {
        return RelaxngBundle.message("relaxng.gutter.is-overridden", new Object[0]);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        OverriddenDefineRenderer that = (OverriddenDefineRenderer)((Object)o);
        return this.myDefine.equals(that.myDefine);
    }

    public int hashCode() {
        return this.myDefine.hashCode();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "define";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/intellij/plugins/relaxNG/model/annotation/OverriddenDefineRenderer";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/intellij/plugins/relaxNG/model/annotation/OverriddenDefineRenderer";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getIcon";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                break;
            }
        }
        String string2 = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string2);
            case 1 -> new IllegalStateException(string2);
        };
    }
}

