/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.debugger.sourcemap;

import com.intellij.util.containers.ContainerUtil;
import java.util.Map;
import java.util.concurrent.ConcurrentMap;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.debugger.sourcemap.GeneratedMappingList;
import org.jetbrains.debugger.sourcemap.MappingList;
import org.jetbrains.debugger.sourcemap.SourceMapDataEx;
import org.jetbrains.debugger.sourcemap.SourceMapDataImpl;
import org.jetbrains.debugger.sourcemap.SourceMapDecoderKt;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u00c7\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001c\u0010\b\u001a\u0004\u0018\u00010\u00072\u0006\u0010\t\u001a\u00020\n2\n\b\u0002\u0010\u000b\u001a\u0004\u0018\u00010\nR\u001a\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lorg/jetbrains/debugger/sourcemap/SourceMapDataCache;", "", "<init>", "()V", "cache", "", "Lorg/jetbrains/debugger/sourcemap/SourceMapDataImpl;", "Lorg/jetbrains/debugger/sourcemap/SourceMapDataEx;", "getOrCreate", "sourceMapData", "", "mapDebugName", "intellij.platform.scriptDebugger.backend"})
@ApiStatus.Internal
public final class SourceMapDataCache {
    @NotNull
    public static final SourceMapDataCache INSTANCE = new SourceMapDataCache();
    @NotNull
    private static final Map<SourceMapDataImpl, SourceMapDataEx> cache;

    private SourceMapDataCache() {
    }

    @Nullable
    public final SourceMapDataEx getOrCreate(@NotNull String sourceMapData, @Nullable String mapDebugName) {
        Intrinsics.checkNotNullParameter((Object)sourceMapData, (String)"sourceMapData");
        SourceMapDataImpl sourceMapDataImpl = SourceMapDecoderKt.parseMapSafely(sourceMapData, mapDebugName);
        if (sourceMapDataImpl == null) {
            return null;
        }
        SourceMapDataImpl data2 = sourceMapDataImpl;
        SourceMapDataEx value = cache.get(data2);
        if (value != null) {
            return value;
        }
        MappingList[] sourceIndexToMappings = SourceMapDecoderKt.calculateReverseMappings(data2);
        GeneratedMappingList generatedMappings = new GeneratedMappingList(data2.getMappings());
        SourceMapDataEx result2 = new SourceMapDataEx(data2, sourceIndexToMappings, generatedMappings);
        cache.put(data2, result2);
        return result2;
    }

    public static /* synthetic */ SourceMapDataEx getOrCreate$default(SourceMapDataCache sourceMapDataCache, String string2, String string3, int n, Object object) {
        if ((n & 2) != 0) {
            string3 = null;
        }
        return sourceMapDataCache.getOrCreate(string2, string3);
    }

    static {
        ConcurrentMap concurrentMap = ContainerUtil.createConcurrentSoftValueMap();
        Intrinsics.checkNotNullExpressionValue((Object)concurrentMap, (String)"createConcurrentSoftValueMap(...)");
        cache = concurrentMap;
    }
}

