/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.gradle.execution.test.runner.events;

import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.text.StringKt;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.MatchGroup;
import kotlin.text.MatchGroupCollection;
import kotlin.text.MatchResult;
import kotlin.text.Regex;
import kotlin.text.RegexOption;
import kotlin.text.jdk8.RegexExtensionsJDK8Kt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0001\u0012B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0012\u0010\r\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0007J\u001a\u0010\r\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0005H\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lorg/jetbrains/plugins/gradle/execution/test/runner/events/AssertionMessageParser;", "", "<init>", "()V", "JUNIT5_ASSERT_EQUALS_EXTRACTOR", "Lkotlin/text/Regex;", "JUNIT5_ASSERT_EQUALS_WITH_CLASS_EXTRACTOR", "JUNIT4_ASSERT_EQUALS_EXTRACTOR", "JUNIT4_ASSERT_EQUALS_WITH_CLASS_EXTRACTOR", "JUNIT4_ASSERT_SAME_EXTRACTOR", "ASSERTJ_ASSERT_EQUALS_EXTRACTOR", "ASSERTJ_ASSERT_SAME_EXTRACTOR", "TESTNG_ASSERT_EQUALS_EXTRACTOR", "parse", "Lorg/jetbrains/plugins/gradle/execution/test/runner/events/AssertionMessageParser$Result;", "assertionMessage", "", "regex", "Result", "intellij.gradle.java"})
public final class AssertionMessageParser {
    @NotNull
    public static final AssertionMessageParser INSTANCE = new AssertionMessageParser();
    @NotNull
    private static final Regex JUNIT5_ASSERT_EQUALS_EXTRACTOR = new Regex("((?<message>.+) ==> )?expected: <(?<expected>.*)> but was: <(?<actual>.*)>", RegexOption.DOT_MATCHES_ALL);
    @NotNull
    private static final Regex JUNIT5_ASSERT_EQUALS_WITH_CLASS_EXTRACTOR = new Regex("((?<message>.+) ==> )?expected: (?<expected>[^<]+<(.*)>) but was: (?<actual>[^<]+<(.*)>)", RegexOption.DOT_MATCHES_ALL);
    @NotNull
    private static final Regex JUNIT4_ASSERT_EQUALS_EXTRACTOR = new Regex("((?<message>.+) )?expected:<(?<expected>.*)> but was:<(?<actual>.*)>", RegexOption.DOT_MATCHES_ALL);
    @NotNull
    private static final Regex JUNIT4_ASSERT_EQUALS_WITH_CLASS_EXTRACTOR = new Regex("((?<message>.+) )?expected: (?<expected>[^<]+<.*>) but was: (?<actual>[^<]+<.*>)", RegexOption.DOT_MATCHES_ALL);
    @NotNull
    private static final Regex JUNIT4_ASSERT_SAME_EXTRACTOR = new Regex("((?<message>.+) )?expected same:<(?<expected>.*)> was not:<(?<actual>.*)>", RegexOption.DOT_MATCHES_ALL);
    @NotNull
    private static final Regex ASSERTJ_ASSERT_EQUALS_EXTRACTOR = new Regex("(?<message>)\nexpected: (?<expected>.*)\n but was: (?<actual>.*)", RegexOption.DOT_MATCHES_ALL);
    @NotNull
    private static final Regex ASSERTJ_ASSERT_SAME_EXTRACTOR = new Regex("(?<message>)\nExpecting actual:\n {2}(?<actual>.*)\nand:\n {2}(?<expected>.*)\nto refer to the same object", RegexOption.DOT_MATCHES_ALL);
    @NotNull
    private static final Regex TESTNG_ASSERT_EQUALS_EXTRACTOR = new Regex("((?<message>.+) )?expected \\[(?<expected>.*)] but found \\[(?<actual>.*)]", RegexOption.DOT_MATCHES_ALL);

    private AssertionMessageParser() {
    }

    @JvmStatic
    @Nullable
    public static final Result parse(@NotNull String assertionMessage) {
        Intrinsics.checkNotNullParameter((Object)assertionMessage, (String)"assertionMessage");
        Result result = INSTANCE.parse(assertionMessage, JUNIT5_ASSERT_EQUALS_EXTRACTOR);
        if (result == null && (result = INSTANCE.parse(assertionMessage, JUNIT5_ASSERT_EQUALS_WITH_CLASS_EXTRACTOR)) == null && (result = INSTANCE.parse(assertionMessage, JUNIT4_ASSERT_EQUALS_EXTRACTOR)) == null && (result = INSTANCE.parse(assertionMessage, JUNIT4_ASSERT_EQUALS_WITH_CLASS_EXTRACTOR)) == null && (result = INSTANCE.parse(assertionMessage, JUNIT4_ASSERT_SAME_EXTRACTOR)) == null && (result = INSTANCE.parse(assertionMessage, ASSERTJ_ASSERT_EQUALS_EXTRACTOR)) == null && (result = INSTANCE.parse(assertionMessage, ASSERTJ_ASSERT_SAME_EXTRACTOR)) == null) {
            result = INSTANCE.parse(assertionMessage, TESTNG_ASSERT_EQUALS_EXTRACTOR);
        }
        return result;
    }

    private final Result parse(String assertionMessage, Regex regex) {
        String string = StringUtil.convertLineSeparators((String)assertionMessage);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"convertLineSeparators(...)");
        String canonicalAssertionMessage = string;
        MatchResult matchResult = regex.matchEntire((CharSequence)canonicalAssertionMessage);
        if (matchResult == null) {
            return null;
        }
        MatchResult matchesResult = matchResult;
        MatchGroup matchGroup = RegexExtensionsJDK8Kt.get((MatchGroupCollection)matchesResult.getGroups(), (String)"expected");
        if (matchGroup == null) {
            return null;
        }
        MatchGroup expected = matchGroup;
        MatchGroup matchGroup2 = RegexExtensionsJDK8Kt.get((MatchGroupCollection)matchesResult.getGroups(), (String)"actual");
        if (matchGroup2 == null) {
            return null;
        }
        MatchGroup actual = matchGroup2;
        MatchGroup message = RegexExtensionsJDK8Kt.get((MatchGroupCollection)matchesResult.getGroups(), (String)"message");
        MatchGroup matchGroup3 = message;
        return new Result(expected.getValue(), actual.getValue(), StringKt.nullize$default((String)(matchGroup3 != null ? matchGroup3.getValue() : null), (boolean)false, (int)1, null));
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\u0018\u00002\u00020\u0001B&\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\r\u0010\u0005\u001a\t\u0018\u00010\u0003\u00a2\u0006\u0002\b\u0006\u00a2\u0006\u0004\b\u0007\u0010\bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\nR\u0018\u0010\u0005\u001a\t\u0018\u00010\u0003\u00a2\u0006\u0002\b\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\n\u00a8\u0006\r"}, d2={"Lorg/jetbrains/plugins/gradle/execution/test/runner/events/AssertionMessageParser$Result;", "", "expected", "", "actual", "message", "Lcom/intellij/openapi/util/NlsSafe;", "<init>", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;)V", "getExpected", "()Ljava/lang/String;", "getActual", "getMessage", "intellij.gradle.java"})
    public static final class Result {
        @NotNull
        private final String expected;
        @NotNull
        private final String actual;
        @Nullable
        private final String message;

        public Result(@NotNull String expected, @NotNull String actual, @Nullable String message) {
            Intrinsics.checkNotNullParameter((Object)expected, (String)"expected");
            Intrinsics.checkNotNullParameter((Object)actual, (String)"actual");
            this.expected = expected;
            this.actual = actual;
            this.message = message;
        }

        @NotNull
        public final String getExpected() {
            return this.expected;
        }

        @NotNull
        public final String getActual() {
            return this.actual;
        }

        @Nullable
        public final String getMessage() {
            return this.message;
        }
    }
}

