/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.streams.trace.impl.interpret;

import com.intellij.debugger.streams.trace.CallTraceInterpreter;
import com.intellij.debugger.streams.trace.TraceElement;
import com.intellij.debugger.streams.trace.TraceInfo;
import com.intellij.debugger.streams.trace.impl.TraceElementImpl;
import com.intellij.debugger.streams.trace.impl.interpret.SimplePeekCallTraceInterpreter;
import com.intellij.debugger.streams.trace.impl.interpret.ValuesOrderInfo;
import com.intellij.debugger.streams.trace.impl.interpret.ex.UnexpectedArrayLengthException;
import com.intellij.debugger.streams.trace.impl.interpret.ex.UnexpectedValueTypeException;
import com.intellij.debugger.streams.wrapper.StreamCall;
import com.sun.jdi.ArrayReference;
import com.sun.jdi.Value;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.jetbrains.annotations.NotNull;

public abstract class MatchInterpreterBase
implements CallTraceInterpreter {
    private final CallTraceInterpreter myPeekResolver = new SimplePeekCallTraceInterpreter();

    @Override
    @NotNull
    public TraceInfo resolve(@NotNull StreamCall call, @NotNull Value value) {
        if (call == null) {
            MatchInterpreterBase.$$$reportNull$$$0(0);
        }
        if (value == null) {
            MatchInterpreterBase.$$$reportNull$$$0(1);
        }
        if (value instanceof ArrayReference) {
            Map<Integer, TraceElement> traceAfter;
            Collection<TraceElement> traceAfterFilter;
            ArrayReference array = (ArrayReference)value;
            if (array.length() != 2) {
                throw new UnexpectedArrayLengthException("trace array for *match call should contain two items. Actual = " + array.length());
            }
            Value peeksResult = array.getValue(0);
            Value streamResult = array.getValue(1);
            TraceElement streamResultElement = TraceElementImpl.ofResultValue(((ArrayReference)streamResult).getValue(0));
            TraceInfo peeksInfo = this.myPeekResolver.resolve(call, peeksResult);
            Collection<TraceElement> traceBeforeFilter = peeksInfo.getValuesOrderBefore().values();
            boolean result = this.getResult(traceBeforeFilter, traceAfterFilter = (traceAfter = peeksInfo.getValuesOrderAfter()).values());
            Action action = this.getAction(result);
            Map<Integer, TraceElement> beforeTrace = Action.CONNECT_FILTERED.equals((Object)action) ? MatchInterpreterBase.onlyFiltered(traceAfterFilter) : MatchInterpreterBase.difference(traceBeforeFilter, traceAfter.keySet());
            return new ValuesOrderInfo(call, beforeTrace, MatchInterpreterBase.makeIndexByTime(Stream.of(streamResultElement)));
        }
        throw new UnexpectedValueTypeException("value should be array reference, but given " + value.type().toString());
    }

    protected abstract boolean getResult(@NotNull Collection<TraceElement> var1, @NotNull Collection<TraceElement> var2);

    @NotNull
    protected abstract Action getAction(boolean var1);

    @NotNull
    private static Map<Integer, TraceElement> onlyFiltered(@NotNull Collection<TraceElement> afterFilter) {
        if (afterFilter == null) {
            MatchInterpreterBase.$$$reportNull$$$0(2);
        }
        return MatchInterpreterBase.makeIndexByTime(afterFilter.stream());
    }

    @NotNull
    private static Map<Integer, TraceElement> difference(@NotNull Collection<TraceElement> before, @NotNull Set<Integer> timesAfter) {
        if (before == null) {
            MatchInterpreterBase.$$$reportNull$$$0(3);
        }
        if (timesAfter == null) {
            MatchInterpreterBase.$$$reportNull$$$0(4);
        }
        return MatchInterpreterBase.makeIndexByTime(before.stream().filter(x -> !timesAfter.contains(x.getTime())));
    }

    @NotNull
    private static Map<Integer, TraceElement> makeIndexByTime(@NotNull Stream<TraceElement> elementStream) {
        if (elementStream == null) {
            MatchInterpreterBase.$$$reportNull$$$0(5);
        }
        Map<Integer, TraceElement> map = elementStream.collect(Collectors.toMap(TraceElement::getTime, Function.identity()));
        if (map == null) {
            MatchInterpreterBase.$$$reportNull$$$0(6);
        }
        return map;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 6 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "call";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "afterFilter";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "before";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "timesAfter";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elementStream";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/debugger/streams/trace/impl/interpret/MatchInterpreterBase";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/debugger/streams/trace/impl/interpret/MatchInterpreterBase";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "makeIndexByTime";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "resolve";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "onlyFiltered";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "difference";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "makeIndexByTime";
                break;
            }
            case 6: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 6 -> new IllegalStateException(string);
        };
    }

    protected static enum Action {
        CONNECT_FILTERED,
        CONNECT_DIFFERENCE;

    }
}

