/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.streams.ui.impl;

import com.intellij.debugger.streams.trace.IntermediateState;
import com.intellij.debugger.streams.trace.NextAwareState;
import com.intellij.debugger.streams.trace.PrevAwareState;
import com.intellij.debugger.streams.trace.TraceElement;
import com.intellij.debugger.streams.ui.PropagationDirection;
import com.intellij.debugger.streams.ui.TraceContainer;
import com.intellij.debugger.streams.ui.TraceController;
import com.intellij.debugger.streams.ui.ValuesSelectionListener;
import com.intellij.debugger.streams.wrapper.StreamCall;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.util.Disposer;
import com.sun.jdi.Value;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TraceControllerImpl
implements TraceController,
Disposable {
    private final List<TraceContainer> myTraceContainers;
    private final ValuesSelectionListener mySelectionListener;
    private final IntermediateState myState;
    private final PrevAwareState myToPrev;
    private final NextAwareState myToNext;
    private TraceController myPrevListener;
    private TraceController myNextListener;

    TraceControllerImpl(@NotNull IntermediateState state) {
        if (state == null) {
            TraceControllerImpl.$$$reportNull$$$0(0);
        }
        this.myTraceContainers = new CopyOnWriteArrayList<TraceContainer>();
        this.myPrevListener = null;
        this.myNextListener = null;
        this.myState = state;
        this.myToPrev = state instanceof PrevAwareState ? (PrevAwareState)state : null;
        this.myToNext = state instanceof NextAwareState ? (NextAwareState)state : null;
        this.mySelectionListener = elements -> {
            this.selectAll(elements);
            this.propagateForward(elements);
            this.propagateBackward(elements);
        };
    }

    public void dispose() {
    }

    void setPreviousController(@NotNull TraceController listener) {
        if (listener == null) {
            TraceControllerImpl.$$$reportNull$$$0(1);
        }
        this.myPrevListener = listener;
    }

    void setNextController(@NotNull TraceController listener) {
        if (listener == null) {
            TraceControllerImpl.$$$reportNull$$$0(2);
        }
        this.myNextListener = listener;
    }

    @Override
    @NotNull
    public List<Value> getValues() {
        List<Value> list = this.myState.getRawValues();
        if (list == null) {
            TraceControllerImpl.$$$reportNull$$$0(3);
        }
        return list;
    }

    @Override
    @NotNull
    public List<TraceElement> getTrace() {
        List<TraceElement> list = this.myState.getTrace();
        if (list == null) {
            TraceControllerImpl.$$$reportNull$$$0(4);
        }
        return list;
    }

    @Override
    @Nullable
    public StreamCall getNextCall() {
        return this.myToNext == null ? null : this.myToNext.getNextCall();
    }

    @Override
    @Nullable
    public StreamCall getPrevCall() {
        return this.myToPrev == null ? null : this.myToPrev.getPrevCall();
    }

    @Override
    @NotNull
    public List<TraceElement> getNextValues(@NotNull TraceElement element) {
        if (element == null) {
            TraceControllerImpl.$$$reportNull$$$0(5);
        }
        List<TraceElement> list = this.myToNext == null ? Collections.emptyList() : this.myToNext.getNextValues(element);
        if (list == null) {
            TraceControllerImpl.$$$reportNull$$$0(6);
        }
        return list;
    }

    @Override
    @NotNull
    public List<TraceElement> getPrevValues(@NotNull TraceElement element) {
        if (element == null) {
            TraceControllerImpl.$$$reportNull$$$0(7);
        }
        List<TraceElement> list = this.myToPrev == null ? Collections.emptyList() : this.myToPrev.getPrevValues(element);
        if (list == null) {
            TraceControllerImpl.$$$reportNull$$$0(8);
        }
        return list;
    }

    @Override
    public boolean isSelectionExists(@NotNull PropagationDirection direction) {
        if (direction == null) {
            TraceControllerImpl.$$$reportNull$$$0(9);
        }
        for (TraceContainer container : this.myTraceContainers) {
            if (!container.highlightedExists()) continue;
            return true;
        }
        return PropagationDirection.FORWARD.equals((Object)direction) ? this.selectionExistsForward() : this.selectionExistsBackward();
    }

    @Override
    public void register(@NotNull TraceContainer listener) {
        if (listener == null) {
            TraceControllerImpl.$$$reportNull$$$0(10);
        }
        this.myTraceContainers.add(listener);
        listener.addSelectionListener(this.mySelectionListener);
        Disposer.register((Disposable)this, (Disposable)listener);
    }

    @Override
    public void highlightingChanged(@NotNull List<TraceElement> values, @NotNull PropagationDirection direction) {
        if (values == null) {
            TraceControllerImpl.$$$reportNull$$$0(11);
        }
        if (direction == null) {
            TraceControllerImpl.$$$reportNull$$$0(12);
        }
        this.highlightAll(values);
        this.propagate(values, direction);
    }

    private void propagate(@NotNull List<TraceElement> values, @NotNull PropagationDirection direction) {
        if (values == null) {
            TraceControllerImpl.$$$reportNull$$$0(13);
        }
        if (direction == null) {
            TraceControllerImpl.$$$reportNull$$$0(14);
        }
        if (direction.equals((Object)PropagationDirection.BACKWARD)) {
            this.propagateBackward(values);
        } else {
            this.propagateForward(values);
        }
    }

    private void propagateForward(@NotNull List<TraceElement> values) {
        if (values == null) {
            TraceControllerImpl.$$$reportNull$$$0(15);
        }
        if (this.myNextListener == null) {
            return;
        }
        List<TraceElement> nextValues = values.stream().flatMap(x -> this.getNextValues((TraceElement)x).stream()).collect(Collectors.toList());
        this.myNextListener.highlightingChanged(nextValues, PropagationDirection.FORWARD);
    }

    private void propagateBackward(@NotNull List<TraceElement> values) {
        if (values == null) {
            TraceControllerImpl.$$$reportNull$$$0(16);
        }
        if (this.myPrevListener == null) {
            return;
        }
        List<TraceElement> prevValues = values.stream().flatMap(x -> this.getPrevValues((TraceElement)x).stream()).collect(Collectors.toList());
        this.myPrevListener.highlightingChanged(prevValues, PropagationDirection.BACKWARD);
    }

    private void highlightAll(@NotNull List<TraceElement> values) {
        if (values == null) {
            TraceControllerImpl.$$$reportNull$$$0(17);
        }
        for (TraceContainer listener : this.myTraceContainers) {
            listener.highlight(values);
        }
    }

    private void selectAll(@NotNull List<TraceElement> values) {
        if (values == null) {
            TraceControllerImpl.$$$reportNull$$$0(18);
        }
        for (TraceContainer listener : this.myTraceContainers) {
            listener.select(values);
        }
    }

    private boolean selectionExistsForward() {
        return this.myNextListener != null && this.myNextListener.isSelectionExists(PropagationDirection.FORWARD);
    }

    private boolean selectionExistsBackward() {
        return this.myPrevListener != null && this.myPrevListener.isSelectionExists(PropagationDirection.BACKWARD);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3, 4, 6, 8 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
            case 1: 
            case 2: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listener";
                break;
            }
            case 3: 
            case 4: 
            case 6: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/debugger/streams/ui/impl/TraceControllerImpl";
                break;
            }
            case 5: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 9: 
            case 12: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "direction";
                break;
            }
            case 11: 
            case 13: 
            case 15: 
            case 16: 
            case 17: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "values";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/debugger/streams/ui/impl/TraceControllerImpl";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getValues";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getTrace";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getNextValues";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getPrevValues";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "setPreviousController";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "setNextController";
                break;
            }
            case 3: 
            case 4: 
            case 6: 
            case 8: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getNextValues";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getPrevValues";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "isSelectionExists";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "register";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "highlightingChanged";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "propagate";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "propagateForward";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "propagateBackward";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "highlightAll";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "selectAll";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3, 4, 6, 8 -> new IllegalStateException(string);
        };
    }
}

