/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.java.frontend.elements;

import com.intellij.ide.highlighter.HighlighterFactory;
import com.intellij.java.frontend.elements.FrontendJavaDocElementTypeFactory;
import com.intellij.java.frontend.parser.JavaLangLevelVirtualFileCustomDataConsumerKt;
import com.intellij.lang.impl.TokenSequence;
import com.intellij.lang.java.lexer.BasicJavaLexer;
import com.intellij.lang.java.lexer.JavaDocLexer;
import com.intellij.lang.java.lexer.JavaTypeEscapeLexer;
import com.intellij.lexer.Lexer;
import com.intellij.lexer.TokenList;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.TextEditor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.LanguageLevelProjectExtension;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.pom.java.LanguageLevel;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.util.concurrency.NonUrgentExecutor;
import java.util.concurrent.Executor;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class FrontendJavaParserUtil {
    private FrontendJavaParserUtil() {
    }

    public static void resetHighlighter(@NotNull Project project, @NotNull VirtualFile file) {
        FileEditor[] editors;
        if (project == null) {
            FrontendJavaParserUtil.$$$reportNull$$$0(0);
        }
        if (file == null) {
            FrontendJavaParserUtil.$$$reportNull$$$0(1);
        }
        FileEditorManager instance = FileEditorManager.getInstance((Project)project);
        for (FileEditor editor : editors = instance.getEditors(file)) {
            EditorEx editorEx;
            TextEditor textEditor;
            Editor editor2;
            if (!(editor instanceof TextEditor) || !((editor2 = (textEditor = (TextEditor)editor).getEditor()) instanceof EditorEx) || (editorEx = (EditorEx)editor2).isDisposed()) continue;
            ReadAction.nonBlocking(() -> HighlighterFactory.createHighlighter((Project)project, (VirtualFile)file)).expireWith((Disposable)editor).expireWhen(() -> !file.isValid()).finishOnUiThread(ModalityState.any(), highlighter -> {
                highlighter.setText(editorEx.getDocument().getImmutableCharSequence());
                editorEx.setHighlighter(highlighter);
            }).submit((Executor)NonUrgentExecutor.getInstance());
        }
    }

    @NotNull
    public static TokenList obtainTokens(@NotNull PsiFile file) {
        if (file == null) {
            FrontendJavaParserUtil.$$$reportNull$$$0(2);
        }
        TokenList tokenList = (TokenList)CachedValuesManager.getCachedValue((PsiElement)file, () -> CachedValueProvider.Result.create((Object)TokenSequence.performLexing((CharSequence)file.getViewProvider().getContents(), (Lexer)FrontendJavaParserUtil.createLexer(FrontendJavaParserUtil.getLanguageLevel((PsiElement)file))), (Object[])new Object[]{file}));
        if (tokenList == null) {
            FrontendJavaParserUtil.$$$reportNull$$$0(3);
        }
        return tokenList;
    }

    @NotNull
    public static BasicJavaLexer createLexer(@NotNull LanguageLevel level) {
        if (level == null) {
            FrontendJavaParserUtil.$$$reportNull$$$0(4);
        }
        return new BasicJavaLexer(level, FrontendJavaDocElementTypeFactory.INSTANCE);
    }

    @NotNull
    public static JavaTypeEscapeLexer createLexerWithMarkdownEscape(@NotNull LanguageLevel level) {
        if (level == null) {
            FrontendJavaParserUtil.$$$reportNull$$$0(5);
        }
        return new JavaTypeEscapeLexer(new BasicJavaLexer(level, FrontendJavaDocElementTypeFactory.INSTANCE));
    }

    @NotNull
    public static JavaDocLexer createDocLexer(@NotNull LanguageLevel level) {
        if (level == null) {
            FrontendJavaParserUtil.$$$reportNull$$$0(6);
        }
        return new JavaDocLexer(level);
    }

    @NotNull
    public static LanguageLevel getLanguageLevel(@NotNull PsiElement element) {
        PsiFile file;
        LanguageLevel forcedLanguageLevel;
        if (element == null) {
            FrontendJavaParserUtil.$$$reportNull$$$0(7);
        }
        if ((forcedLanguageLevel = (LanguageLevel)(file = element.getContainingFile()).getUserData(LanguageLevel.FILE_LANGUAGE_LEVEL_KEY)) != null) {
            LanguageLevel languageLevel = forcedLanguageLevel;
            if (languageLevel == null) {
                FrontendJavaParserUtil.$$$reportNull$$$0(8);
            }
            return languageLevel;
        }
        PsiFile originalFile = file.getOriginalFile();
        forcedLanguageLevel = (LanguageLevel)originalFile.getUserData(LanguageLevel.FILE_LANGUAGE_LEVEL_KEY);
        if (forcedLanguageLevel != null) {
            LanguageLevel languageLevel = forcedLanguageLevel;
            if (languageLevel == null) {
                FrontendJavaParserUtil.$$$reportNull$$$0(9);
            }
            return languageLevel;
        }
        VirtualFile virtualFile = file.getVirtualFile();
        if (virtualFile != null) {
            return FrontendJavaParserUtil.getLanguageLevel(virtualFile, element.getProject());
        }
        PsiElement context = file.getContext();
        if (context != null) {
            return FrontendJavaParserUtil.getLanguageLevel(context);
        }
        return FrontendJavaParserUtil.getLanguageLevel(element.getProject());
    }

    @NotNull
    public static LanguageLevel getLanguageLevel(@Nullable VirtualFile virtualFile, @NotNull Project project) {
        if (project == null) {
            FrontendJavaParserUtil.$$$reportNull$$$0(10);
        }
        if (virtualFile == null) {
            return FrontendJavaParserUtil.getLanguageLevel(project);
        }
        LanguageLevel level = JavaLangLevelVirtualFileCustomDataConsumerKt.getJavaLanguageLevel(virtualFile, project);
        if (level != null) {
            LanguageLevel languageLevel = level;
            if (languageLevel == null) {
                FrontendJavaParserUtil.$$$reportNull$$$0(11);
            }
            return languageLevel;
        }
        return FrontendJavaParserUtil.getLanguageLevel(project);
    }

    @NotNull
    public static LanguageLevel getLanguageLevel(@NotNull Project project) {
        LanguageLevelProjectExtension instance;
        if (project == null) {
            FrontendJavaParserUtil.$$$reportNull$$$0(12);
        }
        LanguageLevel languageLevel = (instance = LanguageLevelProjectExtension.getInstance((Project)project)) != null ? instance.getLanguageLevel() : LanguageLevel.HIGHEST;
        if (languageLevel == null) {
            FrontendJavaParserUtil.$$$reportNull$$$0(13);
        }
        return languageLevel;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3, 8, 9, 11, 13 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 3: 
            case 8: 
            case 9: 
            case 11: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/java/frontend/elements/FrontendJavaParserUtil";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "level";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/java/frontend/elements/FrontendJavaParserUtil";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "obtainTokens";
                break;
            }
            case 8: 
            case 9: 
            case 11: 
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getLanguageLevel";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "resetHighlighter";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "obtainTokens";
                break;
            }
            case 3: 
            case 8: 
            case 9: 
            case 11: 
            case 13: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "createLexer";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "createLexerWithMarkdownEscape";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "createDocLexer";
                break;
            }
            case 7: 
            case 10: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "getLanguageLevel";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3, 8, 9, 11, 13 -> new IllegalStateException(string);
        };
    }
}

