/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.gitlab.authentication;

import com.intellij.collaboration.auth.Account;
import com.intellij.collaboration.auth.ui.login.LoginModel;
import com.intellij.collaboration.auth.ui.login.TokenLoginDialog;
import com.intellij.collaboration.auth.ui.login.TokenLoginInputPanelFactory;
import com.intellij.collaboration.auth.ui.login.TokenLoginPanelModel;
import com.intellij.collaboration.messages.CollaborationToolsBundle;
import com.intellij.collaboration.ui.codereview.list.error.ErrorStatusPresenter;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.ServicesKt;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogPanel;
import com.intellij.util.concurrency.annotations.RequiresEdt;
import java.awt.Component;
import java.util.Collection;
import javax.swing.JComponent;
import kotlin.Metadata;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.coroutines.CoroutineScope;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.gitlab.api.GitLabServerPath;
import org.jetbrains.plugins.gitlab.api.GitLabServerPathKt;
import org.jetbrains.plugins.gitlab.authentication.GitLabLoginErrorStatusPresenter;
import org.jetbrains.plugins.gitlab.authentication.GitLabSecurityUtil;
import org.jetbrains.plugins.gitlab.authentication.LoginResult;
import org.jetbrains.plugins.gitlab.authentication.accounts.GitLabAccount;
import org.jetbrains.plugins.gitlab.authentication.accounts.GitLabProjectDefaultAccountHolder;
import org.jetbrains.plugins.gitlab.authentication.ui.GitLabChooseAccountDialog;
import org.jetbrains.plugins.gitlab.authentication.ui.GitLabTokenLoginPanelModel;
import org.jetbrains.plugins.gitlab.ui.util.GitLabPluginProjectScopeProvider;
import org.jetbrains.plugins.gitlab.util.GitLabBundle;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000d\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\b\u0005\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003JC\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\b\u0010\b\u001a\u0004\u0018\u00010\t2\b\b\u0002\u0010\n\u001a\u00020\u000b2\u0018\u0010\f\u001a\u0014\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u000f0\rH\u0001\u00a2\u0006\u0002\b\u0010JO\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\b\u0010\b\u001a\u0004\u0018\u00010\t2\b\b\u0002\u0010\n\u001a\u00020\u000b2\n\b\u0002\u0010\u0011\u001a\u0004\u0018\u00010\u000e2\u0018\u0010\f\u001a\u0014\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u000f0\rH\u0001\u00a2\u0006\u0002\b\u0010JA\u0010\u0012\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\b\u0010\b\u001a\u0004\u0018\u00010\t2\u0006\u0010\u0013\u001a\u00020\u00142\u0018\u0010\f\u001a\u0014\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u000f0\rH\u0001\u00a2\u0006\u0002\b\u0015JM\u0010\u0012\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\b\u0010\b\u001a\u0004\u0018\u00010\t2\u0006\u0010\u0013\u001a\u00020\u00142\n\b\u0002\u0010\u0011\u001a\u0004\u0018\u00010\u000e2\u0018\u0010\f\u001a\u0014\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u000f0\rH\u0001\u00a2\u0006\u0002\b\u0015J7\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0006\u001a\u00020\u00072\b\u0010\b\u001a\u0004\u0018\u00010\t2\u0006\u0010\u0018\u001a\u00020\u00192\u000b\u0010\u001a\u001a\u00070\u000e\u00a2\u0006\u0002\b\u001b2\u0006\u0010\u001c\u001a\u00020\u000fH\u0002J>\u0010\u001d\u001a\u0004\u0018\u00010\u00142\u0006\u0010\u0006\u001a\u00020\u00072\b\u0010\b\u001a\u0004\u0018\u00010\u001e2\r\u0010\u001f\u001a\t\u0018\u00010\u000e\u00a2\u0006\u0002\b 2\f\u0010!\u001a\b\u0012\u0004\u0012\u00020\u00140\"H\u0001\u00a2\u0006\u0002\b#J$\u0010$\u001a\u00020\u000f2\f\u0010!\u001a\b\u0012\u0004\u0012\u00020\u00140\"2\u0006\u0010%\u001a\u00020\u000b2\u0006\u0010&\u001a\u00020\u000e\u00a8\u0006'"}, d2={"Lorg/jetbrains/plugins/gitlab/authentication/GitLabLoginUtil;", "", "<init>", "()V", "logInViaToken", "Lorg/jetbrains/plugins/gitlab/authentication/LoginResult;", "project", "Lcom/intellij/openapi/project/Project;", "parentComponent", "Ljavax/swing/JComponent;", "serverPath", "Lorg/jetbrains/plugins/gitlab/api/GitLabServerPath;", "uniqueAccountPredicate", "Lkotlin/Function2;", "", "", "logInViaToken$intellij_vcs_gitlab", "requiredUsername", "updateToken", "account", "Lorg/jetbrains/plugins/gitlab/authentication/accounts/GitLabAccount;", "updateToken$intellij_vcs_gitlab", "showLoginDialog", "", "model", "Lorg/jetbrains/plugins/gitlab/authentication/ui/GitLabTokenLoginPanelModel;", "title", "Lcom/intellij/openapi/util/NlsContexts$DialogTitle;", "serverFieldDisabled", "chooseAccount", "Ljava/awt/Component;", "description", "Lorg/jetbrains/annotations/Nls;", "accounts", "", "chooseAccount$intellij_vcs_gitlab", "isAccountUnique", "server", "username", "intellij.vcs.gitlab"})
@SourceDebugExtension(value={"SMAP\nGitLabLoginUtil.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GitLabLoginUtil.kt\norg/jetbrains/plugins/gitlab/authentication/GitLabLoginUtil\n+ 2 KtUtils.kt\ncom/intellij/util/KotlinUtils\n+ 3 services.kt\ncom/intellij/openapi/components/ServicesKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,142:1\n19#2:143\n31#3,2:144\n31#3,2:146\n2632#4,3:148\n*S KotlinDebug\n*F\n+ 1 GitLabLoginUtil.kt\norg/jetbrains/plugins/gitlab/authentication/GitLabLoginUtil\n*L\n50#1:143\n99#1:144,2\n125#1:146,2\n135#1:148,3\n*E\n"})
public final class GitLabLoginUtil {
    @NotNull
    public static final GitLabLoginUtil INSTANCE = new GitLabLoginUtil();

    private GitLabLoginUtil() {
    }

    @RequiresEdt
    @NotNull
    public final LoginResult logInViaToken$intellij_vcs_gitlab(@NotNull Project project, @Nullable JComponent parentComponent, @NotNull GitLabServerPath serverPath, @NotNull Function2<? super GitLabServerPath, ? super String, Boolean> uniqueAccountPredicate) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)serverPath, (String)"serverPath");
        Intrinsics.checkNotNullParameter(uniqueAccountPredicate, (String)"uniqueAccountPredicate");
        return this.logInViaToken$intellij_vcs_gitlab(project, parentComponent, serverPath, null, uniqueAccountPredicate);
    }

    public static /* synthetic */ LoginResult logInViaToken$intellij_vcs_gitlab$default(GitLabLoginUtil gitLabLoginUtil, Project project, JComponent jComponent, GitLabServerPath gitLabServerPath, Function2 function2, int n, Object object) {
        if ((n & 4) != 0) {
            gitLabServerPath = GitLabServerPath.Companion.getDEFAULT_SERVER();
        }
        return gitLabLoginUtil.logInViaToken$intellij_vcs_gitlab(project, jComponent, gitLabServerPath, (Function2<? super GitLabServerPath, ? super String, Boolean>)function2);
    }

    @RequiresEdt
    @NotNull
    public final LoginResult logInViaToken$intellij_vcs_gitlab(@NotNull Project project, @Nullable JComponent parentComponent, @NotNull GitLabServerPath serverPath, @Nullable String requiredUsername, @NotNull Function2<? super GitLabServerPath, ? super String, Boolean> uniqueAccountPredicate) {
        LoginResult loginResult2;
        GitLabTokenLoginPanelModel gitLabTokenLoginPanelModel;
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)serverPath, (String)"serverPath");
        Intrinsics.checkNotNullParameter(uniqueAccountPredicate, (String)"uniqueAccountPredicate");
        GitLabTokenLoginPanelModel $this$logInViaToken_u24lambda_u240 = gitLabTokenLoginPanelModel = new GitLabTokenLoginPanelModel(requiredUsername, uniqueAccountPredicate);
        boolean bl = false;
        $this$logInViaToken_u24lambda_u240.setServerUri(serverPath.getUri());
        GitLabTokenLoginPanelModel model = gitLabTokenLoginPanelModel;
        String dialogTitle = GitLabBundle.message("account.add.dialog.title", new Object[0]);
        int exitCode = this.showLoginDialog(project, parentComponent, model, dialogTitle, false);
        switch (exitCode) {
            case 0: {
                Object $this$asSafely$iv = model.getLoginState().getValue();
                boolean $i$f$asSafely = false;
                Object object = $this$asSafely$iv;
                if (!(object instanceof LoginModel.LoginState.Connected)) {
                    object = null;
                }
                LoginModel.LoginState.Connected connected = (LoginModel.LoginState.Connected)object;
                if (connected == null) {
                    return LoginResult.Failure.INSTANCE;
                }
                LoginModel.LoginState.Connected loginResult3 = connected;
                return new LoginResult.Success(new GitLabAccount(null, loginResult3.getUsername(), model.getServerPath(), 1, null), model.getToken());
            }
            case 2: {
                loginResult2 = LoginResult.OtherMethod.INSTANCE;
                break;
            }
            default: {
                loginResult2 = LoginResult.Failure.INSTANCE;
            }
        }
        return loginResult2;
    }

    public static /* synthetic */ LoginResult logInViaToken$intellij_vcs_gitlab$default(GitLabLoginUtil gitLabLoginUtil, Project project, JComponent jComponent, GitLabServerPath gitLabServerPath, String string, Function2 function2, int n, Object object) {
        if ((n & 4) != 0) {
            gitLabServerPath = GitLabServerPath.Companion.getDEFAULT_SERVER();
        }
        if ((n & 8) != 0) {
            string = null;
        }
        return gitLabLoginUtil.logInViaToken$intellij_vcs_gitlab(project, jComponent, gitLabServerPath, string, (Function2<? super GitLabServerPath, ? super String, Boolean>)function2);
    }

    @RequiresEdt
    @NotNull
    public final LoginResult updateToken$intellij_vcs_gitlab(@NotNull Project project, @Nullable JComponent parentComponent, @NotNull GitLabAccount account, @NotNull Function2<? super GitLabServerPath, ? super String, Boolean> uniqueAccountPredicate) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)((Object)account), (String)"account");
        Intrinsics.checkNotNullParameter(uniqueAccountPredicate, (String)"uniqueAccountPredicate");
        return this.updateToken$intellij_vcs_gitlab(project, parentComponent, account, null, uniqueAccountPredicate);
    }

    @RequiresEdt
    @NotNull
    public final LoginResult updateToken$intellij_vcs_gitlab(@NotNull Project project, @Nullable JComponent parentComponent, @NotNull GitLabAccount account, @Nullable String requiredUsername, @NotNull Function2<? super GitLabServerPath, ? super String, Boolean> uniqueAccountPredicate) {
        GitLabTokenLoginPanelModel gitLabTokenLoginPanelModel;
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)((Object)account), (String)"account");
        Intrinsics.checkNotNullParameter(uniqueAccountPredicate, (String)"uniqueAccountPredicate");
        Function2 predicateWithoutCurrent = (arg_0, arg_1) -> GitLabLoginUtil.updateToken$lambda$1(account, uniqueAccountPredicate, arg_0, arg_1);
        GitLabTokenLoginPanelModel $this$updateToken_u24lambda_u242 = gitLabTokenLoginPanelModel = new GitLabTokenLoginPanelModel(requiredUsername, (Function2<? super GitLabServerPath, ? super String, Boolean>)predicateWithoutCurrent);
        boolean bl = false;
        $this$updateToken_u24lambda_u242.setServerUri(account.getServer().getUri());
        GitLabTokenLoginPanelModel model = gitLabTokenLoginPanelModel;
        String title = GitLabBundle.message("account.update.dialog.title", new Object[0]);
        int exitState = this.showLoginDialog(project, parentComponent, model, title, true);
        LoginModel.LoginState loginState = (LoginModel.LoginState)model.getLoginState().getValue();
        if (exitState == 0 && loginState instanceof LoginModel.LoginState.Connected) {
            return new LoginResult.Success(new GitLabAccount(account.getId(), ((LoginModel.LoginState.Connected)loginState).getUsername(), model.getServerPath()), model.getToken());
        }
        return LoginResult.Failure.INSTANCE;
    }

    public static /* synthetic */ LoginResult updateToken$intellij_vcs_gitlab$default(GitLabLoginUtil gitLabLoginUtil, Project project, JComponent jComponent, GitLabAccount gitLabAccount, String string, Function2 function2, int n, Object object) {
        if ((n & 8) != 0) {
            string = null;
        }
        return gitLabLoginUtil.updateToken$intellij_vcs_gitlab(project, jComponent, gitLabAccount, string, (Function2<? super GitLabServerPath, ? super String, Boolean>)function2);
    }

    private final int showLoginDialog(Project project, JComponent parentComponent, GitLabTokenLoginPanelModel model, String title, boolean serverFieldDisabled) {
        ComponentManager $this$service$iv = (ComponentManager)project;
        boolean $i$f$service = false;
        Class<GitLabPluginProjectScopeProvider> serviceClass$iv = GitLabPluginProjectScopeProvider.class;
        Object object = $this$service$iv.getService(serviceClass$iv);
        if (object == null) {
            throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
        }
        GitLabPluginProjectScopeProvider scopeProvider = (GitLabPluginProjectScopeProvider)((Object)object);
        TokenLoginDialog dialog = (TokenLoginDialog)scopeProvider.constructDialog("GitLab token login dialog", arg_0 -> GitLabLoginUtil.showLoginDialog$lambda$4(project, parentComponent, model, title, serverFieldDisabled, arg_0));
        dialog.showAndGet();
        return dialog.getExitCode();
    }

    @RequiresEdt
    @Nullable
    public final GitLabAccount chooseAccount$intellij_vcs_gitlab(@NotNull Project project, @Nullable Component parentComponent, @Nullable String description, @NotNull Collection<GitLabAccount> accounts) {
        GitLabAccount gitLabAccount;
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter(accounts, (String)"accounts");
        GitLabChooseAccountDialog dialog = new GitLabChooseAccountDialog(project, parentComponent, accounts, false, true, null, description, null, 160, null);
        if (dialog.showAndGet()) {
            GitLabAccount account = dialog.getAccount();
            if (dialog.getSetDefault()) {
                ComponentManager $this$service$iv = (ComponentManager)project;
                boolean $i$f$service = false;
                Class<GitLabProjectDefaultAccountHolder> serviceClass$iv = GitLabProjectDefaultAccountHolder.class;
                Object object = $this$service$iv.getService(serviceClass$iv);
                if (object == null) {
                    throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
                }
                ((GitLabProjectDefaultAccountHolder)((Object)object)).setAccount((Account)account);
            }
            gitLabAccount = account;
        } else {
            gitLabAccount = null;
        }
        return gitLabAccount;
    }

    public final boolean isAccountUnique(@NotNull Collection<GitLabAccount> accounts, @NotNull GitLabServerPath server, @NotNull String username) {
        boolean bl;
        block3: {
            Intrinsics.checkNotNullParameter(accounts, (String)"accounts");
            Intrinsics.checkNotNullParameter((Object)server, (String)"server");
            Intrinsics.checkNotNullParameter((Object)username, (String)"username");
            Iterable $this$none$iv = accounts;
            boolean $i$f$none = false;
            if (((Collection)$this$none$iv).isEmpty()) {
                bl = true;
            } else {
                for (Object element$iv : $this$none$iv) {
                    GitLabAccount it = (GitLabAccount)((Object)element$iv);
                    boolean bl2 = false;
                    if (!(Intrinsics.areEqual((Object)GitLabServerPathKt.toHttpsNormalizedURI(it.getServer()), (Object)GitLabServerPathKt.toHttpsNormalizedURI(server)) && Intrinsics.areEqual((Object)it.getName(), (Object)username))) continue;
                    bl = false;
                    break block3;
                }
                bl = true;
            }
        }
        return bl;
    }

    private static final boolean updateToken$lambda$1(GitLabAccount $account, Function2 $uniqueAccountPredicate, GitLabServerPath serverPath, String username) {
        Intrinsics.checkNotNullParameter((Object)serverPath, (String)"serverPath");
        Intrinsics.checkNotNullParameter((Object)username, (String)"username");
        return Intrinsics.areEqual((Object)serverPath, (Object)$account.getServer()) && Intrinsics.areEqual((Object)username, (Object)$account.getName()) ? true : (Boolean)$uniqueAccountPredicate.invoke((Object)serverPath, (Object)username);
    }

    private static final DialogPanel showLoginDialog$lambda$4$lambda$3(GitLabTokenLoginPanelModel $model, boolean $serverFieldDisabled, CoroutineScope $this$TokenLoginDialog) {
        Intrinsics.checkNotNullParameter((Object)$this$TokenLoginDialog, (String)"$this$TokenLoginDialog");
        CoroutineScope cs = $this$TokenLoginDialog;
        Object[] objectArray = new Object[]{GitLabSecurityUtil.INSTANCE.getMASTER_SCOPES()};
        return TokenLoginInputPanelFactory.createIn$default((TokenLoginInputPanelFactory)new TokenLoginInputPanelFactory((TokenLoginPanelModel)$model), (CoroutineScope)cs, (boolean)$serverFieldDisabled, (String)CollaborationToolsBundle.message((String)"clone.dialog.insufficient.scopes", (Object[])objectArray), (ErrorStatusPresenter)((ErrorStatusPresenter)new GitLabLoginErrorStatusPresenter(cs, $model)), null, (int)16, null);
    }

    private static final TokenLoginDialog showLoginDialog$lambda$4(Project $project, JComponent $parentComponent, GitLabTokenLoginPanelModel $model, String $title, boolean $serverFieldDisabled, CoroutineScope $this$constructDialog) {
        Intrinsics.checkNotNullParameter((Object)$this$constructDialog, (String)"$this$constructDialog");
        return new TokenLoginDialog($project, $this$constructDialog, (Component)$parentComponent, (LoginModel)$model, $title, $model.getTryGitAuthorizationSignal(), arg_0 -> GitLabLoginUtil.showLoginDialog$lambda$4$lambda$3($model, $serverFieldDisabled, arg_0));
    }
}

