/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.gitlab.ui;

import com.intellij.internal.statistic.collectors.fus.fileTypes.FileTypeUsageSchemaDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.vfs.VirtualFile;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.gitlab.ui.GitlabCiIconProviderKt;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0007\u001a\u00020\u00062\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lorg/jetbrains/plugins/gitlab/ui/GitlabFileTypeSchemaProvider;", "Lcom/intellij/internal/statistic/collectors/fus/fileTypes/FileTypeUsageSchemaDescriptor;", "<init>", "()V", "SCHEMA_KEY", "Lcom/intellij/openapi/util/Key;", "", "describes", "project", "Lcom/intellij/openapi/project/Project;", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "intellij.vcs.gitlab"})
@SourceDebugExtension(value={"SMAP\nGitlabFileTypeSchemaProvider.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GitlabFileTypeSchemaProvider.kt\norg/jetbrains/plugins/gitlab/ui/GitlabFileTypeSchemaProvider\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,21:1\n1#2:22\n*E\n"})
public final class GitlabFileTypeSchemaProvider
implements FileTypeUsageSchemaDescriptor {
    @NotNull
    private final Key<Boolean> SCHEMA_KEY;

    public GitlabFileTypeSchemaProvider() {
        Key key = Key.create((String)"GITLAB_CI_SCHEMA");
        Intrinsics.checkNotNullExpressionValue((Object)key, (String)"create(...)");
        this.SCHEMA_KEY = key;
    }

    public boolean describes(@NotNull Project project, @NotNull VirtualFile file) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        if (!Intrinsics.areEqual((Object)file.getFileType().getName(), (Object)"YAML")) {
            return false;
        }
        Boolean bl = (Boolean)file.getUserData(this.SCHEMA_KEY);
        if (bl != null) {
            boolean it = bl;
            boolean bl2 = false;
            return it;
        }
        boolean isGithubFile = GitlabCiIconProviderKt.isGitlabCiFile(file);
        file.putUserData(this.SCHEMA_KEY, (Object)isGithubFile);
        return isGithubFile;
    }
}

